/* Test RXOD functions */
/* drop functions for testing */
call rxfuncdrop 'rxodobjpathfromid'
call rxfuncdrop 'rxodobjpathfromhnd'
call rxfuncdrop 'rxodobjhndfromloc'
call rxfuncdrop 'rxodsetobjectid'

if rxfuncquery('rxodobjpathfromid') then
   do
   call rxfuncadd 'rxodobjpathfromid', 'rxod','rxodobjpathfromid'
   call rxfuncadd 'rxodobjpathfromhnd','rxod','rxodobjpathfromhnd'
   call rxfuncadd 'rxodobjhndfromloc', 'rxod','rxodobjhndfromloc'
   call rxfuncadd 'rxodsetobjectid',   'rxod','rxodsetobjectid'
   end

say 'Please enter OBJECTID to query.'
say 'Input is case sensitive.'
/* note case sensitive */
parse pull objectid

if '<' <> left(objectid,1) then objectid = '<'objectid
if '>' <> right(objectid,1) then objectid = objectid'>'

location = rxodobjpathfromid(objectid)

if location <> '' then
   say 'Objectid' objectid 'file system:' location
else
   say 'Objectid' objectid 'not found or is WPAbstract object.'

objecthandle = rxodobjhndfromloc(objectid)
savehandle = objecthandle

say 'object handle for objectid' objectid 'is' c2x(objecthandle)

xstr = c2x(left(objecthandle,2))
xstr = right(xstr,2)||left(xstr,2)
xstr = strip(xstr,'l','0')

say 'For use as key value in sysini calls:' xstr
say ''

if location <> '' then
   do
      objecthandle = rxodobjhndfromloc(location)

      say 'object handle for location' location 'is' c2x(objecthandle)

      xstr = c2x(left(objecthandle,2))
      xstr = right(xstr,2)||left(xstr,2)
      xstr = strip(xstr,'l','0')

      say 'For use as key value in sysini calls:' xstr
   end

say 'Enter new OBJECTID to assign to this object' objectid location
say 'A Null reply will terminate test with no processing.'
parse pull newobjectid
if newobjectid = '' then nop
else
   do
  if '<' <> left(newobjectid,1) then newobjectid = '<'newobjectid
  if '>' <> right(newobjectid,1) then newobjectid = newobjectid'>'
  say 'New OBJECTID='newobjectid
  say 'Objecthandle to use:' c2x(savehandle)
  myrc = rxodsetobjectid(savehandle,newobjectid)
  say 'Call to rxodsetobjecthandle was' myrc

  newlocation = rxodobjpathfromid(newobjectid)
  say 'Test to retrieve location using OBJECTID' newobjectid
  say 'resulted in location:' newlocation
  if newlocation <> '' then say 'Test to set OBJECTID was successful.'
  else say 'Test to set OBJECTID failed.'
  end

call rxfuncdrop 'rxodobjpathfromid'
call rxfuncdrop 'rxodobjpathfromloc'
call rxfuncdrop 'rxodobjhndfromloc'
call rxfuncdrop 'rxodsetobjectid'
