/* rexx */
/* ================================================================== */
/* Check to see if all REXX utility functions have been Loaded        */
/* NOTE:  RxFuncQuery tests for REXX load.                            */
/* ================================================================== */
if 0 < RxFuncQuery('SysLoadFuncs') THEN DO;
   Call rxfuncadd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs';
   Call SysLoadFuncs;
END;
parse arg FileName;
call  ShowValue ".ICON" ;
call  ShowValue ".TYPE" ;
call  ShowValue ".VERSION" ;
call  ShowValue ".SUBJECT" ;
call  ShowValue ".LONGNAME" ;
call  ShowValue ".KEYPHRASES" ;
call  ShowValue ".COMMENTS" ;
call  ShowValue ".HISTORY" ;
call  ShowValue ".CODEPAGE" ;
return;
ShowValue:
parse arg Item
call charout ,FileName Item||':' d2c(9)
cALL SysGETEA FileName,Item,"EAVAL"
select
   when item=".TYPE" then
      do
         parse var EAVAL 11 type
         call charout ,type
      end
   when item=".LONGNAME" then
      do
         /* pick up two-byte binary integer and interpret */
         parse var EAVAL 3 rd 4 ld +1
         namelength = c2d(ld||rd)
         /* parse for longname using length of string */
         parse var EAVAL 5 longname '+'namelength
         call charout, longname
      end
   otherwise nop
end
say ''
return;

