/* RXODTITL - external function
   argument:  two character object handle in hex
              This value is used as a key in a call to sysini
              to retrieve PM_Abstract:Objects data
   returns:   title of abstract object or null if no title is found.

   Bruce Eric Hgman 1995-06-09
*/
parse arg handle
if verify(handle,'0123456789abcdefABCDEF') > 0 then
   do
      handle = c2x(reverse(handle))
   end
else handle = translate(handle)
/* handle the case where we are passed a 5-byte handle value */
object_handle = handle
if length(handle) > 4 then object_handle = right(handle,4)
if 0 < RxFuncQuery('SysLoadFuncs') then
   do
      call rxfuncadd 'sysloadfuncs','rexxutil','sysloadfuncs'
      call   sysloadfuncs
   end
object_handle = strip(object_handle,'l','0')

objdata = sysini('USER','PM_Abstract:Objects',object_handle)
if abbrev(objdata,'ERROR') then
   do
      /* assume handle is folder and get its location */
      handle = reverse(x2c(handle))||'03'x
      location = rxodobjpathfromhnd(handle)
      call sysgetea location,'.LONGNAME','EAVAL'
      parse var EAVAL 3 rd 4 ld +1
      namelength = c2d(ld||rd)
      /* parse for longname using length of string */
      parse var EAVAL 5 longname '+'namelength
      return longname
   end

objdata = substr(objdata,pos('WPAbstract',objdata)+17)
return left(objdata,pos('00'x,objdata))
