/* RXODFOBJ
   Displays contents of folder, given folder file name or OBJECTID
   (without <>, which causes problems on command line)
*/
parse arg fldrname others
if 0 < pos('?',fldrname others) then
   do
      call syntax
      exit
   end
if 0 < pos('/O',translate(others)) then
   fldrname = '<'fldrname'>'

if rxfuncquery('rxodobjhndfromloc') then
   call rxfuncadd 'rxodobjhndfromloc','rxod','rxodobjhndfromloc'

fldrhandle = rxodobjhndfromloc(fldrname)

fldrhandle = c2x(left(fldrhandle,2))
fldrhandle = right(fldrhandle,2)||left(fldrhandle,2)

objhandles = 'rxodfldr'(fldrhandle)

objhandles = strip(objhandles)

say 'Folder:' fldrname 'contents:'
do while objhandles <> ''
   parse var objhandles onehandle objhandles
   abstract_data = sysini(,'PM_Abstract:Objects',onehandle)
   if 0 = pos('WPAbstract',abstract_data) then
      do
         sub_folder_name = rxodobjpathfromhnd(onehandle)
         folder_file = filespec('n',sub_folder_name)
         say 'handle:' onehandle 'foldr:' folder_file
      end
   else
      do
         objtitle = 'rxodtitl'(onehandle)
         objid = 'RXODOID'(onehandle)
         say 'handle:' onehandle 'title:' objtitle 'ID:' objid
      end
end
return
syntax: procedure
   say 'RXODFOBJ drive:\path\foldername | object_id [/o]'
   say 'example:  c:\desktop\folder1'
   say 'object_id should not have surrounding <>'
   say 'use /o switch when specifying an objectid'
   return
