/* RXODFNUM
   Enumerate objects in a folder.
   Input:  identification of folder and type of data in argument
   returns:  string of object handles including byte that indicates
      the type of object. ('3' is folder, '2' is WPAbstract)
      Each item in the list is separated by a blank.
   identification of folder can be:
      location of folder (file system name)
      objectid of folder (with or without <>)
      object handle in binary
      object handle in hex
   type of data
      /L location
      /O objectid
      /B binary object handle
      /X hexadecimal object handle

   Processing logic:
      The .ini file contains folder contents:
      PM_Abstract:FldrContent, key is hex folder handle
      The folder has a file system name, and a call to
      sysfiletree requesting subdirectories under the given folder
      will return a list of all contained folders.
      On error, returns ERROR: as first word in returned value.

   folder_id can be location, which has drive:\path
   objectid which may or may not have surounding <>
   object handle in binary (two to 4 bytes)
   object handle in hex (4 to 8 bytes)
*/

parse arg folder_id data_type
if 0 < pos('?',folder_id||data_type) then
   do
      call syntax
      if 0 < pos('?',folder_id||data_type) then return 0
      else return 'ERROR: HELP only'
   end

data_type = translate(data_type)

if rxfuncquery('rxodobjhndfromloc') then
   call rxfuncadd 'rxodobjhndfromloc','rxod','rxodobjhndfromloc'

select
   when left(data_type,2) = '/L' then
      do
         folder_handle = rxodobjhndfromloc(folder_id)
         folder_handle = object_handle(folder_handle)
      end
   when left(data_type,2) = '/O' then
      do
         if '<' <> left(folder_id,1) then
            folder_id = '<'folder_id
         if '>' <> right(folder_id,1) then
            folder_id = folder_id'>'
         folder_handle = rxodobjhndfromloc(folder_id)
         folder_handle = object_handle(folder_handle)
      end
   when left(data_type,2) = '/B' then
      do
         if length(folder_id) < 2 then
            return 'ERROR: RXODFNUM folder_id binary value less than 2'
         if length(folder_id > 4 then
            return 'ERROR: RXODFNUM folder_id binary value greater than 4'
         folder_handle = object_handle(folder_id)
      end
   when left(data_type,2) = '/X' then
      do
         if verify('0123456789abcdefABCDEF',folder_id) then
               return 'ERROR: RXODFNUM folder_id not valid hexadecimal value'
         if 0 <> length(folder_id)//2 then folder_id = '0'folder_id
         folder_id = left(folder_id,4)
         folder_handle = folder_id
      end
   otherwise
      return 'ERROR: RXODFNUM invalid data_type argument' data_type
end

folder_handle = left(folder_handle,4)
binary_handle = folder_handle
if 0 <> length(binary_handle)//2 then binary_handle = '0'binary_handle

binary_handle = x2c(left(binary_handle,4))

test_handle = reverse(binary_handle)||x2c('0300')
folder_path = rxodobjpathfromhnd(test_handle)
if folder_path = '' then
   return 'ERROR: object is not folder'

call sysfiletree folder_path'\*','dirlist.','DO'

return_value = ''

do i = 1 to dirlist.0
   sub_folder_handle = rxodobjhndfromloc(dirlist.i)
   return_value = return_value || all_object_handle(sub_folder_handle)' '
end

folder_contents = sysini(,'PM_Abstract:FldrContent',folder_handle)

if \abbrev(folder_contents,'ERROR') then
   do
      ret_value = ''
      do i = 1 to length(folder_contents) by 4
         obj_handle = c2x(reverse(substr(folder_contents,i,2)))
         say 'obj_handle='obj_handle
         obj_data   = sysini(,'PM_Abstract:Objects',,
            strip(obj_handle,'l','0'))
         if abbrev('obj_data','ERROR') then
            say 'error: obj_data for' obj_handle
         else
            do
               bk = length(obj_data)>5
               ka = pos('WP',obj_data)
               kb = pos('00'x,obj_data,5)
               type_byte = ''
               if bk & (kb > ka) then
                  do
                     obj_type = substr(obj_data,5,,
                        pos('00'x,obj_data,5)-5)
                     select
                        when obj_type = 'WPProgram' then
                           type_byte = '2'
                        when obj_type = 'WPShadow' then
                           type_byte = '0'
                        otherwise nop
                     end
                  end
               return_value = return_value||type_byte||obj_handle' '
            end
      end
   end
say return_value
return return_value
all_object_handle: procedure
   parse arg binary_handle
   handle = c2x(reverse(binary_handle))
   handle = right(handle,6)
   return handle

object_handle: procedure
   parse arg handle
   handle = c2x(handle)
   handle = left(handle,4)
   handle = right(handle,2)||left(handle,2)
   handle = strip(handle,'l','0')
   return handle
