/* RXODDESK
   Displays structured listing of OS/2 desktop, showing folders,
   contents.

   Input:  file system name of folder at which to start or null,
           meaning the entire active desktop is displayed.
           The input may also be an OBJECTID of a folder.  The
           distinction is made because the file system name of
           a folder must be fully qualified with drive:\path\folder

   Output:
           structured listing of folders and contents

   Bruce Eric Hgman 1995-06-09
*/
parse arg folder_name
if 0 < pos('?',folder_name) | folder_name = '' then
   do
      call syntax
      if 0 < pos('?',folder_name) then exit
   end

call Load_DLLs
call Load_Locations

folder_list. = ''; folder_list.0 = 0

if folder_name = '' then
   do
      folder_name = rxoddeskpath()
      if folder_name = '' then folder_name = 'WP_DESKTOP'
   end
if ':' <> substr(folder_name,2,1) then folder_name = '<'folder_name'>'

folder_handle =  rxodobjhndfromloc(folder_name)
hex_handle = FormObjHandle(folder_handle)

tst_fldr = sysini(,'PM_Abstract:FldrContent',hex_handle)
if abbrev(tst_fldr,'ERROR') then
   do
      say 'Folder does not exist.'
      exit 1
   end
say 'Folder handle='hex_handle

folder_path = rxodobjpathfromhnd(folder_handle)

call sysfiletree folder_path'\*','dir_list.','DSO'

say copies(d2c(196),20)
say 'Folder:' folder_path
say Get_Longname(folder_path)
call Contains_Folders folder_path 2
say '    Objects:'
call Analyze_Folder_Handle FormObjHandle(folder_handle)

bLoop = 1

do i = 1 to dir_list.0
   folder_name = dir_list.i
   folder_handle = rxodobjhndfromloc(folder_name)
   folder_id = Get_Objectid(folder_handle)

   say copies(d2c(196),20)

   folder_longname = get_longname(folder_name)
   if folder_longname <> folder_name then
      folder_longname = translate(folder_longname,'^~',d2c(10)d2c(13))
   say 'Folder:' folder_longname 'handle='FormObjHandle(folder_handle) 'ID='folder_id

   call Contains_Folders folder_name 2
   say '    Objects:'
   call Analyze_Folder_Handle FormObjHandle(folder_handle)
end

return 0

/* Ŀ
     Analyze_Folder:                                      
                                                          
     function:  analyze contents of one folder            
   */
Analyze_Folder_Handle:
   arg analyze_handle
   fldrdata = sysini('USER','PM_Abstract:FldrContent',analyze_handle)
   contents_list = ''
   do anai = 1 to length(fldrdata) by 4
      contents_list = contents_list FormObjHandle(substr(fldrdata,anai,2))
   end
   contents_list = strip(contents_list)
   do while contents_list <> ''
      parse var contents_list one_item contents_list
      test_obj = sysini(,'PM_Abstract:Objects',one_item)
      if abbrev(test_obj,'ERROR') then iterate
      else call Folder_Item_Data one_item
   end
   return

/* Ŀ
     Contains_Folders:                                    
                                                          
     function:  display list of folders contained in      
                current folder                            
                                                          
     input:     containing folder name                    
   */
Contains_Folders: procedure expose dir_list.
   arg contain_name contain_offset
   offset = contain_offset+2
   do containi = 1 to dir_list.0
      if abbrev(translate(dir_list.containi),contain_name'\') then
         do
            contained_name = Get_Longname(dir_list.containi)
            contained_name = translate(contained_name,'^~',d2c(10)d2c(13))
            say copies(' ',offset)' ' contained_name
            call Contains_Folders dir_list.containi offset
         end
   end
   return

/* Ŀ
     Folder_Item_Data:                                    
                                                          
     function:  display information from object           
                                                          
     input:     handle of object in folder                
   */
Folder_Item_Data:
   arg itemhandle
   abstract_data = sysini(,'PM_Abstract:Objects',itemhandle)
   obj_type = substr(abstract_data,5,pos('00'x,substr(abstract_data,5)))
   if 0 = pos('WPAbstract',abstract_data) then
      do
         sub_folder_name = rxodobjpathfromhnd(itemhandle)
         folder_file = filespec('n',sub_folder_name)
         say 'handle:' itemhandle 'foldr:' folder_file
      end
   else
      do
         itemid = Get_Objectid(itemhandle)
         objtitle = Get_Title(itemhandle)
         objtitle = translate(objtitle,'^~',d2c(10)d2c(13))
         hndl_str = right(copies(' ',4)||itemhandle,4)
         objtypestr = left(obj_type||copies(' ',15),15)
         say hndl_str objtypestr objtitle itemid
      end
   return

/* Ŀ
     Get_Longname:                                        
                                                          
     returns:  longname of object                         
                                                          
     input:    file system name                           
   */
Get_Longname: procedure
   arg shrtfilename
   myrc = sysgetea(shrtfilename,'.LONGNAME',"EAVAL")
   if myrc <> 0 then return ''
   parse var EAVAL 3 rd 4 ld +1
   namelength = c2d(ld||rd)
   parse var EAVAL 5 longname '+'namelength
   return longname

/* Ŀ
     Get_Objectid:                                        
                                                          
     returns:  objectid or null                           
                                                          
     input:    object handle                              
   */
Get_Objectid: procedure expose location_handles. location_hexhandles.
   parse arg idhandle
   if 0 < verify(idhandle,'0123456789abcdefABCDEF') then
      objiddata = location_handles.idhandle
   else
      do
         idhandle = translate(idhandle)
         objiddata = location_hexhandles.idhandle
      end
   if '<' <> left(objiddata,1) then objiddata = ''
   return objiddata

/* Ŀ
     Get_Title:                                           
                                                          
     returns:  title of object                            
                                                          
     input:    handle of object                           
   */
Get_Title: procedure
   arg titlehandle
   titleobjdata = sysini('USER','PM_Abstract:Objects',titlehandle)
   if abbrev(titleobjdata,'ERROR') then return ''
   titleobjdata = substr(titleobjdata,pos('WPAbstract',titleobjdata)+17)
   return left(titleobjdata,pos('00'x,titleobjdata)-1)
/* Ŀ
     Load_DLLs:  load all .dll files needed               
   */
Load_DLLs: procedure

   if 0 < RxFuncQuery('SysLoadFuncs') then
      do
         call rxfuncadd 'sysloadfuncs','rexxutil','sysloadfuncs'
         call   sysloadfuncs
      end

   if rxfuncquery('rxodobjhndfromloc') then
      call rxfuncadd 'rxodobjhndfromloc','rxod','rxodobjhndfromloc'
   if rxfuncquery('rxodobjpathfromhnd') then
      call rxfuncadd 'rxodobjpathfromhnd','rxod','rxodobjpathfromhnd'
   if rxfuncquery('rxoddeskpath') then
      call rxfuncadd 'rxoddeskpath','rxod','rxoddeskpath'
   return

/* Ŀ
     Load_Locations:  load stem variables with data from  
     PM_Workplace:Location containing object handles      
                                                          
     input:  none                                         
                                                          
     output: location_handles. location_hexhandles.       
   */
Load_Locations: procedure expose locations. location_handles. location_hexhandles.
   locations.=''
   location_handles.=''
   location_hexhandles.=''
   call sysini 'user','PM_Workplace:Location','all:','locations.'
   do i = 1 to locations.0
      loc_handle = sysini(,'PM_Workplace:Location',locations.i)
      location_handles.loc_handle = locations.i
      loc_handle = FormObjHandle(loc_handle)
      location_hexhandles.loc_handle = locations.i
   end
   return

/* Ŀ
     FormObjHandle: reformat binary handle to .ini handle 
   */
FormObjHandle: procedure
   parse arg oinhandle
   oxstr = c2x(left(oinhandle,2))
   oxstr = right(oxstr,2)||left(oxstr,2)
   oxstr = strip(oxstr,'l','0')
   return oxstr


/* Ŀ
     Syntax:  display help information for command        
                                                          
     input: null command line arguments or ?              
   */
Syntax: procedure
   say ''
   say 'RXODDESK - syntax of command line'
   say ''
   say '   rxoddesk [folder_location]'
   say ''
   say 'folder_location can be file system name of folder or it'
   say 'can be the OBJECTID of a folder without the surrounding <>.'
   say ''
   say 'If no folder_location is given, the the active desktop folder'
   say 'is the default folder to display.'
   say ''
   return
