/*------------------------------------------------------------------------*\
|                                                                          |
| 9412LS01.CMD (rxls02) - Compare two directories using associative arrays |
|                                                                          |
\*------------------------------------------------------------------------*/
call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'         /* 0006 */
call SysLoadFuncs                                                 /* 0007 */
                                                                  /* 0008 */
directory_1 = 'd:\*.*'                                            /* 0009 */
directory_2 = 'e:\*.*'                                            /* 0010 */
                                                                  /* 0011 */
/*-----------------------*\                                       /* 0012 */
|  Process 1st directory  |                                       /* 0013 */
\*-----------------------*/                                       /* 0014 */
index_1. = 0                        /* initialize all elements */ /* 0015 */
call SysFileTree directory_1, 'tree_1', 'FO'                      /* 0016 */
do t1 = 1 to tree_1.0                                             /* 0017 */
   subscript = FILESPEC( 'P', tree_1.t1 ) ||,                     /* 0018 */
               FILESPEC( 'N', tree_1.t1 )                         /* 0019 */
   index_1.subscript = t1                                         /* 0020 */
end                                                               /* 0021 */
                                                                  /* 0022 */
/*-------------------------------*\                               /* 0023 */
|  Process 2nd directory vs. 1st  |                               /* 0024 */
\*-------------------------------*/                               /* 0025 */
index_2. = 0                        /* initialize all elements */ /* 0026 */
call SysFileTree directory_2, 'tree_2', 'FO'                      /* 0027 */
do t2 = 1 to tree_2.0                                             /* 0028 */
   subscript = FILESPEC( 'P', tree_2.t2 ) ||,                     /* 0029 */
               FILESPEC( 'N', tree_2.t2 )                         /* 0030 */
   index_2.subscript = t2                                         /* 0031 */
   if index_1.subscript > 0 then                                  /* 0032 */
      do                                                          /* 0033 */
         index_1.subscript = -1     /* indicate matching entry */ /* 0034 */
         iterate                                                  /* 0035 */
      end                                                         /* 0036 */
   say directory_1          ||,                                   /* 0037 */
       ' does not contain ' ||,                                   /* 0038 */
       subscript                                                  /* 0039 */
end                                                               /* 0040 */
                                                                  /* 0041 */
/*--------------------------------------------*\                  /* 0042 */
|  Process unmatched entries in 1st directory  |                  /* 0043 */
\*--------------------------------------------*/                  /* 0044 */
do t1 = 1 to tree_1.0                                             /* 0045 */
   subscript = FILESPEC( 'P', tree_1.t1 ) ||,                     /* 0046 */
               FILESPEC( 'N', tree_1.t1 )                         /* 0047 */
   if index_1.subscript > 0 then                                  /* 0048 */
      do                                                          /* 0049 */
         say directory_2          ||,                             /* 0050 */
             ' does not contain ' ||,                             /* 0051 */
             subscript                                            /* 0052 */
      end                                                         /* 0053 */
end                                                               /* 0054 */
                                                                  /* 0055 */
exit                                                              /* 0056 */
