/* product name: RXJIS                                                */
/* Version:      0.40                                                 */
/* author:       YANO Takashi                                         */
/* target:       OS/2 Warp J3.0+                                      */
/* module name:  MIMERECV.CMD                                         */
/* source name:  MIMERECV.CMD                                         */
/* compiler:     N.A.                                                 */
/* address:      tyano@ca2.so-net.or.jp or tyano@yamato.ibm.co.jp     */
/* comment:      RXJIS is a utility functions for REXX.               */
/*               It encodes and decodes JIS 7 bit strings and MIME    */
/*               format strings.                                      */
/*                                                                    */
/*               MIMERECV.CMD is a sample program how to use          */
/*               RXJIS. I am using it with PostRoadMailer 1.03a.      */
/*               It converts a mail message with MIME or JIS 7bit     */
/*               into PC Kanji codet mail message.                    */
/*                                                                    */
/* how to use:   MIMERECV fn                                          */
/*               fn is a mail message file. The converted result is   */
/*               in fn. The original is lost.                         */
/*                                                                    */
/* history:      1996-2-5 0.00 initial release                        */
/*               1996-3-2 0.20 try to remove control chars in         */
/*                             message.                               */
/*                             Use RxLoadFuncs.                       */
/*               1996-04-21 0.30 charset can be lower.                */
/*               1996-05-01 0.40 Use RxJisMimeJisTo.                  */
/*               1996-05-24 0.51 Quit to translate control chars      */
/*                                                                    */
/*               1997-02-20 x.xx modify for PMMail                    */

options 'ETMODE'

remove_code = 'de'x	/* remove code for PMMail */
alter_code_first_byte = '81'x	/* alter code is  */
alter_code_second_byte = 'ac'x
japanese_code1 = '81'x	/* first byte code of Japanese */
japanese_code2 = '9f'x
japanese_code3 = 'e0'x
japanese_code4 = 'fc'x
LF = '0a'x
TAB = '09'x
SPC = '20'x
PAD = '!'
check_count = 60
cont_char_counter = 1
char_counter = 1
subject_line_num = 0
first_char = 0

signal on novalue
arg fn
parse source . . a
workingdir = filespec('D', a) || filespec('P', a)
errorlog = workingdir || 'errorlog.log'
call rxfuncadd 'RxJisLoadFuncs', 'RXJIS', 'RxJisLoadFuncs'
call RxJisLoadFuncs
call rxfuncadd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs' /* A@0.20 */
call SysLoadFuncs                                         /* A@0.20 */
if stream(fn, 'c', 'query exists') = '' then exit
do i = 1 by 1 while lines(fn)
	line.i = linein(fn)
	if line.i = '' then iterate
	line.i = RxJisMimeJisTo(line.i)

	/* add following */
	first_word = word(translate(line.i), 1)
	if first_word = 'SUBJECT:' then do
		subject_line_num = 1
		tmp_subject_line = strip(strip(subword(line.i, 2), ,TAB))
		line.i = word(line.i, 1) || ' '
		call process_subject
	end
	else if subject_line_num <> 0 then do
		if (substr(line.i, 1, 1) = TAB) | (substr(line.i, 1, 1) = SPC) then do
			tmp_subject_line = ' ' || strip(strip(line.i, ,TAB))
			line.i = ''
			call process_subject
		end
		else do
			subject_line_num = 0
		end
	end
	else if first_word = 'FROM:' | first_word = 'TO:' then do
		tmp_line = line.i
		line.i = ''
		call process_address
	end
	/* add above */

end /* do */

call stream fn, 'c', 'close'
line.0 = i - 1
tfn = value('TMP', , 'OS2ENVIRONMENT')
if tfn = '' then tfn = workingdir
if right(tfn, 1) <> '\' then tfn = tfn || '\'
tfn = SysTempFileName(tfn || '????')
do i = 1 to line.0
	call lineout tfn, line.i
end /* do */
call stream tfn, 'c', 'close'
'@copy' tfn fn '> NUL 2>&1'
call SysFileDelete tfn
exit

process_subject:
tmp_subject_line_num = length(tmp_subject_line)
char_counter = 1
do while(char_counter <= tmp_subject_line_num)
	first_char = substr(tmp_subject_line, char_counter, 1)
	if cont_char_counter > check_count then do
		line.i = line.i || first_char
	end 
	else do
		if (first_char >= japanese_code1) & (first_char <=japanese_code2) then do
			if cont_char_counter = check_count then do
				line.i = line.i || PAD
			end
			char_counter = char_counter + 1
			cont_char_counter = cont_char_counter + 1
			second_char = substr(tmp_subject_line, char_counter, 1)
			if second_char = remove_code then do
				line.i = line.i || alter_code_first_byte
				line.i = line.i || alter_code_second_byte
			end 
			else do
				line.i = line.i || first_char
				line.i = line.i || second_char
			end 
		end
		else if (first_char >= japanese_code3) & (first_char <= japanese_code4) then do
			if cont_char_counter = check_count then do
				line.i = line.i || PAD
			end
			char_counter = char_counter + 1
			cont_char_counter = cont_char_counter + 1
			second_char = substr(tmp_subject_line, char_counter, 1)
			if second_char = remove_code then do
				line.i = line.i || alter_code_first_byte
				line.i = line.i || alter_code_second_byte
			end 
			else do
				line.i = line.i || first_char
				line.i = line.i || second_char
			end 
		end
		else do
			line.i = line.i || first_char
		end
	end
	char_counter = char_counter + 1
	cont_char_counter = cont_char_counter + 1
end

if cont_char_counter >= check_count then do
	subject_line_num = 0
end

return

process_address:
tmp_line_num = length(tmp_line)
char_counter = 1
do while(char_counter <= tmp_line_num)
	first_char = substr(tmp_line, char_counter, 1)
	if (first_char >= japanese_code1) & (first_char <=japanese_code2) then do
		char_counter = char_counter + 1
		second_char = substr(tmp_line, char_counter, 1)
		if second_char = remove_code then do
			line.i = line.i || alter_code_first_byte
			line.i = line.i || alter_code_second_byte
		end 
		else do
			line.i = line.i || first_char
			line.i = line.i || second_char
		end 
	end
	else if (first_char >= japanese_code3) & (first_char <= japanese_code4) then do
		char_counter = char_counter + 1
		second_char = substr(tmp_line, char_counter, 1)
		if second_char = remove_code then do
			line.i = line.i || alter_code_first_byte
			line.i = line.i || alter_code_second_byte
		end 
		else do
			line.i = line.i || first_char
			line.i = line.i || second_char
		end 
	end
	else do
		line.i = line.i || first_char
	end
	char_counter = char_counter + 1
end

return

novalue:
call lineout errorlog, date('S') time() condition('C') '@' sigl
call lineout errorlog, date('S') time() condition('D')
call lineout errorlog, date('S') time() condition('I')
call stream errorlog, 'c', 'close'
say 'SEE:' errorlog
exit

