/* REXX: get http document (result incl. http headers to stdout)  */

/* v0.2: optional authorization@www.test instead of www.test for  */

/*       "Authorization:" header, use "Connection: Close" header, */

/*       avoid chunked data by specifying HTTP/1.0 instead of 1.1 */



   signal on novalue  name TRAP  ;  signal on syntax name TRAP

   signal on failure  name TRAP  ;  signal on halt   name TRAP



   parse arg TEXT

   select

      when arg()         > 2 then  exit TRAP( 'too many arguments' )

      when arg()         = 2 then  parse arg PEERNAME ,     TEXT

      when words( TEXT ) > 2 then  exit TRAP( 'too many arguments' )

      when words( TEXT ) = 2 then  parse arg PEERNAME       TEXT .

      when words( TEXT ) = 1 then  parse arg PEERNAME '/'   TEXT .

      otherwise                    exit HELP()

   end



   SOCK = -1   ;  N = 'SockLoadFuncs'

   if RxFuncQuery( N ) then            /* here FAIL throws a TRAP */

      if RxFuncAdd( N, 'RXSOCK', N ) then

         return FAIL( N 'in RXSOCK.DLL not found' )

   call SockLoadFuncs 'N'



   parse var PEERNAME PASSWORD '@' PEERNAME

   if PEERNAME = '' then parse var PASSWORD PEERNAME PASSWORD

   if SockGetHostByName( PEERNAME, 'PEER.1' ) = 0

      then return FAIL( 'unknown host' PEERNAME )



   PEER.1FAMILY   = 'AF_INET' ;  CRLF = x2c( 0D0A )

   PEER.1PORT     = 80



   TEXT = 'GET /'       || TEXT 'HTTP/1.0'

   TEXT = TEXT || CRLF  || 'Host:' || PEERNAME

   if PASSWORD <> '' then do

      PASSWORD = MIME( PASSWORD )

      TEXT = TEXT || CRLF  || 'Authorization: Basic' PASSWORD

   end

   TEXT = TEXT || CRLF  || 'Pragma: no-cache'

   TEXT = TEXT || CRLF  || 'Connection: close'

   TEXT = TEXT || CRLF  || 'User-Agent: RxGetUrl.cmd/0.2'

   TEXT = TEXT || CRLF  || CRLF



   SOCK = SockSocket( 'AF_INET', 'SOCK_STREAM', 'IPPROTO_TCP' )

   if SOCK = -1 then return FAIL( 'SockSocket() =' SOCK )



   signal on novalue  name SOCK  ;  signal on syntax name SOCK

   signal on failure  name SOCK  ;  signal on halt   name SOCK



   if SockConnect( SOCK, 'PEER.1' ) <> 0 then

      return FAIL( 'SockConnect' )

   if SockSend( SOCK, TEXT ) = -1 then

      return FAIL( 'SockSend' )

   if SockShutDown( SOCK, 1 ) <> 0 then

      return FAIL( 'SockShutDown' )



   TEXT = ''

   do until N = 0

      N = SockRecv( SOCK, 'MORE', 256 )

      if N = -1 then return FAIL( 'SockRecv' )

      TEXT = TEXT || left( MORE, N )

   end



   if SockClose( SOCK ) <> 0 then return FAIL( 'SockClose' )



   signal on novalue  name TRAP  ;  signal on syntax name TRAP

   signal on failure  name TRAP  ;  signal on halt   name TRAP



   say TEXT ;  exit 0



MIME: procedure                  /* encode authorization string:  */

   SRC = x2b( c2x( arg( 1 )))

   ADD = ''

   DST =        'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdef'

   DST = DST || 'ghijklmnopqrstuvwxyz0123456789+/'

   do N = 0 until DST = '' ;  parse var DST C.N 2 DST ;  end N

   do N = 1 to (( length( SRC ) // 24 ) / 4 ) // 3

      ADD = ADD || '='  ;  SRC = SRC || '00'

   end N

   do while SRC <> ''

      parse var SRC N 7 SRC

      N = x2d( b2x( N ))

      DST = DST || C.N

   end

   return DST || ADD



HELP: procedure                  /* show usage message and return */

   parse source . . N

   N = substr( N, 1 + lastpos( '\', N ))

   N = substr( N, 1 + lastpos( '/', N ))

   NN = ' e.g.:' N 'www.xyzzy.claranet.de index.html'

   NN = 'usage:' N 'host file' x2c( 0D0A ) || NN

   say NN   ;  return NN         /* caller can show NN in PM win. */



FAIL: procedure expose SOCK      /* show a socket error on stderr */

   NN = arg( 1 ) '(error' max( 0, SockSock_errno() - 10000 ) || ')'

   call SockPSock_errno NN       /* REXX handles missing function */

   call SockClose SOCK           /* as syntax TRAP exiting anyway */

   return NN                     /* caller can show NN in PM win. */



/* -------------------------------------------------------------- */



SOCK:                            /* close socket and handle TRAP: */

   call SockClose SOCK

   if result <> 0 then call SockPSock_errno 'SockClose() =' result



TRAP:                            /* select REXX exception handler */

   call trace 'O' ;  trace N           /* don't trace interactive */

   parse source TRAP                   /* source on separate line */

   TRAP = x2c( 0D ) || right( '+++', 10 ) TRAP || x2c( 0D0A )

   TRAP = TRAP || right( '+++', 10 )   /* = standard trace prefix */

   TRAP = TRAP condition( 'c' ) 'trap:' condition( 'd' )

   select

      when wordpos( condition( 'c' ), 'ERROR FAILURE' ) > 0 then do

         if condition( 'd' ) > ''      /* need an additional line */

            then TRAP = TRAP || x2c( 0D0A ) || right( '+++', 10 )

         TRAP = TRAP '(RC' rc || ')'   /* any system error codes  */

         if condition( 'c' ) = 'FAILURE' then rc = -3

      end

      when wordpos( condition( 'c' ), 'HALT SYNTAX'   ) > 0 then do

         if condition( 'c' ) = 'HALT' then rc = 4

         if condition( 'd' ) > '' & condition( 'd' ) <> rc then do

            if condition( 'd' ) <> errortext( rc ) then do

               TRAP = TRAP || x2c( 0D0A ) || right( '+++', 10 )

               TRAP = TRAP errortext( rc )

            end                        /* future condition( 'd' ) */

         end                           /* may use errortext( rc ) */

         else  TRAP = TRAP errortext( rc )

         rc = -rc                      /* rc < 0: REXX error code */

      end

      when condition( 'c' ) = 'NOVALUE'  then rc = -2 /* dubious  */

      when condition( 'c' ) = 'NOTREADY' then rc = -1 /* dubious  */

      otherwise                        /* force non-zero whole rc */

         if datatype( value( 'RC' ), 'W' ) = 0 then rc = 1

         if condition() = '' then TRAP = TRAP arg( 1 )

   end                                 /* direct: TRAP( message ) */



   TRAP = TRAP || x2c( 0D0A ) || format( sigl, 6 )

   signal on syntax name TRAP.SIGL     /* throw syntax error 3... */

   if 0 < sigl & sigl <= sourceline()  /* if no handle for source */

      then TRAP = TRAP '*-*' strip( sourceline( sigl ))

      else TRAP = TRAP '+++ (source line unavailable)'

TRAP.SIGL:                             /* ...catch syntax error 3 */

   if abbrev( right( TRAP, 2 + 6 ), x2c( 0D0A )) then do

      TRAP = TRAP '+++ (source line unreadable)'   ;  rc = -rc

   end

   select

      when 0 then do                   /* in pipes STDERR: output */

         parse version TRAP.REXX . .   /* REXX/Personal: \dev\con */

         signal on syntax name TRAP.FAIL

         if TRAP.REXX = 'REXXSAA'      /* fails if no more handle */

            then call lineout 'STDERR'  , TRAP

            else call lineout '\dev\con', TRAP

      end

      when 1 then do                   /* OS/2 PM: RxMessageBox() */

         signal on syntax name TRAP.FAIL

         call RxMessageBox ,           /* fails if not in PMREXX  */

            translate( TRAP, ' ', x2c( 0D )), , 'CANCEL', 'WARNING'

      end                              /* replace any CR by blank */

      otherwise   say TRAP ; trace ?L  /* interactive Label trace */

   end



   if condition() = 'SIGNAL' then signal TRAP.EXIT

TRAP.CALL:  return rc                  /* continue after CALL ON  */

TRAP.FAIL:  say TRAP ;  rc = 0 - rc    /* force TRAP error output */

TRAP.EXIT:  exit   rc                  /* exit for any SIGNAL ON  */

