/* +------------------------------------------------------------------------+
   |                                                                        |
   | RXAPI.C   :  RBI Rexx API                                              |
   | Author    :  Dave Lewis                                                |
   | Date      :  Mar   1996                                                |
   |                                                                        |
   | Modification Log:                                                      |
   |                                                                        |
   +------------------------------------------------------------------------+ */

#pragma strings(readonly)

#define INCL_DOS
#define INCL_SUB
#define INCL_REXXSAA

#include <os2.h>

#include <rexxsaa.h>
#include <memory.h>
#include <malloc.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "base64.h"

int utTxtToQuoted ( unsigned char **trget, unsigned char *source, int length );
int utQuotedToTxt ( unsigned char *target, unsigned char *source, int length );

/* +------------------------------------------------------------------------+
   | Declare all exported functions as REXX functions.                      |
   +------------------------------------------------------------------------+ */

RexxFunctionHandler rxLoadFuncs;

RexxFunctionHandler rxSetPathInfo;
RexxFunctionHandler rxBinToBase64;
RexxFunctionHandler rxBase64ToBin;
RexxFunctionHandler rxTxtToQuoted;
RexxFunctionHandler rxQuotedToTxt;

PSZ rxFunctions[] =
{
 "rxSetPathInfo",
 "rxBinToBase64",
 "rxBase64ToBin",
 "rxTxtToQuoted",
 "rxQuotedToTxt" 
};

/* +------------------------------------------------------------------------+
   | Function:  rxLoadFuncts                                                |
   +------------------------------------------------------------------------+ */

ULONG APIENTRY rxLoadFuncs( PUCHAR func, ULONG ac, PRXSTRING av,
                             PSZ    que, PRXSTRING ret )
{
  int i;

  for ( i = 0; i < sizeof( rxFunctions ) / sizeof(rxFunctions[0]); i++ )
    RexxRegisterFunctionDll( rxFunctions[ i ], "RXAPI", rxFunctions[ i ] );

  return( FALSE );
}

/* +------------------------------------------------------------------------+
   | Function:  rxTxtToQuoted                                               |
   | Syntax:    quoteddata = rxTxtToQuoted( source );                       |
   +------------------------------------------------------------------------+ */

ULONG APIENTRY rxTxtToQuoted( PUCHAR func, ULONG ac, PRXSTRING av,
                               PSZ    que, PRXSTRING ret )
{
  PUCHAR quoted;
  int retlen;

  if ( ac != 1 || !RXVALIDSTRING(av[0]) )
  {
    ret -> strptr[0] = 0;
    ret -> strlength = 0;
    return ( FALSE );
  }

  retlen = utTxtToQuoted ( &quoted, av[0].strptr, av[0].strlength );

  if ( retlen > 255 )
    DosAllocMem( (PVOID)&ret -> strptr, retlen + 8, PAG_READ|PAG_WRITE|PAG_COMMIT );

  ret -> strlength = retlen;

  memcpy( ret -> strptr, quoted, retlen );

  free ( quoted );

  return( FALSE );
}

/* +------------------------------------------------------------------------+
   | Function:  rxQuotedToTxt                                               |
   | Syntax:    quoteddata = rxQuotedToTxt( source );                       |
   +------------------------------------------------------------------------+ */

ULONG APIENTRY rxQuotedToTxt( PUCHAR func, ULONG ac, PRXSTRING av,
                               PSZ    que, PRXSTRING ret )
{
  if ( ac != 1 || !RXVALIDSTRING(av[0]) )
  {
    ret -> strptr[0] = 0;
    ret -> strlength = 0;
    return ( FALSE );
  }

  if ( av[0].strlength > 255 )
    DosAllocMem( (PVOID)&ret -> strptr, av[0].strlength, PAG_READ|PAG_WRITE|PAG_COMMIT );

  ret -> strlength = utQuotedToTxt ( ret -> strptr, av[0].strptr, av[0].strlength );

  return( FALSE );
}

/* +------------------------------------------------------------------------+
   | Function:  rxBinToBase64                                               |
   | Syntax:    base64data = rxBinToBase64( source );                       |
   +------------------------------------------------------------------------+ */

ULONG APIENTRY rxBinToBase64( PUCHAR func, ULONG ac, PRXSTRING av,
                               PSZ    que, PRXSTRING ret )
{
  int retlen;

  if ( ac != 1 || !RXVALIDSTRING(av[0]) )
  {
    ret -> strptr[0] = 0;
    ret -> strlength = 0;
    return ( FALSE );
  }

  retlen = ( av[0].strlength + 2 ) / 3 * 4;

  if ( retlen > 255 )
    DosAllocMem( (PVOID)&ret -> strptr, retlen + 8, PAG_READ|PAG_WRITE|PAG_COMMIT );

  ret -> strlength = utBinToBase64( ret -> strptr, av[0].strptr, av[0].strlength );

  return( FALSE );
}

/* +------------------------------------------------------------------------+
   | Function:  rxBase64ToBin                                               |
   | Syntax:    data = rxBinToBase64( base64data );                         |
   +------------------------------------------------------------------------+ */

ULONG APIENTRY rxBase64ToBin( PUCHAR func, ULONG ac, PRXSTRING av,
                               PSZ    que, PRXSTRING ret )
{
  int retlen;

  if ( ac != 1 || !RXVALIDSTRING(av[0]) )
  {
    ret -> strptr[0] = 0;
    ret -> strlength = 0;
    return ( FALSE );
  }

  retlen = av[0].strlength / 4 * 3;

  if ( retlen > 255 )
    DosAllocMem( (PVOID)&ret -> strptr, retlen + 8, PAG_READ|PAG_WRITE|PAG_COMMIT );

  ret -> strlength = utBase64ToBin( ret -> strptr, av[0].strptr, av[0].strlength );

  return( FALSE );
}

/* +------------------------------------------------------------------------+
   | Function:  rxSetFileAttribs                                            |
   | Syntax:    call rxSetPathInfo pathname, [date/time],[ attribs ]        |
   | Return:    return code from DosSetPathInfo                             |
   +------------------------------------------------------------------------+ */

ULONG APIENTRY rxSetPathInfo( PUCHAR func, ULONG ac, PRXSTRING av,
                               PSZ    que, PRXSTRING ret )
{
  LONG       rc;
  FILESTATUS3 fsts;

  if ( ac < 2 || ac > 3 || !RXVALIDSTRING(av[0]) )
  {
    strcpy( ret -> strptr, "-8" );
    ret -> strlength = 2;
    return ( FALSE );
  }

  rc = DosQueryPathInfo( av[0].strptr, FIL_STANDARD, &fsts, sizeof(fsts) );

  if ( !rc )
  {
    if ( RXVALIDSTRING(av[1]) )
    {
       /* YYYYMMDDHHMMSS */

      int varlen = strlen( av[1].strptr );

      if ( varlen > 12 )
      {
        fsts.ftimeLastWrite.twosecs = atoi( av[1].strptr + 12 ) / 2;
        av[1].strptr[12] = 0;
      }

      if ( varlen > 10 )
      {
        fsts.ftimeLastWrite.minutes = atoi( av[1].strptr + 10 );
        av[1].strptr[10] = 0;
      }

      if ( varlen >  8 )
      {
        fsts.ftimeLastWrite.hours   = atoi( av[1].strptr + 8  );
        av[1].strptr[8]  = 0;
      }

      if ( varlen >  6 )
      {
        fsts.fdateLastWrite.day     = atoi( av[1].strptr + 6  );
        av[1].strptr[6]  = 0;
      }

      if ( varlen >  4 )
      {
        fsts.fdateLastWrite.month   = atoi( av[1].strptr + 4  );
        av[1].strptr[4]  = 0;
      }

      fsts.fdateLastWrite.year      = atoi( av[1].strptr ) - 1980;
    }

    if ( ac == 3 && RXVALIDSTRING(av[2]) )
      fsts.attrFile  = atoi( av[2].strptr );

    rc = DosSetPathInfo( av[0].strptr, FIL_STANDARD, &fsts, sizeof( fsts ), DSPI_WRTTHRU );
  }

  sprintf( ret -> strptr, "%d", rc );
  ret -> strlength = strlen ( ret -> strptr );
  return( FALSE );
}

