/* Installation for RxCP290 Package */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* Get directory name to install to */

parse upper arg todir trash

/* Get directory name to install from */

parse upper source os src command
index = pos('INSTALL.CMD', command)
index = index-1
FromDir = SubStr(command,1, index)

/* Get Boot Drive, location of /OS2/APPS/DLL */

BootDrive = FileSpec('Drive', Value('SYSTEM_INI',,'OS2ENVIRONMENT'))
SysFile = BootDrive||'\CONFIG.SYS'
rc = SysFileSearch('LIBPATH=',SysFile,'val.','N')
index = pos('\OS2\APPS\DLL', val.1)
index = index - 2
DllToDir = Substr(val.1,index,15)

/* If no todir specified on command line, set to Bootdrive\RxCP290 */

if ToDir = "" then 
   ToDir = BootDrive||'\RxCP290'
   
/* Check with user if this installation is OK */

Call SysCls
Say '                          RxCP290 Installation Program'
Say 
Say
Say 'Installing From: ' FromDir
Say
Say 'Installing To:   ' ToDir
Say
Say
Say 'Is this OK?: (y/n)'
ans = SysGetKey('NOECHO')
ans = C2D(ans)
if (ans = 89 |  ans = 121) then nop
else do
  Say 'Aborting Installation!'
  exit
end

/* copy DLL to DllToDir  */

Say
Say 'Copying RxCP290 DLL to 'DllToDir'.'
Say
'@copy 'FromDir'rxcp290.dll 'DllToDir' >nul' 

/* Make ToDir */
Say 'Creating 'ToDir' Subdirectory.'
Say
rc = SysMkDir(ToDir)

/* Copy everything to ToDir */

Say 'Copying RxCP290 Utilities, Examples, and Documentation to 'ToDir'.' 
'@copy 'FromDir'*.* 'ToDir' >nul'
Say
Say 'Installation of RxCP290 Complete!'