/*
 * inline.c -- Runs a REXX macro from memory.
 */

#include <os2.h>
#include <rexxsaa.h>

BOOL RunInline( PSZ progbuf, ULONG proglen )
  {
    char     buf[ 256 ];
    APIRET   rc;
    RXSTRING result;
    SHORT    retcode;
    PSZ      filename;
    RXSTRING instore[2];

    /* Set storage for the result... */

    result.strptr    = buf;
    result.strlength = 256;

    /* Set the filename... this is informational mostly, so that
       a PARSE SOURCE in the inline program will return something. */

    filename = "INLINE";

    /* Now point to the inline program.  What you pass in is an
     * array of two RXSTRINGs.  The first RXSTRING is the inline
     * program.  The second RXSTRING will be filled by RexxStart:
     * it's the tokenized version of the inline program.  You can
     * save the tokenized version for use later on -- instead of
     * passing the inline program, just pass the tokenized one.
     * The tokenized version starts executing a bit more quickly
     * because the interpreter doesn't have to reparse it.
     */

    instore[0].strptr    = progbuf;
    instore[0].strlength = proglen;

    instore[1].strptr    = NULL;
    instore[1].strlength = 0;

    rc = RexxStart( 0, NULL, filename, instore, "CMD", RXCOMMAND,
                    NULL, &retcode, &result );

    /* If you don't use the tokenized version of the program, you
     * should be sure to free it... */

    if( instore[1].strptr ){
        DosFreeMem( instore[1].strptr );
    }

    if( result.strptr != buf ){
        DosFreeMem( result.strptr );
    }

    return( rc == 0 );
  }
