/**2/REXX*********************************************************************/
/* Function Name: RPLRXGET                                                   */
/*****************************************************************************/
/* Function Description:                                                     */
/*                                                                           */
/* This routine will display information about a specific RIPL client using  */
/* the RxNetGetRIPLMachineInfo API call.                                     */
/*****************************************************************************/
/* Example:                                                                  */
/*                                                                           */
/* RPLRXGET /L:2 /M:A_MACH                                                   */
/*****************************************************************************/
/* Algorithm:                                                                */
/*                                                                           */
/* begin rplrxget                                                            */
/* |>if there are no input parameters then display the syntax                */
/* |>load and verify input parameters                                        */
/* |>call RxNetGetRIPLMachineInfo API                                        */
/* |>display the information returned from the API                           */
/* |>exit with resulting return code                                         */
/* end rplrxget                                                              */
/*****************************************************************************/
/* trace ?i */
if arg() = 0 then
do
  say 'Get RIPL Machine Information--Command Syntax:'
  say 'RPLRXGET /L: /M: [/S:]'
  say '/L: Level of detail from API(0-2)'
  say '/M: OS/2 Machine ID(<= 15) or DOS Machine ID(<= 8)'
  say '/S: remote IPL Server name(<= 15)'
  exit 0
end
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
call RxFuncAdd 'RxRegRIPLFuncs', 'RXRPLEXT', 'RXREGRIPLFUNCS'
call RxRegRIPLFuncs
/*****************************************************************************/
/* initialize variables                                                      */
/*****************************************************************************/
rc       = 0
level    = -1
mach_id  = ''
ripl_svr = ''
/*****************************************************************************/
/* load and verify parameters                                                */
/*****************************************************************************/
arg p.0 p.1 p.2 p.3
if p.3 <> '' then
do
  rc = 8
  call error
end
do i = 0 to 2
  if p.i <> '' then
  do
    sep_pos = pos(':', p.i)
    if sep_pos = 0 then
    do
      rc = 19
      call error
    end
    parm_sec     = sep_pos - 1
    parm         = substr(p.i, 1, parm_sec)
    parm_val_sec = length(p.i) - sep_pos
    parm_val     = substr(p.i, sep_pos+1, parm_val_sec)
    if      parm = '/L' then
    do
      if (parm_val <> 0) & (parm_val <> 1) & (parm_val <> 2) then
      do
        rc = 20
        call error
      end
      level = parm_val
    end
    else if parm = '/M' then
    do
      if length(parm_val) > 15 then
      do
        rc = 12
        call error
      end
      mach_id = parm_val
    end
    else if parm = '/S' then
    do
      if length(parm_val) > 15 then
      do
        rc = 16
        call error
      end
      ripl_svr = '\\' || parm_val
    end
    else
    do
      rc = 17
      call error
    end
  end
end
if (level = -1) | (mach_id = '') then
do
  rc = 5
  call error
end
call RxNetGetRIPLMachineInfo ripl_svr, level, mach_id, stem
if RESULT <> 0 then
do
  if RESULT < 2100 then
    msg = SysGetMessage(RESULT)
  else
    msg = SysGetMessage(RESULT, 'NET.MSG')
  say msg
  exit RESULT
end
/*****************************************************************************/
/* display the information for the specified RIPL client                     */
/*****************************************************************************/
say ''
say 'RIPL Client Data'
say ''
say ''
say 'machine ID:         'stem.1.name
if level <> 0 then
  say 'description:        'stem.1.remark
if level = 2 then
do
  say 'adapter address:    'stem.1.adapter
  if stem.1.os2recid <> '' then
  do
    say 'OS' || ,
        '/2'
    say 'OS/2 boot drive:    'stem.1.os2bootdrive
    say 'server record ID:   'stem.1.os2recid
    say 'OS/2 config. flags: 'stem.1.os2flags
  end
  if stem.1.dosrecid <> '' then
  do
    say 'DO' || ,
        'S'
    say 'DOS image ID:       'stem.1.dosimageid
    say 'server record ID:   'stem.1.dosrecid
  end
end
exit 0
/*****************************************************************************/
/* this routine displays the appropriate error message then exits            */
/*****************************************************************************/
error:
if      rc = 5 then
  say 'at least one of the necessary parameters was not specified'
else if rc = 8 then
  say 'an incorrect number of parameters was specified'
else if rc = 12 then
  say 'the machine ID specified is more than 15 characters in length'
else if rc = 16 then
do
  say 'the remote IPL server name specified is more than 15 characters in'
  say 'length'
end
else if rc = 17 then
  say 'an invalid parameter was specified'
else if rc = 19 then
  say 'a parameter was specified with an invalid format'
else if rc = 20 then
  say 'an incorrect value was specified for the level(/L:) parameter'
exit rc
