/**2/REXX*********************************************************************/
/* Function Name: RPLRXDEL                                                   */
/*****************************************************************************/
/* Function Description:                                                     */
/*                                                                           */
/* This routine will delete a RIPL client using the RxNetDeleteRIPLMachine   */
/* API call.                                                                 */
/*****************************************************************************/
/* Example:                                                                  */
/*                                                                           */
/* RPLRXDEL /M:A_MACH                                                        */
/*****************************************************************************/
/* Algorithm:                                                                */
/*                                                                           */
/* begin rplrxdel                                                            */
/* |>if there are no input parameters then display the syntax                */
/* |>load and verify input parameters                                        */
/* |>call RxNetDeleteRIPLMachine API                                         */
/* |>exit with resulting return code                                         */
/* end rplrxdel                                                              */
/*****************************************************************************/
/* trace ?i */
if arg() = 0 then
do
  say 'Delete RIPL Machine--Command Syntax:'
  say 'RPLRXDEL /M: [/S:]'
  say '/M: OS/2 Machine ID(<= 15) or DOS Machine ID(<= 8)'
  say '/S: remote IPL Server name(<= 15)'
  exit 0
end
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
call RxFuncAdd 'RxRegRIPLFuncs', 'RXRPLEXT', 'RXREGRIPLFUNCS'
call RxRegRIPLFuncs
/*****************************************************************************/
/* initialize variables                                                      */
/*****************************************************************************/
rc       = 0
mach_id  = ''
ripl_svr = ''
/*****************************************************************************/
/* load and verify parameters                                                */
/*****************************************************************************/
arg p.0 p.1 p.2
if p.2 <> '' then
do
  rc = 8
  call error
end
do i = 0 to 1
  if p.i <> '' then
  do
    sep_pos = pos(':', p.i)
    if sep_pos = 0 then
    do
      rc = 19
      call error
    end
    parm_sec     = sep_pos - 1
    parm         = substr(p.i, 1, parm_sec)
    parm_val_sec = length(p.i) - sep_pos
    parm_val     = substr(p.i, sep_pos+1, parm_val_sec)
    if      parm = '/M' then
    do
      if length(parm_val) > 15 then
      do
        rc = 12
        call error
      end
      mach_id = parm_val
    end
    else if parm = '/S' then
    do
      if length(parm_val) > 15 then
      do
        rc = 16
        call error
      end
      ripl_svr = '\\' || parm_val
    end
    else
    do
      rc = 17
      call error
    end
  end
end
if mach_id = '' then
do
  rc = 5
  call error
end
call RxNetDeleteRIPLMachine ripl_svr, mach_id
if RESULT <> 0 then
do
  if RESULT < 2100 then
    msg = SysGetMessage(RESULT)
  else
    msg = SysGetMessage(RESULT, 'NET.MSG')
  say msg
  exit RESULT
end
say 'the specified RIPL client was deleted successfully'
exit 0
/*****************************************************************************/
/* this routine displays the appropriate error message then exits            */
/*****************************************************************************/
error:
if      rc = 5 then
  say 'at least one of the necessary parameters was not specified'
else if rc = 8 then
  say 'an incorrect number of parameters was specified'
else if rc = 12 then
  say 'the machine ID specified is more than 15 characters in length'
else if rc = 16 then
do
  say 'the remote IPL server name specified is more than 15 characters in'
  say 'length'
end
else if rc = 17 then
  say 'an invalid parameter was specified'
else if rc = 19 then
  say 'a parameter was specified with an invalid format'
exit rc
