/**2/REXX*********************************************************************/
/* Function Name: RPLRXCRE                                                   */
/*****************************************************************************/
/* Function Description:                                                     */
/*                                                                           */
/* This routine will create a RIPL client in one of the two following ways:  */
/* 1. create new RIPL client from default specifications using level 2       */
/*    RxNetCreateRIPLMachine API call                                        */
/* 2. create new RIPL client by cloning an existing RIPL client using level  */
/*    12 RxNetCreateRIPLMachine API call                                     */
/*****************************************************************************/
/* Example:                                                                  */
/*                                                                           */
/* RPLRXCRE /F:2 /M:A_MACH /A:123456789ABC /R:R_21_OTK /B:Z /C:D             */
/*****************************************************************************/
/* Algorithm:                                                                */
/*                                                                           */
/* begin rplrxcre                                                            */
/* |>if there are no input parameters then display the syntax                */
/* |>load and verify input parameters                                        */
/* |>call RxNetCreateRIPLMachine API                                         */
/* |>exit with resulting return code                                         */
/* end rplrxcre                                                              */
/*****************************************************************************/
/* trace ?i */
if arg() = 0 then
do
  say 'Create RIPL Machine--Command Syntax:'
  say 'RPLRXCRE /F:C /M: /A: /R: {(/B: & /C:) | /I:} [/S: /D:]'
  say 'RPLRXCRE /F:M /M: /A: /O: [/S: /D:]'
  say '/F: C->Create new RIPL client'
  say '    M->create new RIPL client by Modeling existing RIPL client'
  say '/M: OS/2 Machine ID(<= 15) or DOS Machine ID(<= 8)'
  say '/A: hex network adapter Address(12)'
  say '/R: server Record ID(<= 40)'
  say '/B: OS/2 remote IPL Boot drive ID(C-Z)'
  say '/C: OS/2 Configuration flags(<= 3)'
  say '    L->Local swapper file  |E->Ega display'
  say '    S->Server swapper file |U->sUper vga display'
  say '    I->Isa bus             |V->Vga display'
  say '    M->Microchannel bus    |X->Xga display'
  say '    3->s3 super vga display|D->Default flags->LMV'
  say '    8->8514 display        |'
  say '/I: DOS Image ID(<= 8)'
  say '/S: remote IPL Server name(<= 15)'
  say '/D: Description-cannot include blanks(<= 40)'
  say '/O: mOdel machine ID(<= 15)'
  exit 0
end
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
call RxFuncAdd 'RxRegRIPLFuncs', 'RXRPLEXT', 'RXREGRIPLFUNCS'
call RxRegRIPLFuncs
/*****************************************************************************/
/* initialize variables                                                      */
/*****************************************************************************/
rc               = 0
level            = 0
mach_id          = ''
adap_add         = ''
os2_srid         = ''
dos_srid         = ''
boot_drv         = ''
cfg_flgs         = ''
cfg_flgs_raw     = ''
cfg_flgs_raw_len = 0
dos_image        = ''
ripl_svr         = ''
description      = ''
model_id         = ''
OS2              = 0
/*****************************************************************************/
/* load and verify parameters                                                */
/*****************************************************************************/
arg p.0 p.1 p.2 p.3 p.4 p.5 p.6 p.7 p.8
if p.8 <> '' then
do
  rc = 8
  call error
end
do i = 0 to 7
  if p.i <> '' then
  do
    sep_pos = pos(':', p.i)
    if sep_pos = 0 then
    do
      rc = 19
      call error
    end
    parm_sec     = sep_pos - 1
    parm         = substr(p.i, 1, parm_sec)
    parm_val_sec = length(p.i) - sep_pos
    parm_val     = substr(p.i, sep_pos+1, parm_val_sec)
    if      parm = '/F' then
    do
      if      parm_val = 'C' then
        level = 2
      else if parm_val = 'M' then
        level = 12
      else
      do
        rc = 10
        call error
      end
    end
    else if parm = '/M' then
    do
      if length(parm_val) > 15 then
      do
        rc = 12
        call error
      end
      mach_id=parm_val
    end
    else if parm = '/A' then
    do
      if length(parm_val) <> 12 then
      do
        rc = 13
        call error
      end
      adap_add = parm_val
    end
    else if parm = '/R' then
    do
      if length(parm_val) > 40 then
      do
        rc = 14
        call error
      end
      if pos('R_D', parm_val) = 0 then
      do
        OS2 = 1
        os2_srid = parm_val
      end
      else
        dos_srid = parm_val
    end
    else if parm = '/B' then
    do
      if (length(parm_val) > 1) | (parm_val < 'C') | (parm_val > 'Z') then
      do
        rc = 9
        call error
      end
      boot_drv = parm_val
    end
    else if parm = '/C' then
    do
      cfg_flgs_raw_len = length(parm_val)
      if cfg_flgs_raw_len > 3 then
      do
        rc = 6
        call error
      end
      cfg_flgs_raw = parm_val
    end
    else if parm = '/I' then
    do
      if length(parm_val) > 8 then
      do
        rc = 15
        call error
      end
      dos_image = parm_val
    end
    else if parm = '/S' then
    do
      if length(parm_val) > 15 then
      do
        rc = 16
        call error
      end
      ripl_svr = '\\' || parm_val
    end
    else if parm = '/D' then
    do
      if length(parm_val) > 40 then
      do
        rc = 4
        call error
      end
      description = parm_val
    end
    else if parm = '/O' then
    do
      if length(parm_val) > 15 then
      do
        rc = 11
        call error
      end
      model_id = parm_val
    end
    else
    do
      rc = 17
      call error
    end
  end
end
if level = 2 then
do
  if model_id <> '' then
  do
    rc = 17
    call error
  end
/*****************************************************************************/
/* level 2--OS/2 RIPL client                                                 */
/*****************************************************************************/
  if OS2 = 1 then
  do
    if (mach_id = '') | (adap_add = '') | (os2_srid = '') | (boot_drv = '') | ,
       (cfg_flgs_raw = '') then
    do
      rc = 5
      call error
    end
    if (dos_image <> '') | (dos_srid <> '') then
    do
      rc = 21
      call error
    end
    cfg_flgs = 'OS2_SWAPPER_LOCAL'
    slot1    = 0
    slot2    = 0
    slot3    = 0
/*****************************************************************************/
/* are the default OS/2 configuration flags specified with the default flag  */
/*****************************************************************************/
    slot = pos('D', cfg_flgs_raw)
    if slot <> 0 then
    do
      call slot_proc
    end
    else
    do
      swapper  = 0
      bus      = 0
      display  = 0
/*****************************************************************************/
/* is a local swapper file specified                                         */
/*****************************************************************************/
      slot = pos('L', cfg_flgs_raw)
      if slot <> 0 then
      do
        swapper = 1
        call slot_proc
      end
/*****************************************************************************/
/* is a remote swapper file specified                                        */
/*****************************************************************************/
      slot = pos('S', cfg_flgs_raw)
      if slot <> 0 then
      do
        if swapper = 1 then
        do
          rc = 1
          call error
        end
        cfg_flgs = 'OS2_SWAPPER_SERVER'
        call slot_proc
      end
/*****************************************************************************/
/* is an ISA bus specified                                                   */
/*****************************************************************************/
      slot = pos('I', cfg_flgs_raw)
      if slot <> 0 then
      do
        bus = 1
        cfg_flgs = cfg_flgs || '|' || 'OS2_BUS_ISA'
        call slot_proc
      end
/*****************************************************************************/
/* is a microchannel bus specified                                           */
/*****************************************************************************/
      slot = pos('M', cfg_flgs_raw)
      if slot <> 0 then
      do
        if bus = 1 then
        do
          rc = 2
          call error
        end
        call slot_proc
      end
/*****************************************************************************/
/* is a VGA display type specified                                           */
/*****************************************************************************/
      slot = pos('V', cfg_flgs_raw)
      if slot <> 0 then
      do
        display = 1
        call slot_proc
      end
/*****************************************************************************/
/* is an S3 super VGA display specified                                      */
/*****************************************************************************/
      slot = pos('3', cfg_flgs_raw)
      if slot <> 0 then
      do
        display = 1
        cfg_flgs = cfg_flgs || '|' || 'OS2_DISPLAY_S3SVGA'
        call slot_proc
      end
/*****************************************************************************/
/* is an 8514 display specified                                              */
/*****************************************************************************/
      slot = pos('8', cfg_flgs_raw)
      if slot <> 0 then
      do
        if display = 1 then
        do
          rc = 3
          call error
        end
        display = 1
        cfg_flgs = cfg_flgs || '|' || 'OS2_DISPLAY_IBM8514'
        call slot_proc
      end
/*****************************************************************************/
/* is an EGA display specified                                               */
/*****************************************************************************/
      slot = pos('E', cfg_flgs_raw)
      if slot <> 0 then
      do
        if display = 1 then
        do
          rc = 3
          call error
        end
        display = 1
        cfg_flgs = cfg_flgs || '|' || 'OS2_DISPLAY_IBMEGA'
        call slot_proc
      end
/*****************************************************************************/
/* is a super VGA display specified                                          */
/*****************************************************************************/
      slot = pos('U', cfg_flgs_raw)
      if slot <> 0 then
      do
        if display = 1 then
        do
          rc = 3
          call error
        end
        display = 1
        cfg_flgs = cfg_flgs || '|' || 'OS2_DISPLAY_SVGA'
        call slot_proc
      end
/*****************************************************************************/
/* is an XGA display specified                                               */
/*****************************************************************************/
      slot = pos('X', cfg_flgs_raw)
      if slot <> 0 then
      do
        if display = 1 then
        do
          rc = 3
          call error
        end
        display = 1
        cfg_flgs = cfg_flgs || '|' || 'OS2_DISPLAY_IBMXGA32'
        call slot_proc
      end
    end
/*****************************************************************************/
/* are there any invalid OS/2 configuration flags specified                  */
/*****************************************************************************/
    if ((cfg_flgs_raw_len = 3) & ((slot1 = 0) | (slot2 = 0) | (slot3 = 0))) | ,
       ((cfg_flgs_raw_len = 2) & ((slot1 = 0) | (slot2 = 0))) | ,
       ((cfg_flgs_raw_len = 1) & (slot1 = 0)) then
    do
      rc = 7
      call error
    end
  end
/*****************************************************************************/
/* level 2--DOS RIPL client                                                  */
/*****************************************************************************/
  else
  do
    if p.7 <> '' then
    do
      rc = 8
      call error
    end
    if (mach_id = '') | (adap_add = '') | (dos_srid = '') | ,
       (dos_image = '') then
    do
      rc = 5
      call error
    end
    if (os2_srid <> '') | (boot_drv <> '') | (cfg_flgs <> '') then
    do
      rc = 21
      call error
    end
    if length(mach_id) > 8 then
    do
      rc = 18
      call error
    end
  end
  call RxNetCreateRIPLMachine ripl_svr, level, mach_id, description, ,
                              adap_add, boot_drv, dos_image, dos_srid, ,
                              os2_srid, cfg_flgs
end
/*****************************************************************************/
/* verify level 12 parameters                                                */
/*****************************************************************************/
else if level = 12 then
do
  if p.6 <> '' then
  do
    rc = 8
    call error
  end
  if (os2_srid <> '') | (dos_srid <> '') | (boot_drv <> '') | ,
     (cfg_flgs_raw <> '') | (dos_image <> '') then
  do
    rc = 17
    call error
  end
  if (mach_id = '') | (adap_add = '') | (model_id = '') then
  do
    rc = 5
    call error
  end
  if length(model_id) > 15 then
  do
    rc = 11
    call error
  end
  call RxNetCreateRIPLMachine ripl_svr, level, mach_id, description, ,
                              adap_add, model_id
end
else
do
  rc = 5
  call error
end
if RESULT <> 0 then
do
  if RESULT < 2100 then
    msg = SysGetMessage(RESULT)
  else
    msg = SysGetMessage(RESULT, 'NET.MSG')
  say msg
  exit RESULT
end
say 'the specified RIPL client was created successfully'
exit 0
/*****************************************************************************/
/* this routine displays the appropriate error message then exits            */
/*****************************************************************************/
error:
if      rc = 1 then
  say 'a machine cannot have a local swapper file and a remote swapper file'
else if rc = 2 then
  say 'a machine cannot have a microchannel bus and an ISA bus'
else if rc = 3 then
  say 'a machine can have only one type of display'
else if rc = 4 then
do
  say 'the value specified for the description parameter is more than 40'
  say 'characters in length'
end
else if rc = 5 then
  say 'at least one of the necessary parameters was not specified'
else if rc = 6 then
do
  say 'the OS/2 configuration flags value is greater than 3 characters'
  say 'in length'
end
else if rc = 7 then
do
  say 'an incorrect flag was used as part of the OS/2 configuration flags'
  say 'value or a flag was repeated in the OS/2 configuration flags value'
end
else if rc = 8 then
  say 'an incorrect number of parameters was specified'
else if rc = 9 then
do
  say 'the OS/2 boot drive value should be 1 alphabetic character in the range'
  say 'from C to Z inclusive'
end
else if rc = 10 then
  say 'an inappropriate value was specified for the function(/F:) parameter'
else if rc = 11 then
  say 'the model ID value specified is more than 15 characters in length'
else if rc = 12 then
  say 'the machine ID specified is more than 15 characters in length'
else if rc = 13 then
  say 'the adapter address specified is not exactly 12 characters in length'
else if rc = 14 then
  say 'the server record ID specified is more than 40 characters in length'
else if rc = 15 then
do
  say 'the DOS image ID value specified is more than 8 characters in'
  say 'length'
end
else if rc = 16 then
do
  say 'the remote IPL server name specified is more than 15 characters in'
  say 'length'
end
else if rc = 17 then
  say 'an invalid parameter was specified'
else if rc = 18 then
  say 'the DOS machine ID specified is more than 8 characters in length'
else if rc = 19 then
  say 'a parameter was specified with an invalid format'
else if rc = 21 then
  say 'DOS and OS/2 parameters were specified resulting in a conflict'
exit rc
/*****************************************************************************/
/* this routine ensures that every OS/2 configuration flag specified is      */
/* accounted for                                                             */
/*****************************************************************************/
slot_proc:
if      slot = 1 then
  slot1 = 1
else if slot = 2 then
  slot2 = 1
else if slot = 3 then
  slot3 = 1
return
