/* rexx
 *
 * name:      RickACT.cmd
 *
 * date:      July 20, 1995
 *
 * Author:    Rick Kruer for OS/2 Magazine
 *            <rick@computer-miracles.com>
 *
 * Function:  This Rexx program will read a Symantec Act! for Windows
 *            database (dbf) in comma delimted format, extracting
 *            name and address data to produce VisPro/Reports labels.
 *
 *            This program as written will extract ALL records from
 *            the Act! database, modify to suit your needs.
 *
 * Status:    This program is freeware and may be distributed for free.
 *
 */

namestem.          = ''
keepstem.          = ''
exclude.           = ''
exclude.COUNTRY    = 1                    /* Exclude this Act! field */
exclude.MANAGER    = 1                    /* Exclude this Act! field */
exclude.OWNERRY    = 1                    /* Exclude this Act! field */
exclude.SALUTATION = 1                    /* Exclude this Act! field */
namestem.0         = 0
keepstem.0         = 0
exclude.0          = 0
incount            = 0
outcount           = 0
infile             = 'd:\actwin2\database\miracles.txt'
outfile            = 'y:\work\vpreport.txt'
limit_infile       = ''                       /* limit count or null */

say
say "Welcome to Rick's Act! database reformat for VisPro/Reports"
say
say "Input comma delimited database text file:" infile
say "Output VisPro/Report text formatted file:" outfile
say
say "Note: this may take many minutes depending on file size"
say "W o r k i n g . . ."
say
/*
 *---------------------------------------------------------------------
 *   Register Rexx Utility functions
 *---------------------------------------------------------------------
 */
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

/*
 *---------------------------------------------------------------------
 *   Delete output file if it exists
 *---------------------------------------------------------------------
 */
rc = stream(outfile, 'C', 'QUERY EXISTS')
if rc <> '' then do
   rc = stream(outfile, 'C', 'CLOSE')
   rc = SysFileDelete(outfile)
   say 'file' outfile 'deleted'
   end

/*
 *---------------------------------------------------------------------
 *   Open files
 *---------------------------------------------------------------------
 */
rc = stream(infile, 'C', 'OPEN READ')
if rc \= 'READY:' then do
   say 'Error doing stream open read'
   say 'rc=' rc
   end

rc = stream(outfile, 'C', 'OPEN WRITE')
if rc \= 'READY:' then do
   say 'Error doing stream open write'
   say 'rc=' rc
   end

/*
 *---------------------------------------------------------------------
 *   Read Act! comma delimited database, created reformatted data
 *   Write out formatted file for use in VisPro/Reports
 *---------------------------------------------------------------------
 */
line = linein(infile)
first = 1
incount = 1
do while lines(infile) <> 0

   i = 0
   do i=i+1
      k = pos('",',line)
      if k = 0 then leave
      name = substr(line,1,k)
      name = strip(name,'B','"')
      line = substr(line,k+2)

      if first = 1 then do             /* Special procesing for     */
         keepstem.0 = keepstem.0 + 1   /* first record includes     */
         keepstem.i = name             /* saving database field     */
         end                           /* names (such as 'Name',    */
      else do                          /* 'Address', 'Phone', etc.) */
         namestem.0 = namestem.0 + 1
         namestem.i = name
         end
      end

/*
 *---------------------------------------------------------------------
 *   Process each database field for this record
 *---------------------------------------------------------------------
 */
   first = 0
   do i = 1 to namestem.0
      if namestem.i = '' then iterate
      name = keepstem.i
      if exclude.name = 1 then iterate
      out = 'Data.'incount'.'left(keepstem.i,12,' ') '=' '"'namestem.i'"'
      rc = lineout(outfile,out)
      outcount = outcount + 1
      end

   out = 'Comment' '=' '"----------------------------------------------------------------"'
   rc = lineout(outfile,out)
   line = linein(infile)
   incount = incount + 1
   end

/*
 *---------------------------------------------------------------------
 *   Close up shop
 *---------------------------------------------------------------------
 */
rc = stream(infile, 'C', 'CLOSE')
rc = stream(outfile, 'C', 'CLOSE')

say 'Input record count.........................' right(incount,9)
say 'Output record count........................' right(outcount,9)
exit 0
