:userdoc.
:title.UU&slash.XX&slash.Base64 Encoders and Decoders
:docprof toc=12.
:h1.Copyrights and Notices
:p.The following copyright information applies to the various components of this software.
:h2.The PL/I Run&hyphen.Time Library
:h3.IBM Supplied Software
:p.I am contractually obliged by IBM to include the following, since you need a copy of the PL/I
run&hyphen.time library in order to run this code&per.
:p.CONTAINS
.br
IBM PL/I for OS/2 Professional Edition Version 1&per.2
.br
Runtime Modules
.br
(c) Copyright IBM Corporation 1994, 1996
.br
All rights reserved
:h2.The OS&slash.2 Commands and REXX Extension DLL
:h3.COPYRIGHT AND LICENSING INFORMATION
:p.This suite of programs and subroutines is freeware, distributed as is, without any warranty
of its usefulness for any purpose&per. You may use it freely&per. You may also redistribute it,
provided no charge is levied beyond the price of its distribution medium&per.
:p.However, the author retains all intellectual property rights&per.
.br
.ce Copyright (C) David W. Noon, 1995, 1997
:h3.OBTAINING TECHNICAL SUPPORT
:p.You can obtain technical support via Internet e-mail, Compuserve or FidoNet Netmail&per.
My addresses are as follows&per.
:font facename='System Monospaced' size=16x12.
:parml compact tsize=15 break=none.
:pt.Internet&colon.
:pd.david_noon&atsign.donor2.demon.co.uk
:pt.
:pd.dwnoon&atsign.ibm.net
:pt.
:pd.dnoon&atsign.acm.org
:pt.Compuserve&colon.
:pd.72172,431
:pt.FidoNet&colon.
:pd.David Noon 2&colon.440&slash.4
:eparml.
:font facename=default size=0x0.
:p.The FidoNet mailbox and the first listed Internet mailbox, which are the same place, I check almost every day&per.
The others are checked less frequently, such as every third day or so&per.
:p.Turn&hyphen.around time on problems might not be spectacular, especially if I have other issues
to handle&per. This is freeware and you should expect no more than you pay for&per.
:h1.The Encoding and Decoding Specifications
:p.The following are &odq.table napkin specs&per.&cdq. for the various encoding schemes supported
by this software&per.
:h2.The UU and XX Encoding and Decoding Specifications
:p.Condensed from a doc file for a UUENCODE&slash.DECODE program by&colon.
:lm margin=20.
.br
Richard Marks
.br
931 Sulgrave Lane
.br
Bryn Mawr, PA 19010
:lm margin=1.
:p.UU&hyphen.encoding is a way to code a file which may contain any characters into a standard character set that can be reliably sent over diverse networks.
.br
:h3.THE CHARACTER ENCODING&colon.
:p.The basic scheme is to break groups of 3 eight bit characters &lpar.24 bits&rpar. into 4 six bit characters and then add 32 &lpar.a space&rpar.
to each six bit character which maps it into the readily transmittable character&per.
Another way of phrasing this is to say that the encoded 6 bit characters are mapped into the set&colon.
:lm margin=5.:font facename=Courier size=16x12.
.br
`&xclm.&cdq.&numsign.&dollar.&percent.&amp.&apos.&lpar.&rpar.&asterisk.&plus.,&hyphen.&per.&slash.012356789&colon.;&lt.&eq.&gt.?&atsign.ABC&per.&per.&per.XYZ&lbrk.&bslash.&rbrk.&caret.&us.
:lm margin=1.:font facename=default size=0x0.
.br
for transmission over communications lines&per.
:p.As some transmission mechanisms compress or remove spaces, spaces are changed into back&hyphen.quote characters &lpar.a 96&rpar.&per.
&lpar.A better scheme might be to use a bias of 33 so the space is not created, but this is not done&per.&rpar.
:p.Another newer less popular encoding method, called XX&hyphen.encoding uses the set&colon.
:lm margin=5.:font facename=Courier size=16x12.
.br
&plus.&hyphen.01&per.&per.&per.89ABC&per.&per.&per.XYZabc&per.&per.&per.xyz
:lm margin=1.:font facename=default size=0x0.
:p.In my opinion, XX&hyphen.encoding is superior to UU&hyphen.encoding because it uses more &odq.normal&cdq. characters that are less likely to get corrupted&per.
In fact several of the special characters in the UU set do not get thru an EBCDIC to ASCII translation correctly&per.
Conversely, an advantage of the UU set is that it does not use lower case characters&per.
Now&hyphen.a&hyphen.days both upper and lower case are sent with no problems; maybe in the communications dark ages, there was a problem with lower case&per.
.br
:h3.COMPOSING A LINE OF ENCODED CHARACTERS&colon.
:p.A small number of eight bit characters are encoded into a single line and a count is put at the start of the line&per.
&lpar.Most lines in an encoded file have 45 encoded characters&per. When you look at a UU&hyphen.encoded file note that most lines start with the letter &odq.M&cdq.&per.  &odq.M&cdq. is decimal 77 which, minus the 32 bias, is 45&per.&rpar.
:p.This encode program puts a check character at the end of each line&per. The check is the sum of all the encoded characters, before adding the mapping, modulo 64&per.
:Note. Horton 9&slash.1&slash.87 UUENCODE has a bug in the line check algorithm; it uses the sum of the original, not the encoded characters&per.
.br
:h3.PACKAGING THE LINES INTO FILES&colon.
:p.The lines of encoded data can be preceded by comments and by network addressing information.  The encoded data is directly preceded by a line containing&colon. begin &lt.file&hyphen.mode&gt. &lt.file&hyphen.name&gt.
:p.The final end of encoded data is an encoded line with zero encoded characters &lpar.a back&hyphen.quote&rpar., followed by a line containing &odq.end&cdq.&per.
.br
:h3.SPLITING UP LONG FILES&colon.
:p.Long files are broken into several sections before transmission&per. This is done because very large files are cumbersome to handle and because some networks require files to be less than 64K bytes&per.
.br
:h3.TABLE LINES&colon.
:p.Some encoded files put the mapping used at the front of the encoded file, just in front of the &odq.begin&cdq. line&per. The format for this is&colon.
:xmp.
table
first 32 characters
second 32 characters
:exmp.
:p.All this starts in column 1&per.
:h2.The Base64 Encoding and Decoding Specifications
:p.Darned if I know where I put these, but they&apos.re real simple&per. Read the code&per.
:h1.The Commands
:p.The command syntax descriptions follow&per.
:h2.The UUENCODE Command
:h3.Syntax
:p.The command is issued from an OS&slash.2 command prompt as follows&colon.
:p.:lm margin=10.:font facename=Courier size=16x12.UUENCODE &lt.Output file&gt. &lt.Input file&gt. &lbrk.&lt.Input file&gt. &per.&per.&per.&rbrk.:font facename=default size=0x0.
:lm margin=1.:p.The output file name is mandatory, as is at least one input file name&per. The input file&lpar.s&rpar. will be read as a binary byte stream&per. The output file will contain
all the specified input files, each with its own &osq.begin&csq. record so that they will be separated when decoded&per.
:h2.The UUDECODE Command
:h3.Syntax
:p.The command is issued from an OS&slash.2 command prompt as follows&colon.
:p.:lm margin=10.:font facename=Courier size=16x12.UUDECODE &lbrk.HORTON&rbrk. &lt.Input file&gt. &lbrk.&plus.&lt.Input file&gt. &per.&per.&per.&rbrk.:font facename=default size=0x0.
:lm margin=1.:p.At 1 least input file name is mandatory&per. Additional input files can be concatenated with a plus sign &lpar.&plus.&rpar. with no embedded spaces&per. All encoded files
in the input concatenation will be decoded&per.
The purpose of this is to allow for the download of multiple messages for a large file and have the decoder join them back together again&per.
:p.The HORTON flag indicates that the decoder should allow for Horton's erroneous checksum algorithm&per. This option must be first and is case sensitive&per.
If you get a lot of checksum warnings decoding a file &lpar.like on every line&rpar. this option might cure the problem&per.
:h2.The XXENCODE Command
:h3.Syntax
:p.The command is issued from an OS&slash.2 command prompt as follows&colon.
:p.:lm margin=10.:font facename=Courier size=16x12.XXENCODE &lt.Output file&gt. &lt.Input file&gt. &lbrk.&lt.Input file&gt. &per.&per.&per.&rbrk.:font facename=default size=0x0.
:lm margin=1.:p.The output file name is mandatory, as is at least one input file name&per. The input file&lpar.s&rpar. will be read as a binary byte stream&per. The output file will contain
all the specified input files, each with its own &osq.begin&csq. record so that they will be separated when decoded&per.
:h2.The XXDECODE Command
:h3.Syntax
:p.The command is issued from an OS&slash.2 command prompt as follows&colon.
:p.:lm margin=10.:font facename=Courier size=16x12.XXDECODE &lbrk.HORTON&rbrk. &lt.Input file&gt. &lbrk.&plus.&lt.Input file&gt. &per.&per.&per.&rbrk.:font facename=default size=0x0.
:lm margin=1.:p.At 1 least input file name is mandatory&per. Additional input files can be concatenated with a plus sign &lpar.&plus.&rpar. with no embedded spaces&per. All encoded files
in the input concatenation will be decoded&per.
The purpose of this is to allow for the download of multiple messages for a large file and have the decoder join them back together again&per.
:p.The HORTON flag indicates that the decoder should allow for Horton's erroneous checksum algorithm&per. This option must be first and is case sensitive&per.
If you get a lot of checksum warnings decoding a file &lpar.like on every line&rpar. this option might cure the problem&per. However, this bug is more likely to
manifest itself in a UU&hyphen.encoded file than an XX&hyphen.encoded file&per.
:h1.The REXX Functions
:p.The REXX extension functions are all in a library called REXXUUXX&per.DLL&per.
:note.REXXUUXX is meant to rhyme with &odq.Gadzooks&cdq., not &odq.Shucks&cdq.&per.
:p.Each function must be loaded as needed by the RxFuncAdd&lpar.&rpar. built&hyphen.in function of REXX&per.
For example&colon.
:xmp.
CALL RxFuncAdd &osq.UUDecodeFiles&csq.,&osq.REXXUUXX&csq.,&osq.UUDecodeFiles&csq.
:exmp.
:p.The DLL has been linked as case insensitive, so the third parameter can be any mixture of lower
case and capital letters&per.
:h2.UUEncodeFiles
:h3.DESCRIPTION
:p.The UUEncodeFiles subroutine takes a list of input files and creates an output file that is the
UU&hyphen.encoded form of those files&per. You must specify the name of the output file, and it must
be the first parameter supplied&per. Each input file has its own &osq.begin&csq. statement so
that the individual files will be separated again when decoded&per.
.br
:h3.Syntax
:p.The calling sytax is as follows&colon.
:p.:lm margin=15.:font facename=Courier size=16x12.
CALL UUEncodeFiles &osq.OUTFILE&per.UUE&csq.,&osq.INFILE1&per.DAT&csq.&lbrk.,&osq.INFILE2&per.DAT&csq.&rbrk. &per.&per.&per.
:font facename=default size=0x0.:lm margin=1.
:h2.UUDecodeFiles
:h3.DESCRIPTION
:p.The UUDecodeFiles subroutine takes a list of input files and creates an output file that is the
UU&hyphen.decoded form of those files&per. The output file&lpar.s&rpar. are determined by the
&osq.begin&csq. record that are encountered in the encoded input&per.
.br
:h3.Syntax
:p.The calling sytax is as follows&colon.
:p.:lm margin=15.:font facename=Courier size=16x12.
CALL UUDecodeFiles &osq.INFILE1&per.UUE&csq.&lbrk.,&osq.INFILE2&per.UUE&csq.&rbrk. &per.&per.&per.
:font facename=default size=0x0.:lm margin=1.
:p.The multiple input files facility is very useful if you have downloaded a file that spans
multiple messages&per. They are simply concatenated back together by the subroutine, but you do need
to code them in the correct order&per.
:p.If you find that an encoded file does not decode properly, it is possible it was encoded using
the invalid checksum algorithm, attributable to Horton&per. To overcome this, the first parameter
can be the string &osq.HORTON&csq., in all capital letters&per. On seeing this, the decoder
routine will use Horton&apos.s checksum algorithm instead&per. Use sparingly&per.
:p.:lm margin=15.:font facename=Courier size=16x12.
CALL UUDecodeFiles &osq.HORTON&csq.,&osq.INFILE1&per.UUE&csq.&lbrk.,&osq.INFILE2&per.UUE&csq.&rbrk. &per.&per.&per.
:font facename=default size=0x0.:lm margin=1.
:h2.XXEncodeFiles
:h3.DESCRIPTION
:p.The XXEncodeFiles subroutine takes a list of input files and creates an output file that is the
XX&hyphen.encoded form of those files&per. You must specify the name of the output file, and it must
be the first parameter supplied&per. Each input file has its own &osq.begin&csq. statement so
that the individual files will be separated again when decoded&per.
.br
:h3.Syntax
:p.The calling sytax is as follows&colon.
:p.:lm margin=15.:font facename=Courier size=16x12.
CALL XXEncodeFiles &osq.OUTFILE&per.XXE&csq.,&osq.INFILE1&per.DAT&csq.&lbrk.,&osq.INFILE2&per.DAT&csq.&rbrk. &per.&per.&per.
:font facename=default size=0x0.:lm margin=1.
:h2.XXDecodeFiles
:h3.DESCRIPTION
:p.The XXDecodeFiles subroutine takes a list of input files and creates an output file that is the
XX&hyphen.decoded form of those files&per. The output file&lpar.s&rpar. are determined by the
&osq.begin&csq. record that are encountered in the encoded input&per.
.br
:h3.Syntax
:p.The calling sytax is as follows&colon.
:p.:lm margin=15.:font facename=Courier size=16x12.
CALL XXDecodeFiles &osq.INFILE1&per.XXE&csq.&lbrk.,&osq.INFILE2&per.XXE&csq.&rbrk. &per.&per.&per.
:font facename=default size=0x0.:lm margin=1.
:p.The multiple input files facility is very useful if you have downloaded a file that spans
multiple messages&per. They are simply concatenated back together by the subroutine, but you do need
to code them in the correct order&per.
:p.If you find that an encoded file does not decode properly, it is possible it was encoded using
the invalid checksum algorithm, attributable to Horton&per. To overcome this, the first parameter
can be the string &osq.HORTON&csq., in all capital letters&per. On seeing this, the decoder
routine will use Horton&apos.s checksum algorithm instead&per. Use sparingly&per.
:p.:lm margin=15.:font facename=Courier size=16x12.
CALL XXDecodeFiles &osq.HORTON&csq.,&osq.INFILE1&per.XXE&csq.&lbrk.,&osq.INFILE2&per.XXE&csq.&rbrk. &per.&per.&per.
:font facename=default size=0x0.:lm margin=1.
:p.This problem is very rare in XX&hyphen.encoded files&per. It is more typical of UU&hyphen.encoded
files&per.
:h2.Base64EncodeFiles
:h3.DESCRIPTION
:p.The Base64EncodeFiles subroutine takes an input file and creates an output file that is the
Base64&hyphen.encoded form of those files&per. You must specify the name of the output file, and it must
be the first parameter supplied&per. There only only 2 parameters for this subroutine&per.
.br
:h3.Syntax
:p.The calling sytax is as follows&colon.
:p.:lm margin=15.:font facename=Courier size=16x12.
CALL Base64EncodeFiles &osq.OUTFILE&per.B64&csq.,&osq.INFILE&per.DAT&csq.
:font facename=default size=0x0.:lm margin=1.
:h2.Base64DecodeFiles
:h3.DESCRIPTION
:p.The Base64DecodeFiles subroutine takes a list of input files and creates an output file that is the
Base64&hyphen.decoded form of those files&per. You must specify the name of the output file, since the
Base64 encoding does not include the filename, and it must be the first parameter supplied&per.
.br
:h3.Syntax
:p.The calling sytax is as follows&colon.
:p.:lm margin=15.:font facename=Courier size=16x12.
CALL Base64DecodeFiles &osq.OUTFILE&per.DAT&csq.,&osq.INFILE1&per.B64&csq.&lbrk.,&osq.INFILE2&per.B64&csq.&rbrk. &per.&per.&per.
:font facename=default size=0x0.:lm margin=1.
:p.The multiple input files facility is very useful if you have downloaded a file that spans
multiple messages&per. They are simply concatenated back together by the subroutine, but you do need
to code them in the correct order&per.
:euserdoc.
