/*
    USERMAINT.CMD User Maintenance Functions

    Supports the following User Functions
	ADDUSER -   Add a User
	DELUSER -   Del a User

    Written: Steven Elliott, August 1993

    Requires REXXNET.DLL
*/

/*
**********************************************************************
  GLOBAL VARIABLES
*/

version = 1.3
tab = D2C(9)
cr = D2C(13)

Server = ''
Alias.All = 7
Alias.File = 1
Alias.Print = 2
App.Public = 2
App.All = 7
App.Private = 2

Drives.Num = 8	 /* Drives M to T */
Drives.First = 'M'

Ports.Num = 4	 /* LPT1 to LPT4 */

App.Excel = 'APMEXCEL'
App.PMWord = 'APMWORD'

Location.HomeDirs = 'F:\HomeDirs'
Location.Sections = 'G:\Sections'
Location.HomeServer = 'HOMEFS'
Location.SectionServer = 'FSHOME'

/********************************************
  Standard Logon Connections
*/
StdLogonAsn.Entries = 4
StdLogonAsn.0.Device = 'H'
StdLogonAsn.0.Alias = 'H'
StdLogonAsn.0.Type = Alias.File
StdLogonAsn.1.Device = 'W'
StdLogonAsn.1.Alias = 'UDOSAPPS'
StdLogonAsn.1.Type = Alias.File
StdLogonAsn.2.Device = 'X'
StdLogonAsn.2.Alias = 'USYSTEM'
StdLogonAsn.2.Type = Alias.File
StdLogonAsn.3.Device = 'Y'
StdLogonAsn.3.Alias = 'UCOMMON'
StdLogonAsn.3.Type = Alias.File

Globals = 'StdLogonAsn. LogonAsn. Drives. Ports. Server App. Alias. UserID Tab UserInfo. Location.'

/*********************************************/

call rxfuncadd SysLoadFuncs, "RexxUtil", SysLoadFuncs
call SysLoadFuncs
call rxfuncadd NetLoadFuncs, "RexxNet", NetLoadFuncs
call NetLoadFuncs
signal on syntax
signal on halt
call main


done:
say ""
say "Thankyou for using UsrMaint"
call NetDropFuncs
exit

halt:
say "UsrMaint interrupted"
call NetDropFuncs
exit

syntax:
say ""
say "Sorry, I've got a headache,"
say "I don't think I can help you at the moment"
say ""
say "Line:" sigl " Error:" rc ':' errortext(rc)
signal done

/*************************************************************
     MAIN
*/

main:
UserID = ''
Server = ''
retc = NetWkstaGetInfo('', 10, Wksta)
if retc \= 0 then do
  call error retc
  return
end
retc = NetGetDCName('', Wksta.Logon_Domain, 'Server')
if retc \= 0 then do
  call error retc
  return
end
do forever
  call SysCls
  say "UserMaint - Version" version
  say ""
  say "Domain :" Wksta.Logon_Domain
  say "PDC    :" Substr(Server, 3)
  say ""
  say "Please select one of the following:"
  say ""
  say "  N)   New User"
  say "  M)   Modify/Delete User"
  say "  R)   Reset Users Password"
  say "  Z)   Zap User (Delete)"
  say ""
  say "  V)   View User Setup"
  say "  L)   List All Users"
  say ""
  say "  P)   Change Printer Connections"
  say "  D)   Change Drive Connections"
  say "  A)   Change Applications"
  say ""
  say "  X)   Exit"
  say ""
  call charout '', "Enter your selection --> "
  parse upper pull func

  if func = 'C' then
    leave

  if func = 'X' then
    leave

  if func = 'L' then do
    call listUser
    iterate
  end
  say ""
  call charout '', "Enter UserID "
  if UserID \= '' then
    call charout '', "(or ENTER for '"||UserID||"')"
  call charout '', " --> "
  parse upper pull newID
  if newID \= '' then
    UserID = newID
  retc = NetUserGetInfo(Server, UserID, 10, UserInfo)
  select
    when retc = 0 then
      nop

    when retc = 2221 then
      if func \= 'N' then do
	say "User does not exist"
	call pause
	iterate
      end

    otherwise do
      call error retc
      iterate
    end
  end

  call SysCls
  select
    when func = 'V' then
      call viewUser

    when func = 'M' then
      call modUser

    when func = 'N' then
      if retc \= 2221 then do
	say "User Already Exists"
	say ""
	call viewUser
      end
      else
	call newUser

    when func = 'R' then
      call ResetPWD

    when func = 'Z' then
      call DelUser

    when func = 'P' then
      call PrintCon

    when func = 'A' then
      call AppSel

    when func = 'D' then
      call Drives

    otherwise
      iterate
  end
  call pause
end /* forever */
return

pause:
  parse arg extra
  say ""
  if extra \= '' then
    say extra
  call charout '', "Hit ENTER to continue "
  parse pull operation
  return

/*************************************************************
     APPSEL

    Allows changes to a user Public Applications
*/

AppSel:
changed = 0
retc = NetUserGetAppSel(Server, UserID, 1, App.All, AppSel)
if retc \= 0 then do
    call error retc
    return
end
do forever
say ""
say "Current Applications for" UserInfo.usr_Comment '('UserInfo.Name')'
say ""
do i = 0 to AppSel.Entries - 1
    say AppSel.i.AppName
end
say ""
say "Enter A)dd to add entry,"
say "      D)elete to remove entry,"
say "      L)ist to show available,"
say "      S)ave current changes,"
say "      C)ancel all changes"
say ""
call charout '', "Enter Option --> "
parse upper pull option
select
  when option = 'L' then do
    retc = NetAppEnum(Server, UserId, 1, App.All, Apps)
    if retc \= 0 then do
      call error retc
      return
    end
    say ""
    j = 0
    do i = 0 to Apps.Entries - 1
      say Left(Apps.i.Name, 16, ' ') Apps.i.Remark
      j = j + 1
      if j = 23 then do
	call charout "", "Hit ENTER to contine "
	parse pull quit
	if quit \= '' then
	  leave
	say ""
	j = 0
      end
    end
    call charout '', "Hit ENTER to continue "
    parse pull quit
  end

  when option = 'A' then do
    call charout '', "Enter Application Name --> "
    parse upper pull newapp
    if newapp \= '' then do
      i = AppSel.Entries
      AppSel.i.AppName = newapp
      AppSel.i.AppType = App.Public
      AppSel.Entries = i + 1
      retc = NetGroupAddUser(Server, newapp, UserID)
      changed = 1
    end
  end

  when option = 'D' then do
    call charout '', "Enter Application Name --> "
    parse upper pull delapp
    do i = 0 to AppSel.Entries - 1
      if AppSel.i.AppName = DelApp then do
	do j = i to AppSel.Entries - 2
	  k = j + 1
	  AppSel.j.AppName = AppSel.k.AppName
	  AppSel.j.AppType = AppSel.k.AppType
	end
	AppSel.Entries = AppSel.Entries - 1
	changed = 1
	retc = NetGroupDelUser(Server, DelApp, UserID)
	leave
      end
    end
  end

  when option = 'C' then
    return

  otherwise
    leave
end /* select */
end /* forever loop */

if changed = 0 then
    return
say "Updating User Application List..."
retc = NetUserSetAppSel(Server, UserID, 1, AppSel)
if retc \= 0 then do
  call error retc
  return
end
call ViewUser
return


/*************************************************************
     DRIVES

    Allow changes to a user's Drive Links
*/

Drives: procedure expose (Globals)
parse arg new
if new \= '' then do
  say "Logon Assignments"
  signal skipdrives
end
say ""
say "Current Drive Connections for" UserInfo.usr_Comment '('UserInfo.Name')'
say ""
retc = NetUserGetLogonAsn(Server, UserID, 1, Alias.All, LogonAsn)
if retc \= 0 then do
    call error retc
    return
end
call StemSort 'LogonAsn' 'Device' 'Alias' 'Type'
do i = 0 to LogonAsn.Entries - 1
  if LogonAsn.i.Type \= Alias.File then
    iterate
  if LogonAsn.i.Device = StdLogonAsn.0.Device then
    leave
  say LogonAsn.i.Device||":" tab LogonAsn.i.Alias
end
say ""
skipdrives:
changed = 0
say ""
say "Enter 'D' to remove entry,"
say "      'L' to list available,"
say "      'S' to save current changes,"
say "      'C' to cancel changes,"
say "      ENTER to skip,"
say "   or Alias to use"
say ""
do drive = 0 to Drives.Num - 1
  cdrive = D2C(drive + C2D(Drives.First))
  call charout '', "Enter new Alias for" cdrive||": --> "
  parse upper pull newalias
  if newalias = '' then
    iterate
  select
  when newalias = 'C' then do
    say "Changes Cancelled"
    return
  end

  when newalias = 'S' then
    leave

  when newalias = 'L' then do
    say ""
    say "Drive Aliases"
    say ""
    retc = NetAliasEnum(Server, 1, Alias.File, Connects)
    if retc \= 0 then do
      call error retc
      return
    end
    j = 0
    say ""
/* TOO SLOW -- call StemSort 'Connects' 'Alias' */
    do i = 0 to Connects.Entries - 1
      if Left(Connects.i.Alias, 1) = 'F' then do
	say Left(Connects.i.Alias, 16, ' ') Connects.i.Remark
	j = j + 1
	if j = 23 then do
	  call charout "", "Hit ENTER to contine "
	  parse pull quit
	  if quit \= '' then
	    leave
	  say ""
	  j = 0
	end
      end
    end
    say ""
    drive = drive - 1
    end
  otherwise do
    if newalias \= 'D' & NetAliasGetInfo(Server, newalias, 0, Test) \= 0 then do
      call pause "Alias does not exist"
      drive = drive - 1
      iterate
    end
    do i = 0 to LogonAsn.Entries - 1
      if cdrive = LogonAsn.i.Device then do
	if newalias = 'D' then do
	  do j = i to LogonAsn.Entries - 2
	    k = j + 1
	    LogonAsn.j.Device = LogonAsn.k.Device
	    LogonAsn.j.Type = LogonAsn.k.Type
	    LogonAsn.j.Alias = LogonAsn.k.Alias
	  end
	  LogonAsn.Entries = LogonAsn.Entries - 1
	  changed = 1
	  retc = NetGroupDelUser(Server, newalias, UserID)
	  leave
	end
	LogonAsn.i.Alias = newalias
	changed = 1
	leave
      end
    end
    if (i = LogonAsn.Entries) & (newalias \= 'D') then do
      LogonAsn.i.Device = cdrive
      LogonAsn.i.Type = Alias.File
      LogonAsn.i.Alias = newalias
      LogonAsn.Entries = LogonAsn.Entries + 1
      retc = NetGroupAddUser(Server, newalias, UserID)
      changed = 1
    end
  end
  end /* select */
end
if new \= '' then
    return
if changed \= 0 then do
  say "Updating User's Drive Connections ..."
  retc = NetUserSetLogonAsn(Server, UserID, 1, LogonAsn)
  if retc \= 0 then do
    call error retc
    return
  end
  call ViewUser
end
return

/*************************************************************
     PRINTCON

    Allow changes to a user's Printer Connections
*/

PrintCon: procedure expose (Globals)
parse arg new
if new \= '' then do
  say ""
  say "Printer Assignments"
  signal skipPrint
end
say ""
say "Current Print Connections for" UserInfo.usr_Comment '('UserInfo.Name')'
say ""
retc = NetUserGetLogonAsn(Server, UserID, 1, Alias.All, LogonAsn)
if retc \= 0 then do
    call error retc
    return
end
call StemSort 'LogonAsn' 'Device' 'Alias' 'Type'
do i = 0 to LogonAsn.Entries - 1
  if LogonAsn.i.Type = Alias.Print then
    say LogonAsn.i.Device tab LogonAsn.i.Alias
end
say ""
skipPrint:
changed = 0
say ""
say "Enter 'D' to remove entry,"
say "      'L' to list available,"
say "      'S' to save current changes,"
say "      'C' to cancel changes,"
say "      ENTER to skip,"
say "   or Alias to use"
say ""
do port = 1 to Ports.Num
  cport = D2C(port + C2D('0'))
  call charout '', "Enter new Alias for LPT"||cport " --> "
  parse upper pull newalias
  if newalias = '' then
    iterate
  select
  when newalias = 'C' then do
    say "Changes Cancelled"
    return
  end

  when newalias = 'S' then
    leave

  when newalias = 'L' then do
    say ""
    say "Printer Aliases"
    say ""
    retc = NetAliasEnum(Server, 1, Alias.Print, Queues)
    if retc \= 0 then do
      call error retc
      return
    end
    call StemSort 'Queues' 'Alias' 'Remark'
    j = 0
    do i = 0 to Queues.Entries - 1
      say Queues.i.Alias tab Queues.i.Remark tab
      j = j + 1
      if j = 23 then do
	call charout "", "Hit ENTER to contine "
	parse pull quit
	if quit \= '' then
	  leave
	say ""
	j = 0
      end
    end
    say ""
    port = port - 1
  end

  otherwise do
    if newalias \= 'D' & NetAliasGetInfo(Server, newalias, 0, Test) \= 0 then do
      say "Alias does not exist"
      port = port - 1
      iterate
    end
    do i = 0 to LogonAsn.Entries - 1
      if "LPT"||cport = LogonAsn.i.Device then do
	if newalias = 'D' then do
	  do j = i to LogonAsn.Entries - 2
	    k = j + 1
	    LogonAsn.j.Device = LogonAsn.k.Device
	    LogonAsn.j.Type = LogonAsn.k.Type
	    LogonAsn.j.Alias = LogonAsn.k.Alias
	  end
	  LogonAsn.Entries = LogonAsn.Entries - 1
	  changed = 1
	  retc = NetGroupDelUser(Server, newalias, UserID)
	  leave
	end
	LogonAsn.i.Alias = newalias
	changed = 1
	leave
      end
    end
    if (i = LogonAsn.Entries) & (newalias \= 'D') then do
      LogonAsn.i.Device = "LPT"||cport
      LogonAsn.i.Type = Print_Alias
      LogonAsn.i.Alias = newalias
      LogonAsn.Entries = LogonAsn.Entries + 1
      retc = NetGroupAddUser(Server, newalias, UserID)
      changed = 1
    end
  end
  end /* select */
end
if new \= '' then
    return
if changed \= 0 then do
  say "Updating User's Print Connections ..."
  retc = NetUserSetLogonAsn(Server, UserID, 1, LogonAsn)
  if retc \= 0 then do
    call error retc
    return
  end
  call ViewUser
end
return


/*************************************************************
     RESETPASSWORD

    Reset Users Password
*/

ResetPWD:
say ""
say "Reset User's Password"
say ""
say "UserID:    " UserID
say "User Name: " UserInfo.usr_comment
say ""
call charout '', "Hit ENTER to Reset Password, any other key to skip "
parse upper pull confirm
if confirm = '' then do
  say ""
  say "Resetting '"||UserInfo.Usr_Comment||"'s Password to '"||UserID||"'"
  retc = NetUserSetInfo(Server, UserId, 2, UserID, 3)
  if retc \= 0 then do
    call error retc
    return
  end
  /* The following re-enables the account incase it has been disabled */
  retc = NetUserSetInfo(Server, UserId, 2, 1, 8)
end
call error retc
return

/*************************************************************
     MODUSER

    Modify User
*/

ModUser:
say ""
say "Modify User"
say ""
say "UserID:    " UserID
say "User Name: " UserInfo.usr_comment
say "Comment 1: " UserInfo.comment
say "Comment 2: " UserInfo.full_name
say ""
call charout '', "Enter new User Name --> "
parse pull name
call charout '', "Enter new Comment 1 --> "
parse pull comment
call charout '', "Enter new Comment 2 --> "
parse pull comment2
say ""
if name = '' & comment = '' & comment2 = '' then
  return
say "Updating User ..."
if name \= '' then do
  retc = NetUserSetInfo(Server, UserId, 2, name, 12)
  if retc \= 0 then do
    call error retc
    return
  end
end
if comment \= '' then do
  retc = NetUserSetInfo(Server, UserId, 2, comment, 7)
  if retc \= 0 then do
    call error retc
    return
  end
end
if comment2 \= '' then do
  retc = NetUserSetInfo(Server, UserId, 2, comment2, 11)
  if retc \= 0 then do
    call error retc
    return
  end
end
call ViewUser
return


/*************************************************************
     DELUSER
*/

DelUser:
say ""
say "Delete User"
say ""
call ViewUser
say ""
call charout '', "Enter Y to delete, any other key to continue "
parse upper pull confirm
if confirm \= 'Y' then do
  say "Delete Cancelled"
  return
end
retc = NetUserDel(Server, UserID)
if retc \= 0 then
  call error retc
retc = NetAliasDel(Server, 'H'UserID)
if retc \= 0 then
  call error retc
say "User Deleted Successfully"
say ""
say "NOTE: The Users Alias has been removed, but their files still exist"
say ""
return

/*************************************************************
     NEWUSER
*/

newUser:
say ""
say "New User"
say ""
UserInfo.Name = UserID
UserInfo.Password = UserID
UserInfo.Priv = 1
UserInfo.Flags = 1
UserInfo.Auth_Flags = 0
UserInfo.Max_Storage = -1
UserInfo.acct_expires = -1
UserInfo.Code_Page = 437
UserInfo.Country_Code = 062
say "UserID: " UserID
call charout '', "Enter User Name --> "
parse pull UserInfo.Usr_Comment
call charout '', "Enter Comment 1 --> "
parse pull UserInfo.Comment
call charout '', "Enter Comment 2 --> "
parse pull UserInfo.Full_Name
if UserInfo.Comment = '' then
  UserInfo.Comment = ' '
if UserInfo.Full_Name = '' then
  UserInfo.Full_Name = ' '

do i = 0 to StdLogonAsn.Entries - 1
  LogonAsn.i.Device = StdLogonAsn.i.Device
  LogonAsn.i.Alias = StdLogonAsn.i.Alias
  LogonAsn.i.Type = StdLogonAsn.i.Type
end
LogonAsn.Entries = StdLogonAsn.Entries
LogonAsn.0.Alias = 'H'UserID

call Drives New
call PrintCon New

AppEntries = 0
call charout '', "Does user require PM Word Access (Y/n) --> "
parse upper pull confirm
if (confirm = 'Y') | (confirm = '') then do
  Apps.AppEntries.Appname = App.PMWord
  Apps.AppEntries.AppType = App.Public
  AppEntries = AppEntries + 1
end
call charout '', "Does user require PM Excel Access (Y/n) --> "
parse upper pull confirm
if (confirm = 'Y') | (confirm = '') then do
  Apps.AppEntries.Appname = App.Excel
  Apps.AppEntries.AppType = App.Public
  AppEntries = AppEntries + 1
end

do while 1
  call charout '', "Enter any other Application Names --> "
  parse upper pull Apps.AppEntries.Appname
  if Apps.AppEntries.Appname = '' then
    leave
  if NetAppGetInfo(Server, '', Apps.AppEntries.Appname, 0, Test) \= 0 then do
    say "Application does not exist"
    iterate
  end
  Apps.AppEntries.AppType = App.Public
  AppEntries = AppEntries + 1
end

say ""
say "Adding User ..."
say ""
retc = NetUserAdd(Server, 2, UserInfo)
if retc \= 0 then do
  call error retc
  return
end

say "Initializing DCDB"
retc = NetUserDCDBInit(Server, UserID)
if retc \= 0 then do
  call error retc
  retc = NetUserDel(Server, UserID)
  return
end


say "Creating Home Directory ..."
retc = NetAliasGetInfo(Server, 'OHOMEDIR', 2, aInfo)
if retc \= 0 then do
  call error retc
  retc = NetUserDel(Server, UserID)
  return
end
uInfo.Local = 'Z:'
uInfo.Remote = aInfo.Server'\'aInfo.NetName
uInfo.Asg_Type = 0
retc = NetUseDel('', 'Z:', 2)
retc = NetUseAdd('', 1, uInfo)
if retc \= 0 then do
  call error retc
  retc = NetUserDel(Server, UserID)
  return
end
retc = SysMkDir('Z:\'UserId)
if (retc \= 0) & (retc \= 5) then do
  call error retc
  retc = NetUserDel(Server, UserID)
  return
end
aInfo.Alias = 'H'UserID
aInfo.NetName = 'H'UserID
aInfo.Max_Users = 2
aInfo.Path = Location.HomeDirs'\'UserID
aInfo.Remark = 'Home Dir -' UserInfo.Usr_Comment '('Location.HomeServer')'
retc = NetAliasAdd(Server, 2, aInfo)
if (retc \= 0) & (retc \= 2782) then do
  call error retc
  retc = NetUserDel(Server, UserID)
  return
end
/*
    Now create the Sharename that the Alias points to
*/
sInfo.NetName = aInfo.NetName
sInfo.Type = 0
sInfo.Remark = aInfo.Remark
sInfo.Max_Users = aInfo.Max_Users
sInfo.Path = aInfo.Path
sInfo.Passwd = ''
retc = NetShareAdd(aInfo.Server, 2, sInfo)
if (retc \= 0) & (retc \= 2118) then do
  call error retc
  retc = NetUserDel(Server, UserID)
  return
end

/*
    Wait for UserID to arrive at Home server
*/
call charout '', "Waiting for Account Replication."
do forever
  retc = NetUserGetInfo(aInfo.Server, UserID, 0, 'Temp')
  if retc = 0 then
    leave
  if retc \= 2221 then do
    call error retc
    return
  end
  call charout '', '.'
  call SysSleep 5
end
say ""
acInfo.resource_name = 'Z:\'UserID
acInfo.attr = 0
acInfo.count = 1
acInfo.access_list.0.ugname = UserID
acInfo.access_list.0.access = 127
retc = NetAccessDel('', acInfo.resource_name)
retc = NetAccessAdd('', 1, acInfo)
if retc \= 0 then do
  say "Could not set Access Permissions for User Home Directory"
  call error retc
end
say "Copying Standard User Files"
'@XCOPY X:\NewUser Z:\'UserID '/S/E >NUL'
if rc \= 0 then do
  say "Could not copy New User Files to users Home Directory"
end
retc = NetUseDel('', 'Z:', 2)

say "Setting Logon Assignments ..."
retc = NetUserSetLogonAsn(Server, UserID, 1, LogonAsn)
if retc \= 0 then do
  call error retc
  retc = NetUserDel(Server, UserID)
  return
end

say "Setting Public Applications ..."
Apps.Entries = AppEntries
retc = NetUserSetAppSel(Server, UserID, 1, Apps)
if retc \= 0 then do
  call error retc
  retc = NetUserDel(Server, UserID)
  return
end

say "Adding user to Groups"
retc = NetGroupEnum(Server, 0, gInfo)
if retc \= 0 then do
  call error retc
  gInfo.Entries = 0
end

do i = 0 to LogonAsn.Entries - 1
  do j = 0 to gInfo.Entries - 1
    if LogonAsn.i.Alias = gInfo.j.Name then
      leave
  end
  if j \= gInfo.Entries then do
    retc = NetGroupAddUser(Server, gInfo.j.Name, UserID)
    if retc \= 0 then do
	say "Group:" gInfo.j.Name UserID
	call error retc
    end
  end
end
do i = 0 to Apps.Entries - 1
  do j = 0 to gInfo.Entries - 1
    if Apps.i.AppName = gInfo.j.Name then
      leave
  end
  if j \= gInfo.Entries then do
    retc = NetGroupAddUser(Server, gInfo.j.Name, UserID)
    if retc \= 0 then do
	say "Group:" gInfo.j.Name UserID
	call error retc
    end
  end
end

say ""
call ViewUser
return


/*************************************************************
     VIEWUSER
*/

ViewUser:
  retc = NetUserGetInfo(Server, UserID, 10, 'UserInfo')
  if retc \= 0 then do
    call error retc
    return
  end
  say ""
  say "UserID   : " UserID
  say "User Name: " UserInfo.Usr_Comment
  say "Comment 1: " UserInfo.comment
  say "Comment 2: " UserInfo.full_name
  say ""
  say "Logon Assignments"
  say ""
  retc = NetUserGetLogonAsn(Server, UserID, 1, Alias.All, LogonAsn)
  if retc \= 0 then do
    call error retc
    return
  end
  call StemSort 'LogonAsn' 'Device' 'Alias' 'Type'
  do i = 0 to LogonAsn.Entries - 1
    if LogonAsn.i.Type \= Alias.File then
	iterate
    if LogonAsn.i.Device = StdLogonAsn.0.Device then
	leave
    say Left(LogonAsn.i.Device||":", 8, ' ') LogonAsn.i.Alias
  end
  say ""
  do i = 0 to LogonAsn.Entries - 1
    if LogonAsn.i.Type = Alias.Print then
      say Left(LogonAsn.i.Device||":", 8, ' ') LogonAsn.i.Alias
  end
  say ""
  say "Applications"
  say ""
  retc = NetUserGetAppSel(Server, UserID, 1, App.All, AppSel)
  if retc \= 0 then do
    call error retc
    return
  end
  call StemSort 'AppSel' 'AppName'
  do i = 0 to AppSel.Entries - 1
    say AppSel.i.AppName
  end
return

/*************************************************************
     LISTUSER
*/

listuser:
  say ""
  say "Retrieving and Sorting User List"
  say ""
  retc = NetUserEnum(Server, 10, ListInfo)
  do j = 0 to ListInfo.Entries - 1
    next = 'ZZZZZZZ'
    do i = 0 to ListInfo.Entries - 1
      if Listinfo.i.Name < next then do
	next = ListInfo.i.Name
	entry = i
      end
    end
    if next = 'ZZZZZZZ' then
       leave
    say "  " Left(next, 10) ListInfo.entry.Usr_Comment
    ListInfo.entry.Name = 'ZZZZZZZ'
    if j - (j % 23) * 23 = 22 then do
      say ""
      call charout '', "Hit RETURN to continue, Z to quit, or letter to jump to --> "
      parse upper pull quit
      select
	when quit = 'Z' then
	  leave
	when quit = '' then
	  nop
	otherwise
	  do k = 0 to ListInfo.Entries - 1
	    if ListInfo.k.Name < quit then
	      ListInfo.k.Name = 'ZZZZZZZ'
	  end
      end
      call SysCls
    end
  end
  if j < 23 then do
    say ""
    call charout '', "Hit RETURN to continue "
    parse pull quit
  return

/*************************************************************
     ERROR
*/

error:
parse arg retc
if retc \= 0 then do
    if retc < 2100 then
	say NetGetMessage(retc)
    else
	say NetGetMessage(retc, "NET.MSG")
end
else
    say "Completed Successfully"
say ""
call pause
return


/*************************************************************
     SHOW
*/

show:
  parse arg Stem level newapi enum
  interpret 'call Net'||newapi||'Info level, Names.'

  if enum = 1 then do
    interpret 'range =' Stem||'.Entries'
    say range
    do j = 0 to range - 1
	interpret 'call showline' Stem||'.'||j
	onscreen = 24 % Names.0
	if j - (j % onscreen) * onscreen = onscreen - 1 then do
	    call charout '', "Pause.."
	    parse pull quit
	    if quit \= '' then
		leave
	end
    end
  end
  else
    call showline Stem
  return

showline:
  parse arg nstem
  do i = 1 to Names.0
    interpret 'say Names.i' nstem||'.'||Names.i
  end
  return


/*************************************************************
     STEMSORT
*/

StemSort:
  parse arg stem field1 field2 field3
  total = Value(stem||".Entries") - 1
  do c1 = 0 to total
    interpret "this =" stem||".c1."||field1
    do c2 = c1 + 1 to total
      interpret "next =" stem||".c2."||field1
      if next < this then do
	interpret stem||".c2."||field1 "= this"
	if field2 \= '' then do
	  interpret "hold = " stem||".c2."||field2
	  interpret stem||".c2."||field2 "=" stem||".c1."||field2
	  interpret stem||".c1."||field2 "= hold"
	  if field3 \= '' then do
	    interpret "hold = " stem||".c2."||field3
	    interpret stem||".c2."||field3 "=" stem||".c1."||field3
	    interpret stem||".c1."||field3 "= hold"
	  end
	end
	this = next
      end
    end
    interpret stem||".c1."||field1 "= this"
  end
  return

