/*
    TRY.CMD Try NETAPI commands

    Commands:
	API name    -	select API set to use
	SERVER '\\name' -   select server to use
	INFO level  -	show field names for api structures at 'level'

  Enter commands without preceding Net or API name or first parameter

ie NetUserGetInfo('\\Server', 'UserID', 1, Info) is typed as
    GetInfo 'userid', 1, info

The normal GetInfo and Enum functions should display their result when entered

functions can also be executed normally using say or call
eg say NetUserDel('server', 'userid')

*/

call rxfuncadd SysLoadFuncs, REXXUTIL, SysLoadFuncs
call SysLoadFuncs
if rxfuncadd(NetLoadFuncs, "RexxNet", NetLoadFuncs) = 20 then do
    say "Failed to find DLL"
    signal done
end
call NetLoadFuncs
if rxfuncquery('NetAppGetInfo') then do
    say "Still cannot find function"
    signal done
end

  parse upper arg api server
  if api = '' then
    say 'Must Specific API before using'
  if server = '' then do
    say 'Server must be specified if other than local'
    server = ''
  end
  trace = ''
  call main
done:
  call NetDropFuncs
  call SysDropFuncs
  exit				  /* The only exit.	       */

main:
  trace 'Off'
  do foreverrx = 1		       /* Loop forever. 	    */
    call charout '', "--> "
    parse pull func args
    if func = '' then
	leave
    parse upper var func func
    if func = 'EXIT' then
	leave
    if func = 'SAY' then do
	signal on syntax name again
	interpret "say " args
	iterate
    end
    if pos('=', args) then do
	signal on syntax name again
	interpret func args
	iterate
    end
    if func = 'TRACE' then do
	parse var args func args
	trace all
    end
    else
	trace (trace)	   /* Need these on same line.	*/
    signal on syntax		    /* Enable syntax trap.	 */
    interpret 'call ' func args
    trace 'Off'                    /* Don't trace rexxtry.      */
  end
  signal done

syntax:
  signal on syntax name external
  call generic func args
  signal main

external:
  signal on syntax name again
  interpret "'@"||func args "'"
  signal main

again:
  trace 'Off'
  say rc ',' errortext(rc)
  signal main

api:
    parse upper var args api
    return

server:
    server = args
    return

trace:
    trace = args
    return

exit:
    signal done

drop:
    drop args
    return

cls:
    call SysCls
    return

/*
*****************************************************
    INFO    return Data structure members
*/
info:
    parse arg level
    interpret 'call Net'||api||'Info level, Names.'
    do i = 0 to Names.0
	say Names.i
    end
    return

/*
*****************************************************
    ENUM    enumerate data
*/
enum:
    select
    when api = 'ALIAS' then
	parse var args level ',' type ',' stem ',' other
    when api = 'APP' then
	parse var args userid ',' level ',' type ',' stem ',' other
    when api = 'ACCESS' then
	parse var args base ',' recur ',' level ',' stem ',' other
    otherwise
	parse var args level ',' stem ',' other
    end
    interpret 'retc = Net'||api||func||'(' server ',' args ')'
    if retc \= 0 then
	call error
    else
	call show level stem 1 api
    return

/*
*****************************************************
    GETINFO    get data on one entry
*/
getinfo:
    select
    when api = 'APP' then
	parse var args who ',' what ',' level ',' stem ',' other
    when api = 'WKSTA' then
	parse var args level ',' stem ',' other
    when api = 'ACCESS' then
	parse var args resource ',' level ',' stem ',' other
    otherwise
	parse var args who ',' level ',' stem ',' other
    end
    interpret 'retc = Net'||api||func||'(' server ',' args ')'
    if retc \= 0 then
	call error
    else
	call show level stem 0 api
    return

/*
*****************************************************
    Generic functions - no return display
*/

generic:
    interpret 'retc = Net'||api||func||'(' server ',' args ')'
    call error
    return


/* ------------------------------------------- */

d:
  parse arg Stem level newapi
  call show level stem 0 newapi
  return

de:
  parse arg Stem level newapi
  call show level stem 1 newapi
  return


show:
  parse arg level Stem enum newapi
  interpret 'call Net'||newapi||'Info level, Names.'

  if enum = 1 then do
    interpret 'range =' Stem||'.Entries'
    say range
    do j = 0 to range - 1
	interpret 'call showline' Stem||'.'||j
	onscreen = 24 % Names.0
	if j - (j % onscreen) * onscreen = onscreen - 1 then do
	    call charout '', "Pause.."
	    parse pull quit
	    if quit \= '' then
		leave
	end
    end
  end
  else
    call showline Stem
  return

showline:
  parse arg nstem
  do i = 1 to Names.0
    interpret 'say Names.i' nstem||'.'||Names.i
  end
  return

error:
    if retc \= 0 then do
	if retc < 2100 then
	    say SysGetMessage(retc)
	else
	    say SysGetMessage(retc, "NET.MSG")
    end
    else
	say "Completed Successfully"
    return

