/*
 *  ascii2xbm.cmd  --- width=48 ascii-picture to width=48 XBM converter
 *
 *         Copyright (C) 1997-1998  OKUNISHI Fujikazu
 *
 * Author:  OKUNISHI Fujikazu <fuji0924@mbox.kyoto-inet.or.jp>
 * Created: Aug 09, 1997
 * Revised: Feb  1, 1998
 *
 * how2use:
 *  ex.)  ascii2xbm.cmd ascii.picture > my.xbm [RET]
 */

  Parse Arg IN .

  If IN='' Then Do
    If Lines()==0 Then Exit 255
    IN='STDIN'
    name='nobody'
  End
  Else If Stream(IN,'C','Query Exist') =''
    Then Exit 255
    Else Do
      name=Filespec('Name',IN); lp=Lastpos('.',name)
      If lp>1 Then name=Left(name,lp -1)
              Else name='nobody'
    End

  OUT='STDOUT'

  Do i=1 By 1 While Lines(IN)
    str.i=Translate(Left(Linein(IN),48),'wwWWWWW_','ozM$HZ# ')
    line1.i=''; line2.i='';
    Do j=1 to 48
      d= Substr(str.i,j,1)
      If d='_' Then Do; d1.j=0; d2.j=0; End
      If d='w' Then Do; d1.j=0; d2.j=1; End
      If d='"' Then Do; d1.j=1; d2.j=0; End
      If d='W' Then Do; d1.j=1; d2.j=1; End
      line1.i=line1.i||d1.j; line2.i=line2.i||d2.j
    End
    line1.i=B2X(line1.i); line2.i=B2X(line2.i)
/*  Say i line1.i;Say i line2.i*/
  End

  Call LineOut OUT,'#define' name || '_width 48'
  Call LineOut OUT,'#define' name || '_height' (i-1)*2
  Call LineOut OUT,'static char' name || '_bits[] = {'

  Do j=1 To i-1
    str1.j='';str2.j='';
    Do m=1 By 2 To 12
      d1.m = '0x' || B2X(Reverse(X2B(Substr(line1.j,m,2)))) ||','
      d2.m = '0x' || B2X(Reverse(X2B(Substr(line2.j,m,2)))) ||','
      str1.j = str1.j ||d1.m; str2.j = str2.j ||d2.m
    End
    Call CharOut OUT, str1.j||str2.j
  End
  Call CharOut OUT,'};' ; Call LineOut OUT /*close*/

Exit

/* end of procedure */
