/***************************************************************************\
 **                                                                       **
 ** UNINSTAL.CMD : uninstall Rexx Editor v1.0 for OS/2                    **
 **                                                                       **
\***************************************************************************/
 CALL RxFuncAdd 'SysLoadFuncs' , 'RexxUtil' , 'SysLoadFuncs'
 CALL SysLoadFuncs

 CALL InfoBox 'UnInstall Rexx Editor'
 CALL SysSleep 1

 CALL InfoBox 'Do you really want to uninstall Rexx Editor? (Y/N)'
 key = SysGetKey('NOECHO')
 IF ((key = 'Y') | (key = 'y')) THEN DO
   Rexxdir = SysIni('USER', 'RexxEditor', 'Directory')
   CALL InfoBox 'Delete all files in the Rexx Editor directory? (Y/N)'
   key = SysGetKey('NOECHO')
   IF ((key = 'Y') | (key = 'y')) THEN DO
     CALL InfoBox 'Deleting 'Rexxdir
     IF DIRECTORY() = Rexxdir THEN
	'@CD..'
     CALL SysFileTree Rexxdir'\*.*', files, 'FSO', '*****', '-----'
     DO i=1 TO files.0 BY 1
	CALL SysFileDelete files.i
     END
     '@RMDIR 'Rexxdir
   END 
   CALL SysSleep 10
   CALL InfoBox 'Deleting Rexx Editor application from OS2.INI'
   CALL SysIni 'USER', 'RexxEditor', 'DELETE:'
   CALL InfoBox 'Rexx Editor succesfully uninstalled'
 END
 ELSE DO
   SIGNAL End
 END


End:
 CALL SysDropFuncs
 Exit

/***************************************************************************\
 **                                                                       **
 ** InfoBox : Procedure that display information in a box.                **
 **                                                                       **
\***************************************************************************/
InfoBox: PROCEDURE
PARSE ARG message
 CALL SysCls
 pos = SysCurPos(5, 5)
 Say 'ͻ'
 pos = SysCurPos(6, 5)
 Say '                                                                 '
 pos = SysCurPos(7, 5)
 Say ' 'message
 pos = SysCurPos(7, 70)
 Say ' '
 pos = SysCurPos(8, 5)
 Say '                                                                 '
 pos = SysCurPos(9, 5)
 Say 'ͼ'
RETURN(0)
