/***************************************************************************\
 **                                                                       **
 ** INSTALL.CMD : install Rexx Editor v1.0 for OS/2                       **
 **                                                                       **
\***************************************************************************/
 CALL RxFuncAdd 'SysLoadFuncs' , 'RexxUtil' , 'SysLoadFuncs'
 CALL SysLoadFuncs

 CALL SysCurState 'OFF'
 CALL SysCls
 CALL InfoBox 'Install Rexx Editor v1.0  MB Products'
 CALL SysSleep 1

 CALL InfoBox 'Copy BPMCC.DLL to C:\OS2\DLL'
 'COPY BPMCC.DLL C:\OS2\DLL'
 IF rc \= 0 THEN DO
   CALL Beep 460, 250
   CALL InfoBox 'Could not copy BPMCC.DLL to C:\OS2\DLL, installation aborted!'
   SIGNAL End
 END

 CALL InfoBox 'Using current directory as your program directory? (Y/N)'
 key = SysGetKey('NOECHO')
 IF ((key = 'Y') | (key = 'y')) THEN DO
   Rexxdir = DIRECTORY() 
 END
 ELSE DO UNTIL Dir.0 > 0
   Rexxdir=AskBox('Give program directory :')
   IF RexxDir <> "" THEN
     CALL SysFileTree RexxDir, dir, 'D'
   ELSE
     Dir.0 = 0
 END
 DROP Dir.

 CALL InfoBox 'Using current directory as your startup directory? (Y/N)'
 key = SysGetKey('NOECHO')
 IF ((key = 'Y') | (key = 'y')) THEN DO
   Startupdir = DIRECTORY() 
 END
 ELSE DO UNTIL Dir.0 > 0
   Startupdir=AskBox('Give startup directory :')
   IF StartupDir <> "" THEN
     CALL SysFileTree StartupDir, dir, 'D'
   ELSE
     Dir.0 = 0
 END

 CALL InfoBox 'Write program directory to OS2.INI'
 Result = SysIni('USER', 'RexxEditor', 'Directory', Rexxdir)
 IF Result = 'ERROR:' THEN DO
   CALL Beep 460, 250
   CALL InfoBox 'There was a problem while setting the Profile for RexxEditor !'
   SIGNAL End
 END
 CALL InfoBox 'Create Object on your desktop'
 IF SysCreateObject('WPProgram','Rexx Editor','<WP_DESKTOP>',,
	'EXENAME='||Rexxdir||'\RE.EXE;STARTUPDIR='||Startupdir||';PROGTYPE=PM;','U') THEN DO
   NOP
 END
 ELSE DO
   CALL Beep 460, 250
   CALL InfoBox 'There was a problem while creating the Object for RexxEditor !'
   SIGNAL End
 END

 CALL InfoBox 'Rexx Editor succesfully installed'

End:
 CALL SysCurState 'ON'
 CALL SysDropFuncs
 Exit


/***************************************************************************\
 **                                                                       **
 ** InfoBox : Procedure that display information in a box.                **
 **                                                                       **
\***************************************************************************/
InfoBox: PROCEDURE
PARSE ARG message
 CALL SysCls
 pos = SysCurPos(5, 5)
 Say 'ͻ'
 pos = SysCurPos(6, 5)
 Say '                                                                 '
 pos = SysCurPos(7, 5)
 Say ' 'message
 pos = SysCurPos(7, 70)
 Say ' '
 pos = SysCurPos(8, 5)
 Say '                                                                 '
 pos = SysCurPos(9, 5)
 Say 'ͼ'
RETURN(0)

/***************************************************************************\
 **                                                                       **
 ** AskBox : Procedure that display information in a box and waits for    **
 **          input.                                                       **
 **                                                                       **
\***************************************************************************/
AskBox: PROCEDURE
PARSE ARG message
 CALL SysCls
 pos = SysCurPos(5, 5)
 Say 'ͻ'
 pos = SysCurPos(6, 5)
 Say '                                                                 '
 pos = SysCurPos(7, 5)
 Say ' 'message
 pos = SysCurPos(7, 70)
 Say ' '
 pos = SysCurPos(8, 5)
 Say '  Ŀ  '
 pos = SysCurPos(9, 5)
 Say '                                                               '
 pos = SysCurPos(10, 5)
 Say '    '
 pos = SysCurPos(11, 5) 
 Say 'ͼ'
 pos = SysCurPos(9,10)
 CALL SysCurState 'ON'
 ask = LINEIN()
 CALL SysCurState 'OFF'
RETURN ask
