/* REXX *********************************************/
/* Frame for your Rexx program. Verify please!      */
/* Program name: ReplStr                            */
/* Function....: Find all occurences of a substring */
/*               and replace it by an another       */
/* Syntax      :                                    */
/* Changes     :                                    */
/*                                                  */
/* Made use of GREED.  20 Dec 1996 / 10:33:16   JRK */
/****************************************************/
Parse Arg string

/*==============(Exception handling)================*/
Signal On Failure Name CLEANUP
Signal On Halt    Name CLEANUP
Signal On Syntax  Name CLEANUP

/*==========(Initialize RexxUtil support)===========*/
If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

Say 
Say Center( "( REPLACE STRING )", 80, '*')

If string = '' Then
  string = ',,,aaa,,,,ccc,,,'
Say 'Replace <,> by <,>:' 
Say String '==>' StrRepl( string, ',', ',' )
Say
Say 'Replace <.> by < , >:' 
Say String '==>' StrRepl( string, '.', ' , ' )
Say
string = 'aaa, aaa, ccc, aaa'
Say 'Replace <aaa> by <x>:' 
Say String '==>' StrRepl( string, 'aaa', 'x' )
Say
string = 'OS/2 OS/2 OS/2 OS/2'
Say 'Replace <OS/2> by <Warp>:' 
Say String '==>' StrRepl( string, 'OS/2', 'Warp' )
Say
string = '.'
Say 'Replace <.> by <+++.+++>:' 
Say String '==>' StrRepl( string, '.', '+++.+++' )
Say
string = '.....'
Say 'Replace <..> by <+..._>:' 
Say String '==>' StrRepl( string, '..', '+..._' )
Say
/*================(End this program)================*/
Call CharOut , "Press any key to exit "
Call LineIn

Exit

CLEANUP:
  Say
  Say 'GREED001E - Break, Failure or Syntax Error'
Exit


/******************************************************/
/*          PROCEDURES                                */
/******************************************************/
/*========( Replace a string with an another )========*/
/*                                                 15 */
/* Name.......: StrRepl                               */
/*                                                    */
/* Function...: Find all occurences of a substring    */
/*              and replace it by an another          */
/*                                                    */
/* Call parm..: _string  - input string,              */
/*              _origin  - substring to be replaced   */
/*              _replStr - replace substring          */
/*                                                    */
/* Returns....: translated string                     */
/*                                                    */
/* Syntax.....:                                       */
/*  tranStr = ReplaceString(_string,_origin,_replStr) */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* Author.....: Janosch R. Kowalczyk, 1996.           */
/*====================================================*/
StrRepl: Procedure
Parse Arg _string, _origin, _replStr

/*---( Find a substring to replace? )---*/
_lastPos = LastPos( _origin, _string )


If _lastPos > 0 Then Do

  /*---( Get prefix to the substring )---*/
  If _lastPos = 1 Then _prefix = ''
  Else _prefix = SubStr( _string, 1, _lastPos - 1 )

  /*---( Get suffix of the substring )---*/
  _suffix = SubStr( _string, _lastPos + Length( _origin ))

  /*---( Find next substring to replace )---*/
  Return StrRepl( _prefix, _origin, _replStr ) || _replStr || _suffix

End
Else
  Return _string

