/* REXX **********************************************/
/*                                                   */
/* Name.......: Euclid.CMD                           */
/* Function...: Get greatest common divisor of 2 dig.*/
/*                                                   */
/* Author.....: Janosch R. Kowalczyk                 */
/*              Compuserve: 101572,2160              */
/*              Internet: 101572.2160@compuserve.com */
/* Create date: Fri, 06 Jun 1997 / 157 / 22:46:06    */
/* Version....: 1.0                                  */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/* Notes......: Start this file with PMREXX to see   */
/*              the output lines.                    */
/*                                                   */
/* Made use of GREED.  26 May 1996 / 12:29:24   JRK  */
/*****************************************************/
/* trace ?R */
Arg _counter, _denuminator

/*===============(Exception handling)================*/
Signal On Failure Name CLEARUP
Signal On Halt    Name CLEARUP
Signal On Syntax  Name CLEARUP

If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

Say 
Say Center( "( GET GREATEST COMMON DIVISOR )", 80, '*')
Say
/*----------(Test greatest common divisor)------------*/
If DataType( _counter ) \= 'NUM' Then _counter = 400
If DataType( _denuminator ) \= 'NUM' Then _denuminator = 600

gcd = EuclidGCD( _counter, _denuminator )
Say Left(_counter '/' _denuminator, 9) '=',
    Left(_counter/gcd '/' _denuminator/gcd, 12), 
    'Greatest common divisor:' gcd

Do 15
  _counter = Random()
  _denuminator = Random() 
  gcd = EuclidGCD( _counter, _denuminator )
  Say Left(_counter '/' _denuminator, 9) '=',
      Left(_counter/gcd '/' _denuminator/gcd, 12), 
      'Greatest common divisor:' gcd
End

Say
Call LineOut , "Press any key to exit "
Call LineIn

Exit

CLEARUP:
  Say
  Say 'GREED001E - Break, Failure or Syntax Error'
Exit


/*===============(Internal subroutines)===============*/
/*=============( Greatest common divisor )============*/
/*                                                 18 */
/* Name.......: EuclidGCD                             */
/*                                                    */
/* Function...: Get greatest common divisor (Euclids  */
/*              algorithm)                            */
/* Call parm..: _counter                              */
/*              _denuminator                          */
/* Returns....: gcd                                   */
/*                                                    */
/* Syntax.....:                                       */
/*    gcd = EuclidGCD( _counter, _denuminator )       */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* Author.....: Janosch R. Kowalczyk                  */
/*====================================================*/
EuclidGCD: Procedure
Arg _counter, _denuminator

Do Until _counter = 0
  If _counter < _denuminator Then Do
    _Xchange     = _counter
    _counter     = _denuminator
    _denuminator = _Xchange
  End
  _counter = _counter - _denuminator
End

Return _denuminator

