/* REXX **********************************************/
/* Frame for your Rexx program. Verify please!       */
/* Program name: ErasPath.CMD                        */
/* Function    : Delete directory Path               */
/* Syntax      : ErasPath _erasePath                 */
/* Changes     : No                                  */
/*                                                   */
/* Made use of GREED.  28 Dec 1996 / 00:39:39   JRK  */
/*****************************************************/
/* (C) Copyright Janosch R. Kowalczyk, 1996.         */
/* All rights reserved.                              */
/*****************************************************/
Parse Source . calledAs .
If calledAs \= "COMMAND" Then 
  Parse Arg _erasePath .
Else 
  Parse Arg _erasePath, .

/*===============(Exception handling)================*/
Signal On Failure  Name CLEARUP
Signal On Halt     Name CLEARUP
Signal On Syntax   Name CLEARUP
Signal On NotReady Name CLEARUP

/*===========(Initialize RexxUtil support)===========*/
If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

Say 
Say Center( "( DELETE DIRECTORY PATH )", 80, '*')

If _erasePath = '' Then 
  _erasePath = 'C:\TEST\MAKE\PATH\PROCEDUR\RECURSIV\NEW\TEST'

Call MakePath _erasePath 
Say
Call ErasePath _erasePath 

Say
Call LineOut , "Press any key to exit "
Call LineIn

/*================(End this program)================*/
Exit

CLEARUP:
  Say
  Say 'GREED001E - Break, Failure or Syntax Error'
Exit



/*==============( Delete Directory Path )=============*/
/*                                                 17 */
/* Name.......: ErasePath                             */
/*                                                    */
/* Function...: delete directory path                 */
/*                                                    */
/* Call parm..: _erasePath - directory path to be     */
/*              deleted                               */
/*                                                    */
/* Returns....: formated string                       */
/*                                                    */
/* Syntax.....:                                       */
/*    _erasePath = MakePath( _erasePath )             */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* Author.....: Janosch R. Kowalczyk                  */
/*====================================================*/
ErasePath: Procedure
Arg _erasePath 

_erasePath = Strip( _erasePath, , '\' )

Do Until Pos('\', _erasePath) = 0 
  rc = SysRmDir( _erasePath )
  If rc > 0 Then
    Say 'Directory:' _erasePath 'not deleted. RC=' rc 
  Else 
    Say _erasePath 'successful deleted'
  _erasePath = SubStr( _erasePath, 1, LastPos('\', _erasePath) - 1)
End

Return _erasePath




/*=============( Recursive Path Creating )============*/
/*                                                 16 */
/* Name.......: MakePath                              */
/*                                                    */
/* Function...: Create recursive directory path       */
/*                                                    */
/* Call parm..: _destPath  - directory path           */
/*                                                    */
/* Returns....: formated string                       */
/*                                                    */
/* Syntax.....:                                       */
/*    _destPath = MakePath( _destPath )               */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* (C) Copyright Janosch R. Kowalczyk, 1996.          */
/* All rights reserved.                               */
/*====================================================*/
/*---------------(Create Directory Path)--------------*/
MakePath: Procedure
Arg _destPath

_destPath = Strip(_destPath,,'\')
If Pos('\', _destPath) = 0 Then Return _destPath

/*--------------( Check Directory Path )--------------*/
rc = SysFileTree( _destPath, fileList, 'DO' )
If fileList.0 = 0 Then Do
  /*------------(Directory path not exists)-----------*/
  Call MakePath SubStr(_destPath, 1, LastPos('\', _destPath))  
  rc = SysMkDir( _destPath )
  If rc > 0 & rc \= 5 Then
    Say 'Destination directory:' _destPath 'not created. RC=' rc 
  Else 
    Say _destPath 'successful created'
End

Return _destPath
