/* REXX **********************************************/
/*                                                   */
/* Name.......: CubeRoot.CMD                         */
/* Function...: Test Rexx algorithms for the Cube    */
/*              Root Evolution                       */
/*                                                   */
/* Author.....: Janosch R. Kowalczyk                 */
/*              Compuserve: 101572,2160              */
/*                                                   */
/* Create date: Wed, 02 Jul 1997 / 183 / 19:56:01    */
/* Version....: 1.0                                  */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/* Notes......: Start this file with PMREXX to see   */
/*              the output lines.                    */
/*                                                   */
/* Made use of GREED.  02 Jul 1997 / 19:39:24   JRK  */
/*****************************************************/
Arg _digit

/*===============(Exception handling)================*/
Signal On Failure Name CLEARUP
Signal On Halt    Name CLEARUP
Signal On Syntax  Name CLEARUP

If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

Say 
Say Center( "( CUBE ROOT EVOLUTION )", 80, '*')
Say
/*----------------(Test Cube Root)-----------------*/
If DataType( _digit, 'N' ) = 1 Then Do
  cbrt = CubeRoot(_digit)
  Say Left(Left("CubeRoot("_digit")", 13) "=" cbrt, 28) "Test:"  cbrt "cubed is" cbrt**3
End

Call RandomStem

Do i = 1 To stem.0
  cbrt = CubeRoot(stem.i)
  Say Left(Left("CubeRoot("stem.i")", 13) "=" cbrt, 28) "Test:"  cbrt "cubed is" cbrt**3
End

Say
Call LineOut , "Press any key to exit "
Call LineIn

Exit

CLEARUP:
  Say
  Say 'GREED001E - Break, Failure or Syntax Error'
Exit


/*===============(Internal subroutines)================*/
/*====================( Cube root )====================*/
/* :-)                                               7 */
/* Name.......: CubeRoot                               */
/*                                                     */
/* Function...: Cube root evolution for the calling    */
/*              parameter                              */
/* Call parms.: Evolution number, precision (optional) */
/* Returns....: Cube root                              */
/*                                                     */
/* Syntax.....: cbrt = CubeRoot(_digit, [precision])   */
/*                                                     */
/* Notes......: precision is the highest possible      */
/*              error for the evaluation.              */
/*              Default Value is 0.00001               */
/*              You are responsible for the valid      */
/*              number value                           */
/*                                                     */
/* Changes....: No                                     */
/*                                                     */
/* Author.....: Janosch R. Kowalczyk                   */
/*=====================================================*/
CubeRoot: Procedure

Arg _digit, precision

If Datatype(_digit) \= 'NUM' Then Return -1
If precision <= 0 | precision > 1 Then precision = 0.000001

cbrt = 1
 
Do Until Abs(cbrt_old - cbrt) < precision
  cbrt_old = cbrt
  cbrt = ( 2 * cbrt_old ** 3 + _digit ) / ( 3 * cbrt_old ** 2 )
End /* Do Until ... */

Return cbrt



/*===========(Fill stem with random numbers)=========*/
/*                                                   */
/* Name.......: RandomStem                           */
/*                                                   */
/* Function...: Fills the stem with random numbers   */
/*                                                   */
/* Call parm..: Number of items  (default = 10)      */
/* Returns....: Nothing (NULL string)                */
/*                                                   */
/* Syntax.....: Call RandomStem number               */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/
RandomStem: Procedure Expose stem.

Arg number

If DataType(number) \= 'NUM' Then number = 10
stem.0 = number

Do i = 1 To number
  stem.i = Random( )
End

Return ''


