/* REXX **********************************************/
/*                                                   */
/* Name.......: BiSearch.CMD                         */
/* Function...: Test Rexx algorithms for the Binary  */
/*              search                               */
/*                                                   */
/* Author.....: Janosch R. Kowalczyk                 */
/*              Compuserve: 101572,2160              */
/*                                                   */
/* Create date: 26 May 1996                          */
/* Version....: 1.0                                  */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/* Notes......: Start this file with PMREXX to see   */
/*              the output lines.                    */
/*                                                   */
/* Made use of GREED.  26 May 1996 / 12:29:24   JRK  */
/*****************************************************/
Arg _items

/*===============(Exception handling)================*/
Signal On Failure Name CLEARUP
Signal On Halt    Name CLEARUP
Signal On Syntax  Name CLEARUP

If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

Say 
Say Center( "( BINARY SEARCH )", 80, '*')

/*--------------(Set random numbers)-------------*/
_items = RandomStem( _items )
searchValue = stem._items

/*------------------(Quick Sort)-----------------*/
Call QSort
Say "Searched Value:" searchValue
Say
Say SayStem()

/*----------------(Binary search)----------------*/
startTime = Time(r)

found = BiSearch( searchValue )

endTime = Time(r)
Say "Search duration for value" searchValue "from" stem.0 "digits:" endTime "sec."
Say "Searched value is the" found"-th value in the stem."  
Say 
Call LineOut , "Press any key to exit "
Call LineIn

Exit

CLEARUP:
  Say
  Say 'GREED001E - Break, Failure or Syntax Error'
Exit


/*===============(Internal subroutines)===============*/

/*====================(Quick sort)====================*/
/* :-D                                              4 */
/* Name.......: QSort                                 */
/*                                                    */
/* Function...: Quick Sort for a stem variable        */
/* Call parm..: No                                    */
/* Returns....: Left-Right span                       */
/*                                                    */
/* Sample call: Call QSort                            */
/*                                                    */
/* Notes......: The elements to sort for must be      */
/*              saved in the stem named so as the     */
/*              stem in this Procedure (in this case  */
/*              "STEM.")                              */
/*              stem.0 must contain the number of     */
/*              elements in stem.                     */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* Author.....: Janosch R. Kowalczyk                  */
/*====================================================*/
QSort: Procedure Expose stem.

Arg left, right

If left  = '' Then left  = 1
If right = '' Then right = stem.0
If right > left Then Do
  i = left
  j = right
  k = (left+right)%2
  x = stem.k
  Do Until i > j
    Do While stem.i < x; i = i + 1; End
    Do While stem.j > x; j = j - 1; End
    If i <= j Then Do
      xchg = stem.i
      stem.i = stem.j
      stem.j = xchg
      i = i + 1
      j = j - 1
    End
  End
  y = QSort(left,j)
  y = QSort(i,right)
End

Return right - left


/*==================(Binary search)===================*/
/* :-D                                              1 */
/* Name.......: BiSearch                              */
/*                                                    */
/* Function...: Search a stem variable for a value    */
/* Call parm..: Search value                          */
/* Returns....: 0 if nothing found                    */
/*              index of the found value              */
/* Sample call: found_index = BiSearch(value)         */
/*              If found_index = 0 Then               */
/*                Say 'Value' value 'not found!'      */
/*              Else                                  */
/*                Say stem.found_index                */
/*                                                    */
/* Notes......: The elements to search for must be    */
/*              saved in the stem named so as the     */
/*              stem in this Procedure (in this case  */
/*              "STEM.")                              */
/*              stem.0 must contain the number of     */
/*              elements in stem.                     */
/*              The stem-variable must be in the      */
/*              sorted order                          */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* (C) Copyright Janosch R. Kowalczyk, 1996.          */
/* All rights reserved.                               */
/*====================================================*/
BiSearch: Procedure Expose stem.

Parse Arg value             /* Search value            */

found  = 0                  /* Index of the found Item */
bottom = 1                  /* Index of the first Item */
top    = stem.0             /* Index of the last Item  */

Do While found = 0 & top >= bottom
  mean = (bottom + top) % 2
  If value = stem.mean Then
    found = mean
  Else If value < stem.mean Then
    top = mean - 1
  Else
    bottom = mean + 1
End /* Do While */

Return found


/*===========(Fill stem with random numbers)=========*/
/*                                                   */
/* Name.......: RandomStem                           */
/*                                                   */
/* Function...: Fills the stem with random numbers   */
/*                                                   */
/* Call parm..: Number of items  (default = 50)      */
/* Returns....: Nothing (NULL string)                */
/*                                                   */
/* Syntax.....: Call RandomStem number               */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/
RandomStem: Procedure Expose stem.

Arg number

If DataType(number) \= 'NUM' Then number = 50
stem.0 = number

Do i = 1 To number
  stem.i = Random( )
End

Return number


/*===============( Say stem as one line )============*/
/*                                                   */
/* Name.......: SayStem                              */
/*                                                   */
/* Function...: Says stem as one line with delimiter */
/*                                                   */
/* Call parm..: Delimiter character(s) (default: ',')*/
/*              Prefix for return value (dflt. : '') */
/*                                                   */
/* Returns....: Line with all stems                  */
/*                                                   */
/* Syntax.....: stemLine = SayStem [delim][, prefix] */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/
SayStem: Procedure Expose stem.

Parse Arg _delim, _stemLine

If _delim = '' Then _delim = ','

If stem.0 > 0 Then _stemLine = '(1)' stem.1

Do i = 2 To stem.0
  _stemLine = _stemLine || _delim '('i')' stem.i
End /* End Do ... */

Return _stemLine