                 8         (   Rexx Algorithms         P   XX^   Binary Search /*==================(Binary search)===================*/
/* :-D                                              1 */
/* Name.......: BiSearch                              */
/*                                                    */
/* Function...: Search a stem variable for a value    */
/* Call parm..: Search value                          */
/* Returns....: 0 if nothing found                    */
/*              index of the found value              */
/* Sample call: found_index = BiSearch(value)         */
/*              If found_index = 0 Then               */
/*                Say 'Value' value 'not found!'      */
/*              Else                                  */
/*                Say stem.found_index                */
/*                                                    */
/* Notes......: The elements to search for must be    */
/*              saved in the stem named so as the     */
/*              stem in this Procedure (in this case  */
/*              "STEM.")                              */
/*              stem.0 must contain the number of     */
/*              elements in stem.                     */
/*              The stem-variable must be in the      */
/*              sorted order                          */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* (C) Copyright Janosch R. Kowalczyk, 1996.          */
/* All rights reserved.                               */
/*====================================================*/
BiSearch: Procedure Expose stem.

Parse Arg value             /* Search value            */

found  = 0                  /* Index of the found Item */
bottom = 1                  /* Index of the first Item */
top    = stem.0             /* Index of the last Item  */

Do While found = 0 & top >= bottom
  mean = (bottom + top) % 2
  If value = stem.mean Then
    found = mean
  Else If value < stem.mean Then
    top = mean - 1
  Else
    bottom = mean + 1
End /* Do While */

Return found

 b            Recursive Formatting /*==============( Recursive formatting )==============*/
/*                                                 13 */
/* Name.......: Combine                               */
/*                                                    */
/* Function...: Format recursive a string             */
/*                                                    */
/* Call parm..: _combStr   - string to format,        */
/*              _combLen   - string's length,         */
/*              _combTooth - format string (opt.),    */
/*              _combRep   - format interval (opt.)   */
/*                                                    */
/* Returns....: formated string                       */
/*                                                    */
/* Syntax.....:                                       */
/*    formStr = Combine( Str, Len, Tooth, Rep )       */
/*                                                    */
/* Notes......: Default value for _combTooth is a     */
/*              blank                                 */
/*              Default value for _combRep is 1       */
/*                                                    */
/* Method of working:                                 */
/*              _combTooth will be inserted into the  */
/*              _combStr at the position computed as  */
/*              follows:                              */
/*              _combLen = _combLen - _combRep        */
/*                                                    */
/* Sample.....: Input string  = '10000000000'         */
/*              Format string = '.'                   */
/*              Interval      = 3                     */
/*                                                    */
/*              Output string = '10.000.000.000'      */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* (C) Copyright Janosch R. Kowalczyk, 1996.          */
/* All rights reserved.                               */
/*====================================================*/
Combine: Procedure
Parse Arg _combStr, _combLen, _combTooth, _combRep

/*----(End processing and return formated string)-----*/
If _combLen < 1 | DataType(_combLen, 'N') = 0 Then
  Return _combStr

/*---(Check call parameter and set default values)----*/
_combLen = Trunc( _combLen )

If _combTooth = '' Then
  _combTooth = ' '

If _combRep < 1 | DataType(_combRep, 'N') = 0 Then
  _combRep = 1
Else If _combRep >= _combLen Then
  Return _combStr

_combRep = Trunc( _combRep )

/*---------(Set new value for Insert position)---------*/
_combLen = _combLen - _combRep

/*---------(Call recursive for the naxt step)----------*/
Return Combine( Insert( _combTooth, _combStr, _combLen ),,
                _combLen,,
                _combTooth,,
                _combRep )
         z  ]]  Bubble Sort /*===================(Bubble sort)====================*/
/* :-I                                              2 */
/* Name.......: BubSort                               */
/*                                                    */
/* Function...: Bubble Sort for a stem variable       */
/* Call parm..: No                                    */
/* Returns....: nothing (NULL string)                 */
/*                                                    */
/* Sample call: Call BubSort                          */
/*                                                    */
/* Notes......: The elements to sort for must be      */
/*              saved in the stem named so as the     */
/*              stem in this Procedure (in this case  */
/*              "STEM.")                              */
/*              stem.0 must contain the number of     */
/*              elements in stem.                     */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* (C) Copyright Janosch R. Kowalczyk, 1996.          */
/* All rights reserved.                               */
/*====================================================*/
BubSort: Procedure Expose stem.

Do i = stem.0 To 1 By -1 Until flip_flop = 1
  flip_flop = 1
  Do j = 2 To i
    m = j - 1
    If stem.m > stem.j Then Do
      xchg   = stem.m
      stem.m = stem.j
      stem.j = xchg
      flip_flop = 0
    End /* If stem.m ... */
  End /* Do j = 2 ...    */
End /* Do i = stem.0 ... */

Return ''

 {"      
 
   vv  Date 2000 /*=======(Translate year to year with century)========*/
/*                                                 11 */
/* Name.......: Date2000                              */
/*                                                    */
/* Function...: Translates year to year with century  */
/* Call option:   Returns dd Mmm yyyy                 */
/*              B Returns dddddd days since 01.01.0001*/
/*              D Returns ddd - days                  */
/*              E Returns dd/mm/yyyy                  */
/*              J Returns yyyy.ddd - julians date     */
/*              L Returns dd Month yyyy               */
/*              M Returns Month                       */
/*              N Returns dd Mmm yyyy                 */
/*              O Returns yyyy/mm/dd                  */
/*              S Returns yyyymmdd                    */
/*              U Returns mm/dd/yyyy                  */
/*              W Returns Weekday                     */
/*                                                    */
/* Syntax.....: Date = Date2000(Option)               */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* (C) Copyright Janosch R. Kowalczyk, 1996.          */
/* All rights reserved.                               */
/*====================================================*/
Date2000: Procedure
Parse Value Arg(1) With Option +1 .

If Option = '' Then Return Date()
If Verify('EJOU', Option, 'M') > 0 Then Do
  Parse Value Date() With . . yyyy
  If Option = 'J' Then Return yyyy || '.' || Date('D')
  Else If Option = 'O' Then Do
    Parse Value Date(Option) With . +2 Rest
    Return yyyy || Rest
  End
  Else Do
    Parse Value Date(Option) With Rest +6 .
    Return Rest || yyyy
  End
End
Else Return Date(Option)
 (        "  <<"  Exclude multiple items  /*=============( Exclude multiple items )=============*/
/*                                                 11 */
/* Name.......: NoMult                                */
/*                                                    */
/* Function...: Excludes multiple lines from a sorted */
/*              file                                  */
/* Call parm..: nothing                               */
/* Returns....: nothing (0)                           */
/*                                                    */
/* Syntax.....: Call NoMult / y = NoMult()            */
/*                                                    */
/* Notes......: The elements to exclude must be       */
/*              saved in the stem named so as the     */
/*              stem in this Procedure (in this case  */
/*              "STEM.")                              */
/*              stem.0 must contain the number of     */
/*              elements in stem.                     */
/*              The stem variable must be previously  */
/*              sorted                                */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* (C) Copyright Janosch R. Kowalczyk, 1996.          */
/* All rights reserved.                               */
/*====================================================*/
NoMult: Procedure Expose stem.

Do i = 1 To stem.0
  Queue stem.i
  Do j = i + 1 while stem.i = stem.j
  End
  i = j - 1
End

Return 0
 /        (  )  Insertion Sort /*=================(Insertion sort)===================*/
/* :-!                                              3 */
/* Name.......: InsSort                               */
/*                                                    */
/* Function...: Insertion Sort for a stem variable    */
/* Call parm..: No                                    */
/* Returns....: nothing (NULL string)                 */
/*                                                    */
/* Sample call: Call InsSort                          */
/*                                                    */
/* Notes......: The elements to sort for must be      */
/*              saved in the stem named so as the     */
/*              stem in this Procedure (in this case  */
/*              "STEM.")                              */
/*              stem.0 must contain the number of     */
/*              elements in stem.                     */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* (C) Copyright Janosch R. Kowalczyk, 1996.          */
/* All rights reserved.                               */
/*====================================================*/
InsSort: Procedure Expose stem.

Do x = 2 To stem.0
  xchg = stem.x
  Do y = x - 1 By -1 To 1 While stem.y > xchg
    xchg   = stem.x
    stem.x = stem.y
    stem.y = xchg
    x = y
  End /* Do y = x... */
  stem.x = xchg
End /* Do x = 2 ...  */

Return ''

 4        4/  M/  Julian to gregorian date /*========(Translate julian to gregorian date)========*/
/*                                                 10 */
/* Name.......: J2G                                   */
/*                                                    */
/* Function...: translates julian to gregorian date   */
/*              julian date                           */
/* Call parm..: julian date in format yyyy.ddd        */
/* Returns....: julian date (yyyy.mm.dd)              */
/*                                                    */
/* Syntax.....: gregDate = J2G(yyyy.gdd)              */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* (C) Copyright Janosch R. Kowalczyk, 1996.          */
/* All rights reserved.                               */
/*====================================================*/
J2G: Procedure
Arg julDate

Parse Var julDate year'.'jday

mon.1  = 0
mon.2  = 31
mon.3  = 59
mon.4  = 90
mon.5  = 120
mon.6  = 151
mon.7  = 181
mon.8  = 212
mon.9  = 243
mon.10 = 273
mon.11 = 304
mon.12 = 334

If year // 400 = 0 | (year // 100 > 0 & year // 4 = 0) Then
  leap = 1
Else
  leap = 0

Do i = 1 To 12 
  If i > 2 Then mon.i = mon.i + leap
  If jday > mon.i Then mon = i
End

day = jday - mon.mon
gregDate = year'.'Right(mon,2,'0')'.'Right(day,2,'0')

return gregDate
 <        5  5  Quick Sort /*====================(Quick sort)====================*/
/* :-D                                              4 */
/* Name.......: QSort                                 */
/*                                                    */
/* Function...: Quick Sort for a stem variable        */
/* Call parm..: No                                    */
/* Returns....: Left-Right span                       */
/*                                                    */
/* Sample call: Call QSort                            */
/*                                                    */
/* Notes......: The elements to sort for must be      */
/*              saved in the stem named so as the     */
/*              stem in this Procedure (in this case  */
/*              "STEM.")                              */
/*              stem.0 must contain the number of     */
/*              elements in stem.                     */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* (C) Copyright Janosch R. Kowalczyk, 1996.          */
/* All rights reserved.                               */
/*====================================================*/
QSort: Procedure Expose stem.

Arg left, right

If left  = '' Then left  = 1
If right = '' Then right = stem.0
If right > left Then Do
  i = left
  j = right
  k = (left+right)%2
  x = stem.k
  Do Until i > j
    Do While stem.i < x; i = i + 1; End
    Do While stem.j > x; j = j - 1; End
    If i <= j Then Do
      xchg = stem.i
      stem.i = stem.j
      stem.j = xchg
      i = i + 1
      j = j - 1
    End
  End
  y = QSort(left,j)
  y = QSort(i,right)
End

Return right - left

 B        (<  3<  Shell Sort /*====================(Shell sort)=====================*/
/* :-)                                               5 */
/* Name.......: ShlSort                                */
/*                                                     */
/* Function...: Shell Sort for a stem variable         */
/* Call parm..: No                                     */
/* Returns....: nothing (NULL string)                  */
/*                                                     */
/* Sample call: Call ShlSort                           */
/*                                                     */
/* Notes......: The elements to sort for must be       */
/*              saved in the stem named so as the      */
/*              stem in this Procedure (in this case   */
/*              "STEM.")                               */
/*              stem.0 must contain the number of      */
/*              elements in stem.                      */
/*                                                     */
/* Changes....: No                                     */
/*                                                     */
/* (C) Copyright Janosch R. Kowalczyk, 1996.           */
/* All rights reserved.                                */
/*=====================================================*/
ShlSort: Procedure Expose stem.

parts = 3        /* adjust to your necessities ( >1 ) */
Do n = 1 To parts
  incr = 2**n - 1
  Do j = incr + 1 To stem.0
    i = j - incr
    xchg = stem.j
    Do While xchg < stem.i & i > 0
      m = i + incr
      stem.m = stem.i
      i = i - incr
    End /* Do While xchg ... */
    m = i + incr
    stem.m = xchg
  End /* Do j = incr ... */
End /* Do n = 1 ... */

Return ''

 H        C  )C  Gregorian to julian date /*=============(Gregorian to julian date)==============*/
/*                                                  9  */
/* Name.......: G2J                                    */
/*                                                     */
/* Function...: translates gregorian date to the       */
/*              julian date                            */
/* Call parm..: gregorian date in format yyyy.mm.dd    */
/* Returns....: julian date (yyyy.ddd)                 */
/*                                                     */
/* Syntax.....: julDate = G2J(yyyy.mm.dd)              */
/*                                                     */
/* Changes....: No                                     */
/*                                                     */
/* (C) Copyright Janosch R. Kowalczyk, 1996.           */
/* All rights reserved.                                */
/*=====================================================*/
G2J: Procedure
Arg gregDat

year = SubStr(gregDat,1,4)
mon  = SubStr(gregDat,6,2) + 0 /* To delete leading zero */
day  = SubStr(gregDat,9,2)

mon.1  = 0
mon.2  = 31
mon.3  = 59
mon.4  = 90
mon.5  = 120
mon.6  = 151
mon.7  = 181
mon.8  = 212
mon.9  = 243
mon.10 = 273
mon.11 = 304
mon.12 = 334

If (year // 400 = 0 | (year // 100 > 0 & year // 4 = 0)) & mon > 2 Then
  leap = 1
Else leap = 0

julDay = mon.mon + day + leap

Return year'.'Right(julDay,3,'0')
 HO        H  [[H  Square root evolution /*====================(Square root)====================*/
/* :-)                                               6 */
/* Name.......: SqrRoot                                */
/*                                                     */
/* Function...: Square root evolution for the call     */
/*              parameter                              */
/* Call parms.: Evolution number, precision            */
/* Returns....: Square root                            */
/*                                                     */
/* Syntax.....: sqrt = SqrRoot(number, [precision])    */
/*                                                     */
/* Notes......: precision is the highest possible      */
/*              error for the evaluation.              */
/*              Default Value is 0.00001               */
/*              You are responsible for the valid      */
/*              number value                           */
/*                                                     */
/* Changes....: No                                     */
/*                                                     */
/* (C) Copyright Janosch R. Kowalczyk, 1996.           */
/* All rights reserved.                                */
/*=====================================================*/
SqrRoot: Procedure

Arg number, precision

If Datatype(number) \= 'NUM' Then Return -1
If precision <= 0 | precision > 1 Then precision = 0.00001

sqrt = 1
 
Do Until Abs(sqrt_old - sqrt) < precision
  sqrt_old = sqrt
  sqrt = (sqrt_old * sqrt_old + number) / (2 * sqrt_old)
End /* Do Until ... */

Return sqrt

 
V        `O  xO  Recursive Path Creating /*=============( Recursive Path Creating )============*/
/*                                                 16 */
/* Name.......: MakePath                              */
/*                                                    */
/* Function...: Create recursive directory path       */
/*                                                    */
/* Call parm..: _destPath  - directory path           */
/*                                                    */
/* Returns....: formated string                       */
/*                                                    */
/* Syntax.....:                                       */
/*    _destPath = MakePath( _destPath )               */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* (C) Copyright Janosch R. Kowalczyk, 1996.          */
/* All rights reserved.                               */
/*====================================================*/
/*---------------(Create Directory Path)--------------*/
MakePath: Procedure
Arg _destPath

_destPath = Strip(_destPath,,'\')
If Pos('\', _destPath) = 0 Then Return _destPath

/*--------------( Check Directory Path )--------------*/
rc = SysFileTree( _destPath, fileList, 'DO' )
If fileList.0 = 0 Then Do
  /*------------(Directory path not exists)-----------*/
  Call MakePath SubStr(_destPath, 1, LastPos('\', _destPath))  
  rc = SysMkDir( _destPath )
  If rc > 0 & rc \= 5 Then
    Say 'Destination directory:' _destPath 'not created. RC=' rc 
  Else 
    Say _destPath 'successful created'
End

Return _destPath
 /\        "V  8V  Delete Directory Path /*==============( Delete Directory Path )=============*/
/*                                                 17 */
/* Name.......: ErasePath                             */
/*                                                    */
/* Function...: delete directory path                 */
/*                                                    */
/* Call parm..: _erasePath - directory path to be     */
/*              deleted                               */
/*                                                    */
/* Returns....: formated string                       */
/*                                                    */
/* Syntax.....:                                       */
/*    _erasePath = MakePath( _erasePath )               */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* (C) Copyright Janosch R. Kowalczyk, 1996.          */
/* All rights reserved.                               */
/*====================================================*/
/*-------------(Delete Directory Path)------------*/
ErasePath: Procedure
Arg _erasePath 

_erasePath = Strip( _erasePath, , '\' )

Do Until Pos('\', _erasePath) = 0 
  rc = SysRmDir( _erasePath )
  If rc > 0 Then
    Say 'Directory:' _erasePath 'not deleted. RC=' rc 
  Else 
    Say _erasePath 'successful deleted'
  _erasePath = SubStr( _erasePath, 1, LastPos('\', _erasePath) - 1)
End

Return _erasePath l        G\  `\  Remove umlaut characters /*============( Remove umlaut characters )============*/
/*                                                 14 */
/* Name.......: NoUmlaut                              */
/*                                                    */
/* Function...: Replace umlaut characters with double */
/*              character strings ( -> ae,  -> oe,  */
/*               -> ue,  -> ss)                     */
/*                                                    */
/* Call parm..: _string - string with umlauts,        */
/*              _upper  - upper case return string    */
/*                        (optional)                  */
/*                                                    */
/* Returns....: translated string                     */
/*                                                    */
/* Syntax.....:                                       */
/*    tranStr = NoUmlaut( uString,['U'] )             */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* Note.......: This function calls the function      */
/*              ReplaceUmlaut                         */
/*                                                    */
/* Author.....: Janosch R. Kowalczyk, 1996.           */
/*====================================================*/
NoUmlaut: Procedure
Parse Arg _string, _upper

/*---------(Replace '' '' by 'ae' 'Ae')-----------*/
_string = ReplaceUmlaut( _string, '', 'ae' )
_string = ReplaceUmlaut( _string, '', 'Ae' )

/*---------(Replace '' '' by 'oe' 'Oe')-----------*/
_string = ReplaceUmlaut( _string, '', 'oe' )
_string = ReplaceUmlaut( _string, '', 'Oe' )

/*---------(Replace '' '' by 'ue' 'Ue')-----------*/
_string = ReplaceUmlaut( _string, '', 'ue' )
_string = ReplaceUmlaut( _string, '', 'Ue' )

/*-------------(Replace '' by 'ss')----------------*/
_string = ReplaceUmlaut( _string, '', 'ss' )

If Abbrev('UPPER', _upper, 1) = 1 Then
  Return Translate( _string )

Return _string

/*========( Replace a string with an another )========*/
/*                                                14a */
/* Name.......: ReplaceUmlaut                         */
/*                                                    */
/* Function...: Find all occurences of a substring    */
/*              and replace it by an another          */
/*                                                    */
/* Call parm..: _string  - input string,              */
/*              _origin  - substring to be replaced   */
/*              _replStr - replace substring          */
/*                                                    */
/* Returns....: translated string                     */
/*                                                    */
/* Syntax.....:                                       */
/*    tranStr = ReplaceUmlaut( String, origin, repl ) */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* Note.......: This function is called from NoUmlaut */
/*              and was developed for this purpose    */
/*              only. It isn't able to replace sub-   */
/*              strings that have same characters in  */
/*              both - origin and replace string!     */
/*                                                    */
/* Author.....: Janosch R. Kowalczyk, 1996.           */
/*====================================================*/
ReplaceUmlaut: Procedure
Parse Arg _string, _origin, _replStr

/*---( Same characters in the input and output strings )---*/
If Verify( _origin, _replStr, 'M' ) > 0 Then Return _string

/*-----(Replace umlaut by combined characters)-----*/
Do While Pos( _origin, _string ) > 0
  Parse Var _string _prefix_ (_origin) _suffix_
  _string = _prefix_ || _replStr || _suffix_
End

Return _string
 r        l  /l  Replace a string /*========( Replace a string with an another )========*/
/*                                                 15 */
/* Name.......: StrRepl                               */
/*                                                    */
/* Function...: Find all occurences of a substring    */
/*              and replace it by an another          */
/*                                                    */
/* Call parm..: _string  - input string,              */
/*              _origin  - substring to be replaced   */
/*              _replStr - replace substring          */
/*                                                    */
/* Returns....: translated string                     */
/*                                                    */
/* Syntax.....:                                       */
/*  tranStr = ReplaceString(_string,_origin,_replStr) */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* Author.....: Janosch R. Kowalczyk, 1996.           */
/*====================================================*/
StrRepl: Procedure
Parse Arg _string, _origin, _replStr

/*---( Find a substring to replace? )---*/
_lastPos = LastPos( _origin, _string )

If _lastPos > 0 Then Do

  /*---( Get prefix to the substring )---*/
  If _lastPos = 1 Then _prefix = ''
  Else _prefix = SubStr( _string, 1, _lastPos - 1 )

  /*---( Get suffix of the substring )---*/
  _suffix = SubStr( _string, _lastPos + Length( _origin ))

  /*---( Find next substring to replace )---*/
  Return StrRepl( _prefix, _origin, _replStr ) || _replStr || _suffix

End
Else
  Return _string

 w        	s  !s  Translate To Lower Case /*=============(Translate To Lower Case)===============*/
/* :-)                                               8 */
/* Name.......: ToLower                                */
/*                                                     */
/* Function...: Translate entired string to lower      */
/*              case                                   */
/* Call parms.: String to translate                    */
/* Returns....: Translated string                      */
/*                                                     */
/* Syntax.....: lowString = ToLower(upperString)       */
/*                                                     */
/* Changes....: No                                     */
/*                                                     */
/* (C) Copyright Janosch R. Kowalczyk, 1996.           */
/* All rights reserved.                                */
/*=====================================================*/
ToLower: Procedure

/*------------(Lower Case entired string)--------------*/
Parse Arg Upper_String

Lowers = XRange('a','z') || ''
Uppers = XRange('A','Z') || ''

Return Translate(Upper_String, Lowers, Uppers)

 }        w  w  Read file into a stem /*==============(Read file into a stem)==============*/
/* :-)                                OS/2 Only!!! 7 */
/* Name.......: FileRead                             */
/*                                                   */
/* Function...: Read file into a stem                */
/*                                                   */
/* Call parms.: File name                            */
/*              Number of lines                      */
/* Returns....: Number of lines                      */
/*                                                   */
/* Sample call: lines = FileRead('read.me')            */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/* (C) Copyright Janosch R. Kowalczyk, 1996.         */
/* All rights reserved.                              */
/*===================================================*/
FileRead: Procedure Expose stem.
Arg fileName, lines

If lines = '' Then
  lines = Stream( fileName, 'C', 'Query Size' )

status = Stream( fileName, 'C', 'Query Exists' )
If status  \= '' Then Do
  Do i = 1 To lines while Lines( fileName ) > 0
    stem.i = LineIn( filename )
  End
  stem.0 = i - 1
  status = Stream( fileName, 'C', 'Close' )
End
Else Do
  stem.1 = 'FileRead Error. File' fileNeme' not found'
  stem.0 = 1
End

Return stem.0
         }  ff}  Greatest common divisor /*=============( Greatest common divisor )============*/
/*                                                 18 */
/* Name.......: EuclidGCD                             */
/*                                                    */
/* Function...: Get greatest common divisor (Euclids  */
/*              algorithm)                            */
/* Call parm..: _counter                              */
/*              _denuminator                          */
/* Returns....: gcd                                   */
/*                                                    */
/* Syntax.....:                                       */
/*    gcd = EuclidGCD( _counter, _denuminator )       */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* (C) Copyright Janosch R. Kowalczyk, 1997.          */
/* All rights reserved.                               */
/*====================================================*/
/*--------------(Greatest common divisor)-------------*/
EuclidGCD: Procedure
Arg _counter, _denuminator

Do Until _counter = 0
  If _counter < _denuminator Then Do
    _Xchange     = _counter
    _counter     = _denuminator
    _denuminator = _Xchange
  End
  _counter = _counter - _denuminator
End

Return _denuminator

         -  bbA  Cube root evolution /*====================( Cube root )====================*/
/* :-)                                               7 */
/* Name.......: CubeRoot                               */
/*                                                     */
/* Function...: Cube root evolution for the calling    */
/*              parameter                              */
/* Call parms.: Evolution number, precision (optional) */
/* Returns....: Cube root                              */
/*                                                     */
/* Syntax.....: cbrt = CubeRoot(_digit, [precision])   */
/*                                                     */
/* Notes......: precision is the highest possible      */
/*              error for the evaluation.              */
/*              Default Value is 0.00001               */
/*              You are responsible for the valid      */
/*              number value                           */
/*                                                     */
/* Changes....: No                                     */
/*                                                     */
/* (C) Copyright Janosch R. Kowalczyk, 1997.           */
/* All rights reserved.                                */
/*=====================================================*/
CubeRoot: Procedure

Arg _digit, precision

If Datatype(_digit) \= 'NUM' Then Return -1
If precision <= 0 | precision > 1 Then precision = 0.000001

cbrt = 1
 
Do Until Abs(cbrt_old - cbrt) < precision
  cbrt_old = cbrt
  cbrt = ( 2 * cbrt_old ** 3 + _digit ) / ( 3 * cbrt_old ** 2 )
End /* Do Until ... */

Return cbrt
             ͉  Play digital file /*================(Play digital file)================*/
/* :-)                                OS/2 Only!!! 7 */
/* Name.......: PlayFile                             */
/*                                                   */
/* Function...: Play digital WAV/MID file            */
/*                                                   */
/* Call parms.: File name to play                    */
/* Returns....: RC from the last mciRexx function    */
/*                                                   */
/* Sample call: rc = PlayFile('bach.mid')            */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/* (C) Copyright Janosch R. Kowalczyk, 1996.         */
/* All rights reserved.                              */
/*===================================================*/
PlayFile: Procedure

Arg CmdObject
If CmdObject = '' Then Return -1

/*-----------(Initialize mciREXX support)-----------*/
If RxFuncQuery( 'mciRxInit' ) Then Do
  rc = RxFuncAdd( 'mciRxInit', 'MCIAPI', 'mciRxInit' )
  Init_RC = mciRxInit()
End

loudness = 70 /* % */
/*--------------(Prepare MCI-commands)---------------*/
CmdStr.1 = 'OPEN' CmdObject 'ALIAS W WAIT'
CmdStr.2 = 'SET W TIME FORMAT MS WAIT'
CmdStr.3 = 'SET W AUDIO VOLUME' loudness 'WAIT'
CmdStr.4 = 'PLAY W WAIT'
/*------------(Play digital WAV/MID file)------------*/
Do i = 1 To 4
  /*-----------(Send MCI command strings)------------*/
  rc = mciRxSendString(CmdStr.i, 'retstrvar', '0','0')
  If rc > 0 Then Leave
End

CmdStr = 'CLOSE W WAIT'
/*--------------(Send MCI command string)--------------*/
rc = mciRxSendString(CmdStr, 'retstrvar', '0','0')

Return rc

 