/*********************************************************************/
/*  FILE NAME:              RSP.CMD                                  */
/*                                                                   */
/*  AUTHOR:                 Kathleen Colina                          */
/*                                                                   */
/*  DATE:                   May 5, 1995                              */
/*                                                                   */
/*  PURPOSE:                Test Digital Video (SMV)                 */
/*                                                                   */
/*  HARDWARE:               1 audio card                             */
/*********************************************************************/

/*********************************************************************/
/* Must enter name of output file in order to execute.               */
/*********************************************************************/

parse upper arg ERRFILE
ERRFILE = STRIP(ERRFILE)

if (ERRFILE = ' ' | ERRFILE = '?')
  then do
         say 'Specify name of output file, (FILENAME FILENAME.OUT)'.
         exit
       end

/*********************************************************************/
/* Load the DLL, initialize MCI REXX support                         */
/*********************************************************************/

rc = RXFUNCADD('SysSleep','RexxUtil','SysSleep')
rc = RXFUNCADD('mciRxInit','MCIAPI','mciRxInit')
InitRC = mciRxInit()


   env='OS2ENVIRONMENT'

   say "Starting time: "TIME(C)

   call SendString "defaultconnection digitalvideo make type wave stream to ampmix01 totype amp stream wait"
   say "#01  connect digitalvideo"

   call SendString "Open digitalvideo alias dv1 shareable wait"
   say "#02  open    dv1"

   DeviceID = mciRxGetDeviceID(dv1)
   say "#03  get     dv1 device ID"

   call SendString "Capability dv1 device type wait"
   say "#04  capability - device type"

   call SendString "Capability dv1 can setvolume wait"
   say "#05  capability - setvolume"

   call SendString "Set dv1 time format MMTIME wait"
   say "#06  set     dv1 time format"

   call SendString "Load dv1 \ulti\movie.avi wait"
   say "#07  load    dv1 movie.avi"

   call SendString "Status dv1 volume wait"
   say "#08  status  dv1 volume"

   call SendString "Status dv1 length wait"
   say "#09  status  dv1 length"

   call SendString "Cue dv1 output wait"
   say "#10  cue     dv1 output"
/*********************************************************************/
   call SendString "Acquire dv1 exclusive instance wait"
   say "#11  acquire dv1 exclusive instance"
   call SysSleep 5

   call SendString "Play dv1 from 0"
   say "#12  play    dv1 from 0"
   call SysSleep 10

   call SendString "Pause dv1 wait"
   say "#13  pause   dv1"
   call SysSleep 5

   call SendString "Resume dv1 wait"
   say "#14  resume  dv1"
   call SysSleep 10
/*********************************************************************/
   call SendString "Seek dv1 to start wait"
   say "#15  seek    dv1 to start"
   call SysSleep 5

   call SendString "Play dv1 from 0"
   say "#16  play    dv1 from 0"
   call SysSleep 20

   call SendString "Stop dv1 wait"
   say "#17  stop    dv1"
   call SysSleep 5

   call SendString "Release dv1 wait"
   say "#18  release dv1"
   call SysSleep 5

   call SendString "Acquire dv1 exclusive instance"
   say "#19  acquire dv1 exclusive instance"
   call SysSleep 5

   call SendString "Load dv1 \ulti\laserc24.avi wait"
   say "#20  load    dv1 laserc24.avi"
   call SysSleep 5

   call SendString "Play dv1 from 0 to 25000"
   say "#21  play    dv1 from 0 to 25000"
   call SysSleep 10

   call SendString "Pause dv1 wait"
   say "#22  pause   dv1"
   call SysSleep 5

   call SendString "Resume dv1 wait"
   say "#23  resume  dv1"
   call SysSleep 20

   call SendString "Stop dv1 wait"
   say "#24  stop    dv1"
   call SysSleep 5

   call SendString "Release dv1 wait"
   say "#25  release dv1"
   call SysSleep 5

   call SendString "Acquire dv1 exclusive instance"
   say "#26  acquire dv1 exclusive instance"
   call SysSleep 5

   call SendString "Load dv1 \ulti\movie.avi wait"
   say "#27  load    dv1 movie.avi"
   call SysSleep 5

   call SendString "Play dv1"
   say "#28  play    dv1"
   call SysSleep 10

/*********************************************************************/
/* Attempt to acquire first file exclusive instance.  Should         */
/* return Device is Locked.                                          */
/*********************************************************************/

   call SendString "Acquire dv1 exclusive instance wait"
   linerc=LINEOUT(ERRFILE,'This string has passed. Expect:  Device is Locked')
   say "#29  acquire dv1 - expected return Device is Locked"
   call SysSleep 10

   call SendString "Stop dv1 wait"
   say "#30  stop    dv1"
   call SysSleep 5

   call SendString "Release dv1 wait"
   say "#31  release dv1"
   call SysSleep 5

   call SendString "Acquire dv1 wait"
   say "#32  acquire dv1"
   call SysSleep 5

   call SendString "Load dv1 \ulti\laserc24.avi wait"
   say "#33  load    dv1 laserc24.avi"
   call SysSleep 5

   call SendString "Cue dv1 output wait"
   say "#34  cue     dv1 output"
   call SysSleep 5

   call SendString "Status dv1 mode wait"
   say "#35  status  dv1 mode"
   call SysSleep 5

   call SendString "Release dv1 wait"
   say "#36  release dv1"
   call SysSleep 5

   call SendString "Acquire dv1 wait"
   say "#37  acquire dv1"
   call SysSleep 5

   call SendString "Play dv1 from 0 to 8000"
   say "#38  play    dv1 0 to 8000"
   call SysSleep 15

   call SendString "Stop dv1 wait"
   say "#39  stop    dv1"
   call SysSleep 5

   call SendString "Release dv1 wait"
   say "#40  release dv1"
   call SysSleep 5

   call SendString "Acquire dv1 wait"
   say "#41  acquire dv1"
   call SysSleep 5

   call SendString "Play dv1 from 0"
   say "#42  play    dv1 from 0"
   call SysSleep 20

   call SendString "Stop dv1 wait"
   say "#43  stop    dv1"
   call SysSleep 10

/*********************************************************************/
/* Close all instances                                               */
/*********************************************************************/

   call SendString "Close dv1 wait"
   say "#44  close   dv1"

   say "Ending time: "TIME(C)

   say "Click on OK button of REXX PROCEDURE HAS ENDED message"
   say "Then close PMREXX by double-click on left icon of title bar"
   say "  "
   say "  "
   say "  "
   say "  "
   say "  "
   say "  "
   say "  "
   say "  "
   say "  "
   say "  "

/*********************************************************************/
/* Terminate the REXX command file and Exit (DLL), return code = 0.  */
/*********************************************************************/
                      /****************************************/
MacRC = mciRxExit()   /* Terminate REXX command file          */
call rxqueue 'Set', 'pmrexxque'   /* SET Queue name for PMREXX*/
call lineout 'QUEUE:','1'         /* Add line to Queue        */
exit 0                /* Tell the DLL we're going away        */
                      /****************************************/

   say "Test complete"

/*********************************************************************/
/* Terminate the REXX command file and Exit (DLL), return code = 0.  */
/*********************************************************************/
                      /****************************************/
MacRC = mciRxExit()   /* Terminate REXX command file          */
call rxqueue 'Set', 'pmrexxque'   /* SET Queue name for PMREXX*/
call lineout 'QUEUE:','1'         /* Add line to Queue        */
exit 0                /* Tell the DLL we're going away        */
                      /****************************************/

/*********************************************************************/
/*   --- SendString --                                               */
/* Call DLL function.  Pass the command to process and the           */
/* name of a REXX variable that will recieve textual return          */
/* information.                                                      */
/*********************************************************************/

SendString:
   arg CmndTxt
   Zero='0'
   MacRC = mciRxSendString(CmndTxt, 'RetSt', Zero, Zero)
   if (MacRC<>0) then
      do
      ErrRC = MacRC
      linerc=LINEOUT(ERRFILE,'MciCmd=' CmndTxt)
      linerc=LINEOUT(ERRFILE, 'Err:mciRxSendString RC=' ErrRC RetSt)
      MacRC = mciRxGetErrorString(ErrRC, 'ErrStVar')
        linerc=LINEOUT(ERRFILE, ErrStVar)                /***********************/
        MacRC = ErrRC                                    /* return the error rc */
     end                                                 /***********************/
     else
        if (RetSt <> '') then
           linerc=LINEOUT(ERRFILE, CmndTxt 'returned' RetSt)
   return MacRC


