/** Rexx Program to Query VIM Capabilities **/
ARG TYPE

/* Unload functions upon error */
SIGNAL ON ERROR NAME done

if LENGTH(STRIP(type)) = 0 then do
   Say
   Say 'Incorrect Syntax!  Correct syntax is:'
   Say
   Say 'VIMCAP < Capability to query | ALL'
   Say
   Say 'VIMCAP ALL will query all VIM functions'
   Say
   return
end  /* Do */

TYPE = TRANSLATE(STRIP(TYPE))
if TYPE = 'ALL' then do
  call LoadVIMCap
  doall = TRUE
end  /* Do */
else
  doall = FALSE

call RxFuncAdd 'RxVIMLoadFuncs', 'REXXVIM', 'RxVIMLoadFuncs'
call RxVIMLoadFuncs
rc = RxVIMInitialize()
Say
Say '|-Capability----------------------Value------------------------------------|'

if doall = TRUE then do
   do count=1 to vimcap.0
      TYPE = TRANSLATE(STRIP(vimcap.count))
      rc = RxVIMQueryCapability(TYPE,'Query')
   if rc>0 then signal VIMERR
      Say ' 'LEFT(TYPE||':',30)'  ' SUBSTR(Query,1,30)
   end /* do */
end  /* Do */
else do
   rc = RxVIMQueryCapability(TYPE,'Query')
   if rc>0 then signal VIMERR
   Say ' 'LEFT(TYPE||':',30)'  ' SUBSTR(Query,1,30)
   Say
end  /* Do */

rc = RxVIMTerminate()
/*** Drop all of the external functions ***/
call RxVIMDropFuncs
Say '|--------------------------------------------------------------------------|'
Say 'Demo Complete.  All functions released'
'pause'
exit

/***** VIMErr *******/
VIMERR:

rc = RxVIMStatusText(rc,'Status')
Say
Say '|-Error Information -----------------|'
Say '  Error Text:' status.1
Say
if LENGTH(STRIP(status.2)) > 0 then
   Say '  Ext Status:' status.2
rc = RxVIMTerminate()

DONE:
/*** Drop all of the external functions ***/
call RxVIMDropFuncs
Say '|------------------------------------|'
Say 'Demo Complete.  All functions released'
exit

/****** Load all VIM Capabilities into stem variable *****/
LOADVIMCAP:

vimcap.0    =  32
vimcap.1    =  "VIMSEL_VERSION"
vimcap.2    =  "VIMSEL_IMPLEMENTATION"
vimcap.3    =  "VIMSEL_IMPLEMENTATION_VERSION"
vimcap.4    =  "VIMSEL_PRODUCT"
vimcap.5    =  "VIMSEL_MAX_SUBJECT_LEN"
vimcap.6    =  "VIMSEL_MAX_TYPE_LEN"
vimcap.7    =  "VIMSEL_MAX_TEXT_LEN"
vimcap.8    =  "VIMSEL_RTF"
vimcap.9    =  "VIMSEL_FAX"
vimcap.10   =  "VIMSEL_STYLED"
vimcap.11   =  "VIMSEL_PICT"
vimcap.12   =  "VIMSEL_MOVIE"
vimcap.13   =  "VIMSEL_IMAG"
vimcap.14   =  "VIMSEL_UNWRAPPED_TEXT"
vimcap.15   =  "VIMSEL_ALL_NOTE_PARTS_SUPP"
vimcap.16   =  "VIMSEL_ATTACH_TYPE_SUPP"
vimcap.17   =  "VIMSEL_ATTACH_DIRS"
vimcap.18   =  "VIMSEL_ENCRYPT"
vimcap.19   =  "VIMSEL_ENCRYPT_WITH_KEY"
vimcap.20   =  "VIMSEL_SIGN"
vimcap.21   =  "VIMSEL_NSTD_DERIVED_REPLIES"
vimcap.22   =  "VIMSEL_NSTD_DERIVED_FORWRDS"
vimcap.23   =  "VIMSEL_CP850"
vimcap.24   =  "VIMSEL_CP1252"
vimcap.25   =  "VIMSEL_CP437"
vimcap.26   =  "VIMSEL_LMBCS"
vimcap.27   =  "VIMSEL_ISTRING"
vimcap.28   =  "VIMSEL_UNICODE"
vimcap.29   =  "VIMSEL_APPLESINGLE"
vimcap.30   =  "VIMSEL_PATH_REQUIRED"
vimcap.31   =  "VIMSEL_NAME_REQUIRED"
vimcap.32   =  "VIMSEL_PASS_REQUIRED"
                                                     
                                             
return
