/** Msgacts.cmd **/
/*********************************************/
/*                                           */
/* Command line syntax:                      */
/*                                           */
/* msgacts db_path user_password user_name   */
/*                                           */
/*                                           */
/*********************************************/
ARG db_path user_pw user_name
'@echo off'
'@cls'
Say 'RexxVIM Message Access Demonstration Program'
Say

/* Unload the function upon error */
SIGNAL ON ERROR NAME done

/* Prompt for the parameters if not passed on the */
/* command line                                   */
if LENGTH(STRIP(db_path)) = 0 then do
   Say 'Enter Postoffice Directory -'
   PARSE PULL db_path .
   Say
   Say 'Enter User Name -'
   PARSE PULL user_name
   Say 'Enter Password -'
   PARSE PULL user_pw
end  /* Do */


/* Load the RexxVIM extensions to Rexx */
rc = RxFuncAdd('RxVIMLoadFuncs', 'REXXVIM', 'RxVIMLoadFuncs')
if rc <> 0 then do
   Say
   Say 'RexxVIM failed to load, return code' rc
   Say
   Say 'Functions have been released.  Retry program.'
   signal done
end  /* Do */
call RxVIMLoadFuncs
Say 'Functions are now loaded'
Say


/* Initialize the VIM subsystem */
rc = RxVIMInitialize()
if (rc > 0) then call vimerr


/* Open a session with the postoffice using the parameters */
/* provided by the user                                    */
rc = RxVIMOpenSession(db_path,user_name,user_pw,Session)
if (rc > 0) then call vimerr


/* Open the default message container -- Inbox */
rc = RxVIMOpenMessageContainer(Session,'','Inbox')
if (rc > 0) then call vimerr


/* Display all messages in Inbox if they exist */

     /* Enumerate messages in container -- Inbox */
     pos = ''                           /* Start at the beginning of the container */
     skipcnt = 1                        /* Move forward through the container one at a time */
     mcount  = 1                        /* Retrieve 1 message for each call */
     filter  = 'VIMSEL_NO_FILTER'       /* No filter, return all messages in inbox */
     fdata   = ''                       /* No filter data */
     flags   = 'VIM_NO_FLAGS'           /* No enumeration flags, return all messages in inbox */
     more    = ''                       /* Set the value of more to nul */
     action  = 'N'                      /* Set the value of repeat loop indicator to N */

     AttrDesc.0 = 3                               /* Retrieve 3 attributes for each message */
     AttrDesc.1.Selector = 'VIMSEL_REF'           /* 1st attribute is the message reference number */
     AttrDesc.1.Buffer   = 'MsgRefNo'             /* store results in this stem variable */
     AttrDesc.2.Selector = 'VIMSEL_SUBJECT'       /* 2nd attribute is the message subject */
     AttrDesc.2.Buffer   = 'Subject'              /* store results in this stem variable */
     AttrDesc.3.Selector = 'VIMSEL_UNREAD_MAIL'   /* 3rd attribute is if unread */
     AttrDesc.3.Buffer   = 'Unread'               /* store results in this stem variable */

     do until TRANSLATE(SUBSTR(action,1,1)) = 'X'

          /* Continue retrieving message info until user enters N */

          rc = RxVIMEnumerateMessages(Inbox,'pos',skipcnt,'AttrDesc','mcount',filter,fdata,flags,'more')
          if (rc > 0) then call vimerr

          /* Display results */
         'cls'
          Say 'RexxVIM - (c) Innovative Business Technologies, Inc'
          Say
          Say 'Message Container Demo'
          Say
          Say '--------------------------------------------------------'
          Say '    Message =' MsgRefNo.1
          Say '    Subject =' Subject.1
          Say '    Unread  =' Unread.1
          Say '--------------------------------------------------------'
          Say
          Say 'Select an action for this message'
          Say
          Say '   D - Delete message'
          Say '   F - File message in a folder'
          Say '   N - Go to next message, leave this one in the Inbox'
          Say '   M - Mark message as read'
          Say '   H - Display message header info'
          Say '   I - Display message items'
          Say '   T - Display the first 60 characters of first message item'
          Say '   X - Exit demo now'
          Say
          Say 'Enter your selection below:'
          PULL action

          /* Process the selection entered.  X will fall through the select statement */
          select
             when TRANSLATE(SUBSTR(action,1,1)) = 'D' then do
                /* Delete message */
                rc = RxVIMRemoveMessage(Inbox,MsgRefNo.1)
                if (rc > 0) then call vimerr
           end  /* Do */
             when TRANSLATE(SUBSTR(action,1,1)) = 'F' then do
                /* File message in folder */
                Say 'Enter the name of the folder:'
                PULL category
                 rc = RxVIMSetMessageCategory(Inbox,MsgRefNo.1,category)
                if (rc > 0) then call vimerr
             end  /* Do */
             when TRANSLATE(SUBSTR(action,1,1)) = 'N' then do
                /* Go to the next message */
                /* Nothing to do.....loop will pull next message */
             end  /* Do */
             when TRANSLATE(SUBSTR(action,1,1)) = 'M' then do
                /* Open message */
                rc = RxVIMOpenMessage(Inbox,MsgRefNo.1,'','MsgHandle')
                if (rc > 0) then call vimerr

                /* Mark the message as read */
                rc = RxVIMMarkMessageAsRead(Inbox,MsgRefNo.1)
                if (rc > 0) then call vimerr

                /* Close the message */
                rc = RxVIMCloseMessage(MsgHandle)
                if (rc > 0) then call vimerr
             end  /* Do */
             when TRANSLATE(SUBSTR(action,1,1)) = 'H' then do
                /* Open message */
                rc = RxVIMOpenMessage(Inbox,MsgRefNo.1,'','MsgHandle')
                if (rc > 0) then call vimerr

                /* Get the message header info */
                attrDesc.0 = 2
                attrDesc.1.Selector = 'VIMSEL_FROM_NAME'
                attrDesc.1.Buffer   = 'from'
                attrDesc.2.Selector = 'VIMSEL_PRIORITY'
                attrDesc.2.Buffer   = 'priority'
 
                rc = RxVIMGetMessageHeader(MsgHandle,'attrDesc')
                if (rc > 0) then call vimerr
                Say '--------------------------------------------------------'
                Say '    Message Sent by -' from
                Say '    Message Priority-' priority
                Say '--------------------------------------------------------'
                'pause'
                /* Close the message */
                rc = RxVIMCloseMessage(MsgHandle)
                if (rc > 0) then call vimerr
             end  /* Do */
             when TRANSLATE(SUBSTR(action,1,1)) = 'I' then do
                /* Open message */
                rc = RxVIMOpenMessage(Inbox,MsgRefNo.1,'','MsgHandle')
                if (rc > 0) then call vimerr

                /* Retrieve all of the items for this message */
                ipos      = ''
                icount   = 20
                imore    = ''
                ItemDesc = ''
                ifilter   = 'VIMSEL_NO_FILTER'
                ifdata    = ''

                rc = RxVIMEnumerateMessageItems(MsgHandle,'ipos',1,'icount','ItemDesc',,
                                                ifilter,ifdata,'imore')
                if (rc > 0) then call vimerr

                'cls'
                Say 'RexxVIM - (c) Innovative Business Technologies, Inc'
                Say
                Say ' Message Information with Item Detail'
                Say '--------------------------------------------------------'
                Say '    Message =' MsgRefNo.1
                Say '    Subject =' Subject.1
                Say '    Unread  =' Unread.1
                Say '--------------------------------------------------------'

                loopcnt = 1
                do while (loopcnt <= icount)
                   /* Display each item descriptor entry */
                   Say '    Item Class  -' ItemDesc.loopcnt.CLASS
                   Say '    Item Type   -' ItemDesc.loopcnt.TYPE
                   Say '    Item Name   -' ItemDesc.loopcnt.NAME
                   Say '    Item Size   -' ItemDesc.loopcnt.SIZE
                   Say '    Item Ref No -' ItemDesc.loopcnt.REF
                   Say '--------------------------------------------------------'

                   loopcnt = loopcnt + 1
                end /* do */
                'pause'
                /* Close the message */
                rc = RxVIMCloseMessage(MsgHandle)
                if (rc > 0) then call vimerr
             end  /* Do */
             when TRANSLATE(SUBSTR(action,1,1)) = 'T' then do
                /* Open message */
                rc = RxVIMOpenMessage(Inbox,MsgRefNo.1,'','MsgHandle')
                if (rc > 0) then call vimerr

                /* Retrieve all of the items for this message */
                ipos      = ''
                icount    = 20
                imore     = ''
                ItemDesc  = ''
                ifilter   = 'VIMSEL_CLASS'        /* Filter on item class */
                ifdata    = 'VIMSEL_NOTE_PART'    /* Retrieve only text items */

                rc = RxVIMEnumerateMessageItems(MsgHandle,'ipos',1,'icount','ItemDesc',,
                                                ifilter,ifdata,'imore')
                if (rc > 0) then call vimerr
                /* Retrieve the text for the first message item */
                tconvert          = 'VIM_TEXT'         /* Use text conversion   */
                tflags            = ''                 /* No conversion flags   */
                BufDesc.Buffer    = 'ItemText'         /* Return buffer name    */
                BufDesc.Size      = 256                /* Size of return buffer */
                BufDesc.FileName  = ''

                rc = RxVIMGetMessageItem(MsgHandle,ItemDesc.1.REF,tconvert,tflags,'BufDesc')
                if (rc > 0) then call vimerr

                'cls'
                Say 'RexxVIM - (c) Innovative Business Technologies, Inc'
                Say
                Say ' Message Information with Item Detail'
                Say '--------------------------------------------------------'
                Say '    Message =' MsgRefNo.1
                Say '    Subject =' Subject.1
                Say '    Unread  =' Unread.1
                Say '--------------------------------------------------------'

                /* Display each item descriptor entry */
                Say '    Item Class  -' ItemDesc.1.CLASS
                Say '    Item Type   -' ItemDesc.1.TYPE
                Say '    Item Name   -' ItemDesc.1.NAME
                Say '    Item Size   -' ItemDesc.1.SIZE
                Say '    Item Ref No -' ItemDesc.1.REF
                Say '--------------------------------------------------------'
                Say ' Message Contents for first item (max 60 characters) -'
                Say
                Say SUBSTR(ItemText,1,60)
                Say '--------------------------------------------------------'
                'pause'
                /* Close the message */
                rc = RxVIMCloseMessage(MsgHandle)
                if (rc > 0) then call vimerr
             end  /* Do */
          otherwise
          end  /* select */

          /* End the loop if no more messages to retrieve */
          if more = 'False' then do
             Say 'All messages have been retrieved'
             action = 'X'
          end  /* Do */

     end /* do */


/* Close the message container -- Inbox */
rc = RxVIMCloseMessageContainer(Inbox)
if (rc > 0) then call vimerr


/* Close the session with the postoffice */
rc = RxVIMCloseSession(Session)
if (rc > 0) then call vimerr


/* Terminate the active VIM subsystem connection */
rc = RxVIMTerminate()
if (rc > 0) then call vimerr
signal done


/***** VIMErr *******/

/* If an error occurs, this function will return the text */
/* associated with the error.  Extended text may be       */
/* displayed if it exists for the specified error.        */

VIMERR:

erc = RxVIMStatusText(Session,rc,'Status')
Say
Say '|-Error Information ------------------------------------|'
Say '  Error Text -' status.1
Say
Say '  Ext Status -' status.2
rc = RxVIMTerminate()
signal done


/* The done section will unload the RexxVIM extensions */
/* and exit the program                                */
DONE:
/*** Drop all of the external functions ***/
call RxVIMDropFuncs
Say '|-------------------------------------------------------|'
Say 'Demo Complete.  All functions released'
'pause'
exit
