/* ------------------------------------------------------------------ */
/* File : RESYNCPW                                                    */
/*                                                                    */
/*                  Gnr par RXPP v2.0 le 15/12/98                  */
/*                                                                    */
/* ------------------------------------------------------------------ */

 
/* ===== RXPP ======================================================= */
/* Les lignes suivantes proviennent du fichier source                 */
/* ================================================================== */
 
/*Ŀ
    MODULE:          RESYNCPW.CMD                                        
  Ĵ
   Resynchronize the password of a server machine with the Primary       
   Domain Controller.                                                    
  Ĵ
    External Dependancies :                                              
   PWDEXP.EXE PWDIMP.EXE Export and Import of a user's password (in      
       crypted form)                                                     
  */

Call LS_Init 'RexxUtil,LSRXUT'

/* We have to guess the machine name. It is stored into IBMLAN.INI         */
htaPgorPteN = Reverse(SysSearchPath('Path','Net.exe'))
Parse Var htaPgorPteN . '\' htaPgorPteN
NetProgPath = Reverse(htaPgorPteN)
Parse Var htaPgorPteN . '\' htaPteN
IniFile = Reverse(htaPteN) || '\IBMLAN.INI'
Call SysFileSearch 'ComputerName',IniFile,'Lines.'
If Lines.0 = 0
  Then Do
         Call Display PMsg(4)
         Exit
       End
Do i = 1 to Lines.0
  Parse Value Translate(Lines.i) With . 'COMPUTERNAME' . '=' Test
  If Test \= '' Then ComputerName = Strip(Test)
End                                                               /* End do*/

Call LS_ServerModalInfo ComputerName,'Info.'
Parse Var Info.role SrvRole Junk
PRDCName = Info.Primary

/* Now we have to verify the availability of our utility programs ...      */
NeededProgs = 'PWDEXP.EXE PWDIMP.EXE'
Do While NeededProgs \= ''
  Parse Var NeededProgs P NeededProgs
  If SysSearchPath('Path',P) = ''
    Then Do
           Call Display PMsg(6,P)
           Exit
         End
  Parse Value Reverse(P) With . '\' htaPslooT
  ToolsPath = Reverse(htaPslooT)
End                                                               /* End do*/

"@NET ACCOUNTS /ROLE:STANDALONE 1>Nul 2>Nul"
If Rc = 0
  Then Do
         Call Display PMsg(5,Translate(SrvRole))
       End
  Else Do
         Call Display PMsg(8)
         Call Display PMsg(11)
         Exit
       End

/* We have to ask the user a valid UserID and Passwords for performing a   */
/* local logon                                                             */
Do Forever
  Call LineAsk PMsg(1); Pull LocUser
  Call LineAsk PMsg(2); LocPW = Translate(GetPW())
  "@LOGON" LocUser "/P:" || LocPW "/V:L /R 1>Nul 2>Nul"
  If rc <> 0 Then Call Display PMsg(3,LocUser)
             Else Leave
End                                                               /* End do*/

/* Create a temporary Queue to retrieve the actual local password          */
PW_Queue = RXQueue('CREATE')
Junk     = RXQueue('SET',PW_Queue)
'@PWDEXP' ComputerName '| RXQUEUE' PW_Queue
Pull LocalPW
Call RXQueue 'DELETE',PW_Queue
/* LocalPW contains ServerName:XXXXXXXXXXXXXXXXXXXXXXXXXX */
"@LOGOFF"
Call Display PMsg(16,LocalPW)

/* Now we have to logon onto the domain ...                         */
/* We hope that the given elements are corrects. If not we will ask */
/* for more...                                                      */

"@LOGON" LocUser "/P:" || LocPW "/V:D /R 1>Nul 2>Nul"
If rc <> 0
  Then Do Forever
         Call LineAsk PMsg(7); Pull DomUser
         Call LineAsk PMsg(2); DomPW = Translate(GetPW())
         "@LOGON" DomUser "/P:" || DomPW "/V:D /R 1>Nul 2>Nul"
         If rc <> 0 Then Call Display PMsg(3,DomUser)
                    Else Leave
       End

/* Make Sure that the PWDIMP.EXE file is available on the PR-DC            */
Call SysFileTree '\\' || PRDCName || '\IBMLAN$\NETPROG\PWDIMP.EXE','Test.','FO'
If Test.0 = 0
  Then Do                                          /* Just Copy it in Place*/
          "@COPY" ToolsPath || '\PWDIMP.EXE \\' || PRDCName || '\IBMLAN$\NETPROG 1>Nul 2>Nul'
          /* And in that case copy the companion ... */
          "@COPY" ToolsPath || '\PWDEXP.EXE \\' || PRDCName || '\IBMLAN$\NETPROG 1>Nul 2>Nul'
       End
/* We now use Net Admin to perform exactly the same stuff as before ...    */
PW_Queue = RXQueue('CREATE')
Junk     = RXQueue('SET',PW_Queue)
'@NET ADMIN \\' || PrDCName '/C PWDEXP' ComputerName '| RXQUEUE' PW_Queue
Pull DomainPW
Call RXQueue 'DELETE',PW_Queue
Call Display PMsg(17,DomainPW)

If LocalPW = DomainPW
  Then Do
         Call Display PMsg(18)
         Call Display PMsg(19)
       End
  Else Do
         "@NET ADMIN \\" || PrDCName '/C PWDIMP' LocalPW '1>Nul 2>Nul'
         If Rc = 0
           Then Do
                  Call Display PMsg(9,ComputerName,PRDCName)
                  "@NET ACCOUNTS /ROLE:" || SrvRole '1>Nul 2>Nul'
                  If rc = 0
                    Then Do
                           Call Display PMsg(14,ComputerName,SrvRole)
                           Call Display PMsg(12)
                           "@NET START SERVER"
                         End
                    Else Do
                           Call Display PMsg(15,ComputerName,SrvRole)
                         End
                End
           Else Do
                  Call Display PMsg(10,ComputerName)
                End
       End

/* Then We can use Net Admin to perform the work ... */
/* In Any Case we have to make a Logoff */
"@LOGOFF 1>Nul 2>Nul"
Call Display PMsg(13)
Exit

/* This routines gets the characters entered but displays stars on the screen */
/* Extended keys (Arrows or functions) Tab are ignored. Enter terminates      */
GetPW: procedure
String = ''
Parse Value SysCurPos() With Row0 Col0
Do Forever
  Char = SysGetKey('NoEcho')
  Select
    When Char = d2c(13) Then Leave
    When (Char = d2c(0)) | (Char = d2c(224))
      Then Do                                               /* Extended Key*/
             Junk = SysGetKey('NoEcho')
             Call Charout ,d2c(7)                                   /* Beep*/
           End
    When Char = d2c(8)                                         /* BackSpace*/
      Then If Length(String) > 1
             Then Do
                    String = Left(String,Length(String) - 1)
                    Call SysCurPos Row0,Col0
                    Do i = 1 to Length(String) + 1
                      Call Charout ,' '      /* Wipe out our previous stars*/
                    End                                           /* End do*/
                    Call SysCurPos Row0,Col0
                    Do i = 1 to Length(String)
                      Call Charout ,'*'
                    End                                           /* End do*/
                  End
             Else Call Charout ,d2c(7)
    When Char = d2c(9)                                           /* Tab Key*/
      Then Call Charout , d2c(7)
    Otherwise
      String = String || Char
      Call Charout , '*'
  End                                                             /* Select*/
End                                                               /* End do*/
Say                                             /* Goto Next line on screen*/
Return String
 
/* ===== RXPP ======================================================= */
/* Les lignes suivantes proviennent des directives EXTERN             */
/* ================================================================== */
 
 
/* ----- RXPP ------------------------------------------------------- */
/* Membre : LS_INIT (D:\RXPP\LIBS\lslib.RLB)                          */
/* ------------------------------------------------------------------ */
 
LS_Init: Procedure
Arg ToolsList
ToolsList = Space(Translate(ToolsList,'  ',',;'))
Signal On Syntax Name LoadFailed
Do While ToolsList \= ''
  Parse Var ToolsList ToolsSet ToolsList
  Select
    When ToolsSet = 'REXXUTIL'
      Then Do
             If DLL_Needed('REXXUTIL') = 0
               Then Do
                      Call Display LSMsg(2,'REXXUTIL')
                      Exit
                    End
             Call RxFuncAdd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs'
             Call SysLoadFuncs
           End
    When ToolsSet = 'LSRXUT'
      Then Do
             If DLL_Needed('LSRXUT') = 0
               Then Do
                      Call DIsplay LSMsg(2,'LSRXUT')
                      Exit
                    End
             Call RxFuncAdd 'LoadLSRXUtFuncs','LSRXUT','LoadLSRXUtFuncs'
             Call LoadLSRxUtFuncs
           End
    When ToolsSet = 'RXUTILS'
      Then Do
             If DLL_Needed('RXUTILS') = 0
               Then Do
                      Call Display LSMsg(2,'RXUTILS')
                      Exit
                    End
             Call RxFuncAdd 'RxLoadFuncs','RXUTILS','RxLoadFuncs'
             Call RxLoadFuncs
           End
    Otherwise
      Call Display LSMsg(3,ToolsSet)
      Exit
  End                                                         /* End select*/
End                                                               /* End do*/
Signal OFF Syntax
Return
LoadFailed:
  Call Display LSMsg(1,ToolsSet)
  Exit

 
/* ----- RXPP ------------------------------------------------------- */
/* Membre : LSMSG (D:\RXPP\LIBS\lslib.RLB)                            */
/* ------------------------------------------------------------------ */
 
LSmsg: Procedure Expose __LSMSGS__. __COLORS__. __PROGNAME__
Trace Off
If __LSmsgs__.1 = '__LSMSGS__.1' Then Do          /* not set or not exposed*/
 
/* ----- RXPP ------------------------------------------------------- */
/* Les lignes suivantes ont t gnres par une directive SETSTEM    */
/* impliquant le fichier E:\aurora\newdev\LsLib.eng                   */
/* ------------------------------------------------------------------ */
 
__LSMSGS__.1 = 'E Unable to register the Rexx function of &1'
__LSMSGS__.2 = 'E Needed file &1 not found in LIBPATH'
__LSMSGS__.3 = 'E Unknown ToolsSet &1'
__LSMSGS__.4 = 'E A called function &2 returned RC=&1'
__LSMSGS__.5 = 'E &2 : Invalid command &1'
__LSMSGS__.6 = 'E Code for &1 not yet implemented. Noting Done'
 
/* ----- RXPP ------------------------------------------------------- */
/* Fin des lignes gnres par SETSTEM                                */
/* ------------------------------------------------------------------ */
 
 
/* ----- RXPP ------------------------------------------------------- */
/* La ligne suivante a t gnre par une directive SETVAR           */
/* ------------------------------------------------------------------ */
 
__PROGNAME__ = 'RESYNCPW'
End                                                                /* EndIf*/
Parse Arg Number,Parms
String = __LSMSGS__.Number
Do _i = 1 By 1 Until Pos('&' || _i,String) = 0; End _i
NParms = _i - 1
Do _i = 1 To NParms
  LookFor = '&' || _i
  Parse Var String before (lookfor) after
  String = before || Arg(_i + 1) || after
End _i
Return String
 
/* ----- RXPP ------------------------------------------------------- */
/* Membre : LS_SERVERMODALINFO (D:\RXPP\LIBS\lslib.RLB)               */
/* ------------------------------------------------------------------ */
 
LS_ServerModalInfo:
Arg Server,InfoStem
Server = '\\' || Strip(Server,'L','\')
NetServerModals = 370
If Length(Server)= 2 Then Server = ''
Rc = NetGetInfo(NetServerModals,InfoStem,Server)
Return Rc
 
/* ----- RXPP ------------------------------------------------------- */
/* Membre : COLOR (D:\RXPP\LIBS\OS2.RLB)                              */
/* ------------------------------------------------------------------ */
 
/* Cette procdure permet l'affichage d'un mot en couleur            */
/* Elle retroune la chane passe entoure des caractres spciaux   */
/* qui intercepts par ANSI.SYS assureront le changement de couleur. */
/* On ne sait pas, pour le moment afficher en mode soulign et blink */
Color: Procedure
Parse Arg Color,High,Text

All_Cols = 'DEF BLU RED PIN GRE TUR YEL WHI'
All_High = 'NON BLI REV UND HIG'

Intro    = X2C('1b') || '['
Fin      = Intro || '0m'

Color = Translate(Substr(Strip(Color,'B'),1,3))
Highl = Translate(Substr(Strip(High ,'B'),1,3))
Color = Word('DEF'  All_Cols,1+WordPos(Color,All_Cols))
Highl = Word('NONE' All_High,1+WordPos(Highl,All_High))
Select
   when Color = 'DEF' then code = 0
   When Color = 'BLU' then code = 34
   When Color = 'RED' then code = 31
   When Color = 'PIN' then code = 35
   When Color = 'GRE' then code = 32
   When Color = 'TUR' then code = 36
   When Color = 'YEL' then code = 33
   When Color = 'WHI' then code = 37
otherwise Code = 0
end  /* select */
Select
   when Highl = 'NON' then Code = Code || ';1m'
   when Highl = 'BLI' then Code = Code || ';1m'
   when Highl = 'REV' then Code = Code + 10 || ';1m'
   When Highl = 'UND' then Code = Code || ';1m'
   When Highl = 'HIG' then Code = Code || ';1m'
otherwise Code = Code || ';m'
end  /* select */
Return Intro || Code || Text || Fin
 
/* ----- RXPP ------------------------------------------------------- */
/* Membre : SAY_COLOR (D:\RXPP\LIBS\OS2.RLB)                          */
/* ------------------------------------------------------------------ */
 
/* Cette procdure affiche une ligne dans la couleur spcifie.      */
/* Elle utilise les services de Color et a donc les mmes limitations*/
Say_Color: Procedure
Parse Arg Col,High,Text
Say Color(Col,High,Text)                         
Return
 
/* ----- RXPP ------------------------------------------------------- */
/* Membre : DISPLAY (D:\RXPP\LIBS\OS2.RLB)                            */
/* ------------------------------------------------------------------ */
 
/* This function displays a message in a color representative of     */
/* it's severity. The message is in the form s text where s is the   */
/* severity. The functions PMsg and SMSg are in charge of setting    */
/* the replaceable parameters with the supplied values.              */
/* This ones only detects the severity and call Say_Color accordingly*/
/* The colors are defines in the file STANDARD.COL */
Display: procedure
 
/* ----- RXPP ------------------------------------------------------- */
/* Les lignes suivantes ont t gnres par une directive SETSTEM    */
/* impliquant le fichier D:\RXPP\SYS\STANDARD.COL                     */
/* ------------------------------------------------------------------ */
 
__COLORS__.E = 'Red'
__COLORS__.I = 'Turquoise'
__COLORS__.W = 'White'
__COLORS__.Q = 'Yellow'
__COLORS__.S = 'Red'
__COLORS__.R = 'Yellow'
__COLORS__.T = 'Red'
 
/* ----- RXPP ------------------------------------------------------- */
/* Fin des lignes gnres par SETSTEM                                */
/* ------------------------------------------------------------------ */
 
Parse Arg Sev Text
Sev = Translate(Sev)
Call Say_Color __Colors__.Sev,'NONE',Text
Return
 
/* ----- RXPP ------------------------------------------------------- */
/* Membre : LINEASK (D:\RXPP\LIBS\OS2.RLB)                            */
/* ------------------------------------------------------------------ */
 
LineAsk: Procedure
 
/* ----- RXPP ------------------------------------------------------- */
/* Les lignes suivantes ont t gnres par une directive SETSTEM    */
/* impliquant le fichier D:\RXPP\SYS\STANDARD.COL                     */
/* ------------------------------------------------------------------ */
 
__COLORS__.E = 'Red'
__COLORS__.I = 'Turquoise'
__COLORS__.W = 'White'
__COLORS__.Q = 'Yellow'
__COLORS__.S = 'Red'
__COLORS__.R = 'Yellow'
__COLORS__.T = 'Red'
 
/* ----- RXPP ------------------------------------------------------- */
/* Fin des lignes gnres par SETSTEM                                */
/* ------------------------------------------------------------------ */
 
Parse Arg Sev Text
Sev = Translate(Sev)
Call Charout ,Color(__Colors__.Sev,'NONE',Text || ' ')
Return
 
/* ----- RXPP ------------------------------------------------------- */
/* Membre : DLL_NEEDED (D:\RXPP\LIBS\OS2.RLB)                         */
/* ------------------------------------------------------------------ */
 
DLL_Needed: Procedure Expose  __LibPath__
Arg Dll
Parse Var Dll Dll '.' .            /* get rid of a potential .DLL extension*/
If Symbol('__LibPath__') = 'LIT'
  Then Do
         BootDrive = FileSpec('Drive',Value('ComSpec',,'OS2ENVIRONMENT'))
/* As we are perhaps asked to check for RexxUtil availability, we cannot   */
/* rely on SysFileSearch to get the value assigned to LIBPATH in CONFIG.SYS*/
/* We will do the work by ourselves ...                                    */
         ConfigSys = BootDrive || '\CONFIG.SYS'
         LibPath   = ''
         Do While Lines(ConfigSys) > 0
           Line = Space(Translate(LineIn(ConfigSys)))
           If Abbrev(Line,'LIBPATH')
             Then Do
                    Parse Var Line . '=' LibPath
                    Leave
                  End
         End                                                      /* End do*/
         Call Stream ConfigSys,'COMMAND','CLOSE'        /* Close Config.Sys*/
         If LibPath = '' Then Return 0                  /* Just in case ...*/
         __LibPath__ = LibPath             /* Store it for future reference*/
       End
  Else LibPath = __LibPath__

/* Now just scan the path to find out if the DLL will be available ...     */
Ok = 0
Do Until (LibPath = '') | Ok
  Parse Var LibPath Test ';' LibPath
  Test = Strip(Space(Test),'T','\') || '\' || Dll || '.DLL'
  Ok =  Stream(Test,'COMMAND','QUERY EXISTS') \= ''
End                                                               /* End do*/
/* We come here either via the leave implied by our test and then ok = 1   */
/* or because the contents of LibPath has been exhausted and then ok = 0   */
Return Ok
 
/* ----- RXPP ------------------------------------------------------- */
/* Membre : PMSG (D:\RXPP\LIBS\STANDARD.RLB)                          */
/* ------------------------------------------------------------------ */
 
/* ------------------------------------------------------------------ */
/* NAME       : Pmsg                                                  */
/* TYPE       : Function                                              */
/* PARAMETERS : Message number, parameters                            */
/* INPUT      : Message_number identifies the program messages        */
/*              a variable number of parameters is allowed. These     */
/*              parameters will be used to replace the &n markers     */
/* OUTPUT     : The updated message is returned                       */
/* FUNCTION   : Allows the dynamic contruction of messages            */
/* EXAMPLE    : String = Pmsg(1,name)                                 */
/* NOTES      : Code very similar to SMsg                             */
/*              Building is dynamic with %%LANG%% variable            */
/*              XMSG is required                                      */
/* ------------------------------------------------------------------ */
Pmsg: Procedure Expose __PMSGS__. __COLORS__. __PROGNAME__
Trace Off
If __Pmsgs__.1 = '__PMSGS__.1' Then Do  /* not set or not exposed     */
 
/* ----- RXPP ------------------------------------------------------- */
/* Les lignes suivantes ont t gnres par une directive SETSTEM    */
/* impliquant le fichier E:\aurora\newdev\ResyncPW.eng                */
/* ------------------------------------------------------------------ */
 
__PMSGS__.1 = 'Q Enter a LOCAL administrator UserID .................'
__PMSGS__.2 = 'Q Enter the corresponding password ...................'
__PMSGS__.3 = 'E Local logon as &1 failed.'
__PMSGS__.4 = 'E Unable to get the name of this server'
__PMSGS__.5 = 'I Role changed from &1 to STANDALONE'
__PMSGS__.6 = 'E Needed file &1 is not in your PATH.'
__PMSGS__.7 = 'Q Enter a DOMAIN administrator UserID ................'
__PMSGS__.8 = 'E Role cannot be changed to STANDALONE'
__PMSGS__.9 = 'I Password for &1 has been updated on &2'
__PMSGS__.10 = 'I Error occured when trying to update the password of &1'
__PMSGS__.11 = 'W Have you issued a NET STOP SERVER?'
__PMSGS__.12 = 'I NET START SERVER command issued'
__PMSGS__.13 = 'I LOGOFF has been issued'
__PMSGS__.14 = 'I Role of &1 successfuly changed to &2'
__PMSGS__.15 = 'E Role of &1 was not updated to &2'
__PMSGS__.16 = 'W Local Password ........ : &1'
__PMSGS__.17 = 'W Domain Password ....... : &1'
__PMSGS__.18 = 'E Passwords seem to be synchronized. Problem must be further analyzed'
__PMSGS__.19 = 'W The role of this machine has been left as STANDALONE'
 
/* ----- RXPP ------------------------------------------------------- */
/* Fin des lignes gnres par SETSTEM                                */
/* ------------------------------------------------------------------ */
 
 
/* ----- RXPP ------------------------------------------------------- */
/* La ligne suivante a t gnre par une directive SETVAR           */
/* ------------------------------------------------------------------ */
 
__PROGNAME__ = 'RESYNCPW'
End  /* EndIf */
Parse Arg Number,Parms
String = __PMSGS__.Number
Do _i = 1 By 1 Until Pos('&' || _i,String) = 0; End _i
NParms = _i - 1
Do _i = 1 To NParms
  LookFor = '&' || _i
  Parse Var String before (lookfor) after
  String = before || Arg(_i + 1) || after
End _i
Return String
