/* renqwk.cmd -- renames .QWK files based on the date that they were DL'd,
along with a user-determined BBS prefix

Steve Allen
Altech Computer Services
121 Herta St.
Easley, SC 29640

Nov 93
*/

say ""
say "RENQWK v1.0 1993"
say "Altech Computer Services" 'fe'x "Steve Allen"
say ""

call RxFuncAdd SysLoadFuncs,RexxUtil,SysLoadFuncs
call SysLoadFuncs

main: 
    NbrRenamed = 0
    call GetConfig
    Filespec = QwkDir"\*.*"
    call SysFileTree Filespec, FileList,'F'
    do i=1 to FileList.0
        parse var FileList.i Date Time Size Attr FullFileName
        if ValidExt(FullFileName) then
            call RenameFile FullFileName Date
        else
            iterate
    end
    say ""
    say NbrRenamed "QWK packets renamed."
exit


ValidExt: procedure
arg FullFileName
    RetVal = 0
    parse var FullFileName . "." Ext
    FileName = NameWOPath(FullFileName)

    /* if this QWK packet has already been renamed, we don't rename it again */
    if substr(Ext,1,2) = "QW" &,
        (datatype(substr(FileName,1,2),"M") &, 
         datatype(substr(FileName,3,6),"W")) then
            nop
    else
        if substr(Ext,1,2) = "QW" | (datatype(substr(Ext,1,1),"W"),
            & length(Ext) = 1) then
                RetVal = 1
return RetVal


RenameFile: procedure expose Extension. NbrRenamed
arg FullFileName Date
    Date = right(Date,8)
    Date = translate(Date,"0"," ")
    parse var Date MM "/" DD "/" YY
    FileName = NameWOPath(FullFilename)
    DateName = FilePrefix(FileName) || YY || MM || DD || ".QWK"
    PathName = PathPart(FullFileName)
    NewFile = CreateNewName(DateName, PathName)
    say "Renaming" FullFileName "to" NewFile"..."
    "@REN" FullFileName NewFile "> NUL"
    NbrRenamed = NbrRenamed + 1
return 


CreateNewName: procedure
arg DateName, PathName
    WholeName = PathName || DateName
    CheckExists = stream(WholeName, 'c', 'query exists')
    if CheckExists <> "" then 
        do i = 1 to 9
            DateName = substr(DateName,1,11) || i
            WholeName = PathName || DateName
            CheckExists = stream(WholeName, 'c', 'query exists')
            if CheckExists = "" then leave
        end
return DateName


NameWOPath: procedure
arg FullFilename
    StartPos = lastpos("\", FullFileName) + 1
    OrigFilename = substr(FullFileName, StartPos)
return OrigFilename


PathPart: procedure
arg FullFilename
    EndPos = lastpos("\", FullFileName) 
    PathName = substr(FullFileName, 1, EndPos)
return PathName


GetConfig: procedure expose Extension. QwkDir
    Share = "OS2ENVIRONMENT"
    CmdDir = value('CmdDir',,Share)
    if CmdDir = "" then
        Ifile = "RENQWK.CFG"
    else
        Ifile = CmdDir"\RENQWK.CFG"

    Iline = linein(Ifile)
    QwkDir = strip(Iline)

    i = 0
    do while lines(Ifile) > 0
        Iline = linein(Ifile)
        if Iline <> "" then
            do
                parse var Iline BBS "=" BBSprefix .
                i = i + 1
                Extension.i.1 = strip(BBS)
                Extension.i.2 = strip(BBSprefix)
            end
    end
    Extension.0 = i
return


FilePrefix: procedure expose Extension.
arg BBSName
    parse var BBSName BaseName "."
    do i = 1 to Extension.0
        if BaseName = extension.i.1 then leave
    end

    if i > Extension.0 then
        Prefix = "UN"
    else
        Prefix = Extension.i.2
return Prefix


/* end of RENQWK.CMD */
