/* support functions which set rexx variables
 * copyright 1997, Patrick McPhee distributed under the terms of version 2
 * of the GNU Library General Public License
 */
#include <time.h>
#include <malloc.h>

/* use the interface header, rexxsaa.h, instead of the internal header,
 * rexx.h */
#define INCL_RXSHV
#define INCL_RXFUNC
#include "rexxsaa.h"
#include "rxproto.h"

/* it's preferable to set these things in one big blow, but sometimes
 * you have to do it one-off. */
void set_rc(const char * const value, const int len)
{
    SHVBLOCK avar;
    
    avar.shvnext = NULL;
    avar.shvname.strptr = "RC";
    avar.shvname.strlength = 2;
    avar.shvvalue.strptr = value;
    avar.shvvalue.strlength = len;
    avar.shvcode = RXSHV_SET;
    RexxVariablePool(&avar);
}


void rc_one()
{
    set_rc("1", 1);
}

void rc_zero()
{
    set_rc("0", 1);
}

void setavar(PRXSTRING varname, const char * const value)
{
    SHVBLOCK avar;
    
    avar.shvnext = NULL;
    avar.shvname.strptr = varname->strptr;
    avar.shvname.strlength = varname->strlength;
    avar.shvvalue.strptr = value;
    avar.shvvalue.strlength = strlen(value);
    avar.shvcode = RXSHV_SET;
    RexxVariablePool(&avar);
}

/* given an array of strings and the name of a stem variable, set the stem
 * variable to match the strings */
void setastem(PRXSTRING varname, int arraylen, const char * const * const values)
{
    SHVBLOCK *astem = NULL,
	    stem0[2];
    register int i;
    int namelen = varname->strlength + arraylen/10 + 2;
    char * namebuf = malloc(namelen * (arraylen+1)),
	 * origname, valbuf[10], *nameptr;
    
    if (arraylen) {
	astem = malloc(arraylen*sizeof(*astem));
	memset(astem, 0, arraylen * sizeof(*astem));
    }

    memset(stem0, 0, sizeof(stem0));

    rxstrdup(origname, *varname);
    strupr(origname);
    nameptr = namebuf;

    /* drop the stem */
    stem0[0].shvnext = stem0+1;
    stem0[0].shvname = *varname;
    stem0[0].shvcode = RXSHV_DROPV;

    /* set up the .0 member */
    stem0[1].shvnext = astem;
    stem0[1].shvname.strptr = nameptr;
    stem0[1].shvname.strlength = sprintf(nameptr, "%s%d", origname, 0);
    stem0[1].shvvalue.strptr = valbuf;
    stem0[1].shvvalue.strlength = sprintf(valbuf, "%d", arraylen);
    stem0[0].shvcode = RXSHV_SET;

    nameptr += namelen;

    for (i = 0; i < arraylen; i++) {
	astem[i].shvnext = astem+i+1;
	astem[i].shvname.strptr = nameptr;
	astem[i].shvname.strlength = sprintf(nameptr, "%s%d", origname, i+1);
	astem[i].shvvalue.strptr = values[i];

	astem[i].shvvalue.strlength = strlen(values[i]);
	astem[i].shvcode = RXSHV_SET;
	nameptr += namelen;
    }

    if (i)
	astem[i-1].shvnext = NULL;

    RexxVariablePool(stem0);
    free(namebuf);
    if (astem)
	free(astem);
}
