/* make Regina the default processor for .rex files
 * $Header: G:/ptjm/rexx/w32funcs/RCS/regregina.rex 1.2 1998/02/17 00:20:04 pmcphee Exp $
 */

call rxfuncadd 'w32loadfuncs', 'w32util', 'w32loadfuncs'
call w32loadfuncs

 /* here's where regina is installed */
 regexe='d:\ptjm\bin\regina.exe'

 /* here's the extension I want */
 regext = '.rex'

 /* open up the classes root key, and see if there's already a .rex
    there */
 crkey = w32RegOpenKey("CLASSES_ROOT", regext)

 if crkey \= 0 then do
   call w32RegCloseKey(crkey)
   call charout , regext 'is already defined as an extension. Overwrite it? '
   pull yesno
   if left(yesno,1) \= 'Y' then exit 1
   end

  /* now create the necessary sub-keys. I'll ignore rc until we set the value */
  crkey = w32RegCreateKey("CLASSES_ROOT", regext)

  if crkey = 0 then do
    say 'failed to create HKEY_CLASSES_ROOT/'regext
    exit 2
    end
  crskey = w32RegCreateKey(crkey, "Shell")
  crsokey = w32RegCreateKey(crskey, "Open")
  crsockey = w32RegCreateKey(crsokey, "Command")
  if w32RegSetValue(crsockey, '', "REG_SZ", regexe '%1 %*') then do
    say 'failed to set up the registry key'
    exit 3
    end

  call w32RegCloseKey crkey
  call w32RegCloseKey crskey
  call w32RegCloseKey crsokey
  call w32RegCloseKey crsockey
  
  /* deal with the PATHEXT environment variable */
  defpathext='.com;.exe;.bat;.cmd'
  
  senvkey = w32RegOpenKey("LOCAL_MACHINE", "System\CurrentControlSet\Control\Session Manager\Environment")
  if senvkey = 0 then do
    say 'There is no environment. This unit must die.'
    exit 4
    end

  syspathext = w32RegQueryValue(senvkey, "PATHEXT")
  if syspathext = '' then
    syspathext = defpathext

  uenvkey = w32RegOpenKey("CURRENT_USER", "Environment")
  if uenvkey = 0 then do
    say 'There is no environment defined for the current user.'
    call charout , 'Would you like to create one?'
    pull yesno
    if left(yessno,1) = 'Y' then
      uenvkey = w32RegCreateKey("CURRENT_USER", "Environment")
    else
      exit 5
    end

  userpathext = w32RegQueryValue(uenvkey, "PATHEXT")

  say 'Would you like to have' regext 'files work for the current user only (U)'
  call charout , 'or for all users of this machine (A)? '
  pull whatyouwant
  if left(whatyouwant,1) = 'U' then do
    if userpathext = '' then userpathext = syspathext
    rcc = w32RegSetValue(uenvkey, "PATHEXT", "REG_SZ", userpathext';'regext)
    if rcc then say 'ack, I failed!'
    end

  else do
    if userpathext \= '' then do
      rcc = w32RegSetValue(uenvkey, "PATHEXT", "REG_SZ", userpathext';'regext)
      if rcc then say 'ack, I failed!'
      end

    rcc = w32RegSetValue(senvkey, "PATHEXT", "REG_SZ", syspathext';'regext)
    if rcc then say 'ack, I failed!'

    end

  call w32regclosekey uenvkey
  call w32regclosekey senvkey


  exit 0
