/**********************************************************/
/*                                                        */
/* Program name:  Symon.cmd                               */
/* Title:  E-Mail Enabling Rexx                           */
/* OS/2 Developer Magazine, Rexx Report                   */
/* Author:  Mark Ramsey                                   */
/* Phone:   (614) 791-9055 Ext 11                         */
/* Fax:     (614) 791-9055                                */
/*                                                        */
/* Description:  This app monitors the available disk     */
/*               space on the system.  If the avaiable    */
/*               reach 5% or less, a warning message is   */
/*               sent to the specified e-mail id.         */
/*                                                        */
/* Program Requirements:  Must have a VIM e-mail system   */
/*               and associated dlls, RexxVIM, and the    */
/*               OS/2 Rexx sub-system                     */
/*                                                        */
/* Date:  March 23, 1995                                  */
/**********************************************************/

/* Variables */
user_name   = 'Joe User'       /* this must be a valid e-mail id for signon */
user_pw     = 'snoopy'         /* this must be the valid passord            */
db_path     = 'm:\ccdata'      /* this is the location of the mail files    */
admin_name  = 'System_Monitor' /* this is where to send the warning message */
sleep_time  = 3600             /* how long to wait between checks           */
low_percent = 5                /* percentage to cause warning message       */
temp_file   = 'DIRLIST.TXT'    /* file name to store directory listing      */

'@echo off'
'@cls'
Say 
Say 
Say 'System Monitor, Version 1.00  (03/23/95)'
Say

/* Load the RexxVIM extensions to Rexx */
rc = RxFuncAdd('RxVIMLoadFuncs', 'REXXVIM', 'RxVIMLoadFuncs')
if rc <> 0 then do
   Say
   Say '  RexxVIM failed to load, return code' rc
   Say
   signal done
end  /* Do */
call RxVIMLoadFuncs
Say '  RexxVIM functions are now loaded'

/* Load the RexxUtil extensions to Rexx */
rc = RxFuncAdd('SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs')
if rc <> 0 then do
   Say
   Say '  RexxUtil failed to load, return code' rc
   Say
   signal done
end  /* Do */
call SysLoadFuncs
Say '  RexxUtil functions are now loaded'

Say
Say '  Monitoring system........ '

do forever

   parse value SysDriveInfo('C:') with drive free total label

   free_percent = FORMAT(free/total * 100,2,0)

   if  free_percent <= low_percent then do
 
      /* Text to send with message */
      TextMsg = "Drive Size:" total " Free:" free " Label:" label

      /* Create file listing for root directory */
      'dir c:\ >' temp_file

      /* Call the procedure to send message to administrator */
      call SEND_MESSAGE

      /* Remove the temp directory file */
      'erase' temp_file


   end  /* Do */
   SysSleep(sleep_time)       /* Wait for specified time */

end /* do */
return
/* end of main program */


/***** SEND_MESSAGE *******/

/* This procedure performs the VIM functions to send a message */
/* to the admin id.  Each time a message is sent, the program  */
/* establishes a new connection to the VIM subsystem           */

SEND_MESSAGE:

/* Initialize the VIM subsystem */
Session = ''
rc = RxVIMInitialize()
if (rc > 0) then signal VIMError


/* Open a session with the postoffice using the parameters */
/* specified.                                              */
/*                                                         */
/*  db_path   - path to the message container database     */
/*  user_name - name of the e-mail id to open session      */
/*  user_pw   - password for the user_name account         */
/*  Session   - will contain the session pointer after the */
/*              completion of the function call            */

rc = RxVIMOpenSession(db_path,user_name,user_pw,'Session')
if (rc > 0) then signal VIMError


/* Create a new message of type VIM_MAIL                   */
/*                                                         */
/*  Session - session pointer from the open function call  */
/*  msg type- VIM_MAIL only supported type                 */
/*  Message - will contain the message pointer after the   */
/*            completion of the function call              */

rc = RxVIMCreateMessage(Session,'VIM_MAIL','Message')
if (rc > 0) then signal VIMError


/* Set the subject of the message                          */
/*                                                         */
/*  Message -   msg pointer from the create function call  */
/*  Attribute - Keyword for attribute to set               */
/*  Value     - Value to use                               */

hdrtext = "Disk Space at" free_percent "percent"
rc = RxVIMSetMessageHeader(Message,'VIMSEL_SUBJECT', hdrtext)
if (rc > 0) then signal VIMError


/* Set the priority to high                                */
/*                                                         */
/*  Message -   msg pointer from the create function call  */
/*  Attribute - Keyword for attribute to set               */
/*  Value     - Value to use                               */

rc = RxVIMSetMessageHeader(Message,'VIMSEL_PRIORITY', 'VIM_HIGH_PRIORITY')
if (rc > 0) then signal VIMError


/* Set the recipient to the administrative user            */
/*                                                         */
/*  Message - msg pointer from the create function call    */
/*  class   - keyword for class of recipient (TO,CC,BCC)   */
/*  type    - type of recipient (One or group name         */
/*  entity  - name type                                    */
/*  adrbook - addressbook for name                         */
/*  name    - userid to send (in local addressbook)        */
/*  adrtype - type of addressbook entry (one or group)     */
/*  adrname - full address entry (Fred Smith at ABC_PO)    */

rc = RxVIMSetMessageRecipient(Message,'VIMSEL_TO','VIMSEL_ENTITY','','',,
                admin_name,'','')
if (rc > 0) then signal VIMError


/* Add the text to the message                             */
/*                                                         */
/*  Message - msg pointer from the create message function */
/*  Class   - class of the item (here it is part of note)  */
/*  Type    - item type (here we are adding text)          */
/*  Flags   - this is native text                          */
/*  Name    - name or title of item                        */
/*  Item    - text of the item                             */
/*  Filename- not used for this call                       */

rc = RxVIMSetMessageItem(Message,'VIMSEL_NOTE_PART','VIM_TEXT','VIMSEL_NATIVE',,
         'Text',TextMsg,'')
if (rc > 0) then signal VIMError


/* Add the file attachment to the message                  */
/*                                                         */
/*  Message - msg pointer from the create message function */
/*  Class   - class of the item (here it is a file attach) */
/*  Type    - item type (here we are adding text)          */
/*  Flags   - this is native text                          */
/*  Name    - name or title of item                        */
/*  Item    - not used for this call                       */
/*  Filename- filename to use for the attachment           */

rc = RxVIMSetMessageItem(Message,'VIMSEL_ATTACH','VIM_TEXT','VIMSEL_NATIVE',,
         'Directory','',temp_file)
if (rc > 0) then signal VIMError


/* Send the message                                        */
/*                                                         */
/*  Message - msg pointer from the create message call     */

rc = RxVIMSendMessage(Message)
Say '  Warning message sent'
if (rc > 0) then signal VIMError


/* Close the session with the postoffice                   */
/*                                                         */
/*  Session - session pointer from the open session call   */

rc = RxVIMCloseSession(Session)
if (rc > 0) then signal VIMError


/* Terminate the active VIM subsystem connection           */

rc = RxVIMTerminate()
if (rc > 0) then signal VIMError

return


/***** VIMError *******/

/* If an error occurs, this function will return the text */
/* associated with the error.  Extended text may be       */
/* displayed if it exists for the specified error.        */

VIMError:

/* Obtain the status text on the non-zero return code      */
/*                                                         */
/*  Session - session pointer from the open session call   */
/*  rc      - return code to obtain extended information   */
/*  Status  - stem variable to return text                 */

rc = RxVIMStatusText(Session,rc,'Status')
Say
Say '|-Error Information -----------------|'

if Status.1 = 'STATUS.1' then
  Say 'Cannot obtain error status information'
else do
  Say '  Error Text -' Status.1
  Say
  Say '  Ext Status -' Status.2
end

/* Terminate the VIM Connection */
rc = RxVIMTerminate()
signal done


/* The done section will unload the RexxVIM extensions */
/* and RexxUtil extenstions                            */
DONE:
/*** Drop all of the RexxVIM external functions ***/
call RxVIMDropFuncs
Say '  All RexxVIM functions released'
call SysDropFuncs
Say '  All RexxUtil functions released'
exit
