/*PYRxUtil demo*/
/*  ᮢ .
   Kill 'em all ... */
/*trace i*/
SLICE = 32 ; SCAN_DT = 1000
P_I_SIZE = 40

P_I_FG = 'a'x ; P_I_SEL = '3f'x
ACT_BG = '50'x ; IDLE_BG = '10'x
PATH_ATTR = '7'x ; HEAD_ATTR = '72'x
SUM_ATTR = '80'x ; KEY_ATTR = '71'x
REG_U_BG = '40'x ; REG_S_BG = '60'x
IDL_U_BG = '50'x ; IDL_S_BG = '10'x
CPU_B_BG = '40'x ; CPU_I_BG = '60'x ;

LEFT_HEAD = ' PID  PPID  Type   Time used     Peak'
EXE_HEAD = 'Exe Name' ; WIN_HEAD = 'Window title' 
THR_HEAD = ' TID Slot Priort State  SleepID   Peak'
CPU_HEAD = '  N   Busy    Intr    Idle    Freq'
PATH = 0 ; TITLE = 1 ; THREAD = 3 ; CPU = 4
rt_view = PATH
INFO.0 = "info_tx = '<P>path <W>title <T>threads <C>CPU  ('||'18'x||' '||'19'x||' <PgUp><PgDn><Home><End><Del>)+<Ctrl>'"
INFO.1 = "info_tx = '  Kill process (ID='s_pid') Y/N ?'"
INFO.2 = "info_tx = '  Kill -9 process (ID='s_pid') Y/N ?'"
INFO.3 = "info_tx = '  <0>reboot  <1>standby  <2>suspend  <3>power_off'"
F_coeff = 1000

signal on HALT name do_exit
call RxFuncAdd 'PYRxInit', 'PYRxUtil', 'PYRxInit'
call PYRxInit
my_pid = PYRxGo("p","Kill 'em all... (c)PYzone 2001") ; s_pid = my_pid
parse value PYRxShow(0,0,0) with . . ymx xmx .
call PYRxShow ,,ymx*xmx,' ','7'x
INF_LINES = ymx - 3
call PYRxShow ,,0,left(left(LEFT_HEAD,P_I_SIZE)||EXE_HEAD,xmx),HEAD_ATTR
sys_time = 0 ; s_off = 1 ; draw_time = 0 ; q_kill = 0

do forever
  timer = info_tx
  interpret INFO.q_kill
  if info_tx \= timer then
    call PYRxShow ymx-1,0,0,left(info_tx,xmx),KEY_ATTR
  timer = PYRxGo('i','.............?')
  s_thn = 0
  if timer - sys_time >= SCAN_DT - draw_time then
    do
      drop pl. pid. ppid.    
      sys_time = timer 
      wait = SCAN_DT
      call PYRxGo 'P','*','*','pl'
      do i=1 to pl.0  
        parse var pl.i pid.i ppid.i . . p_thn .
        s_thn = s_thn + p_thn
        if pid.i = s_pid then
          s_idx = i
       end
      sum_txt = '  Summary: 'pl.0' processes with 's_thn' threads .  '
      call PYRxShow ymx-2,0,0,sum_txt,SUM_ATTR
      if rt_view = PATH then
        do
          attr = SUM_ATTR
          if sys_time > 4208567295 then
            attr = bitor(SUM_ATTR,'4'x)
          if sys_time > 4291367295 then
            attr = bitor(SUM_ATTR,'c'x)
          call PYRxShow ymx-2,length(sum_txt),0,left('System timer:',
                             ||t_conv(sys_time),xmx-length(sum_txt)),attr
         end
      if rt_view = TITLE then
        call PYRxShow ymx-2,length(sum_txt),0,left('System time: '||date()||'  'time(),,
                               xmx-length(sum_txt)),SUM_ATTR
      call get_cpu
      if rt_view = CPU then
        call show_cpu_info
     end
  do while s_idx > pl.0
    s_idx = pl.0 ; s_pid = pid.s_idx ; s_off = 0
   end
  y_prc = 1
  do i=1 to pl.0 + INF_LINES while y_prc <= INF_LINES
    mask = ' '||ppid.i||' '
    parse var chain chain (mask) +1 alive .
    if alive = '' then chain = ''
    chain = ' 'chain' 'alive' 'pid.i' '
    if i < s_idx - s_off then
      iterate
    if i <= pl.0 then
      call show_p_info
     else
      call PYRxShow y_prc,0,P_I_SIZE+(xmx-P_I_SIZE)*(rt_view\=THREAD),' ','7'x
    y_prc = y_prc + 1
   end
  if rt_view = THREAD then
    do
      y_thr = 1 ; chain = '' ; drop tl.    
      call PYRxGo 'P',,s_pid,'tl'
      do while s_pid \= t_pid
        call drop_slots
        t_pid = s_pid ; t_mem = 0
       end
      call PYRxShow ymx-2,length(sum_txt),0,left('Process 't_pid' have ',
                             tl.0' thread(s) .',xmx-length(sum_txt)),SUM_ATTR
      do i=1 to tl.0 + INF_LINES
        if i <= tl.0 then
          call show_t_info
         else
          if y_thr <= INF_LINES then
            do
              call PYRxShow y_thr,P_I_SIZE,(xmx-P_I_SIZE),' ','7'x
              y_thr = y_thr + 1
             end
       end
     end
  
  call drop_slots
  draw_time = PYRxGo('i','.............?') - timer
  wait = wait - draw_time
  if wait <= draw_time then
    iterate
  parse value PYRxKey(wait) with char scan state
  parse upper value x2c(char) with char
  select
    when scan = '00' & char = '0'x then
      if q_kill \= 0 then
        do
          attr = bitor(KEY_ATTR,d2c(7*((timer%1000)//2)))
          call PYRxShow ymx-1,2,length(info_tx),,attr
         end
    when scan='01' then	/*Esc*/
      exit
    when q_kill \= 0 then
      do
        if q_kill = 3 then
          do
            if pos(char,'0123') \= 0 then
              call PYRxGo 'p','-',char
           end
         else
          if char = 'y' | char = 'Y' then
            if q_kill = 1 then
              call PYRxGo 'p','-',s_pid
             else
              call PYRxGo 'P','-',s_pid
        q_kill = 0
       end
    when scan='0F' then	/*Tab*/
      call PYRxGo 't','.'
    when scan='1C' then	/*Enter*/
      call PYRxGo 'p','!',s_pid
    when scan = 48 then	/*Up*/
      if s_idx > 1 then
        do
	  s_idx = s_idx-1
	  s_off = s_off - (s_off > 0)
	 end
    when scan = 50 then	/*Down*/
      if s_idx < pl.0 then
        do
          s_idx = s_idx+1
	  s_off = s_off + (s_off < INF_LINES-1)
	 end
    when scan = 49 then	/*PgUp*/
      do
        s_idx = s_idx - INF_LINES
        if s_idx < 1 then s_idx = 1
        if s_idx - s_off < 1 then s_off = s_idx - 1
       end
    when scan = 51 then	/*PgDn*/
      do
        s_idx = s_idx + INF_LINES - 1
        do while s_idx > pl.0
          s_idx = pl.0
          s_off = (INF_LINES-1)*(pl.0 > INF_LINES)
         end
        if s_idx - s_off < 1 then s_off = 0
       end
    when scan = 47 then /* Home */
      do
        s_idx = s_idx - s_off
        s_off = 0
       end
    when scan = '4F' then /*End*/
      do  
        s_idx = s_idx + INF_LINES - s_off - 1
        if s_idx > pl.0 then s_idx = pl.0
        s_off = INF_LINES - 1
        if s_off > pl.0 then s_off = pl.0 - 1
       end
    when scan = 53 then	/* Del */
      if s_pid \= my_pid then
        q_kill = 1 + 2*(s_pid <= 3)
    when scan = 93 then	/* Ctrl-Del */
      if s_pid \= my_pid then
        q_kill = 2 + (s_pid <= 3)
    when char = 'T' then /* Threads view */
      do
        rt_view = THREAD ; drop t_pid ; t_idx = 1
        call PYRxShow 0,P_I_SIZE,0,left(THR_HEAD,xmx-P_I_SIZE),HEAD_ATTR
       end
    when char = 'C' then /* CPU view */
      do
        rt_view = CPU ; t_idx = 1
        call PYRxShow 0,P_I_SIZE,0,left(CPU_HEAD,xmx-P_I_SIZE),HEAD_ATTR
       end
    when char = 'P' then /* Exe Path names */
      do
        rt_view = PATH
        call PYRxShow 0,P_I_SIZE,0,left(EXE_HEAD,xmx-P_I_SIZE),HEAD_ATTR
       end
    when char = 'W' then /* Task titles */
      do
        rt_view = TITLE
        call PYRxShow 0,P_I_SIZE,0,left(WIN_HEAD,xmx-P_I_SIZE),HEAD_ATTR
       end
    when rt_view \= THREAD & rt_view \= CPU then
      nop
    when scan = '8D' then /*Ctrl-Up*/
      if t_idx > 1 then
        t_idx = t_idx-1
    when scan = 91 then	/*Ctrl-Down*/
      if t_idx <= tl.0 - INF_LINES then
        t_idx = t_idx+1
    when scan = 84 then /*Ctrl-PgUp*/
      do
        t_idx = t_idx - INF_LINES
        if t_idx < 1 then
          t_idx = 1
       end
    when scan = 76 then /*Ctrl-PgDn*/
      if t_idx <= tl.0 - INF_LINES then
        t_idx = t_idx + INF_LINES
    when scan = 77 then /* Ctrl-Home */
      t_idx = 1
    when scan = 75 then /*Ctrl-End*/
      if tl.0 > INF_LINES then
        t_idx = tl.0 - INF_LINES + 1
    otherwise
      nop
   end /*select*/
  s_pid = pid.s_idx
 end
do_exit:
  exit

/**/

show_p_info:
  parse var pl.i . . p_typ p_ses p_thn p_st p_time ,
                  '"'p_pth'" "'p_ttl '2201'x dt_sys dt_usr dt_idle p_dt
  p_time = t_conv(p_time*SLICE)
  peak = ((SLICE*(dt_sys+dt_usr))/p_dt)*100
  if peak >= 100.0 then
    peak = ' --.-- '
   else
    peak = format(peak,3,2)||'%' ; d_sign = '  '
  if s_idx = i then 
    if (y_prc = 1 & s_idx > 1) | s_idx = pl.0 then 
      d_sign = '1818'x
     else
      if (s_off = INF_LINES-1 & s_idx < pl.0) | s_idx = 1 then d_sign = '1919'x
  view_str = right(pid.i,5)||right(ppid.i,6)||right(p_typ,4)||p_time||peak||d_sign
  act  = format(((dt_sys+dt_usr-dt_idle)*P_I_SIZE*SLICE)/p_dt,,0)
  idle = format((dt_idle*P_I_SIZE*SLICE)/p_dt,,0)
  attr = P_I_FG ; if i = s_idx then attr = P_I_SEL
  lt_attr = ACT_BG ; dk_attr = IDLE_BG
  y_view = y_prc ; x_view = 0 ; sz_view = P_I_SIZE
  call right_view
  select
    when rt_view = PATH then
      do
        ch_x = 2*(words(chain)-1) ; v_text = strip(right(p_pth,xmx-ch_x-P_I_SIZE-2))
        if v_text \= p_pth then v_text = '..'v_text
        v_text = left(left("",ch_x)||v_text,xmx-P_I_SIZE)
        call PYRxShow ,P_I_SIZE,0,v_text,PATH_ATTR
       end
    when rt_view = TITLE then
      do
        v_text = left(p_ttl,xmx - P_I_SIZE - 2)
        if length(p_ttl) > xmx - P_I_SIZE - 2 then v_text = v_text'..'
        call PYRxShow ,P_I_SIZE,0,left(v_text,xmx - P_I_SIZE),PATH_ATTR
       end
    otherwise
      nop
   end
  return
  
t_conv: procedure
  parse arg tim
  rsec = tim%1000 ; rmsec = right(tim//1000,3,'0')
  rmin = rsec % 60 ;  rsec = right(rsec//60,2,'0')
  rhour = rmin % 60 ; rmin = right(rmin//60,2,'0')
  rday = right(rhour%24,3) ; rhour = right(rhour//24,2,'0')
  return rday':'rhour':'rmin':'rsec'.'rmsec
  
drop_slots:
  do while t_slots \= ''
    parse var t_slots slot t_slots
    drop ut.slot st.slot
   end
  t_slots = chain
  return
  
show_t_info:
  parse var tl.i . tid slot sleep prio state t_st t_ut t_tim
  mask = ' 'slot' ' ;  chain = ' 'chain||mask
  parse var t_slots t_slots (mask) +1 alive mask ; t_slots = t_slots||mask
  if alive \= '' then
    do
      dt_sys =  t_st - st.slot ; dt_usr = t_ut - ut.slot
     end
   else
    do
      dt_sys =  t_st ; dt_usr = t_ut
     end
  st.slot = t_st ; ut.slot = t_ut
  if tid = 1 then
    t_dt = t_tim - t_mem 
  t_mem = t_tim ;
  if i < t_idx | y_thr > INF_LINES then 
    return
  peak = ((SLICE*(dt_sys+dt_usr))/t_dt)*100
  if peak >= 100.0 then
    peak = ' --.-- '
   else
    peak = format(peak,3,2)||'%'
  view_str = right(tid,4)||right(slot,6)||' '||left(prio,6)||right(state,4),
        ||right(sleep,11)||peak
  idle = format((dt_sys*(xmx-P_I_SIZE)*SLICE)/t_dt,,0)
  act = format((dt_usr*(xmx-P_I_SIZE)*SLICE)/t_dt,,0)
  lt_attr = REG_U_BG ; dk_attr = REG_S_BG
  if pos("IDL",prio) = 1 then
    do
      lt_attr = IDL_U_BG ; dk_attr = IDL_S_BG
     end
  y_view = y_thr ; x_view = P_I_SIZE ; sz_view = xmx-P_I_SIZE ; attr = PATH_ATTR
  call right_view
  y_thr = y_thr + 1
  return

get_cpu:
  drop tl.    
  call PYRxGo "i",,"tl"
  if \datatype(tl.0,'w') then
    do
      CPU_TXT = "Not supported OS level"
      tl.0 = 0
     end
   else 
    if tl.0 = 0 then
      CPU_TXT = "Not supported CPU type"
     else
      CPU_TXT = tl.0||" CPU(s) onboard"
  CPU_TXT = "CPU info: "CPU_TXT
  do i=1 to tl.0
    parse var tl.i ts_l ts_h idle_l idle_h busy_l busy_h int_l int_h dt
      ts_cur = 4294967296*ts_h   + ts_l
    idle_cur = 4294967296*idle_h + idle_l
    busy_cur = 4294967296*busy_h + busy_l
     int_cur = 4294967296*int_h  + int_l
    if ts_prev.i \= 'TS_PREV.'||i then
      do
	ts = ts_cur - ts_prev.i
	busy = right(format(((busy_cur - busy_prev.i)*100)/ts,,2),7)
	int = right(format(((int_cur - int_prev.i)*100)/ts,,2),7)
	idle = right(format(((idle_cur - idle_prev.i)*100)/ts,,2),7)
	freq = format(ts/(dt*F_coeff),,0)
	tl.i = left('  'i||busy"%"int"%"idle"%  ~"freq" MGz.",xmx-P_I_SIZE)
       end
      else
       tl.i = ""
    ts_prev.i = ts_cur ;     idle_prev.i = idle_cur
    busy_prev.i = busy_cur ; int_prev.i = int_cur
   end
  return

show_cpu_info:
  y_thr = 1
  do i=1 to tl.0 + INF_LINES while y_thr <= INF_LINES
    if i <= tl.0 & tl.i \= '' then
      do
        if i < t_idx then
          iterate
        parse var tl.i view_str 1 . busy '%' int '%' .
        act = format(busy*(xmx-P_I_SIZE)/100,,0)
        idle = format(int*(xmx-P_I_SIZE)/100,,0)
        lt_attr = CPU_B_BG ; dk_attr = CPU_I_BG
        y_view = y_thr ; x_view = P_I_SIZE ; sz_view = xmx-P_I_SIZE 
        attr = PATH_ATTR
        call right_view
        y_thr = y_thr + 1
       end
     else
      do
        call PYRxShow y_thr,P_I_SIZE,(xmx-P_I_SIZE),' ','7'x
        y_thr = y_thr + 1
       end
   end
  call PYRxShow ymx-2,length(sum_txt),0,left(CPU_TXT,,
                              xmx-length(sum_txt)),SUM_ATTR
  return

right_view:
  attr_str = ""
  if datatype(act,'w') then
    do
      if act > 0 then
        attr_str = left("",act,bitor(lt_attr,bitand(attr,'f'x)))
       else
        act = 0
     end
   else
    act = 0
  if datatype(idle,'w') then
    do
      if idle > 0 then
        attr_str = attr_str||left("",idle,bitor(dk_attr,bitand(attr,'f'x)))
       else
        idle = 0
     end
   else
    idle = 0
  sz_attr = sz_view-act-idle
  if sz_attr > 0 then
    attr_str = attr_str||left("",sz_attr,attr)
  view_str = left(view_str,sz_view)
  v_str = ''
  do j=1 to sz_view
    v_str = v_str||substr(view_str,j,1)||substr(attr_str,j,1)
   end
  call PYRxShow y_view,x_view,-1,v_str
  return