/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         CB_1_Click
*/
CB_1_Click: 
    
    /***** Enable or disable spin buttoms *******************************/
    
    if VRGet( CB_1, 'Set') then do
        call VRSet SPIN_1, 'Enabled', 1
        call VRSet SPIN_4, 'Enabled', 1
    end
    else do
        call VRSet SPIN_1, 'Enabled', 0
        call VRSet SPIN_4, 'Enabled', 0
    end

return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
    
    /***** Terminate printing environment *******************************/
    
    call PrtGRxTerm prt
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         idm_about_Click
*/
idm_about_Click: 
    ver = PrtGRxVersion();
    wTitle = 'PrtGraph Demo 2/REXX v' || ver
    call aboutwin VRWindow(), wTitle
return

/*:VRX         idm_exit_Click
*/
idm_exit_Click: 
    call Quit
return

/*:VRX         idm_prt_setup_Click
*/
idm_prt_setup_Click: 
    
    /***** Call the printers dialog *************************************/
    
    window = VRLoadSecondary( "PrtDialog", "W" )
    
    
    if pName <> '' then do
        ver = PrtGRxVersion();
        wTitle = 'PrtGraph Demo 2/REXX v' || ver '-' pName
        call VRSet Window1, 'Caption', wTitle
    end
return

/*:VRX         Init
*/
Init:
    
    window = VRWindow()
    call VRMethod window, "CenterWindow"
    
    /***** Load the printing functions if necessary *********************/
    
    if RxFuncQuery( 'PrtGRxLoadFuncs') then
        rcy = RxFuncAdd( 'PrtGRxLoadFuncs', 'PrtGraph', 'PrtGRxLoadFuncs');
    rcy = PrtGRxLoadFuncs();

/* 
    if RxFuncQuery( 'TstRxLoadFuncs') then do
        rcy = RxFuncAdd( 'TstRxLoadFuncs', 'ADD_TST', 'TstRxLoadFuncs');
        call TstRxLoadFuncs
    end

    call TstRxInit 'PRTGRX', 'E'
*/
    /***** Set the title of the window **********************************/
    
    prt = PrtGRxInit( 0);
    
    ver = PrtGRxVersion();
    pName = PrtGRxCurrentPrinter( prt);
    wTitle = 'PrtGraph Demo 2/REXX v' || ver '-' pName
    call VRSet window, 'Caption', wTitle
    
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    
    /***** Initialise the printing environment for the process **********/
    
    /***** Get the path to the OS/2 logo ********************************/
    
    set_path = VALUE( 'PATH', , 'OS2ENVIRONMENT');
    bootdrive = substr( set_path, pos( '\OS2\SYSTEM', set_path ) -2, 2);
    bmp_name = bootdrive || '\os2\bitmap\os2logo.bmp'
    bmp_name2 = bootdrive || '\os2\bitmap\addlogo.bmp'

    drop window ver set_path bootdrive

return

/*:VRX         LB_1_DoubleClick
*/
LB_1_DoubleClick: 
    selected = VRGet( "LB_1", "Selected" )
    rcy = PrtGRxSetPrinter( prt, selected)
    pName = VRGet( "LB_1", "SelectedString" )
    call PrtDialog_Close
return

/*:VRX         PB_1_Click
*/
PB_1_Click: 
    
    /***** Get Page settings ********************************************/
    
    border = VRGet( CB_1, 'Set');
    if border then do
        thick = VRGet( SPIN_1, 'Value');
        style = VRGet( SPIN_4, 'Value');
    end
    else do
        thick = 0;
        style = 0;
    end
    
    /***** Get header settings ******************************************/
    
    header = VRGet( CB_2, 'Set');
    allpages = VRGet( CB_4, 'Set');
    if header then do
        hthick = VRGet( SPIN_2, 'Value');
        hstyle = VRGet( SPIN_3, 'Value');
    end
    else do
        hthick = 0;
        hstyle = 0;
    end
    
    /***** Get footer settings ******************************************/
    
    footer = VRGet( CB_3, 'Set');
    if footer then do
        fthick = VRGet( SPIN_6, 'Value');
        fstyle = VRGet( SPIN_5, 'Value');
    end
    else do
        fthick = 0;
        fstyle = 0;
    end
    
    /***** Get margins for page *****************************************/
    
    lm = VRGet( SPIN_10, 'Value');
    rm = VRGet( SPIN_9, 'Value');
    tm = VRGet( SPIN_8, 'Value');
    bm = VRGet( SPIN_7, 'Value');
    ils = VRGet( SPIN_11, 'Value');
    
    /***** Find what we want to print ***********************************/
    
    if VRGet( RB_1, 'Set') then
        pstyle = 1
    if VRGet( RB_2, 'Set') then
        pstyle = 2
    if VRGet( RB_3, 'Set') then
        pstyle = 3
    if VRGet( RB_4, 'Set') then
        pstyle = 4
    if VRGet( RB_5, 'Set') then
        pstyle = 5
    if VRGet( RB_6, 'Set') then
        pstyle = 6
    if VRGet( RB_7, 'Set') then
        pstyle = 7
    if VRGet( RB_8, 'Set') then
        pstyle = 8
    
    /***** get the font face name ***************************************/
    
    facename = VRGet( EF_1, 'Value');
    if facename = '' then do
        call RxWinAlarm 3
        return
    end

    p = pos( '.', facename) + 1;
    facename = substr( facename, p);

    call VRSet Window1, 'pointer', 'wait'

    /***** Set the margins **********************************************/
    
    rcy = PrtGRxSetMargins( prt, lm, rm, tm, bm, thick, style);
    
    /***** Set the header mode ******************************************/
    
    rcy = PrtGRxSetHeaderMode( prt, header, facename, 10, hstyle, hthick, allpages);
    
    /***** Set the header ***********************************************/
    
    rcy = PrtGRxSetHeader( prt, 3, ,
                           "$c", "$lADD Consulting (CH)$r@",,
                           'Demo for PrtGraph Dynamic Link Library for REXX');
    
    /***** Set the footer if any ****************************************/
    
    if footer then do
        rcy = PrtGRxSetFooter( prt, facename, 8, fstyle, fthick, '$$rpage $#');
    end
    
    /***** Open the print job *******************************************/
    
    rcy = PrtGRxOpenPrintJob( prt, 'Test Printing');

    /***** Check that everything was ok *********************************/
    
    if \rcy then do
        call VRSet Window1, 'pointer', '<default>'
        return
    end
    
    /***** Set the line spacing for printing ****************************/
    
    rcy = PrtGRxSetLineSpace( prt, ils);

    /***** Set the texts for printing ***********************************/
    
    txt1 = 'Hello everyone, this is some text in'
    txt2 = 'point which wraps over several lines.'
    txt3 = 'This is so that you can see how the functions in the graphic printing DLL work.'
    txt4 = 'We hope that you will find them useful.'
    
    select
        
        /***** If left justified text demo ******************************/
        
        when pstyle = 1 then do
            fnt = 8
            rcy = PrtGRxWriteln( prt, facename, fnt, txt1 facename fnt txt2 txt3 txt4);
            rcy = PrtGRxWriteln( prt, , fnt, '');
            do fnt = 10 to 24 by 2
                rcy = PrtGRxWriteln( prt, , fnt, txt1 facename fnt txt2 txt3 txt4);
                rcy = PrtGRxWriteln( prt, , fnt, '');
            end
        end
        
        /***** If right justified text demo *****************************/
        
        when pstyle = 2 then do
            fnt = 8
            rcy = PrtGRxJustRight( prt, facename, fnt, txt1 facename fnt txt2 txt3 txt4);
            rcy = PrtGRxWriteln( prt, , fnt, '');
            do fnt = 10 to 24 by 2
                rcy = PrtGRxJustRight( prt, , fnt, txt1 facename fnt txt2 txt3 txt4);
                rcy = PrtGRxWriteln( prt, , fnt, '');
            end
        end
        
        /***** If centred text demo *************************************/
        
        when pstyle = 3 then do
            fnt = 8
            rcy = PrtGRxCentre( prt, facename, fnt, txt1 facename fnt txt2 txt3 txt4);
            rcy = PrtGRxWriteln( prt, , fnt, '');
            do fnt = 10 to 24 by 2
                rcy = PrtGRxCentre( prt, , fnt, txt1 facename fnt txt2 txt3 txt4);
                rcy = PrtGRxWriteln( prt, , fnt, '');
            end
        end
        
        /***** If justified text demo ***********************************/
        
        when pstyle = 4 then do
            fnt = 8
            rcy = PrtGRxJustified( prt, facename, fnt, txt1 facename fnt txt2 txt3 txt4);
            rcy = PrtGRxWriteln( prt, , fnt, '');
            do fnt = 10 to 24 by 2
                rcy = PrtGRxJustified( prt, , fnt, txt1 facename fnt txt2 txt3 txt4);
                rcy = PrtGRxWriteln( prt, , fnt, '');
            end
        end
        
        /***** If print bitmap demo *************************************/
        
        when pstyle = 5 then do
            rcy = PrtGRxWriteln( prt, facename, 14, 'Hello everyone, this is boxed printout of the OS/2 logo');
            rcy = PrtGRxBitMap( prt, bmp_name, 40, 20, 100, 80, 200);
            rcy = PrtGRxBitMap( prt, bmp_name2, 50, 90, 90, 120, 100);
        end
        
        /***** If print table demo **************************************/
        
        when pstyle = 6 then do
            rcy = PrtGRxWriteln( prt, facename, 12, 'Example of printing a table with different styles in each cell');
            rcy = PrtGRxWriteln( prt,,,'');
            rcy = PrtGRxWriteln( prt,,,'Table created with PrtGRxStartTable');
            call WriteTable

            rcy = PrtGRxWriteln( prt,facename, 12,'');
            rcy = PrtGRxWriteln( prt, facename, 12, 'Table created with PrtGRxDefineTable');
            rcy = PrtGRxWriteln( prt,facename, 12,'');
            call WriteTable2
        end
        
        /***** If styles demo *******************************************/
        
        when pstyle = 7 then do
            call PrintStyles
        end
        
        /***** If tabbing and goto demo *********************************/
        
        when pstyle = 8 then do
            call PrintTabbedText
        end

    end
    
    /***** Close the print job ******************************************/
    
    rcy = PrtGRxClosePrintJob( prt);

    call VRSet Window1, 'pointer', '<default>'

return

/*:VRX         PB_2_Click
*/
PB_2_Click: 
    call Quit
return

/*:VRX         PB_3_Click
*/
PB_3_Click: 
    
    /***** Get the font for printing ************************************/

    face = VRGet( EF_1, 'Value')
    p = pos( '.', face)
    if p > 0 then
        face = word( substr( face, p + 1), 1);
    else
        face = ''
    font = PrtGRxFontDlg( prt, 'Choose Font for Printing', face);
    if font <> '' then
        call VRSet EF_1, 'Value', font

    drop font face
return

/*:VRX         PB_4_Click
*/
PB_4_Click: 
    
    /***** Get/Set the job properties for selected printer **************/
    
    rcy = PrtGRxJobProps( prt);
return

/*:VRX         PB_5_Click
*/
PB_5_Click: 
    call idm_prt_setup_Click
return

/*:VRX         PB_6_Click
*/
PB_6_Click: 
    call idm_about_Click
return

/*:VRX         PB_7_Click
*/
PB_7_Click: 
    selected = VRGet( "LB_1", "Selected" )
    if selected > 0 then do
        rcy = PrtGRxSetPrinter( prt, selected)
        pName = VRGet( "LB_1", "SelectedString" )
    end
    call PrtDialog_Close
return

/*:VRX         PB_8_Click
*/
PB_8_Click: 
    call PrtDialog_Close
return

/*:VRX         PrintStyles
*/
PrintStyles: 
    
    /***** Get the page size ********************************************/
    
    retstr = PrtGRxGetPageSize( prt);

    if retstr = ',' then do
        rcy = VRMessage( VRWindow(), 'Failed to get pagesize', 'ERROR', 'E');
        return;
    end

    parse var retstr wide ',' high
    
    /***** Calculate positions for printing *****************************/
    
    vpos1 = trunc( high / 3) * 2;
    vpos2 = trunc( high / 3);
    vinc = trunc( vpos2/ 3);

    by1 = vpos1 
    ty1 = vpos1 + vinc
    by2 = vpos2
    ty2 = vpos2 + vinc

    hpos = trunc( wide / 8);
    hinc = trunc( hpos / 3) * 2;

    bx = 5;
    tx = bx + hinc;
    
    /***** Say what we are printing *************************************/
    
    rcy = PrtGRxWriteln( prt, facename, 10, 'Defined styles for filling');
    
    /***** print a row of boxes with different styles *******************/
    
    do style = 0 to 7
        rcy = PrtGRxBox( prt, bx, by1, tx, ty1, 28, style);
        rcy = PrtGRxGoto( prt, bx, by1 - 10);
        rcy = PrtGRxWrite( prt, facename, 10, 'Style' style);
        bx = bx + hpos;
        tx = tx + hpos;
    end

    bx = 5;
    tx = bx + hinc;
    
    /***** print a row of boxes with different styles *******************/
    
    do style = 8 to 15
        rcy = PrtGRxBox( prt, bx, by2, tx, ty2, 28, style);
        rcy = PrtGRxGoto( prt, bx, by2 - 10);
        rcy = PrtGRxWrite( prt, facename, 10, 'Style' style);
        bx = bx + hpos;
        tx = tx + hpos;
    end

return

/*:VRX         PrintTabbedText
*/
PrintTabbedText: 
    
    /***** Get the page size ********************************************/
    
    retstr = PrtGRxGetPageSize( prt);

    if retstr = ',' then do
        rcy = VRMessage( VRWindow(), 'Failed to get pagesize', 'ERROR', 'E');
        return;
    end

    parse var retstr wide ',' high
    
    /***** Calculate the number of tabs *********************************/
    
    numtabs = trunc( wide / 10) - 1;
    
    /***** Print '|' at each tab position *******************************/
    
    rcy = PrtGrxWriteln( prt, facename, 10, 'Tab positions are shown on the next line');
    rcy = PrtGrxWriteln( prt, , , '');
    rcy = PrtGrxWrite( prt, , , '|');

    do i = 1 to numtabs
        rcy = PrtGRxTab( prt);
        rcy = PrtGrxWrite( prt, , , '|');
    end
    
    /***** Go to the bottom of the page *********************************/
    
    rcy = PrtGrxWriteln( prt, , , '');
    rcy = PrtGRxGoto( prt, 0, 10);
    rcy = PrtGRxWrite( prt, , , 'On the next page we show 20 random moves in an area within 200mm of the top margin and right margin');
    rcy = PrtGRxNewPage( prt);

    vinc = high - 20;
    hinc = wide - 20;
    
    /***** Do 20 random jumps around the page ***************************/
    
    do i = 1 to 20
        x = random( 5, hinc)
        y = random( 5, vinc)
        rcy = PrtGRxGoto( prt, x, y);
        rcy = PrtGRxWrite( prt,,,'Jump' i x','y);
    end

return

/*:VRX         PrtDialog_Close
*/
PrtDialog_Close: 
    call PrtDialog_Fini
return

/*:VRX         PrtDialog_Create
*/
PrtDialog_Create: 
    call PrtDialog_Init
    rcy = PrtGRxPrinterList( prt, "printers.");

    ok = VRMethod( "LB_1", "Clear" )
    ok = VRMethod( "LB_1", "AddStringList", "printers." )

    position = VRMethod( "LB_1", "FindString", pName, 1, "Exact", "Case" )
    call VRSet "LB_1", "Selected", position
return

/*:VRX         PrtDialog_Fini
*/
PrtDialog_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         PrtDialog_Init
*/
PrtDialog_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         Quit
*/
Quit:
/*
    call TstRxStop
*/
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

/*:VRX         WriteTable
*/
WriteTable: 
    
    /***** Initialise a table *******************************************/
    
    rcy = PrtGRxStartTable( prt, 0, 24, 3,,
                            30,45,,
                            75,50,,
                            125,40);

    if rcy then do
        
        /***** Start printing a row *************************************/
        
        rcy = PrtGRxStartRow( prt);
        
        /***** write to col 1 *******************************************/
        
        rcy = PrtGRxStartCol( prt, 1);
        rcy = PrtGRxJustRight( prt, 'Helvetica', 10, 'This is some text in the first column. It is not very long,');
        
        /***** write to col 2 *******************************************/
        
        rcy = PrtGRxStartCol( prt, 2);
        rcy = PrtGRxJustified( prt, 'Helvetica Bold', 10, 'This is some text in the second column. It is not very long,');
        rcy = PrtGRxJustified( prt,,,'This text has several lines and with a bit of luck should force a new page.');
        rcy = PrtGRxJustified( prt,,,'If it does then we have a test of a cell rolling over from one page to the next and we will not have to write any more.');
        
        /***** write to col 3 *******************************************/
        
        rcy = PrtGRxStartCol( prt, 3);
        rcy = PrtGRxCentre( prt, 'Helvetica Bold', 14, 'This is some text in the third column. It is not very long,');
        
        /***** print out the row ****************************************/
        
        rcy = PrtGRxEndRow( prt);
        
        /***** start the next row ***************************************/
        
        rcy = PrtGRxStartRow( prt);
        
        /***** write to col 1 *******************************************/
        
        rcy = PrtGRxStartCol( prt, 1);
        rcy = PrtGRxJustRight( prt, 'Times New Roman', 10, 'This is some text in the first column. It is not very long,');
        
        /***** write to col 2 *******************************************/
        
        rcy = PrtGRxStartCol( prt, 2);
        rcy = PrtGRxWrite( prt, 'Helvetica Bold', 10, 'This is some text in the second column. It is not very long and should be left justified.');
        rcy = PrtGRxCentre( prt,,,'This text has several lines and with a bit of luck should be centred.');
        rcy = PrtGRxJustified( prt,,,'This text here was designed to be justified and should roll over several lines, of course the last line will be left aligned.');
        rcy = PrtGRxJustRight( prt,,,'This last bit of text should finally show all the styles in one cell as it is right aligned.');
        
        /***** write to col 3 *******************************************/
        
        rcy = PrtGRxStartCol( prt, 3);
        rcy = PrtGRxJustified( prt, 'Times New Roman', 8, 'This is some text in the third column. It is not very long,');
        
        /***** print out the row ****************************************/
        
        rcy = PrtGRxEndRow( prt);
        
        /***** Terminate the table **************************************/
        
        rcy = PrtGRxEndTable( prt);
    end
    else
        rcy = PrtGRxWrite( prt, 'Helvetica Bold', 14, 'ERROR - Failed to create the table...');

return

/*:VRX         WriteTable2
*/
WriteTable2: 

/***** Define the table ********************************/

table.0 = 8
table.1 = 0
table.2 = 14
table.3 = 1
table.4 = 0
table.5 = 28
table.6 = 1
table.7 = 12
table.8 = 'Helvetica Bold'

/***** Make 3 columns ***********************************/

Cols.0.0 = 3

Cols.1.1 = 30
Cols.1.2 = 45
Cols.1.3 = 'Column 1'

Cols.2.1 = 75
Cols.2.2 = 50
Cols.2.3 = 'Column 2'

Cols.3.1 = 125
Cols.3.2 = 40
Cols.3.3 = 'Column 3'
                       
rcy = PrtGRxDefineTable( prt, "table.", "Cols.");

/**** Start printing in the table **********************************/

if rcy then do
    do i = 1 to 20
        rcy = PrtGRxStartRow( prt);
        rcy = PrtGRxStartCol( prt, 1)
        rcy = PrtGRxWrite( prt, 'Helvetica Bold', 10, i);
        rcy = PrtGRxStartCol( prt, 2)
        rcy = PrtGRxWrite( prt, 'Helvetica Italic', 10, 'Some italic text');
        rcy = PrtGRxStartCol( prt, 3)
        rcy = PrtGRxWrite( prt, 'Helvetica', 10, random( 20000));
        rcy = PrtGRxEndRow( prt);
    end
    rcy = PrtGRxEndTable( prt);
end    
else
    rcy = PrtGRxWrite( prt, 'Helvetica Bold', 14, 'ERROR - Failed to create the table...');

return

