/*
  Ŀ
   PMSW - OS/2 program to switch to a task by name in the task   
   list.  For example:  to switch to TSO mainframe session that  
   is named "A - A - 3270 EMULATOR", provide a mask string as    
   a command line entry:  "*3270 EMULATOR*". PMSW will switch    
   to the first task that matches the mask string.  The chars    
   "*" and "?" can be used to indicate "zero or more" and "one"  
   any character(s) respectively.                                
                                                                 
   Example:  Task entry:  "A - A - 3270 Emulator"                
   'PMSW *3270 EMUL*';                                           
   OR:  "A*3270*EM*" is a good mask for selection.               
                                                                 
   Example:  Task entry:  "CCMAIL.BAT"                           
   'PMSW *CCMAIL*'                                               
                                                                 
   Example:  'PMSW *'  switches focus to own session             
                                                                 
  
  Ŀ
   Copyright (C) 1993,1994 Bruce E. Hgman.  All Rights Reserved.
   This program has been dedicated to the Public Domain.         
  
  Ŀ
                                                                 
   External functions:  mskchk                                   
     (*mask,mlen,*area,alen,*qmark,*ast)                         
   Command line:  PMSW "task mask" [/r]                          
     /r:  test only.  Returns:  READY: if task is in list.       
     if no /r, then switch to named task.                        
     task mask of * means switch to self.  rc=0 or 2 only.       
                                                                 
   Returns:  numeric RC                                          
     2:      error in processing or task not found.  If error    
             caused by system service failure or bad syntax,     
             a message is displayed on STDERR file handle.       
     1:      Requested task by name is active and jumpable.      
     0:      Requested task by name was made focus.              
                                                                 
  
*/
#define INCL_DOSMEMMGR
#define INCL_DOSPROCESS
#define INCL_WINSWITCHLIST
#define INCL_PM
#include <stdio.h>
#include <OS2.H>
#include "PMSW.h"
#define UDEBUG 0
/*
  Ŀ
   The OS2H include file code is reproduced here to assist in    
   code development.  Be sure to check the latest .H files.      
  
*/
 #ifdef USERDUMMY
/*
  Ŀ
   SWBLOCK switch-list block structure.                          
  
*/
 typedef struct _SWBLOCK {
 ULONG      cswentry;     /* Count of switch list entries  */
 SWENTRY    aswentry[1];  /* Switch list entries  */
  } SWBLOCK;
/*
  Ŀ
   SWENTRY switch-list entry structure.                          
  
*/
 typedef struct _SWENTRY {
 HSWITCH    hswitch;  /* Switch-list entry handle used for focus */
 SWCNTRL    swctl;    /* Switch-list control block structure  */
  } SWENTRY;
/*
  Ŀ
   SWCNTRL switch-list entry structure.                          
  
*/
 typedef struct _SWCNTRL {
 HWND        hwnd;                   /* Window handle  */
 HWND        hwndIcon;               /* Window-handle icon  */
 HPROGRAM    hprog;                  /* Program handle  */
 PID         idProcess;              /* Process identity  */
 ULONG       idSession;              /* Session identity  */
 UCHAR       uchVisibility;          /* Visibility  */
 UCHAR       fbJump;                 /* Jump indicator  */
 CHAR        szSwtitle[MAXNAMEL+1];  /* Switch-list control block title (null-terminated)  */
 BYTE        bProgType;              /* Program type  */
  } SWCNTRL;
 #endif
/*
  Ŀ
   PMSW program entry                                            
  
*/
 int main ( int argc, char *argv[])
 {
 BOOL      bFound=FALSE;    /* TRUE if requested task name found */
 BOOL      bQuery=FALSE;    /* if /r flag is used to return info */
 BOOL      bSelf=FALSE;     /* if title/name mask is single asterisk */
 HAB       hAnchorBlock;    /* Anchor-block handle */
 HSWITCH   hswitchSwHandle; /* Window List entry handle of program to be activated */
 int       i;
 int       iMaskLen=0;
 int       iRCmskchk=0;
 int       iRC=0;           /* return code from program */
 UCHAR     pAster[]="*";
 ULONG     pBase;
 UCHAR     pQmark[]="?";
 SWCNTRL  *pSWCItem;
 SWENTRY  *pSWEItem;
 PSWBLOCK  pswblkBlock;     /* Switch entries block */
 PSWBLOCK  pswblkItem;      /* ptr work to an individual SWCNTRL */
 UCHAR     scInputMask[64]="";
 char      scTestString[80]="";
 CHAR      szUCtitle[MAXNAMEL+1]="";
 ULONG     ulNrItems;
 ULONG     ulRetCode=0;     /* Return code *from Win* functions */
 ULONG     ulcbBufLength;
 PTIB      ptib_us;
 PPIB      ppib_us;

/*
  Ŀ
   On bad command line syntax (no argument(s)), display msg.     
  
*/
 if (argc<1)
 { ErrorReturn:
   fprintf(stderr,"Ŀ\n");
   fprintf(stderr," PMSW REXX Function call syntax:                \n");
   fprintf(stderr,"                                                \n");
   fprintf(stderr," Retstr=PMSW(task_name [,\"/r\"]);                \n");
   fprintf(stderr,"                                                \n");
   fprintf(stderr," Returns: FOCUS:/READY:/ERROR:                  \n");
   fprintf(stderr,"                                                \n");
   fprintf(stderr," FOCUS:  task named was made focus.             \n");
   fprintf(stderr," READY:  /r suppressed FOCUS:                   \n");
   fprintf(stderr," ERROR:  Error occurred during processing.      \n");
   fprintf(stderr,"                                                \n");
   fprintf(stderr," Control returns immediately to caller in all   \n");
   fprintf(stderr," cases.  When FOCUS:, then desktop focus has    \n");
   fprintf(stderr," changed as requested.                          \n");
   fprintf(stderr,"\n");
   iRC=2;
   return iRC;
 }
 for (i=1;i<argc;i++)
 { if (!strstr(strupr(argv[i]),"/R"))
   { strcat(scInputMask,strupr(argv[i]));
     strcat(scInputMask," ");
   }
   else
   { bQuery=TRUE; break; }
 }
 if (scInputMask[strlen(scInputMask)-1]==' ')
     scInputMask[strlen(scInputMask)-1]='\0'; /* truncate last blank */
 #if UDEBUG
 fprintf(stderr,"Arg=>%s<=\n",scInputMask);
 #endif
 iMaskLen=strlen(scInputMask);
 if (iMaskLen==1 && scInputMask[0]=='*') bSelf=TRUE;
/*
  Ŀ
   If request is to switch to self, then we get info blocks      
   using DosGetInfoBlocks to get PID, then use                   
   WinQuerySwitchHandle with PID data to get hswitch that we     
   can then use in WinSwitchToProgram call.                      
  
*/
 if (bSelf)
 {
   DosGetInfoBlocks(&ptib_us,&ppib_us);
   hswitchSwHandle=WinQuerySwitchHandle(NULL,ppib_us->pib_ulpid);
   ulRetCode = WinSwitchToProgram( hswitchSwHandle);
   if (0<ulRetCode)   /* return ERROR: on failure to switch */
   { iRC=2;
   #if UDEBUG
   fprintf(stderr,"PMSW WinSwitchToProgram RC=%lu\n",ulRetCode);
   #endif
   }
   else iRC=0; /* FOCUS: focus has changed */
   return iRC;
 }
/*
  Ŀ
   Assemble the contents of the switch list as an array in       
   our area.  We'll walk thru list item by item, checking names  
   using the name mask.                                          
  
*/
 ulNrItems = WinQuerySwitchList(hAnchorBlock, NULL, 0);
 #if UDEBUG
 fprintf(stderr,"PMSW # items in list=%lu\n",ulNrItems);
 #endif
 ulcbBufLength = (ulNrItems * sizeof(SWENTRY)) + sizeof(ULONG);
 pswblkBlock=(SWBLOCK *)malloc(ulcbBufLength);
 /* gets struct. array */
 WinQuerySwitchList( hAnchorBlock, pswblkBlock, ulcbBufLength);

 pSWEItem=(SWENTRY *)&(pswblkBlock->aswentry[0]);
 for (i=0;i<ulNrItems;i++)
 { pSWCItem=(SWCNTRL *)&((pSWEItem+i)->swctl);
   strcpy(scTestString,pSWCItem->szSwtitle);
   if (pSWCItem->fbJump&SWL_JUMPABLE)
   { strcpy(szUCtitle,pSWCItem->szSwtitle); strupr(szUCtitle);
     #if UDEBUG
     fprintf(stderr,"Task title=%s\n",szUCtitle);
     #endif
     iRCmskchk=mskchk( scInputMask,iMaskLen, szUCtitle,
       strlen(pSWCItem->szSwtitle), pQmark, pAster);
     if (!iRCmskchk)
     { bFound=TRUE; hswitchSwHandle=(pSWEItem+i)->hswitch;
       #if UDEBUG
       fprintf(stderr,"Task found: %s\n",scTestString);
       #endif
     }
   }
   if (bFound) break;
 }

/*
  Ŀ
   If the requested task is found, either set the return code    
   and return, or request change of focus to the target window   
   and then return with the FOCUS: return string.                
  
*/
 if (bFound)
 { if (!bQuery)         /* request is to change focus */
   { ulRetCode = WinSwitchToProgram( hswitchSwHandle);
     if (0<ulRetCode)   /* return ERROR: on failure to switch */
     { iRC=2;
     #if UDEBUG
     fprintf(stderr,"PMSW WinSwitchToProgram RC=%lu\n",ulRetCode);
     #endif
     }
     else iRC=0; /* FOCUS: focus has changed */
   }
   else iRC=1; /* request is to check on readiness for focus */
 }
 else iRC=2;
 free(pswblkBlock);
 return iRC;
}
