/* PGPAMP.CMD version 1.0 Copyright 1994 04/10/94 by Alan M. Pugh */

/* PGPAMP is a shell to use with PGP. It requires that you have VREXX
support enabled. PGP is a file encryption/decryption program. For this 
command file to work, the PGPPATH environment variable must be set. 
For instance, SET PGPPATH=C:\PGP\

This command file will prompt for a file to encrypt, or let you 
create the file on the fly using the Enhance Editor.  
PGPAMP.CMD is freeware. No warranty whatsoever is implied. 

When I encrypt a file, I am normally sending it through echomail or
MCI Mail. This means that the file must be an ASCII file. Therefor,
I've provided syntax for both "ASCII ARMORED" files and binary files.
This program is shipped with ASCII output enabled. If you want it to
produce binary output (which is smaller), edit this file to change
the syntax that is called. */

'@echo off'
call RxFuncAdd 'VInit', 'VREXX', 'VINIT'
initcode = VInit()
if initcode = 'ERROR' then signal CLEANUP

signal on failure name CLEANUP
signal on halt name CLEANUP
signal on syntax name CLEANUP


/* Main Menu */

main:
main.0 = 7
main.1  = "Clear Sign a File."
main.2  = "Encrypt File to Person(s)."
main.3  = "Sign a File and Encrypt to Person(s)"
main.4  = "Encrypt using DES Encryption"
main.5  = "Decrypt a File"
main.6  = "Key Management Commands"
main.7  = "Exit Program"
main.vstring = main.1          /* default selection */

call VDialogPos 25, 25
call VListBox "Make Selection Press OK", main, 35, 8, 1

if main.vstring="Exit Program"
then
call cleanup

if main.vstring="Clear Sign a File."
then
do 
call getfile
call get2file
    "pgp -sta +clearsig=on " file "-o " file2
end

if main.vstring="Encrypt File to Person(s)."
then
do
   call getfile
   call getname
   call get2file
/*   "pgp -e " file name "-o " file2 */       /* Binary output */
   "pgp -ea " file name "-o " file2           /* ASCII output */
end

if main.vstring="Sign a File and Encrypt to Person(s)"
then
do
   call getfile
   call getname
   call get2file
/*   "pgp -es " file '"'name'"' "-o " file2 */  /* Binary output */
   "pgp -sea " file '"'name'"' "-o " file2    /* ASCII output */
end

if main.vstring="Encrypt using DES Encryption"
then
do
   call getfile
   call get2file
/*   "pgp -c " file "-o "file2 */             /* Binary output */
   "pgp -ca " file "-o "file2                 /* ASCII output */
end

if main.vstring="Decrypt a File"
then
do
   call getfile
   call get2file
   "pgp " file "-o " file2
end

if main.vstring="Key Management Commands"
then 
call keymgmt
 

call main 

/* this section gets names or files */

getfile:
call VDialogPos 10, 50
button = VFileBox("Pick the file to encrypt...", "*.*", "fname")
file=fname.vstring
if button= "CANCEL" 
then 
call cancelled

return


get2file:
call VDialogPos 10, 50
button = VFileBox("Choose a Target Filename...", "*.*", "fname")
file2=fname.vstring
if button= "CANCEL" 
then 
call cancelled

return

call MAIN


/* this section gets names */
getname:
persname.0 = 2
persname.1 = "Enter name of recipient"
persname.2 = "(First Last)"
persname.vstring = "John Doe"
button = VInputBox("Enter Name Please", persname, 20, 3)
name=persname.vstring
if button= "CANCEL" 
then 
call cancelled
return


cancelled:

msg.0 = 2
msg.1 = 'You pressed CANCEL.'
msg.2 = 'Returning you to MAIN'

rb = VMsgBox('PGPAMP', msg, 1)
call main


/* this is the key management section */
keymgmt:

key.0 = 12
key.1  = "Add a Key to Your Public Key"
key.2  = "Extract a Key From Your Public Key"
key.3  = "Extract an ASCII Key From Your Public Key"
key.4  = "View a Key's Fingerprint"
key.5  = "View Your Public Key's Contents"
key.6  = "View Public Key Contents Verbosely"
key.7  = "Edit your Private Key's PassPhrase"
key.8  = "Sign Someone's Public Key"
key.9  = "Disable/Enable a Key"
key.10  = "Detatch Signature From Signed Document"
key.11  = "Goto Main Menu"
key.12  = "Exit Program"
key.vstring = key.11          /* default selection */

call VDialogPos 25, 25
call VListBox "Make Selection Press OK", key, 55, 13, 1

if key.vstring= "Add a Key to Your Public Key"
then
do
   call getfile
   "pgp -ka " file
end

if key.vstring= "Extract a Key From Your Public Key"
then 
do
   call getname
   "pgp -kx "  '"'name'"'                 /* Binary output */
/*   "pgp -kxa "  '"'name'"' */           /* ASCII output */
end

if key.vstring= "Extract an ASCII Key From Your Public Key"
then 
do
   call getname
/*   "pgp -kx "  '"'name'"'   */     /* Binary output */
   "pgp -kxa "  '"'name'"'           /* ASCII output */
  
end

if key.vstring= "View a Key's Fingerprint"
then 
do
   call getname
   "pgp -kvc "  name
   say "Press a key to return..."
   pull
end

if key.vstring= "View Your Public Key's Contents"
then 
do
   "pgp -kv | more"  
   say "Press a key to return..."
   pull
end

if key.vstring= "View Public Key Contents Verbosely"
then 
do
   "pgp -kvv | more"
   say "Press a key to return..."
   pull
end

if key.vstring= "Edit your Private Key's PassPhrase"
then 
do
   "pgp -ke "  
   say "Press a key to return..."
   pull
end

if key.vstring= "Sign Someone's Public Key"
then 
do
   call getname
   "pgp -ks "  '"'name'"'
end

if key.vstring= "Disable/Enable a Key"
then 
do
   call getname
   "pgp -kd " '"'name'"'
end

if key.vstring= "Detatch Signature From Signed Document"
then 
do
   call getfile
   "pgp -b "  file
end

if key.vstring= "Goto Main Menu"
then
call main

if key.vstring= "Exit Program"
then call cleanup

call keymgmt

CLEANUP:
   call VExit

exit

