/* Recreate objects script. */

/* Register with REXX API extensions. */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* Get creation disposition. */
Say 'When object exists object creation should:' 
Call CharOut, '  (U=Update, R=Replace, F=Fail) : '
Parse Upper Pull Answer
CreateCollision = 'Fail'
If Left( Answer, 1 ) = R Then CreateCollision = 'Replace' 
If Left( Answer, 1 ) = U Then CreateCollision = 'Update' 

Call RegisterClasses
Call CreateObjects
Exit

CreateObject: procedure
    Parse Arg Class, Title, Location, Setup, Collision
    Say 'Creating ['Title']'
    rc = SysCreateObject( Class, Title, Location, Setup, Collision )
    If rc <> 1 Then
        Say ' > failed to create ['Title' | 'Class'] at location ['Location']'
    return rc

CreateObjects:

    rc = CreateObject( 'WPNetwork',,
        'Netzwerk',,
        '<WP_CONNECTIONSFOLDER>',,
        'NOCOPY=YES;'||,
            'NODELETE=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=NONGRID,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'OBJECTID=<WP_NETWORK>',,
        CreateCollision )

      rc = CreateObject( 'WPFolder',,
          'Netzwerkdienste',,
          '<WP_NETWORK>',,
          'NOTDEFAULTICON=YES;'||,
              'NOPRINT=YES;'||,
              'DEFAULTVIEW=CONTENTS;'||,
              'SELFCLOSE=1;'||,
              'ICONFONT=9.WarpSans;'||,
              'DETAILSFONT=9.WarpSans;'||,
              'TREEFONT=9.WarpSans;'||,
              'ICONVIEW=NONGRID,NORMAL;'||,
              'DETAILSVIEW=MINI;'||,
              'TREEVIEW=LINES,MINI;'||,
              'OBJECTID=<WC_NETSERV>',,
          CreateCollision )

        rc = CreateObject( 'LSPeerWorkstation',,
            'Gemeinsame Ressourcen und^Netzwerkverbindungen',,
            '<WC_NETSERV>',,
            'NOPRINT=YES;'||,
                'MINWINSKTOP;'||,
                'DEFAULTVIEW=SETTINGS;'||,
                'HELPPANEL01;'||,
                'HELPLIBRARY=LSPRWPS.HLP;'||,
                'OBJECTID=<PEER_WKST>',,
            CreateCollision )

        rc = CreateObject( 'WPProgram',,
            'LAN Server^Verwaltung',,
            '<WC_NETSERV>',,
            'NOPRINT=YES;'||,
                'DEFAULTVIEW=RUNNING;'||,
                'HELPPANEL21;'||,
                'HELPLIBRARY=D:\IBMLAN\NETPROG\LSIWOBJS.HLP;'||,
                'EXENAME=D:\IBMLAN\NETPROG\NETGUI.EXE;'||,
                'STARTUPDIR=D:\IBMLAN\NETPROG;'||,
                'PROGTYPE=PM;'||,
                'OBJECTID=<LS_ADMIN>',,
            CreateCollision )

        rc = CreateObject( 'WPShadow',,
          'LAN Server^Verwaltung',,
          '<WP_NETWORK>',,
          'SHADOWID=<LS_ADMIN>;'||,
              'OBJECTID=<LS_ADMIN_SHADOW>',,
          CreateCollision )

        rc = CreateObject( 'WPFolder',,
            'Anmeldungen',,
            '<WC_NETSERV>',,
            'NOTDEFAULTICON=YES;'||,
                'NOPRINT=YES;'||,
                'DEFAULTVIEW=CONTENTS;'||,
                'HELPPANEL02;'||,
                'HELPLIBRARY=D:\IBMLAN\NETPROG\LSIWOBJS.HLP;'||,
                'ICONVIEWPOS=9 44 50 14;'||,
                'SELFCLOSE=1;'||,
                'ICONFONT=9.WarpSans;'||,
                'DETAILSFONT=9.WarpSans;'||,
                'TREEFONT=9.WarpSans;'||,
                'ICONVIEW=NONGRID,NORMAL;'||,
                'DETAILSVIEW=MINI;'||,
                'TREEVIEW=LINES,MINI;'||,
                'ICONFILE=D:\Temp\Anmeldungen.ICO;'||,
                'OBJECTID=<LS_FOLDER>',,
            CreateCollision )

          rc = CreateObject( 'WPProgram',,
              'Starten^LAN Requester-Dienste',,
              '<LS_FOLDER>',,
              'NOPRINT=YES;'||,
                  'MINWINSKTOP;'||,
                  'DEFAULTVIEW=RUNNING;'||,
                  'HELPPANEL07;'||,
                  'HELPLIBRARY=D:\IBMLAN\NETPROG\LSIWOBJS.HLP;'||,
                  'ICONPOS=8,12;'||,
                  'EXENAME=D:\IBMLAN\NETPROG\NETSTCMD.CMD;'||,
                  'STARTUPDIR=D:\IBMLAN\NETPROG;'||,
                  'PARAMETERS=START PEER;'||,
                  'PROGTYPE=WINDOWABLEVIO;'||,
                  'OBJECTID=<LS_START>',,
              CreateCollision )

          rc = CreateObject( 'WPProgram',,
              'LAN Requester-Dienste^Anmeldung bei Datenstation',,
              '<LS_FOLDER>',,
              'NOPRINT=YES;'||,
                  'MINWINSKTOP;'||,
                  'DEFAULTVIEW=RUNNING;'||,
                  'HELPPANEL08;'||,
                  'HELPLIBRARY=D:\IBMLAN\NETPROG\LSIWOBJS.HLP;'||,
                  'ICONPOSC,12;'||,
                  'EXENAME=D:\MUGLIB\LOGON.EXE;'||,
                  'STARTUPDIR=D:\MUGLIB;'||,
                  'PARAMETERS=/v:local;'||,
                  'PROGTYPE=PM;'||,
                  'OBJECTID=<PEER_LOCALLOGON>',,
              CreateCollision )

          rc = CreateObject( 'LSPeerUser',,
              'Netzwerkbenutzereintrag',,
              '<LS_FOLDER>',,
              'NOPRINT=YES;'||,
                  'MINWINSKTOP;'||,
                  'DEFAULTVIEW=SETTINGS;'||,
                  'HELPPANELu01;'||,
                  'HELPLIBRARY=LSPRWPS.HLP;'||,
                  'ICONPOSb,12;'||,
                  'OBJECTID=<PEER_USER>',,
              CreateCollision )

          rc = CreateObject( 'WPProgram',,
              'Abmelden',,
              '<LS_FOLDER>',,
              'NOPRINT=YES;'||,
                  'MINWINSKTOP;'||,
                  'DEFAULTVIEW=RUNNING;'||,
                  'HELPPANEL09;'||,
                  'HELPLIBRARY=D:\IBMLAN\NETPROG\LSIWOBJS.HLP;'||,
                  'ICONPOS ,12;'||,
                  'EXENAME=D:\MUGLIB\LOGOFF.EXE;'||,
                  'STARTUPDIR=D:\MUGLIB;'||,
                  'PARAMETERS=/L;'||,
                  'PROGTYPE=PM;'||,
                  'OBJECTID=<PEER_LOGOFF>',,
              CreateCollision )

          rc = CreateObject( 'WPProgram',,
              'LAN Server^Anmeldung',,
              '<LS_FOLDER>',,
              'NOTDEFAULTICON=YES;'||,
                  'NOPRINT=YES;'||,
                  'MINWINSKTOP;'||,
                  'DEFAULTVIEW=RUNNING;'||,
                  'HELPPANEL08;'||,
                  'HELPLIBRARY=D:\IBMLAN\NETPROG\LSIWOBJS.HLP;'||,
                  'ICONPOS),12;'||,
                  'EXENAME=D:\MUGLIB\LOGON.EXE;'||,
                  'STARTUPDIR=D:\MUGLIB;'||,
                  'PARAMETERS=/v:domain /d;'||,
                  'PROGTYPE=PM;'||,
                  'ICONFILE=D:\Temp\LAN Server!Anmeldung.ICO;'||,
                  'OBJECTID=<PEER_LANLOGON>',,
              CreateCollision )

      rc = CreateObject( 'WPShadow',,
          'Anmeldungen',,
          '<WP_NETWORK>',,
          'SHADOWID=<LS_FOLDER>;'||,
              'OBJECTID=<LS_FOLDER_SHADOW>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Netzwerknachrichtendienste',,
          '<WC_NETSERV>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'HELPPANEL05;'||,
              'HELPLIBRARY=D:\IBMLAN\NETPROG\LSIWOBJS.HLP;'||,
              'EXENAME=D:\IBMLAN\NETPROG\NETMSG.EXE;'||,
              'STARTUPDIR=D:\IBMLAN\NETPROG;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<LS_NETMSG>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Netzwerk-DDE und^gemeinsame Zwischenablage',,
           '<WC_NETSERV>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'HELPPANEL04;'||,
              'HELPLIBRARY=D:\IBMLAN\NETPROG\LSIWOBJS.HLP;'||,
              'EXENAME=D:\IBMLAN\NETPROG\NWDDE.EXE;'||,
              'STARTUPDIR=D:\IBMLAN\NETPROG;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<LS_CLIP>',,
          CreateCollision )


return


RegisterClasses:

Say
Say 'Registering classes....'
Say
Say 'The following classes will be registered:'
Say
Say '  LSPeerWorkstation  '
Say
Say 'Press enter to register 1 classes for object creation,'
Call CharOut, 'or type any other key and enter to ignore: '
Say
Parse Pull Answer
If Answer <> '' Then return
  If SysRegisterObjectClass( 'LSPeerWorkstation', 'LSPRWPS' ) <> 1 Then
      Say 'Can''t register class LSPeerWorkstation with LSPRWPS.'
  Else
      Say 'Registered class LSPeerWorkstation with LSPRWPS.'

return



