/* rexxify                                                        */
/*                                                                */
/* OS2VER.CMD                                                     */
/*                                                                */
/* Test showing how to use os2check in a REXX script to determine */
/* the version of the operating system currently in use.          */
/*                                                                */
/* OS2CHECK.EXE can be used to test whether a program compiled    */
/* specifically for Warp can be run prior to running it.  This    */
/* enables a more friendly message to appear describing that a    */
/* product may require OS/2 Warp in lieu of the SYS Error Box     */
/* that may scare the operator.  A REXX script can use OS2CHECK   */
/* to determine which version of a program to load (e.g., 2.11    */
/* or Warp specific).                                             */
/*                                                                */
/* The parameters permit any level of the operating system to be  */
/* tested.  If no parameters are passed, then 20 30 is used as    */
/* this is the way Warp is identified.                            */
/*                                                                */
/* A return value from os2check will be 0 if what is installed    */
/* matches the values passed.  Otherwise, the major and minor     */
/* values are concatenated into a single value (e.g., 2030 for    */
/* Warp, or 2011 for OS/2 2.11).  A value of (-1) is returned     */
/* if an error is encountered in the parameters passed.           */
/*                                                                */
/* The VERBOSE flag causes a listing of the system information    */
/* to be printed to stderr and can be redirected to a file using  */
/* the 2> redirection facility of OS/2.                           */
/*                                                                */
/* To see how this script may be used, type the following:        */
/* testos2 20 30 1                                                */
/*         |  |  |                                                */
/*  major--+  |  +-- verbose listing                              */
/*     minor--+                                                   */  
/*                                                                */

parse upper arg major minor verbose
if major = ''  then major = 20
if minor = '' then minor = 30
'@'os2check major minor verbose
say
if (RC == 0) then
do
   if ((major == 20) & (minor >= 30)) | (major > 20) then
   do
      say "This system is running OS/2 Warp (or higher)."
   end
   else
   do
      say "This is the expected version of OS/2."
   end
end
else
do
   say "This version of OS/2 is "RC
end
exit

