/* REXX *********************************************************************/
/*                                                                          */
/* Name:        OBJectDIRectory                                             */
/*                                                                          */
/* Version:     1.00                                                        */
/*                                                                          */
/* Author:      Jon Renton (c)                                              */
/*                                                                          */
/* Date:        7.96                                                        */
/*                                                                          */
/* Description: Accept Dragged & Dropped Desktop Objects and start a        */ 
/*              command prompt in the directory for the given object.       */
/*              This is a useful tool for anyone who needs (or wants)       */
/*              to work using a command prompt, but hates to enter the      */
/*              the drive and full path name of the required directory.     */
/*                                                                          */
/* Files:       INSTALL.CMD  - Description & Installation                   */
/*              OBJDIR.CMD   - Main Exec                                    */
/*              OBJDIR.ICO   - Icon                                         */
/*                                                                          */
/* Install:     Create a desktop object which starts the program '*'.       */
/*              On the Object Settings Notebook Page, change parameter      */
/*              value to '/K <path>\OBJDIR.CMD %*'. Change <path> as        */
/*              required or create an object by running this exec. This     */
/*              Exec must be run from the directory where the files are     */
/*              located.                                                    */
/*                                                                          */
/* System:      OS/2 REXX support must be installed.                        */
/*                                                                          */
/* Copyright:   This utility may be distributed & used free of charge       */
/*              (FREEWARE), as long as all files remain unchanged and are   */
/*              included in this package.                                   */
/*                                                                          */
/*              Any suggestions or comments are welcome. Please send an     */
/*              EMAIL to me at Compuserve 100655,265 or                     */
/*              100655.265@compuserve.com.                                  */
/*                                                                          */
/*              Or just let me know if you are using ObjDir. I am always    */
/*              working on new tools to make life a little easier and a     */
/*              mail always motivates !!!!                                  */
/*                                                                          */
/****************************************************************************/

Trace Off

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

DIR = TRANSLATE(DIRECTORY())
OBJ = "OBJDIR"

CLASS="WPProgram"
TITLE="Object Dir"
LOC="<WP_DESKTOP>"
CONF="EXENAME=CMD.EXE;PARAMETERS=/K "DIR"\"OBJ".CMD %*;ICONFILE="DIR"\"OBJ".ICO"
OPT="U"

CRC = SysCreateObject(CLASS, TITLE, LOC, CONF, OPT)

If (CRC = 1) then
  Say 'Creation ended successfully' 
Else
  Say 'Creation failed with RC: 'CRC 

Exit