/* A REXX program for printing a tree of directories  01/05/95 Ver 1.1  */
/* Written by William M. Comegys II 76226,2747                          */
/* Copywright 1995 William M. Comegys II                                */
/*  Use a spread sheet parse command to break these apart               */
/* This program totals up all files in each directory below the current */
/* And out puts them to the screen or a redirection can be used  > or | */
/*
    Ascnum           String number in bytes for each file
    Dirs             All directorys under the current
    Dtemp            A Holding varable when formating each line of output
    Dtotal           A varable which the number for each indvidule directory is formated and written to the display
    Filebytes        File size in bytes for each file
    Gtotal           Grand total for all files under this directory
    Newfilespec      Appended to the directory is \*.*
    t                Left over from older versions makes Dtotal into an array
    Totaler          Acumulator for files in each directory
*/

/* trace(?I) */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'         /* load extra functions */
call SysLoadFuncs
numeric digits(20)
t = 0
Gtotal = 0
Totaler = 0
C_dir = directory()
call SysFileTree '*.*', 'Dirs', 'ODS'                              /* Get directories  */

do i=1 to Dirs.0                                         /* Loop to get files in each directory          */
    newdir = directory(Dirs.i)
/*    say newdir
    "cd"   */
    Newfilespec = "*.*"                                     /* Append \*.* to the directory             */
    call sysfiletree Newfilespec, 'files', 'f'              /* Get individule files                     */
    Totaler = 0                                              /* Set the Subdirectory size to 0           */

   do j=1 to files.0                                       /* Loop to add up individule file sizes       */
        Ascnum = substr(Files.j, 18, 11)                          /* Add up the byte size for each file  */
        Ascnum =  translate(Ascnum, "0", " " )                    /* Some messing around to convert the bytes size of a files to integer */
        Filebytes = Ascnum * 1
        Totaler=Totaler+Filebytes                                 /* Add up each files size in bytes   */
   end /* do */

     Gtotal = Totaler + Gtotal                                    /* Add up total file size for all directory (not output) */
     t = t + 1
     Dtemp = Insert(Dirs.i, "-",,40,"-")                          /* Puts - expandes to a string length of 40           */
     Totaler = format(Totaler, 13)                                /* Right justifies numbers        */
     Dtotal.t = Insert(Totaler, Dtemp,50,,"-")                    /* Put what is output to the screen in an array */
     say Dtotal.t format(files.0, 7)                              /* Outputs to the screen                 */

end /* do */
C_dir = directory(C_dir)
exit
