/* A REXX program for deleting tempory files                            */
/* Written by William M. Comegys II 76226,2747                          */
/* Copywright 1995 William M. Comegys II                                */
/* This program writes the files to be deleted to the out_file          */
/* Which you can then edit                                              */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'     /* load extra functions */
call SysLoadFuncs

in_file = 'c:\util\dpurge.dat'                                /* Input file with valid file specs
                                                                 examples
                                                                 C:\DATA\MW*.TMP
                                                                 *.BAK
                                                              */

out_file = 'c:\util\dpurge.cmd'                               /* File which the file to be deleted are written to. */

call sysfiledelete out_file                                   /* Delete out_file this is so REXX doesn't append to the file */

/* trace(?I) */

call syscls

do while lines (in_file) > 0
   In_file_data = linein(in_file)

   in_pos = length(In_file_data)                              /* Length of the string comming from the input file */
   if in_pos = 0 then leave ;                                 /* If End Of File leave                       */

    say "Present file tree I'm on is  " In_file_data time()   /* Write inpuut file out to screen            */

     call sysfiletree  In_file_data, 'Delfiles', 'SFO'        /* Read directory of files from disk.         */

   do i=1 to Delfiles.0                                       /* Write files to be deleted out to screen    */
     say Delfiles.i
     Out_data = insert('del ', Delfiles.i)                    /* Append del to the front of the path        */
     result = lineout(out_file, Out_data)
  end
end

exit

