/* $Header:   C:/PROJECT/REXX/MSGDCOMP/PVCS/MSGDCOMP.CMV   1.3   12 Nov 1995 17:11:26   Dennis Bareis  $ */

/*--- Initialization --------------------------------------------------------*/
PgmVersion = "95.316";
NullByte        = '00'x;
CrLf            = '0D0A'x;
FALSE           = 0;
TRUE            = 1;
MyFixDllNoExtn  = 'DB$GMSG'
MyFixDll        = MyFixDllNoExtn || '.DLL';
BlueWarpBugText = 'Probably truncated to 500 bytes by SysGetMessage() bug.';

/*--- Put out startup message -----------------------------------------------*/
say '[]----------------------------------------------------------[]';
say '| MSGDCOMP.CMD Version ' || PgmVersion || ' (C)opyright Dennis Bareis 1995 |';
say '[]----------------------------------------------------------[]';
say '';
say 'All rights reserved.';
say '';
say '';

/*--- Split up the passed argument and display the info ---------------------*/
Args = ARG(1);
PARSE VAR Args InputFile OutputFile MsgPrefix EmptyIfOk;

/*--- Make sure an input file was specified ---------------------------------*/
if  InputFile = "" then
do
   call SyntaxError 'Expected the name of an OS/2 message file (with extension .MSG)', 255;
end;

/*--- Make sure an output file was specified ---------------------------------*/
if  OutputFile = "" then
do
   call SyntaxError 'Expected the name of a file which is to contain the decompiled .MSG text', 254;
end;

/*--- Make sure an output file was specified ---------------------------------*/
if  MsgPrefix = "" then
do
   call SyntaxError 'Expected the message file prefix (3 characters)', 253;
end;
MsgPrefix = translate(MsgPrefix);

/*--- Don't want too many parms! --------------------------------------------*/
if  EmptyIfOk <> "" then
do
   call SyntaxError 'Too many parameters', 252;
end;

/*--- Output the message file prefix ----------------------------------------*/
say 'Creating "' || OutputFile || '"...';
address cmd '@del ' || OutputFile || ' >nul 2>&1';
call lineout OutputFile, MsgPrefix;

/*--- Work out which routine we will use to retrieve messages ---------------*/
call RxFuncAdd  'SysSearchPath', 'RexxUtil', 'SysSearchPath';
FullDllName     = SysSearchPath('PATH', MyFixDll); /* work around to RxFunc? bugs */
if FullDllName <> "" then
do
   /*--- We have located my DLL now register function -----------------------*/
   UseSysGetMessage = 'N';
   call RxFuncAdd  'DbGetMessage', FullDllName, 'DbGetMessage';
end;
else
do
   /*--- Can't find my DLL, oh well into cripple mode -----------------------*/
   UseSysGetMessage = 'Y';
   call RxFuncAdd  'SysGetMessage', 'RexxUtil', 'SysGetMessage';
   say 'WARNING: using "SysGetMessage()" as "' || MyFixDllNoExtn || '" can' || "'t be loaded."
end;

/*--- Loop around trying each message number to try and get text ---*/
FirstMsgInFile          = -1;
LastMsgFoundInFile      = -1;
MissingMessages         = 0;
TotalMessages           = 0;
SysGetMessageTruncation = 0;
ExitRc                  = 0;
do MsgNumber = 0 to 9999
   /*--- Get the message ----------------------------------------------------*/
   if  UseSysGetMessage = 'Y' then
       Message = SysGetMessage(MsgNumber, InputFile);
   else
       Message = DbGetMessage( MsgNumber, InputFile);

   /*--- See if the message existed in the message file or we have an error message ---*/
   if MessageIsInFile(Message, MsgNumber) = TRUE then
   do
       /*--- Output 'filler' messages if required ---------------------------*/
       if  FirstMsgInFile = -1 then
       do
           /*--- Record the 1st message number, no need to fill before it ---*/
           FirstMsgInFile = MsgNumber;
       end;
       else
       do
           /*--- See if we need to fill for 'missing' message numbers -------*/
           if  (MsgNumber-LastMsgFoundInFile) > 1 then
           do
               /*--- Need to fill in ----------------------------------------*/
               do FillNumber = LastMsgFoundInFile+1 to MsgNumber-1
                  MissingMessages = MissingMessages + 1;
                  call lineout OutputFile, MsgPrefix || Get4Digits(FillNumber) || "?: ";
               end;
               call lineout OutputFile, ';';
           end;
       end;
       LastMsgFoundInFile = MsgNumber;

       /*--- Work out message type (adjust message if prompt!) --------------*/
       if  MsgNumberAttached(Message, MsgNumber) then
       do
           /*--- Remove the message number from the message -----------------*/
           Message = substr(Message, 10);

           /*--- This was either a 'W' or 'E' type of message ---------------*/
           MsgType = 'E';


           /*--- We may need to add a "%0" if no CR + LF on end -------------*/
           if  right(Message, 2) <> CrLf then
               Message = Message || '%0' || Crlf;
       end;
       else
       do
           /*--- No message # on message (is this a prompt message?) --------*/
           if  right(Message, 2) = CrLf then
               MsgType = 'I';
           else
           do
               /*--- Must be a prompt message -------------------------------*/
               MsgType = 'P';
               Message = Message || '%0' || Crlf;
           end;
       end;

       /*--- Output the message with the correct prefix etc -----------------*/
       TotalMessages = TotalMessages + 1;
       MessageNumberEtc = MsgPrefix || Get4Digits(MsgNumber) || MsgType || ": ";
       call charout OutputFile, MessageNumberEtc || Message;
       if  UseSysGetMessage = 'Y' then
       do
           /*--- Check for SysGetMessage truncating message -----------------*/
           if  length(Message) = 500 then
           do
               /*--- Message unlikely to be exactly 500 bytes, assume truncated ---*/
               say MessageNumberEtc || BlueWarpBugText || ''
               call lineout OutputFile, ";WARNING: " || BlueWarpBugText;
               SysGetMessageTruncation = SysGetMessageTruncation + 1;
               ExitRc                  = 1;
           end;
       end;
       call lineout OutputFile, ";";
       call lineout OutputFile, ";" || copies("*", 78);
       call lineout OutputFile, ";";
   end;
   else
   do
   end;
end

/*--- Output a summary for the user -----------------------------------------*/
if SysGetMessageTruncation <> 0 then
do
   /*--- Add message to end of generated file about the truncation ----------*/
   call lineout OutputFile, ';';
   call lineout OutputFile, ';*** ' || SysGetMessageTruncation || ' truncated messages in this file ***';
   call lineout OutputFile, ';';

   /*--- Seperate the truncation messages from the summary ------------------*/
   say '';
   say '';
   say 'SUMMARY'
   say '~~~~~~~'
end;
say 'Total # of messages   : ' || TotalMessages;
if MissingMessages <> 0 then
   say 'Missing # of messages : ' || MissingMessages;
say 'First Msg # In File   : ' || FirstMsgInFile;
say 'Last  Msg # In File   : ' || LastMsgFoundInFile;
if SysGetMessageTruncation <> 0 then
   say 'Truncated messages    : ' || SysGetMessageTruncation || ' (warnings as comments in output)';

/*--- Close the file and exit -----------------------------------------------*/
call lineout OutputFile;
call Beep 1300,80;
call Beep 1200,80;
call Beep 1300,80;
exit ExitRc;



/*===========================================================================*/
Get4Digits:
/*                                                                           */
/* ARG(1) = Message #                                                        */
/*===========================================================================*/
   FourDigits = right("000" || arg(1), 4);
   return(FourDigits);


/*===========================================================================*/
MsgNumberAttached:
/*                                                                           */
/* ARG(1) = Message Text                                                     */
/* ARG(2) = Message #                                                        */
/*===========================================================================*/
   /*--- Work out the message # and ':' string ------------------------------*/
   RightPart = Get4Digits(arg(2)) || ': ';

   /*--- Is the above in the correct location -------------------------------*/
   if  substr(arg(1), 4, 6) <> RightPart then
       return(FALSE);

   /*--- See if the prefix the user supplied was correct --------------------*/
   if  substr(arg(1), 1, 3) <> MsgPrefix then
   do
       say 'ERROR: Message file prefix should have been "' || substr(Message, 1, 3) || '"';
       exit 200;
   end;
   return(TRUE);



/*===========================================================================*/
MessageIncludesMsgNumber:
/*                                                                           */
/* ARG(1) = Message Text                                                     */
/* ARG(2) = Message #                                                        */
/*===========================================================================*/
   if mid("cannot", arg(1)) = 0 then
      return(TRUE);
   else
       return(FALSE);


/*===========================================================================*/
MessageIsInFile:
/*                                                                           */
/* ARG(1) = Message Text (may be error message).                             */
/* ARG(2) = Message # used to retrieve the message text.                     */
/*===========================================================================*/
   if  (pos("The system cannot find message  ", arg(1)) <> 0) & (pos(arg(2), arg(1)) <> 0) then
       return(FALSE);          /* Error message saying message can't be loaded! */
   else
       return(TRUE);





/*===========================================================================*/
SyntaxError:
/*===========================================================================*/
        say "[]-----------------------------------------------------------[]";
        say "| MSGDCOMP.CMD, Version " || PgmVersion || " (C)opyright Dennis Bareis 1993 |";
        say "[]-----------------------------------------------------------[]";
        say "";
        say "This program decompiles OS/2 message files.  This allows you to";
        say "see their contents and if you have the TOOLKIT program MKMSGF.EXE";
        say "then you could modify the messages and recompile it!";
        say "";
        say "";
        say "CORRECT SYNTAX:";
        say "~~~~~~~~~~~~~~";
        say "   MSGDCOMP[.CMD] NameOfMsgFile NameOutOutputFile 3CharacterPrefix";
        say "";
        say "THE PROBLEM";
        say "~~~~~~~~~~~";
        Say ARG(1) || "";


        CmdRc = ARG(2); if CmdRc = "" then CmdRc = 255;
        EXIT CmdRc;

