/*
        REXX utility that will search all available drives for OS/2 Online Reference Manuals (.INF files)
        MAKEBOOK.CMD
        Version 2.1  (404 titles supported)
        By: Derek Berube
==============================================================================
  THIS UTILITY IS SHAREWARE.  PLEASE FEEL FREE TO DISTRIBUTE THE ORIGINAL
  MAKEBOOK.ZIP ARCHIVE, UNMODIFIED, TO ANYONE YOU CHOOSE.  PLEASE DO NOT 
  MODIFY AND DISTRIBUTE THIS UTILITY.  IF YOU HAVE ANY SUGGESTIONS, PLEASE
  SEND THEM TO:   DCYBERTEK@AOL.COM  RATHER THAN MODIFYING THE ORIGINAL REXX
  SCRIPT.  THIS WILL HELP ME TO MAINTAIN CONSISTENCY WITH THE REVISION 
  NUMBERS.
==============================================================================
*/
call RxFuncAdd "SysLoadFuncs","RexxUtil","SysLoadFuncs"
call SysLoadFuncs

/* Global Variable Declaration */
        BootDrive = Substr(Value('PATH',,'OS2ENVIRONMENT'),Pos('\OS2\SYSTEM',Value('PATH',,'OS2ENVIRONMENT'))-2,2)
        KnownINF=1      /* used to determine whether or not something is a known INF file */
        NADA=" is not an OS/2 on-line book"
        VERSION='2.1'
        VERSIONDATE='04.14.95'
/* End of Global Variable Declaration */

call SysCls
Title:
Say
Say "OS/2 Online Reference Manual Icon Creator - Version "VERSION
Say "By Derek Berube "VERSIONDATE

Say
Say "Searching the fixed disk for OS/2 Online reference manuals"
/* Append data to logfile if it exists */
rc=LineOut(BootDrive'\OS2\INSTALL\MAKEBOOK.LOG',"******* MakeBook Start "TIME('C')" "DATE('U')" *******")
/* The following line searches the fixed disk for all .INF files and stores the path and filename
 * information in the file matrix.  file.0 is a numerical value  giving the total number of elements
 * in the array. */
/****************************************/
/* Get Drive Information                           */
/* DriveInfo    - stem to store drive information */
/* DriveInfo.0  - number of drives present        */
/* DriveInfo.1..x - drive letters present           */
/****************************************/
/* Get the number of drives on the system */
        Result=SysDriveMap()
        DriveInfo.0=Trunc(length(Result)/3)+1
do temp=1 to DriveInfo.0
   X=pos(':',Result)                    /* Get position of end of 1st drive */
   Y=length(Result)-X                   /* Get length from end of 1st drive to end of Result */
   DriveInfo.temp=DELSTR(Result,x,y)    /* Assign drive letter to DriveInfo */
   Result=DELSTR(Result,1,3)            /* Parse the Result variable */
end /* end do */

do temp=1 to DriveInfo.0 /* DO #1 */
 call SysFileTree driveinfo.temp"\*.INF","file","FS"
 /****************************************************************************************************************************/
 /* Once all the files are found, the following procedure creates the icons in a folder called "MAKEBOOK.CMD - Find Results" */
 /****************************************************************************************************************************/
 if file.0 >0 then  /******************************************************/
                    /* Repeat the following procedure for each file found */
                    /******************************************************/
 do /* DO #2 */
 Say "Making icons for online books found on drive "DriveInfo.temp"..."
 rc=SysCreateObject("WPFolder","MAKEBOOK.CMD - Find Results","<WP_DESKTOP>","OBJECTID=<MAKEBOOK>;","u")
    do i=1 to file.0 /* DO #3 */
      KnownINF=1
      file.i=Translate(file.i)
      BookDate=DELSTR(File.i,9)
      TempSize=DELSTR(File.i,29)
      BookSize=RIGHT(TempSize,(LENGTH(TempSize)-LASTPOS(' ',TempSize)))
      BookPath=Right(File.i,(LENGTH(File.i)-LASTPOS(':',File.i)+2)) 
      BookName=FileSpec("name",BookPath)   /* This line strips the path from the OS/2 file.i string and stores the name of the INF in BookName */
      /*****************************************************/
      /* This section will assign names to know .INF files */
      /*****************************************************/
      FolderTitle=""
      FolderID=""
      Select /* SELECT #1 */
         when BookName="20APR1.INF" then do 
                BookName="OS/2 2.x & Related Product APARS"||"0a"x||"Volume I"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="20APR2.INF" then do
                BookName="OS/2 2.x & Related Product APARS"||"0a"x||"Volume II"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="20APR3.INF" then do
                BookName="OS/2 2.x & Related Product APARS"||"0a"x||"Volume III"
                FolderID="<MB_2XAPARS>"
         end /* do */    
         when BookName="20APR4.INF" then do
                BookName="OS/2 2.x & Related Product APARS"||"0a"x||"Volume VI"
                FolderID="<MB_2XAPARS>"
         end /* do */           
         when BookName="20APR5.INF" then do
                BookName="OS/2 2.x & Related Product APARS"||"0a"x||"Volume V"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="21APR1.INF" then do
                BookName="OS/2 2.x & Related Product APARS"||"0a"x||"2.1 Volume I"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="21APR2.INF" then do
                BookName="OS/2 2.x & Related Product APARS"||"0a"x||"2.1 Volume II"
                FolderID="<MB_2XAPARS>"
         end /* do */    
         when BookName="21APR3.INF" then do
                BookName="OS/2 2.x & Related Product APARS"||"0a"x||"2.1 Volume III"
                FolderID="<MB_2XAPARS>"
         end /* do */    
         when BookName="21APR4.INF" then do
                BookName="OS/2 2.x & Related Product APARS"||"0a"x||"2.1 Volume IV"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="21APR5.INF" then do
                BookName="OS/2 2.x & Related Product APARS"||"0a"x||"2.1 Volume V"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="21APR6.INF"  then do
                BookName="OS/2 2.x & Related Product APARS"||"0a"x||"2.1 Volume VI"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="21APR7.INF"  then do
                BookName="OS/2 2.x & Related Product APARS"||"0a"x||"2.1 Volume VII"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="21APR8.INF"  then do
                BookName="OS/2 2.x & Related Product APARS"||"0a"x||"2.1 Volume VIII"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="21APR9.INF"  then do
                BookName="OS/2 2.x & Related Product APARS"||"0a"x||"2.1 Volume IX"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="21APR10.INF"  then do
                BookName="OS/2 2.x & Related Product APARS"||"0a"x||"2.1 Volume X"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="30APR1.INF" then do
                BookName="OS/2 Warp & Related Product APARS"
                FolderID="<MB_3XAPARS>"
         end  /* Do */
         when BookName="386HPFS.INF"  then do
                BookName="386 HPFS Technical Considerations"
                FolderID="<MB_OPSYS>"
         end /* do */     
         when BookName="4OS2.INF"  then do
                BookName="4-OS/2 Command Shell"||"0a"x||"User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="700.INF" then do
                BookName="700 Series Information"
                FolderID="<MB_HELPCTR>"
         end  /* Do */
         when BookName="A3ALANOR.INF"  then do
                BookName="OS/2 LAN Online Reference (Administrator)"
                FolderID="<MB_LS30>"
         end /* do */     
         when BookName="A3ALANCR.INF"  then do
                BookName="OS/2 LAN Online Reference (Commands)"
                FolderID="<MB_LS30>"
         end /* do */     
         when BookName="ACCC.INF"  then do
                BookName="GUI Controls Reference ACCC (Revision 4)"
                FolderID="<MB_ACCF>"
         end /* do */     
         when BookName="ACCE.INF"  then do
                BookName="Programming Guide (Revision 6)"
                FolderID="<MB_ACCF>"
         end /* do */     
         when BookName="ACCF.INF"  then do
                BookName="Files Component ACCF (Revision 3)"
                FolderID="<MB_ACCF>"
         end /* do */     
         when BookName="ACCG.INF"  then do
                BookName="GUI Component ACCG (Revision 5)"
                FolderID="<MB_ACCF>"
         end /* do */     
         when BookName="ACCI.INF"  then do
                BookName="Interactive Component ACCI (Revision 3)"
                FolderID="<MB_ACCF>"
         end /* do */     
         when BookName="ACCM.INF"  then do
                BookName="Modeling Component ACCM (Revision 6)"
                FolderID="<MB_ACCF>"
         end /* do */     
         when BookName="ACCN.INF"  then do
                BookName="Networking Component ACCN (Revision 1)"
                FolderID="<MB_ACCF>"
         end /* do */     
         when BookName="ACCP.INF"  then do
                BookName="Problem Determination Guide"
                FolderID="<MB_ACCF>"
         end /* do */     
         when BookName="ACCS.INF"  then do
                BookName="Getting Started (Revision 5)"
                FolderID="<MB_ACCF>"
         end /* do */     
         when BookName="ADVISOR.INF"  then do
                BookName="Advisor Reference Guide"
         end /* do */     
         when BookName="AIXLIKE.INF" then do
                BookName="AIXLIKE Version 3.30"
                FolderID="<MB_APPGUIDE>"
         end  /* Do */
         when BookName="APMTDOC.INF" then do
                BookName="Automated PM Tester/Driver (Version 1.8)"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="APPLBK.INF"  then do
                BookName="Application Compatibility"
         end /* do */     
         when BookName="APROGREF.INF" then do
                BookName="APPC Application Suite Programming"
                FolderID="<MB_APPC>"
         end /* do */     
         when BookName="ASDT32.INF"  then do
                BookName="ASDT32 User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="ATD2.INF"  then do
                BookName="ATD/2 for OS/2 2.x"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="AUSERGDE.INF"  then do
                BookName="APPC Application Suite User's Guide"
                FolderID="<MB_APPC>"
         end /* do */     
         when BookName="BACHVIEW.INF" then do
                BookName="Backman/Viewer User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */
         when BookName="BATHROOM.INF" then do
                BookName="Bathroom Humor"
                FolderID="<MB_FUNNY>"
         end /* do */     
         when BookName="BBS.INF"  then do
                BookName="TSG Bulletin Board System (BBS)"
                FolderID="<MB_HELPCTR>"
         end /* do */     
         when BookName="BBSFILES.INF"  then do
                BookName="IBM NSC BBS Files Available for Download"
                FolderID="<MB_HELPCTR>"
         end /* do */     
         when BookName="BBSLIST.INF"  then do
                BookName="The IBM PCC Bulliten Board File Listing"
                FolderID="<MB_HELPCTR>"
         end /* do */     
         when BookName="BC.INF"  then do
                BookName="Borland C++ for OS/2 Online Help"
                FolderID="<MB_BCOS2>"
         end /* do */     
         when BookName="BKMTAGS.INF"  then do
                BookName="BookMaster Online Reference"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="BM2IPF.INF"  then do
                BookName="BM2IPF User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="BMHLP03.INF"  then do
                BookName="BackMaster On-line Help"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="C-FAQ.INF"  then do
                BookName="C-FAQ: Common Q&A for C Programming"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="CFGTOOL.INF"  then do
                BookName="CfgTool for OS/2 User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="CHKSTORE.INF"  then do
                BookName="CHKSTORE User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="CM2MEDIC.INF"  then do
                FolderName="CM/2"
                FolderID="<MB_CM2>"
         end /* do */     
         when BookName="CMAPR1.INF"  then do
                BookName="Communications Manager /2 APARs"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="CMCMDREF.INF"  then do
                BookName="CM/2 Command Reference"
                FolderID="<MB_CM2>"
         end /* do */     
         when BookName="CMDREF.INF"  then do
                Select
                   when BookSize="472318" then do
                      BookName="PC-DOS 7 Command Reference"
                      FolderID="<MB_OPSYS>"
                   end  /* Do */
                   when BookSize="469247" then do
                      BookName="OS/2 Warp v3 Command Reference"
                      FolderID="<MB_OPSYS>"
                   end  /* Do */
                otherwise do
                   BookName="OS/2 Command Reference"
                   FolderID="<MB_OPSYS>"
                end /* Do */
                end  /* select */
         end /* do */     
         when BookName="CMMSGREF.INF"  then do
                BookName="CM/2 Message Reference"
                FolderID="<MB_CM2>"
         end /* do */     
         when BookName="COLORS.INF" then do
                BookName="Common Color Names and RGB Values"
         end  /* Do */
         when BookName="COM.INF"  then do
                BookName="Serial Communications and OS/2 2.x"
         end /* do */     
         when BookName="COMPPM.INF"  then do
                BookName="CompPM User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="COMPRESS.INF"  then do
                BookName="COMPRESS and BACKSTH USer's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="CONTACT.INF"  then do
                BookName="Contact List for Help Desk"
                FolderID="<MB_BUFFER>"
         end /* do */     
         when BookName="CONQUEST.INF"  then do
                BookName="Solar Conquest Player's Guide"
                FolderName="Application User's Guides"
                FolderID="<MB_GAMES>"
         end /* do */     
         when BookName="CPICRC.INF"  then do
                BookName="CPI-C Return Codes, A Practical Guide"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="CPGREF1.INF"  then do
                BookName="Control Program Guide and Reference"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="CPGREF2.INF" then do
                BookName="Control Program Guide and Reference Part 2"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="CPGREF3.INF"  then do
                BookName="Control Program Guide and Reference Part 3"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="CRACKS.INF"  then do
                BookName="Cracks"
                FolderID="<MB_GAMES>"
         end /* do */     
         when BookName="CV2SAMPS.INF"  then do
                BookName="Client Views/2 Sample Programs Cross-Reference"
                FolderID="<MB_CVIEWS>"
         end /* do */     
         when BookName="CV2SRC.INF"  then do
                BookName="Client Views/2 Library Cross-Reference"
                FolderID="<MB_CVIEWS>"
         end /* do */     
         when BookName="CYBERLNK.INF"  then do
                BookName="CyberLink"
                FolderID="<MB_MAGAZINE>"
         end /* do */     
         when BookName="CYBERTIP.INF"  then do
                BookName="CyberTips"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="CYBERTOO.INF"  then do
                BookName="CyberToo: Companion to CyberTips"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="DBAPR1.INF"  then do
                BookName="Database2 for OS/2 (DB2/2) APARs"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="DBCMREF.INF"  then do
                BookName="DB2/2 Command Reference"
                FolderID="<MB_DB2>"
         end /* do */     
         when BookName="DBMINDEX.INF"  then do
                BookName="DB2/2 Master Index"
                FolderID="<MB_DB2>"
         end /* do */     
         when BookName="DBMSG.INF"  then do
                BookName="Database Manager Messages"||"0a"x||"(or) DB2/2 Messages"
                FolderID="<MB_DB2>"
         end /* do */     
         when BookName="DBOXMGR2.INF"  then do
                BookName="dBoxMgr2 A PM Dialog Box Manager version 2.19"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="DDE3LIB.INF"  then do
                BookName="IBM Library Manager Reference"
                FolderID="<MB_CSET>"
         end /* do */     
         when BookName="DDE3LTT.INF"  then do
                BookName="IBM Library Manager Tutorial"
                FolderID="<MB_CSET>"
         end /* do */     
         when BookName="DDE3TT1E.INF"  then do
                BookName="IBM WorkFrame/2 Tutorial"
                FolderID="<MB_WF2>"
         end /* do */     
         when BookName="DDE3TUT.INF"  then do
                BookName="IBM WorkFrame/2 Tutorial"
                FolderID="<MB_WF2>"
         end /* do */     
         when BookName="DDE3WF.INF"  then do
                BookName="IBM WorkFrame/2 Reference"
                FolderID="<MB_WF2>"
         end /* do */     
         when BookName="DDE4ASCL.INF"  then do
                BookName="C/C++ FirstStep Tools: Application Support"
                FolderID="<MB_CSET>"
         end /* do */     
         when BookName="DDE4BTUT.INF"  then do
                BookName="IBM C/C++ Tools: Browser Tutorial"
                FolderID="<MB_CSET>"
         end /* do */     
         when BookName="DDE4CCL.INF"  then do
                BookName="C/C++ Tools"||"0a"x||"Collection Class Library Reference"
                FolderID="<MB_CSET>"
         end /* do */     
         when BookName="DDE4CLIB.INF"  then do
                BookName="IBM C/C++ Tools"||"0a"x||"C Library Reference"
                FolderID="<MB_CSET>"
         end /* do */     
         when BookName="DDE4LRM.INF"  then do
                BookName="IBM C/C++ Tools"||"0a"x||"Online Language Reference"
                FolderID="<MB_CSET>"
         end /* do */     
         when BookNAme="DDE4SCL.INF"  then do
                BookName="IBM C/C++ Tools"||"0a"x||"Standard Class Library Reference"
                FolderID="<MB_CSET>"
         end /* do */     
         when BookName="DDE4TMST.INF"  then do
                BookName="IBM C/C++ Debugger Tutorial"
                FolderID="<MB_CSET>"
         end /* do */     
         when BookName="DDE4UIL.INF"  then do
                BookName="User Interface Class Library Reference"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="DDE4UTIL.INF"  then do
                BookName="IBM C/C++ Tools"||"0a"x||"Compiler Utilities Reference"
                FolderID="<MB_CSET>"
         end /* do */     
         when BookName="DIRTOOLS.INF"  then do
                BookName="DirTools - OS/2 Directory Tools"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="DMAN.INF"  then do
                BookName="DeskMan/2 User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="DMMAIL.INF"  then do
                BookName="DMMail Version 1.3 User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="DOSERROR.INF" then do
                BookName="PC-DOS 7 Error Messages"
                FolderID="<MB_OPSYS>"
         end  /* Do */
         when BookName="DOSREXX.INF" then do
                BookName="PC-DOS 7 REXX Reference"
                FolderID="<MB_REXX>"
         end  /* Do */
         when BookName="DRCYBER.INF" then do
                BookName="Dr. Cybertek"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="DRDIALOG.INF"  then do
                BookName="Dr. Dialog Reference"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="DRM.INF"  then do
                BookName="DRM Technical and Warranty Support Plan"
                FolderID="<MB_HELPCTR>"
         end /* do */     
         when BookName="DSCDATEC.INF" then do
                BookName="DSCDATE online reference guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */
         when BookName="DSN93A.INF"  then do
                BookName="IBM PSP Developer Support News 1993 - Issue 1"
                FolderID="<MB_DSN93>"
         end /* do */     
         when BookName="DSN93B.INF"  then do
                BookName="IBM PSP Developer Support News 1993 - Issue 2"
                FolderID="<MB_DSN93>"
         end /* do */     
         when BookName="DSN93C.INF"  then do
                BookName="IBM PSP Developer Support News 1993 - Issue 3"
                FolderID="<MB_DSN93>"
         end /* do */     
         when BookName="DSN93D.INF"  then do
                BookName="IBM PSP Developer Support News 1993 - Issue 4"
                FolderID="<MB_DSN93>"
         end /* do */     
         when BookName="DSN93E.INF"  then do
                BookName="IBM PSP Developer Support News 1993 - Issue 5"
                FolderID="<MB_DSN93>"
         end /* do */     
         when BookName="DSN93F.INF"  then do
                BookName="IBM PSP Developer Support News 1993 - Issue 6"
                FolderID="<MB_DSN93>"
         end /* do */     
         when BookName="DSN93G.INF"  then do
                BookName="IBM PSP Developer Support News 1993 - Issue 7"
                FolderID="<MB_DSN93>"
         end /* do */     
         when BookName="DSN93H.INF"  then do
                BookName="IBM PSP Developer Support News 1993 - Issue 8"
                FolderID="<MB_DSN93>"
         end /* do */     
         when BookName="DSN93I.INF"  then do
                BookName="IBM PSP Developer Support News 1993 - Issue 9"
                FolderID="<MB_DSN93>"
         end /* do */     
         when BookName="DSN94A.INF"  then do
                BookName="IBM PSP Developer Support News 1994 - Issue 1"
                FolderID="<MB_DSN94>"
         end /* do */     
         when BookName="DSN94B.INF"  then do
                BookName="IBM PSP Developer Support News 1994 - Issue 2"
                FolderID="<MB_DSN94>"
         end /* do */     
         when BookName="DSN94C.INF"  then do
                BookName="IBM PSP Developer Support News 1994 - Issue 3"
                FolderID="<MB_DSN94>"
         end /* do */     
         when BookName="DSN94D.INF"  then do
                BookName="IBM PSP Developer Support News 1994 - Issue 4"
                FolderID="<MB_DSN94>"
         end /* do */     
         when BookName="DSN94E.INF"  then do
                BookName="IBM PSP Developer Support News 1994 - Issue 5"
                FolderID="<MB_DSN94>"
         end /* do */     
         when BookName="DSN94F.INF"  then do
                BookName="IBM PSP Developer Support News 1994 - Issue 6"
                FolderID="<MB_DSN94>"
         end /* do */     
         when BookName="DSN94G.INF"  then do
                BookName="IBM PSP Developer Support News 1994 - Issue 7"
                FolderID="<MB_DSN94>"
         end /* do */     
         when BookName="DSN94H.INF"  then do
                BookName="IBM PSP Developer Support News 1994 - Issue 8"
                FolderID="<MB_DSN94>"
         end /* do */     
         when BookName="DSN94I.INF"  then do
                BookName="IBM PSP Developer Support News 1994 - Issue 9"
                FolderID="<MB_DSN94>"
         end /* do */     
         when BookName="DSN94J.INF" then do
                BookName="IBM PSP Developer Support News 1994 - Issue 10"
                FolderID="<MB_DSN94>"
         end /* do */     
         when BookName="DSN94K.INF" then do
                BookName="IBM PSP Developer Support News 1994 - Issue 11"
                FolderID="<MB_DSN94>"
         end /* do */     
         when BookName="DSN94L.INF" then do
                BookName="IBM PSP Developer Support News 1994 - Issue 12"
                FolderID="<MB_DSN94>"
         end /* do */     
         when BookName="DSN94M.INF" then do
                BookName="IBM PSP Developer Support News 1994 - Issue 13"
                FolderID="<MB_DSN94>"
         end /* do */
         when BookName="DSN95A.INF" then do
                BookName="IBM PSP Developer Support News 1995 - Issue 1"
                FolderID="<MB_DSN95>"
         end  /* Do */
         when BookName="DSN95B.INF" then do
                BookName="IBM PSP Developer Support News 1995 - Issue 2"
                FolderID="<MB_DSN95>"
         end  /* Do */
         when BookName="DSN95C.INF" then do
                BookName="IBM PSP Developer Support News 1995 - Issue 3"
                FolderID="<MB_DSN95>"
         end  /* Do */
         when BookName="DSN95D.INF" then do
                BookName="IBM PSP Developer Support News 1995 - Issue 4"
                FolderID="<MB_DSN95>"
         end  /* Do */
         when BookName="DSN95E.INF" then do
                BookName="IBM PSP Developer Support News 1995 - Issue 5"
                FolderID="<MB_DSN95>"
         end  /* Do */
         when BookName="DSN95F.INF" then do
                BookName="IBM PSP Developer Support News 1995 - Issue 6"
                FolderID="<MB_DSN95>"
         end  /* Do */
         when BookName="DSN95G.INF" then do
                BookName="IBM PSP Developer Support News 1995 - Issue 7"
                FolderID="<MB_DSN95>"
         end  /* Do */
         when BookName="DSN95H.INF" then do
                BookName="IBM PSP Developer Support News 1995 - Issue 8"
                FolderID="<MB_DSN95>"
         end  /* Do */
         when BookName="DSN95I.INF" then do
                BookName="IBM PSP Developer Support News 1995 - Issue 9"
                FolderID="<MB_DSN95>"
         end  /* Do */
         when BookName="DSN95J.INF" then do
                BookName="IBM PSP Developer Support News 1995 - Issue 10"
                FolderID="<MB_DSN95>"
         end  /* Do */
         when BookName="DSN95K.INF" then do
                BookName="IBM PSP Developer Support News 1995 - Issue 11"
                FolderID="<MB_DSN95>"
         end  /* Do */
         when BookName="DSN95L.INF" then do
                BookName="IBM PSP Developer Support News 1995 - Issue 12"
                FolderID="<MB_DSN95>"
         end  /* Do */
         when BookName="DSN95M.INF" then do
                BookName="IBM PSP Developer Support News 1995 - Issue  "
                FolderID="<MB_DSN95>"
         end  /* Do */
         when BookName="DXT25REF.INF"  then do
                BookName="DXT Reference"
         end /* do */     
         when BookName="EBOOKIE.INF"  then do
                BookName="EBOOKIE2 Version 2.2 User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */
         when BookName="EHSA7MST.INF" then do
                BookName="Search Manager/2: Retrieval and Indexing"
                FolderID="<MB_APPGUIDE>"
         end  /* Do */
         when BookName="EMTFORPM.INF" then do
                BookName="Help for EMTFORPM Program"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="EPMTECH.INF"  then do
                BookName="EPM Technical Reference"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="EPMUSERS.INF"  then do
                BookName="Enhanced Editor User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="ESAPR1.INF"  then do
                BookName="Extended Services APARs"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="ETKE.INF"  then do
                BookName="Programmer's Guide to E Editor Toolkit 2.0"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="EVFCLMST.INF"  then do
                BookName="OS/400 Control Language Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="EXCAL.INF"  then do
                BookName="CUA Calendar Example"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="EXCEPT.INF"  then do
                BookName="Except Package"
         end /* do */     
         when BookName="FLG.INF"  then do
                BookName="Freelance Graphics for OS/2 2.0"||"0a"x||"Release Notes"
                FolderID="<MB_APPGUIDE>"
         end /* do */
         when BookName="FMOS2.INF" then do
                BookName="File Manager for OS/2"
                FolderID="<MB_APPGUIDE>"
         end  /* Do */
         when BookName="FUNNY.INF"  then do
                BookName="The Compendium of All Things Funny"
                FolderID="<MB_FUNNY>"
         end /* do */     
         when BookName="FUNNY195.INF" then do
                BookName="The Compendium of All Things Funny (1/95)"
                FolderID="<MB_FUNNY>"
         end  /* Do */
         when BookName="FUNNY295.INF" then do
                BookName="The Compendium of All Things Funny (2/95)"
                FolderID="<MB_FUNNY>"
         end  /* Do */
         when BookName="FUNNY395.INF" then do
                BookName="The Compendium of All Things Funny (3/95)"
                FolderID="<MB_FUNNY>"                         
         end  /* Do */
         when BookName="FUNNY495.INF" then do
                BookName="The Compendium of All Things Funny (4/95)"
                FolderID="<MB_FUNNY>"
         end  /* Do */
         when BookName="FUNNY595.INF" then do
                BookName="The Compendium of All Things Funny (5/95)"
                FolderID="<MB_FUNNY>"
         end  /* Do */
         when BookName="FUNNY695.INF" then do
                BookName="The Compendium of All Things Funny (6/95)"
                FolderID="<MB_FUNNY>"
         end  /* Do */
         when BookName="FUNNY795.INF" then do
                BookName="The Compendium of All Things Funny (7/95)"
                FolderID="<MB_FUNNY>"
         end  /* Do */
         when BookName="FUNNY895.INF" then do
                BookName="The Compendium of All Things Funny (8/95)"
                FolderID="<MB_FUNNY>"
         end  /* Do */
         when BookName="FUNNY995.INF" then do
                BookName="The Compendium of All Things Funny (9/95)"
                FolderID="<MB_FUNNY>"
         end  /* Do */
         when BookName="FUNNY095.INF" then do
                BookName="The Compendium of All Things Funny (10/95)"
                FolderID="<MB_FUNNY>"
         end  /* Do */
         when BookName="FUNNYA95.INF" then do
                BookName="The Compendium of All Things Funny (11/95)"
                FolderID="<MB_FUNNY>"
         end  /* Do */
         when BookName="FUNNYB95.INF" then do
                BookName="The Compendium of All Things Funny (12/95)"
                FolderID="<MB_FUNNY>"
         end  /* Do */
         when BookName="GALLERCM.INF" then do
                BookName="Galleria/CM"
                FolderID="<MB_APPGUIDE>"
         end  /* Do */
         when BookName="GALLERIA.INF"  then do
                BookName="Galleria User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="GAMMA.INF"  then do
                BookName="Gamma Tech Utilities"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="GG243070.INF" then do
                BookName="Bibliography of Redbook Documents"
                FolderID="<MB_REDBOOK>"
         end  /* Do */
         when BookName="GG243730.INF"  then do
                BookName="OS/2 Redbook"||"0a"x||"Volume 1 Control Program"
                FolderID="<MB_REDBOOK>"
         end /* do */     
         when BookName="GG243731.INF"  then do
                BookName="OS/2 Redbook"||"0a"x||"Volume 2 DOS and Windows Settings"
                FolderID="<MB_REDBOOK>"
         end /* do */     
         when BookName="GG243732.INF"  then do
                BookName="OS/2 Redbook"||"0a"x||"Volume 3 PM and Workplace Shell"
                FolderID="<MB_REDBOOK>"
         end /* do */     
         when BookName="GG243774.INF"  then do
                BookName="OS/2 Redbook"||"0a"x||"Volume 4 Application Development"
                FolderID="<MB_REDBOOK>"
         end /* do */     
         when BookName="GG243775.INF"  then do
                BookName="OS/2 Redbook"||"0a"x||"Volume 5 Print Subsystem"
                FolderID="<MB_REDBOOK>"
         end /* do */     
         when BookName="GG243948.INF"  then do
                BookName="IBM 2.1 Technical Update"
                FolderID="<MB_REDBOOK>"
         end /* do */     
         when BookName="GG244199.INF"  then do
                BookName="IBM REXX"
                FolderID="<MB_REDBOOK>"
         end /* do */     
         when BookName="GG244201.INF"  then do
                BookName="OS/2 Configurations: Cracking the Workplace"
                FolderID="<MB_REDBOOK>"
         end /* do */     
         when BookName="GG244212.INF"  then do
                BookName="OS/2 2.11 and Updates to OS/2 2.1"
                FolderID="<MB_REDBOOK>"
         end /* do */     
         when BookName="GG244213.INF"  then do
                BookName="OS/2 2.1 National Language Support"
                FolderID="<MB_REDBOOK>"
         end /* do */     
         when BookName="GML2RTF.INF"  then do
                BookName="TDOXX Application - GML Starter Set to RTF"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="GPADEN.INF"  then do
                BookName="Help for GraphPad Program"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="GPADFR.INF"  then do
                BookName="Aide du programme Graphpad"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="GQFGUIDE.INF"  then do
                BookName="GDDM-OS/2 Link"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="GUIREF20.INF"  then do
                BookName="Control Program Reference"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="GUPLOAD.INF"  then do
                BookName="Using Graphics Upload (GUPLOAD)"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="HDBV.INF"  then do
                BookName="HDBV - Help"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="HELPTIPS.INF"  then do
                BookName="HelpCenter Tips and Techniques"
                FolderID="<MB_HELPCTR>"
         end /* do */     
         when BookName="HIDECMD.INF"  then do
                BookName="HIDECMD Documentation"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="HLYGRAIL.INF"  then do
                BookName="Monty Python and The Holy Grail"
                FolderID="<MB_FUNNY>"
         end /* do */     
         when BookName="HUMOR.INF"  then do
                BookName="Humor in Support"
                FolderID="<MB_FUNNY>"
         end /* do */     
         when BookName="HYPERWRT.INF"  then do
                BookName="HyperWrite/E"||"0a"x||"User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */
         when BookName="I18N.INF" then do
                BookName="I18N Internationalization Package for OS/2"
                FolderID="<MB_APPGUIDE>"
         end  /* Do */
         when BookName="ICPACDN.INF"  then do
                BookName="Help for ICPA Program (Canadian Version)"
                FolderID="<MB_ICPA>"
         end /* do */     
         when BookName="IFS.INF"  then do
                BookName="OS/2 Installable File Systems"
                FolderID="<MB_OPSYS>"
         end /* do */     
         when BookName="INEWS001.INF"  then do
                BookName="Idle News No.1 July 1991"
                FolderID="<MB_MAGAZINE>"
         end /* do */     
         when BookName="INSTALL.INF"  then do
                BookName="Application Installation Overview"
         end /* do */     
         when BookName="IPF.INF"  then do
                BookName="Information Presentation Facility Sample"
                FolderID="<MB_IPFC>"
         end /* do */     
         when BookName="IPFC20.INF"  then do
                BookName="IPFC Reference"
                FolderID="<MB_IPFC>"
         end /* do */     
         when BookName="IPFCEXMP.INF"  then do
                BookName="IPFC Examples"
                FolderID="<MB_IPFC>"
         end /* do */     
         when BookName="IPFGUIDE.INF"  then do
                BookName="Getting Started With IPF"
                FolderID="<MB_IPFC>"
         end /* do */     
         when BookName="KDEBUG.INF"  then do
                BookName="Debug Kernel Reference"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="KDVL2MST.INF" then do
                BookName="IBM TCP/IP 2.0 for OS/2: Command Reference"
                FolderID="<MB_APPGUIDE>"
         end  /* Do */
         when BookName="KILLER4.INF"  then do
                BookName="Help for Killer4 Program (BUFFER)"
                FolderID="<MB_BUFFER>"
         end /* do */     
         when BookName="LANCRUIS.INF" then do
                BookName="LAN Cruiser User's Guide"
                FolderID="<MB_APPGUIDE>"
         end  /* Do */
         when BookName="LAUNCH.INF"  then do
                BookName="Launching Objects on the OS/2 Desktop"
         end /* do */     
         when BookName="LOADRAM2.INF"  then do
                BookName="LoadRAM User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="LOAN.INF" then do
                BookName="Loan Repayments Calculator Help"
                FolderID="<MB_APPGUIDE>"
         end  /* Do */
         when BookName="LOTUS123.INF"  then do
                BookName="1-2-3 for OS/2 2.0"||"0a"x||"Release Notes"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="LOTUSFLG.INF"  then do
                BookName="Freelance Graphics for OS/2 2.0"||"0a"x||"Release Notes"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="LPEX.INF"  then do
                BookName="LPEX Reference"
                FolderID="<MB_LPEX>"
         end /* do */     
         when BookName="LPXCREF.INF" then do
                BookName="LPEX Command Reference"
                FolderID="<MB_LPEX>"
         end  /* Do */
         when BookName="LPEXPROG.INF"  then do
                BookName="LPEX Programming Guide"
                FolderID="<MB_LPEX>"
         end /* do */     
         when BookName="LS30UTIL.INF"  then do
                BookName="IBM LAN Server 3.0 REXX Utility DLL"
                FolderID="<MB_LS30>"
         end /* do */     
         when BookName="LS30UTNF.INF"  then do
                BookName="IBM LAN Server 3.0 REXX Utility DLL"
                FolderID="<MB_LS30>"
         end /* do */     
         when BookName="LSAPR1.INF"  then do
                BookName="LAN Server 2.0 and 3.0 APARs"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="LS40ADML.INF" then do
                BookName="IBM OS/2 LAN Server 4.0 Administrator Tasks"
                FolderID="<MB_LS40>"
         end  /* Do */
         when BookName="LS40USRL.INF" then do
                BookName="IBM OS/2 LAN Server 4.0 User Tasks"
                FolderID="<MB_LS40>"
         end  /* Do */
         when BookName="LSREF.INF"  then do
                BookName="LAN Server 3.0 Reference Collection"
                FolderID="<MB_LS30>"
         end /* do */     
         when BookName="LXGFC.INF"  then do
                BookName="LPEX GFC Help/Book"
                FolderID="<MB_LPEX>"
         end /* do */     
         when BookName="LXQUICK.INF"  then do
                BookName="LPEX 'Quick' Command"
                FolderID="<MB_LPEX>"
         end /* do */     
         when BookName="LXSPELL.INF"  then do
                BookName="LXSpell - Information"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="MAKEDOCS.INF"  then do
                BookName="MakeDocs Document Conversion Program"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="MANUALS.INF"  then do
                BookName="Game Manuals"
                FolderID="<MB_GAMES>"
         end /* do */     
         when BookName="MCICPP.INF"  then do
                BookName="MCI Class Library"
         end /* do */     
         when BookName="MCIREXX.INF"  then do
                BookName="MultiMedia REXX"
                FolderID="<MB_REXX>"
         end /* do */     
         when BookName="MEMORY.INF"  then do
                BookName="Blake Payne's"||"0a"x||"Memory Management Handbook"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="MMAPR1.INF"  then do
                BookName="MMPM/2 Ver 1.1 APARs"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="MOUINF.INF"  then do
                BookName="Pointing Devices and OS/2 2.x (3/3/94)"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="MOUSE.INF"  then do
                BookName="OS/2 2.x, Pointing Devices - Hints and Tips"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="MR1INFO.INF"  then do
                BookName="OS/2 2.1 CSD XR06200"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="MULTIMBK.INF"  then do
                BookName="Multimedia"
         end /* do */     
         when BookName="NOTETAKR.INF"  then do
                BookName="NoteTaker Online Help"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="NSCBOOKS.INF"  then do
                BookName="Technical Support Group On-Line Books"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="NSCDATA.INF"  then do
                BookName="NSC Database"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="NSCPROC.INF"  then do
                BookName="NSC Procedures Reference"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="NTAPR1.INF"  then do
                BookName="NTS/2 APARs"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="NWAPR1.INF"  then do
                BookName="Netware Requester for OS/2 2.x APARs"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="NZMOBILE.INF" then do
                BookName="IBM New Zealand Moblie Workstation Guide"
         end  /* Do */
         when BookName="OMNIBASE.INF"  then do
                BookName="OmniBase by Mike Williams"
                FolderID="<MB_DATABASE>"
         end /* do */
         when BookName="OPENDOOR.INF" then do
                BookName="Open NetDoor Help"
                FolderID="<MB_APPGUIDE>"
         end /* do */
         when BookName="OPSYS.INF"  then do
                BookName="Operating Systems Reference v1.00"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="OPSYSDAT.INF"  then do
                BookName="Operating Systems Database"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="OPSYSDOS.INF"  then do
                BookName="DOS Database"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="OPSYSOS2.INF"  then do
                BookName="OS/2 Database"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="OMF.INF"  then do
                BookName="IBM OS/2 16/32-bit Object Module Format (OMF) a"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="OPSYSREF.INF"  then do
                BookName="Operating Systems Reference and Tutorial"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="OPSYSTRN.INF"  then do
                BookName="Operating Systems Training Manual"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="ORYXSR.INF"  then do
                BookName="Oryx System Reference"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="OS211DOC.INF" then do 
                BookName="OS/2 2.1 Update"
                FolderID="<MB_OPSYS>"
         end /* do */     
         when BookName="OS2APAR1.INF"  then do
                BookName="OS/2 2.x & Related Products Vol. 1"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="OS2APAR2.INF"  then do
                BookName="OS/2 2.x & Related Products Vol. 2"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="OS2APAR3.INF"  then do
                BookName="OS/2 2.x & Related Products Vol. 3"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="OS2APAR4.INF"  then do
                BookName="OS/2 2.x & Related Products Vol. 4"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="OS2APAR5.INF"  then do
                BookName="OS/2 2.x & Related Products Vol. 5"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="OS2APAR6.INF"  then do
                BookName="OS/2 2.x & Related Products Vol. 6"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="OS2APAR7.INF"  then do
                BookName="OS/2 2.x & Related Products Vol. 7"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="OS2APAR8.INF"  then do
                BookName="OS/2 2.x & Related Products Vol. 8"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="OS2FAQ.INF"  then do
                BookName="OS/2 FAQ List: User's Edition (4 Apr 94)"
                FolderID="<MB_OPSYS>"
         end /* do */     
         when BookName="OS2IMAGE.INF"  then do
                BookName="OS/2 Programmer's Guide to Image Formats"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="OS2PART1.INF"  then do
                BookName="OS/2 Database Part 1"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="OS2PART2.INF" then do 
                BookName="OS/2 Database Part 2"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="OS2PING.INF"  then do
                BookName="OS2PING Help File"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="OS2SPUFI.INF"  then do
                BookName="OS2SPUFI Version 1.09"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="OS2TECHG.INF"  then do
                BookName="A Technical Guide to OS/2 2.0"
                FolderID="<MB_OPSYS>"
         end /* do */     
         when BookName="OS2TNT.INF"  then do
                BookName="OS/2 Tips and Techniques"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="OTM.INF"  then do
                BookName="Object Test Monitor (OTM) User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="OVERVIEW.INF"  then do
                BookName="CM/2 Overview"
                FolderID="<MB_CM2>"
         end /* do */     
         when BookName="PCMCIA.INF"  then do
                BookName="PCMCIA Tips"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="PCPRINT.INF"  then do
                BookName="PCPRINT User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="PE-PLX.INF"  then do
                BookName="PE-PL/x On-Line Help"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="PERFBK.INF"  then do
                BookName="System Performance"
         end /* do */     
         when BookName="PHONE.INF"  then do
                BookName="Phone List"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="PIPE.INF"  then do
                BookName="OS/2 Pipelines"
         end /* do */     
         when BookName="PIPE_DEV.INF" then do
                BookName="OS/2 Pipeline Stage Developer's Documentation"
                FolderID="<MB_PROGRAMMING>"
         end  /* Do */
         when BookName="PKTCAL2.INF"  then do
                BookName="Pocket Calendar/2"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="PKZIP.INF"  then do
                BookName="PKZip Reference Manual"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="PLOT.INF"  then do
                BookName="Plot made easy"
         end /* do */     
         when BookName="PM.INF" then do
                BookName="Introduction to PM Programming"
                FolderID="<MB_PROGRAMMING>"
         end  /* Do */
         when BookName="PMCOMM.INF"  then do
                BookName="PM Comm User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="PMDPROFS.INF"  then do
                BookName="PMDPROFS: A PM Diary <-> PROFS Calendar"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="PMFUN.INF"  then do
                BookName="PM Reference"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="PMGPI.INF"  then do
                BookName="PM Reference: Graphics Functions"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="PMHOK.INF"  then do
                BookName="PM Reference: Graphics Orders"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="PMI.INF" then do
                BookName="IBM Project Management Integrator Help"
                FolderID="<MB_APPGUIDE>"
         end  /* Do */
         when BookName="PMMSG.INF"  then do
                BookName="PM Reference: Message Processing"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="PMPROCS.INF" then do
                BookName="OS/2 PM Code Snippets"
                FolderID="<MB_PROGRAMMING>"
         end  /* Do */
         when BookName="PMREL.INF"  then do
                BookName="PM Reference: Miscellaneous Reference"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="PMSW.INF"  then do
                BookName="PMSW - Switch Focus to Application by Name"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="PMWIN.INF"  then do
                BookName="PM Reference: Window Functions"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="PMWKP.INF"  then do
                BookName="PM Reference: Workplace"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="PRCP0A.INF"  then do
                BookName="Images for Help for ICPA Program (PS Version) A"
                FolderID="<MB_ICPA>"
         end /* do */     
         when BookName="PRCP0M.INF"  then do
                BookName="Images for Help for ICPA Program (PS Version) M"
                FolderID="<MB_ICPA>"
         end /* do */     
         when BookName="PRCP0P.INF"  then do
                BookName="Images for Help for ICPA Program (PS Version) P"
                FolderID="<MB_ICPA>"
         end /* do */     
         when BookName="PRCP0W.INF"  then do
                BookName="Images for Help for ICPA Program (PS Version) W"
                FolderID="<MB_ICPA>"
         end /* do */     
         when BookName="PRCPFAX.INF"  then do
                BookName="HelpFax Reference"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="PRCPFEAT.INF"  then do
                BookName="Features & Benefits - IBM Personal Systems"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="PRCPTEK.INF"  then do
                BookName="Technical Reference - IBM Personal Systems"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="PRINTBK.INF"  then do
                BookName="Printing in OS/2"
         end /* do */     
         when BookName="PROGREF.INF"  then do
                BookName="Programming Reference Generator"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="PS2A_GEN.INF"  then do
                BookName="IBM PS General Assistant"
                FolderID="<MB_PSASST>"
         end /* do */     
         when BookName="PS2A_MKT.INF"  then do
                BookName="IBM PS Marketing Assistant"
                FolderID="<MB_PSASST>"
         end /* do */     
         when BookName="PS2A_SVC.INF"  then do
                BookName="IBM PS Service Assistant"
                FolderID="<MB_PSASST>"
         end /* do */     
         when BookName="PS2A_TEC.INF"  then do
                BookName="IBM PS Technical Assistant"
                FolderID="<MB_PSASST>"
         end /* do */     
         when BookName="PS1A_TSP.INF"  then do
                BookName="IBM PS Tech Specs Assistant #1"
                FolderID="<MB_PSASST>"
         end /* do */     
         when BookName="PS2A_TSP.INF"  then do
                BookName="IBM PS Tech Specs Assistant #2"
                FolderID="<MB_PSASST>"
         end /* do */     
         when BookName="PS2A_TTL.INF"  then do
                BookName="PS/2 Assistant"
                FolderID="<MB_PSASST>"
         end /* do */     
         when BookName="PSNS.INF"  then do
                BookName="PSnS 2.10"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="PSPSTR2.INF"  then do
                BookName="PSP Strategy Document 2"
                FolderID="<MB_BUFFER>"
         end /* do */     
         when BookName="PSPSTRAT.INF"  then do
                BookName="PSP Strategy Document"
                FolderID="<MB_BUFFER>"
         end /* do */     
         when BookName="PTI.INF" then do 
                BookName="IBM Project Tools Integrator Help"
                FolderID="<MB_APPGUIDE>"
         end /* do */
         when BookName="PTNSHOOT.INF"  then do
                BookName="Point and Shoot User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="PWDEMO1.INF"  then do
                BookName="PlantWorks Demonstrations 1"
                FolderID="<MB_PLANTWORKS>"
         end /* do */     
         when BookName="PWISA1.INF"  then do
                BookName="PlantWorks ISA Symbols"
                FolderID="<MB_PLANTWORKS>"
         end /* do */     
         when BookName="PWSAMP.INF"  then do
                BookName="PlantWorks Samples"
                FolderID="<MB_PLANTWORKS>"
         end /* do */     
         when BookName="PWSAMP1.INF"  then do
                BookName="PlantWorks Samples"
                FolderID="<MB_PLANTWORKS>"
         end /* do */     
         when BookName="QRYTOOL.INF"  then do
                BookName="Online Help for QRYTOOL"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="QTOUR.INF"  then do
                BookName="OS/2 Preload"||"0a"x||"Essentials Quick Tour"
         end /* do */     
         when BookName="RACEREXX.INF"  then do
                BookName="RACEREXX Help Facility"
                FolderID="<MB_REXX>"
         end /* do */     
         when BookName="RANDOM.INF"  then do
                BookName="Random Number Generator Online Documentation"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="RDMEAPR.INF"  then do
                BookName="LAN Server 3.0 APAR Readme"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="RDMEPUB.INF"  then do
                BookName="LAN Server 3.0 Readme"
                FolderID="<MB_LS30>"
         end /* do */     
         when BookName="READINS.INF"  then do
                BookName="OS/2 2.1 README.INS"
                FolderID="<MB_OPSYS>"
         end /* do */     
         when BookName="README.INF"  then do
                Select
                   when BookSize="26860" then do
                      BookName="Visipro/REXX v2.03 README"
                      FolderID="<MB_APPGUIDE>"
                   end  /* Do */
                   when BookSize="43974" then do
                      BookName="OS/2 Warp Internet Connection"||"0a"x||"Important Information"
                      FolderID="<MB_APPGUIDE>"
                   end  /* Do */
                   when BookSize="42999" then do
                      BookName="Communications Manager 1.11 - README"
                      FolderID="<MB_CM2>"
                   end  /* Do */
                   when BookSize="74125" then do
                      BookName="IBM Web Explorer 1.0 README"
                      FolderID="<MB_APPGUIDE>"
                   end  /* Do */
                   when BookName="77976" then do
                      BookName="LAN Server 3.0 Readme"
                      FolderID="<MB_LS30>"
                   end  /* Do */
                otherwise BookName="README ("BookSize" bytes)"
                end  /* select */
         end /* do */     
         when BookName="READSP1.INF"  then do
                BookName="OS/2 2.0 Service Pack WR6100 README.INS"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="READSP2.INF"  then do
                BookName="OS/2 2.0 Service Pack WR6100 README.SP"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="REDBOOKS.INF"  then do
                BookName="IBM RedBooks"
                FolderID="<MB_REDBOOK>"
         end /* do */     
         when BookName="REXX.INF"  then do
                BookName="REXX Information"
                FolderID="<MB_REXX>"
         end /* do */     
         when BookName="REXXAPI.INF"  then do
                BookName="REXX Program Reference"
                FolderID="<MB_REXX>"
         end /* do */     
         when BookName="REXXAPPC.INF"  then do
                BookName="REXAPPC Programmer's Reference"
                FolderID="<MB_REXX>"
         end /* do */     
         when BookName="REXXEA.INF" then do 
                BookName="Extended Attribute functions for REXX"
                FolderID="<MB_REXX>"
         end /* do */     
         when BookName="RIO.INF" then do
                BookName="RIO - Rexx CRC File Comparison Tool"
                FolderID="<MB_REXX>"
         end  /* Do */
         when BookName="ROBOSAVE.INF"  then do
                BookName="RoboSave Online documentation"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="ROISTUB.INF"  then do
                BookName="OS/2 LAN Online Reference"
                FolderID="<MB_LS30>"
         end /* do */     
         when BookName="ROX.INF"  then do
                BookName="Rox - REXX Object Extensions"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="RXCOM.INF"  then do
                BookName="RxCom Online Documentation"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="RXCRC.INF" then do
                BookName="RXCRC - REXX CRC File Comparison Tool"
                FolderID="<MB_REXX>"
         end  /* Do */
         when BookName="RXFTP.INF" then do
                BookName="REXX FTP API"
                FolderID="<MB_REXX>"
         end  /* Do */
         when BookName="RXLOG.INF" then do
                BookName="RXLOG - REXX Logging Facility"
                FolderID="<MB_REXX>"
         end  /* Do */
         when BookName="RXMATHS.INF"  then do
                BookName="RXMATHS Mathematical Function Package"
                FolderID="<MB_REXX>"
         end /* do */     
         when BookName="RXNPIPES.INF"  then do
                BookName="Rexx Named Pipes"
                FolderID="<MB_REXX>"
         end /* do */     
         when BookName="RXSEA.INF" then do
                BookName="REXX Std Ext Attributes Mgr - User Guide"
                FolderID="<MB_REXX>"
         end  /* Do */
         when BookName="RXSEM32.INF"  then do
                BookName="RXSEM32 - 32-bit Semaphore Support for REXX"
                FolderID="<MB_REXX>"
         end /* do */     
         when BookName="RXSOCKET.INF" then do
                BookName="REXX Socket Support"
                FolderID="<MB_REXX>"
         end  /* Do */
         when BookName="RXUTILS.INF"  then do
                BookName="RxUtils User's Guide"
                FolderID="<MB_REXX>"
         end /* do */     
         when BookName="RXWIN.INF" then do
                BookName="RxWin User's Guide and Reference"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="SAD.INF"  then do
                BookName="Oryx SuperVisor Guide and Reference"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="SAMPIPF.INF" then do
                BookName="BookMaster & IPF Compatibility"
                FolderID="<MB_IPFC>"
         end /* do */     
         when BookName="SAVEFLDR.INF"  then do
                BookName="SAVEFLDR Version 2.1 User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="SCENARIO.INF"  then do
                BookName="Call Scenario for Socrates Help Desk"
                FolderID="<MB_BUFFER>"
         end /* do */     
         when BookName="SD386.INF"  then do
                BookName="SD386 User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="SENSDATA.INF"  then do
                BookName="APPC/APPN Sense Data, A Practical Guide"
         end /* do */     
         when BookName="SERVICE.INF"  then do
                BookName="'Think Gold' Executive Service and Support"
                FolderID="<MB_HELPCTR>"
         end /* do */     
         when BookName="SHAREAPP.INF"  then do
                BookName="Serving Public Apps in OS/2"
         end /* do */     
         when BookName="SLIPMAIL.INF" then do
                BookName="Help for SlipMail"
                FolderID="<MB_APPGUIDE>"
         end  /* Do */
         when BookName="SNAFAQ.INF" then do 
                BookName="SNA Frequently Asked Questions"
         end /* do */
         when BookName="SNAPDUMP.INF"  then do
                BookName="SnapDump/2 Reference"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="SOM.INF"  then do
                BookName="System Object Model (SOM) Reference"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="STPOS2.INF" then do
                BookName="Subdirectory Tree Manager Plus for OS/2"
                FolderID="<MB_APPGUIDE>"
         end  /* Do */
         when BookName="SWAPMON3.INF" then do
                BookName="SwapMon3 User's Guide"
                FolderID="<MB_APPGUIDE>"
         end  /* Do */
         when BookName="SYSERROR.INF" then do
                BookName="OS/2 SYS Errors"
                FolderID="<MB_DATABASE>"
         end  /* Do */
         when BookName="TASM.INF"  then do
                BookName="Turbo Assembler Help"
                FolderID="<MB_BCOS2>"
         end /* do */     
         when BookName="TCAPR1.INF"  then do
                BookName="TCP/IP for OS/2 Version 1.2.1 & 2.0 APARs"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="TDHELP.INF"  then do
                BookName="Turbo Debugger GX Online Help"
                FolderID="<MB_BCOS2>"
         end /* do */     
         when BookName="TDOXX.INF"  then do
                BookName="TDOXX Reference"
         end /* do */     
         when BookName="TELE.INF"  then do
                BookName="TELE/2 - An OS/2 Telephone Directory"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="TELEPATH.INF"  then do
                BookName="Telepath Documentation"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="THESEUS2.INF"  then do
                BookName="Using THESEUS2"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="TIPS.INF"  then do
                BookName="General Questions and Answers"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="TKAPR1.INF"  then do
                BookName="2.0, 2.1 Toolkits, C Set/2, C Set++, and Workframe/2 APARs"
                FolderID="<MB_2XAPARS>"
         end /* do */     
         when BookName="TONYA.INF"  then do
                BookName="Tonya Harding Center for Opponent Neutralization"
                FolderID="<MB_FUNNY>"
         end /* do */     
         when BookName="TOOLINFO.INF"  then do
                BookName="Tools Reference"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="TORTURE.INF" then do
                BookName="Torture Utility for OS/2"
                FolderID="<MB_APPGUIDE>"
         end  /* Do */
         when BookName="TRADEMBK.INF"  then do
                BookName="Trademarks"
         end /* do */     
         when BookName="TRAP.INF"  then do
                BookName="Trap Error Guide"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="TRAPIPF.INF"  then do
                BookName="Trap Error Guide"
                FolderID="<MB_DATABASE>"
         end /* do */     
         when BookName="TREKLIST.INF"  then do
                BookName="Star Trek: The Original Episodes"
                FolderID="<MB_MAGAZINE>"
         end /* do */     
         when BookName="TVFS.INF"  then do
                BookName="The Toronto Virtual File System User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="USER.INF"  then do
                BookName="Multi-Net BBS User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="USERGUID.INF"  then do
                BookName="Ultimotion Workshop/2 Beta User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="VERS4B.INF"  then do
                BookName="ADVENT User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="VIEWBOOK.INF"  then do
                BookName="How to Use Online Reference"
                FolderID="<MB_IPFC>"
         end /* do */     
         when BookName="VPQELIB.INF"  then do
                BookName="VisiPro/REXX 2.0 QELIB Interface"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="VPSERIES.INF" then do
                BookName="ValuePoint Performance Series Systems"
         end  /* Do */
         when BookName="VREXX.INF"  then do
                BookName="Visual Rexx"
                FolderID="<MB_REXX>"
         end /* do */     
         when BookName="WARPFAQ.INF" then do
                BookName="OS/2 Warp FAQ List"
                FolderID="<MB_OPSYS>"
         end  /* Do */
         when BookName="WEREADME.INF" then do
                BookName="IBM Web Explorer ReadMe"
                FolderID="<MB_APPGUIDE>"
         end  /* Do */
         when BookName="WHATSNEW.INF" then do
                BookName="What's New in Communications Manager/2 1.11"
                FolderID="<MB_CM2>"
         end  /* Do */
         when BookName="WINOS2BK.INF"  then do
                BookName="Windows in OS/2"
         end /* do */     
         when BookName="WHYOS2.INF"  then do
                BookName="Why OS/2 2.0"
                FolderID="<MB_OPSYS>"
         end /* do */     
         when BookName="WITTSEND.INF"  then do
                BookName="WITTsEnd - Help Information"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="WNMODEM.INF" then do
                BookName="Supported Modems"
         end  /* Do */
         when BookName="WORKEA.INF"  then do
                BookName="WorkEa User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="WORKSHOP.INF"  then do
                BookName="Resource Workshop for OS/2 Online Help"
                FolderID="<MB_BCOS2>"
         end /* do */     
         when BookName="WPSCLASS.INF"  then do
                BookName="Introduction to the WorkPlace Shell"
                FolderID="<MB_PROGRAMMING>"
         end /* do */     
         when BookName="WPSMAIL.INF"  then do
                BookName="WPSMAIL Version 2.0 User's Guide"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="WR07020.INF" then do
                BookName="NTS/2 LAPS 2.14 - WR07020"
                FolderID="<MB_2XAPARS>"
         end  /* Do */
         when BookName="WREXX.INF"  then do
                BookName="WRESS: 32 Window Engine for OS/2 REXX"
                FolderID="<MB_REXX>"
         end /* do */     
         when BookName="X.INF" then do
                BookName="X Editor User's Guide"
                FolderID="<MB_APPGUIDE>"
         end  /* Do */
         when BookName="XPG4.INF"  then do
                BookName="(XPG/4) National Language Support Library"
                FolderID="<MB_APPGUIDE>"
         end /* do */     
         when BookName="XWING.INF"  then do
                BookName="X-Wing Flight Controls"
                FolderID="<MB_GAMES>"
         end /* do */     
         when BookName="ZBMCOMMS.INF"  then do
                BookName="ZBM COM Reusable Library Functions"
                FolderID="<MB_ZBM>"
         end /* do */     
         when BookName="ZBMFUNCS.INF"  then do
                BookName="ZBM Reusable Library Functions"
                FolderID="<MB_ZBM>"
         end /* do */     
         when BookName="ZBMMUSIC.INF"  then do
                BookName="ZBM MUS Reusable Library Documentation"
                FolderID="<MB_ZBM>"
         end /* do */     
         when BookName="ZBMPAINT.INF"  then do
                BookName="ZBM PNT Reusable Library Documentation"
                FolderID="<MB_ZBM>"
         end /* do */     
         when BookName="ZBMSYMBS.INF"  then do
                BookName="ZBM SYM Reusable Library Documentation"
                FolderID="<MB_ZBM>"
         end /* do */     
         when BookName="ZBMTEXTS.INF"  then do
                BookName="ZBM TXT Reusable Library Documentation"
                FolderID="<MB_ZBM>"
         end /* do */     
         when BookName="ZCVFUNCS.INF"  then do
                BookName="ZCV Reusable Library Documentation"
                FolderID="<MB_ZBM>"
         end /* do */     
         when BookName="ZDTFUNCS.INF"  then do
                BookName="ZDT Reusable Library Documentation"
                FolderID="<MB_ZBM>"
         end /* do */     
         when BookName="ZGSFUNCS.INF"  then do
                BookName="ZGS Reusable Library Documentation"
                FolderID="<MB_ZBM>"
         end /* do */     
         when BookName="ZHPFUNCS.INF"  then do
                BookName="ZHP Reusable Library Documentation"
                FolderID="<MB_ZBM>"
         end /* do */     
         when BookName="ZISFUNCS.INF"  then do
                BookName="ZIS Reusable Library Documentation"
                FolderID="<MB_ZBM>"
         end /* do */     
         when BookName="ZLMFUNCS.INF"  then do
                BookName="ZLM Reusable Library Documentation"
                FolderID="<MB_ZBM>"
         end /* do */     
         when BookName="ZNLFUNCS.INF"  then do
                BookName="ZNL Reusable Library Documentation"
                FolderID="<MB_ZBM>"
         end /* do */
      otherwise KnownINF=0
      end /* Select #1 - for processing known INF titles */
      /* Done setting up titles with filenames */
      /*****************************************************************************/
      /* The following lines are files that I know which are not OS/2 Online Books */
      /* So ICONS will not be created for them                                     */
      /*****************************************************************************/
      Select
         when BookName="APPS.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="CONTROL.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="DOS5.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="DRVMAP.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="EXECIO.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="EXMAP1.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="FILELIST.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="GD5424.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="GD5426.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="GD5428.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="HWPM.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="I_MAST.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="INSTDOS.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="LM1.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="LM2.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="LM3270.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="LM3270E1.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="LME1.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="LNM.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="MEMMAKER.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="MODEM.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="MSIN.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="NET2COM.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="NETWORK.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="ODBC.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="OEM0.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="OEM1.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="OEM543X.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="OEMSETUP.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="OEMNADDS.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="OEMNADLM.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="OEMNADLT.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="OEMNADNF.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="OEMNSVKT.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="OEMNXPSM.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="PAD.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="PMCONTRL.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="PMSETUP.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="PRTUPD.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="~PROFILE.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="SETUP.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="SWITCH.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="TAPCIS.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="TITLE.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="TXTSETUP.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="TRIST100.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="UNINSTAL.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="UPDATE.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="WDSETUP.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="WWORD20.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="WINNET.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="WINWORD6.INF" then rc=NotAnINF(BookName,BookSize)
         when BookName="ZBMCHARS.INF" then rc=NotAnINF(BookName,BookSize)
      otherwise do /* DO #4 */
      /* Since BookName was not in the above list, it is an INF document so create an
         icon for it. */
         if FolderID<>"" then do /* DO #5 */
            Select /* Select #2 */
               when FolderID="<MB_2XAPARS>" Then FolderTitle="OS/2 2.x & Related Product APARS"
               when FolderID="<MB_3XAPARS>" then FolderTitle="OS/2 3.x & Related Product APARS"
               when FolderID="<MB_ACCF>" Then FolderTitle="ACCF Programming Guide"
               when FolderID="<MB_APPGUIDE>" Then FolderTitle="Application User's Guides"
               when FolderID="<MB_APPC>" Then FolderTitle="APPC Application Suite"
               when FolderID="<MB_BCOS2>" Then FolderTitle="Borland C++ for OS/2"
               when FolderID="<MB_BUFFER>" Then FolderTitle="B.U.F.F.E.R. Documentation"
               when FolderID="<MB_CM2>" Then FolderTitle="CM/2 Documentation"
               when FolderID="<MB_CSET>" Then FolderTitle="C/Set++ Documentation"
               when FolderID="<MB_CVIEWS>" Then FolderTitle="Client Views/2 Documentation"
               when FolderID="<MB_DATABASE>" Then FolderTitle="Databases"
               when FolderID="<MB_DB2>" Then FolderTitle="DB2/2 Documentation"
               when FolderID="<MB_DSN93>" Then FolderTitle="IBM Developer's Support News 1993"
               when FolderID="<MB_DSN94>" Then FolderTitle="IBM Developer's Support News 1994"
               when FolderID="<MB_DSN95>" Then FolderTitle="IBM Develpoer's Support News 1995"
               when FolderID="<MB_FUNNY>" Then FolderTitle="Humorous Books"
               when FolderID="<MB_GAMES>" Then FolderTitle="Game Manuals"
               when FolderID="<MB_HELPCTR>" Then FolderTitle="HelpCenter Documentation"
               when FolderID="<MB_ICPA>" Then FolderTitle="ICPA Documentation"
               when FolderID="<MB_IPFC>" Then FolderTitle="IPFC Information"
               when FolderID="<MB_LPEX>" Then FolderTitle="LPEX Information"
               when FolderID="<MB_LS30>" Then FolderTitle="OS/2 LAN Server 3.0"
               when FolderID="<MB_LS40>" Then FolderTitle="OS/2 LAN Server 4.0"
               when FolderID="<MB_MAGAZINE>" Then FolderTitle="On-line Magazines"
               when FolderID="<MB_OPSYS>" Then FolderTitle="Operating System Information"
               when FolderID="<MB_REDBOOK>" Then FolderTitle="IBM Redbooks"
               when FolderID="<MB_REXX>" Then FolderTitle="REXX Documentation"
               when FolderID="<MB_PLANTWORKS>" Then FolderTitle="PlantWorks Documentation"
               when FolderID="<MB_PROGRAMMING>" Then FolderTitle="Programming Information"
               when FolderID="<MB_PSASST>" Then FolderTitle="PS/Assistant"
               when FolderID="<MB_WF2>" Then FolderTitle="Workframe/2 Documentation"
               when FolderID="<MB_ZBM>" Then FolderTitle="ZBM Documentation"
            otherwise FolderTitle="Unknown FolderID - "FolderID
            end  /* select #2 */
            rc=SysCreateObject("WPFolder",""FolderTitle"","<MAKEBOOK>","OBJECTID="FolderID"",u);
             if rc=0 then do  /* If the folder could not be created, update the log file */
               rc=LINEOUT(BootDrive'\OS2\INSTALL\MAKEBOOK.LOG','FOLDER_FAILURE: 'FolderTitle' ('FolderID') could not be created!');  
             end /* do */
            rc=SysCreateObject("WPProgram",""BookName"",""FolderID"","EXENAME=VIEW.EXE;PARAMETERS="BookPath";STARTUPDIR=\OS2\BOOK;",r)
             if rc=0 then do /* If the icon could not be created, update the log file */
               rc=LINEOUT(BootDrive'\OS2\INSTALL\MAKEBOOK.LOG','ICON_FAILURE: 'BookName' in Folder 'FolderTitle'('FolderID')');  
             end /* do */
         end /* do #5 - for creating icons in a specific folder */
         /****************************************************************************************/
         /* If no folder ID is set, the object will be placed in the MakeBook folder (next line) */
         /****************************************************************************************/
         else rc=SysCreateObject("WPProgram",""BookName"","<MAKEBOOK>","EXENAME=VIEW.EXE;PARAMETERS="BookPath";STARTUPDIR=\OS2\BOOK;",r)
      end /* do #4 for creating icons */
      if KnownINF=0 then rc=LINEOUT(BootDrive'\OS2\INSTALL\MAKEBOOK.LOG','Unknown .INF: 'BookName' ('BookSize')')
    end /* DO #3 */ /*******************************************/ 
                    /* End of procedure repeated for each file */
                    /*******************************************/
 end /* do #2 - for current drive which has .INF files on it */ 
 end
 else Say "No files found on drive "DriveInfo.temp" to set up! "
end /* do #1 - this one is overall loop for different drives found */
Say
Say "C'est le fin!  Aurevoir!"
rc=LineOut(BootDrive'\OS2\INSTALL\MAKEBOOK.LOG',"******* MakeBook End "TIME('C')" "DATE('U')" *******")
rc=LineOut(BootDrive'\OS2\INSTALL\MAKEBOOK.LOG') /* Close out the LogFile */ 
Signal THE_END
/******************************************************************************
    NotAnINF procedure
******************************************************************************/
NotAnINF: procedure Expose KnownINF
   Arg BookName, BookSize
       KnownINF=1
       ReturnCode="NOTHING"
   return ReturnCode
/* end of NotAnINF Procedure */
THE_END:
