/*------------------------------------------------------------------------*\
|                                                                          |
|           LISTEA.CMD   - Version 1.3 - Version Date 1995-03-27           |
|               Copyright (C) 1994-95 by C F S Nevada, Inc.                |
|                                                                          |
|                  by Dick Goran  - Voice    702-732-9616                  |
|                                 - FAX      702-732-3847                  |
|                                 - CIS      71154,2002                    |
|                                 - Internet 71154.2002@compuserve.com     |
|                                                                          |
| ------------------------------------------------------------------------ |
|  REXXLIB.DLL  - OS/2 REXX external function library                      |
|                 (c) Copyright 1992-94 Quercus Systems                    |
\*------------------------------------------------------------------------*/
/*
     This program will build a file, LISTEA.TXT, in the same directory
     where this program resides. This file will contain a text listing
     of all of the Extended Attributes (in both hex and character
     notation) for all directories and files in the object system
     except that REXX metafiles are not detailed and non-local drives
     are ignored.

     Two temporary work files, SYS001 and SYS002, area created in the
     same directory where LISTEA.CMD resides while the program is
     running. They are erased on completion.

     This program may take a considerable amount of time to run
     depending on the speed of the system and the number of files to
     be processed.

     The file created by this program, LISTEA.TXT, will be large (2 MB
     - 3 MB) and can be viewed with any viewer or ASCII editor capable
     of handling large files.

     An index list of the EA names encountered is included at the end
     of LISTEA.TXT with the name of a file which contains this EA.
     Also, the number of times that that EA type occurs in the system
     is indicated.

Updates:
         94/01/12 - Eliminate non LOCAL drives
         94/01/21 - Minor changes
         94/02/04 - Check floppies & check for NOTREADY with DOSDISK()
         94/04/07 - Do not put unused drives in title line
   1.1   94/12/31 - Warp DIR output variances
   1.2   95/02/18 - NLS date parsng variances
   1.3   95/03/27 - Set appropriate DIRCMD value to prevent user
                       established conflicts
                    Shorten data shown for .ASSOCTABLE
                    Handle .ICON1 & .IBMLT.THUMBNAIL like .ICON
                    Ignore ?:\OS2\ARCHIVES\*.*
*/
parse Version         REXX_Version .                              /* 0053 */
parse Source          OS_Name,                                    /* 0054 */
                      Calling_Environment,                        /* 0055 */
                      program_path_and_name                       /* 0056 */
GBL.environment     = 'OS2ENVIRONMENT'                            /* 0057 */
GBL.boot_drive      = LEFT( VALUE( 'RUNWORKPLACE',, GBL.environment ), 2 )
GBL.program_name    = FILESPEC( 'N', program_path_and_name )      /* 0059 */
GBL.program_path    = FILESPEC( 'D', program_path_and_name ) ||,  /* 0060 */
                      FILESPEC( 'P', program_path_and_name )      /* 0061 */
GBL.program_version = 1.3           /* version / mod of this program */
call TIME 'E'                       /* set elapsed timer - sssss.uuuuu */
                                                                  /* 0064 */
say 'Begin' GBL.program_name 'at' TIME('N')                       /* 0065 */
call REGISTER_REQUIRED_FUNCTIONS                                  /* 0066 */
                                                                  /* 0067 */
   SIGNAL ON ERROR                  /* trap object time errors     */
   SIGNAL ON FAILURE                /* trap object time errors     */
   SIGNAL ON HALT                   /* trap object time errors     */
   SIGNAL ON NOVALUE                /* trap object time errors     */
   SIGNAL ON SYNTAX                 /* trap object time errors     */
                                                                  /* 0073 */
/*-------------------------------*\                               /* 0074 */
|  Retrieve NLS dependent values  |                               /* 0075 */
\*-------------------------------*/                               /* 0076 */
GBL.sDate_character =,                                            /* 0077 */
   STRIP( SysIni( 'USER', 'PM_National', 'sDate' ), 'T', '00'x )  /* 0078 */
                                                                  /* 0079 */
/*----------------------------*\                                  /* 0080 */
|  Define output & work files  |                                  /* 0081 */
\*----------------------------*/                                  /* 0082 */
output_file = GBL.program_path || 'LISTEA.TXT'                    /* 0083 */
output_disk = TRANSLATE( FILESPEC( 'D', output_file ) )           /* 0084 */
call SysFileDelete output_file                                    /* 0085 */
output_file_line_count = 0                                        /* 0086 */
free_space = DOSDISK( 'F', output_disk )                          /* 0087 */
if free_space < (2 * 1024 * 1024) then                            /* 0088 */
   do                                                             /* 0089 */
      call LINEOUT 'CON:',,                                       /* 0090 */
               'WARNING! There may not be adequate free space on drive ' ||,
               output_disk || '.'                                 /* 0092 */
      call LINEOUT 'CON:',,                                       /* 0093 */
               '         However, program will continue.'         /* 0094 */
   end                                                            /* 0095 */
                                                                  /* 0096 */
SYS001 = GBL.program_path || 'LISTEA.SY1' /* directory lines              */
SYS002 = GBL.program_path || 'LISTEA.SY2' /* ea file size & full name     */
                                                                  /* 0099 */
/*-------------------------------*\                               /* 0100 */
|  Table & constant declarations  |                               /* 0101 */
\*-------------------------------*/                               /* 0102 */
call INITIALIZE                     /* setup tables & constants           */
output_width  = 76                  /* output page max line width         */
ea_max_length = 0                   /* length of longest name             */
GBL.spaces    = COPIES( ' ', 3 )    /* nbr of indent spaces               */
                                                                  /* 0107 */
/* signal PROCESS_SYS002 */         /* for test use only */       /* 0108 */
                                                                  /* 0109 */
/*------------------------------------*\                          /* 0110 */
|  Put EA file size & names in SYS002  |                          /* 0111 */
\*------------------------------------*/                          /* 0112 */
say COPIES( GBL.spaces, 1 ) ||,                                   /* 0113 */
    'Retrieving directory & file names'                           /* 0114 */
call SysFileDelete SYS002                                         /* 0115 */
do w = 1 to WORDS(drive_table)                                    /* 0116 */
   call PROCESS_DRIVE  WORD( drive_table, w )                     /* 0117 */
end                                                               /* 0118 */
call STREAM SYS002, 'C', 'CLOSE'                                  /* 0119 */
                                                                  /* 0120 */
/*---------------------------------------*\                       /* 0121 */
|  Sort and write all EAs to output file  |                       /* 0122 */
\*---------------------------------------*/                       /* 0123 */
PROCESS_SYS002:                                                   /* 0124 */
                                                                  /* 0125 */
say COPIES( GBL.spaces, 1 ) ||,                                   /* 0126 */
    'Sorting directory & file names'                              /* 0127 */
file_table. = ''                    /* initialize array */        /* 0128 */
file_table_max_length = 0                                         /* 0129 */
e = 0                                                             /* 0130 */
do while LINES(SYS002) > 0                                        /* 0131 */
   e = e + 1                                                      /* 0132 */
   input_line = LINEIN(SYS002)                                    /* 0133 */
   file_table.e = input_line                                      /* 0134 */
   file_table_max_length = MAX( file_table_max_length,,           /* 0135 */
                                LENGTH( input_line ) - 9 )        /* 0136 */
end                                                               /* 0137 */
call STREAM SYS002, 'C', 'CLOSE'                                  /* 0138 */
                                                                  /* 0139 */
file_table.0 = e                                                  /* 0140 */
call ARRAYSORT 'file_table', 1, file_table.0,,                    /* 0141 */
                                10, file_table_max_length         /* 0142 */
                                                                  /* 0143 */
call SysCurState 'OFF'              /* turn off cursor */         /* 0144 */
call CHAROUT 'CON:', COPIES( GBL.spaces, 1 ) ||,                  /* 0145 */
                     'Building ' ||,                              /* 0146 */
                     output_file    ||,                           /* 0147 */
                     COPIES( ' ', 3 )                             /* 0148 */
title = 'Listing of EAs on Drives ' ||,                           /* 0149 */
        title                                                     /* 0150 */
heading.1 =,                                                      /* 0151 */
         DATE('O') ||,                                            /* 0152 */
         COPIES( ' ', 2 ) ||,                                     /* 0153 */
         TIME('N')                                                /* 0154 */
space_count = ( output_width - LENGTH(heading.1) - LENGTH(title) ) % 2
if space_count < 1 then space_count = 1                           /* 0156 */
heading.1 = heading.1 ||,                                         /* 0157 */
         COPIES( ' ', space_count ) ||,                           /* 0158 */
         title                                                    /* 0159 */
call LINEOUT output_file, heading.1 || '0D0A'x                    /* 0160 */
                                                                  /* 0161 */
bksp = '08'x                                                      /* 0162 */
progress_list = '\|/'                                            /* 0163 */
progress_subscript = 1                                            /* 0164 */
do e = 1 to file_table.0                                          /* 0165 */
   call FORMAT_EA_ITEM file_table.e                               /* 0166 */
   call CHAROUT 'CON:', bksp ||,                                  /* 0167 */
                       SUBSTR( progress_list, progress_subscript, 1 )
   progress_subscript = progress_subscript + 1                    /* 0169 */
   if progress_subscript > LENGTH(progress_list) then             /* 0170 */
      progress_subscript = 1                                      /* 0171 */
end                                                               /* 0172 */
call LINEOUT 'CON:', bksp || ' '                                  /* 0173 */
                                                                  /* 0174 */
/*--------------------------------------*\                        /* 0175 */
|  Write sorted EA index to output file  |                        /* 0176 */
\*--------------------------------------*/                        /* 0177 */
heading.2 =,                                                      /* 0178 */
   '0C'x ||,                                                      /* 0179 */
   CENTER( 'EA Index List', output_width )                        /* 0180 */
call LINEOUT output_file,  heading.2 ||,                          /* 0181 */
                           '0D0A'x                                /* 0182 */
                                                                  /* 0183 */
output_line = LEFT( 'EA Name', 22 ) ||,                           /* 0184 */
              LEFT( 'Type',     8 ) ||,                           /* 0185 */
              LEFT( 'Ct.',      7 ) ||,                           /* 0186 */
              'Example'                                           /* 0187 */
call LINEOUT output_file, output_line                             /* 0188 */
                                                                  /* 0189 */
output_line = COPIES( '-', 19 ) ||,                               /* 0190 */
              COPIES( ' ',  3 ) ||,                               /* 0191 */
              COPIES( '-',  4 ) ||,                               /* 0192 */
              COPIES( ' ',  4 ) ||,                               /* 0193 */
              COPIES( '-',  4 ) ||,                               /* 0194 */
              COPIES( ' ',  3 ) ||,                               /* 0195 */
              COPIES( '-', 39 )                                   /* 0196 */
call LINEOUT output_file, output_line                             /* 0197 */
                                                                  /* 0198 */
call ARRAYSORT 'ea_table', 1, ea_table.0                          /* 0199 */
do i = 1 to ea_table.0                                            /* 0200 */
   parse value ea_table.i with ea_name ea_hex_value ea_example    /* 0201 */
   output_line = LEFT( ea_name, 22) ||,                           /* 0202 */
                 C2X( ea_hex_value ) ||,                          /* 0203 */
                 COPIES( ' ', 3 ) ||,                             /* 0204 */
                 FORMAT( ea_table.ea_name, 5 ) ||,                /* 0205 */
                 COPIES( ' ', 3 ) ||,                             /* 0206 */
                 ea_example                                       /* 0207 */
   call WRITE_OUTPUT_FILE output_line                             /* 0208 */
end                                                               /* 0209 */
call STREAM output_file, 'C', 'CLOSE'                             /* 0210 */
call SysCurState 'ON'               /* turn on cursor */          /* 0211 */
                                                                  /* 0212 */
call SysFileDelete SYS001           /* erase work files                   */
call SysFileDelete SYS002                                         /* 0214 */
                                                                  /* 0215 */
call EOJ 0                                                        /* 0216 */
                                                                  /* 0217 */
!tr!=VALUE('TRACE',,'OS2Environment'); if !tr!<>'' then do;TRACE(!tr!);nop;end
/*------------------------------------------------------------------------*\
|                                                                          |
|                                End of Job                                |
|                                                                          |
\*------------------------------------------------------------------------*/
EOJ:                                                              /* 0224 */
   Procedure                                                      /* 0225 */
                                                                  /* 0226 */
if ARG() = 0 then                                                 /* 0227 */
   eoj_rc = 0                                                     /* 0228 */
else                                                              /* 0229 */
   eoj_rc = ARG(1)                                                /* 0230 */
                                                                  /* 0231 */
elapsed_time = TIME('E')            /* get elapsed time - sssss.uuuuu */
parse value elapsed_time with seconds '.' micro_seconds           /* 0233 */
if SUBSTR( micro_seconds, 1, 1 ) >= 5 then                        /* 0234 */
   seconds = seconds + 1                                          /* 0235 */
ss = FORMAT( seconds // 60, 2 )                                   /* 0236 */
minutes = ( seconds - ss ) / 60                                   /* 0237 */
mm = FORMAT( minutes // 60, 2 )                                   /* 0238 */
hh = FORMAT( ( minutes - mm ) / 60, 2 )                           /* 0239 */
duration = hh':'mm':'ss                                           /* 0240 */
                                                                  /* 0241 */
parse Source   . . program_path_and_name                          /* 0242 */
program_name = FILESPEC( 'N', program_path_and_name )             /* 0243 */
say 'EOJ  ' program_name 'at' TIME('N') ||,                       /* 0244 */
    ', duration' TRANSLATE( duration, '0', ' ' )                  /* 0245 */
exit eoj_rc                                                       /* 0246 */
                                                                  /* 0247 */
/*------------------------------------------------------------------------*\
|                                                                          |
|          Get each EA and write to output file & build EA matrix          |
|                                                                          |
\*------------------------------------------------------------------------*/
FORMAT_EA_ITEM:                                                   /* 0253 */
   Procedure expose,                                              /* 0254 */
      ea_max_length,                                              /* 0255 */
      ea_table.,                                                  /* 0256 */
      GBL.,                                                       /* 0257 */
      output_file,                                                /* 0258 */
      output_file_line_count,                                     /* 0259 */
      contig_hex_tt,                                              /* 0260 */
      spread_hex_tt,                                              /* 0261 */
      SYS001 SYS002,                                              /* 0262 */
      tt_128                                                      /* 0263 */
                                                                  /* 0264 */
parse arg file_size file_name                                     /* 0265 */
file_name = STRIP(file_name)                                      /* 0266 */
crlf = '0D0A'x                                                    /* 0267 */
                                                                  /* 0268 */
ea_count = DOSEALIST( file_name, 'name_stem', 'value_stem', 'flag_stem' )
if ea_count > 0 then                                             /* 0270 */
   do                                                             /* 0271 */
      say '0D0A'x || 'DOSEALIST unexpected return code of ' ||,   /* 0272 */
          ea_count                                                /* 0273 */
      say '   for' file_name                                      /* 0274 */
      say '   Data for above file will not appear in ' ||,        /* 0275 */
          FILESPEC( 'N', output_file )                            /* 0276 */
      return                                                      /* 0277 */
   end                                                            /* 0278 */
                                                                  /* 0279 */
do i = 1 to name_stem.0                                           /* 0280 */
   name = STRIP( name_stem.i, 'L', '.' )                          /* 0281 */
                                                                  /* 0282 */
   /*------------------------*\                                   /* 0283 */
   |  Write Formatted output  |                                   /* 0284 */
   \*------------------------*/                                   /* 0285 */
   output_line = file_name                                        /* 0286 */
   if file_size = '<DIR>' then                                    /* 0287 */
      do                                                          /* 0288 */
         output_line = output_line || ' <DIR>'                    /* 0289 */
      end                                                         /* 0290 */
                                                                  /* 0291 */
   list_control = 0                 /* < 0 name only, > 0 truncate value */
   select                                                         /* 0293 */
      when LEFT( name, 5 ) = 'REXX.' then                         /* 0294 */
         list_control = -1                                        /* 0295 */
      when name = 'ICON' then                                     /* 0296 */
         list_control = -1                                        /* 0297 */
      when name = 'ICON1' then                                    /* 0298 */
         list_control = -1                                        /* 0299 */
      otherwise                                                   /* 0300 */
         nop                                                      /* 0301 */
   end                                                            /* 0302 */
   select                                                         /* 0303 */
      when name = 'ASSOCTABLE' then                               /* 0304 */
         do                                                       /* 0305 */
            list_control = POS( 'FEFF02'x, value_stem.i ) - 1     /* 0306 */
         end                                                      /* 0307 */
      when name = 'IBMLT.THUMBNAIL' then                          /* 0308 */
         do                                                       /* 0309 */
            list_control = POS( '00'x, value_stem.i, 34 )         /* 0310 */
         end                                                      /* 0311 */
      otherwise                                                   /* 0312 */
         nop                                                      /* 0313 */
   end                                                            /* 0314 */
                                                                  /* 0315 */
   if list_control < 0 then                                       /* 0316 */
      if i = 1 then                                               /* 0317 */
         do                                                       /* 0318 */
            if output_file_line_count > 0 then                    /* 0319 */
               output_line = crlf || output_line /* precede with blank line */
            call WRITE_OUTPUT_FILE output_line                    /* 0321 */
         end                                                      /* 0322 */
      else                                                        /* 0323 */
         nop                                                      /* 0324 */
   else                                                           /* 0325 */
      do                                                          /* 0326 */
         if output_file_line_count > 0 then                       /* 0327 */
            output_line = crlf || output_line /* precede with blank line */
         call WRITE_OUTPUT_FILE output_line                       /* 0329 */
      end                                                         /* 0330 */
                                                                  /* 0331 */
   output_line = COPIES( ' ', 3 ) ||,                             /* 0332 */
                 LEFT( 'Flag = ''' || C2X(flag_stem.i) || '''x', 15) ||,
                 'Name = ' ||,                                    /* 0334 */
                 LEFT( name_stem.i, 35 ) ||,                      /* 0335 */
                 'Length = ''' ||,                                /* 0336 */
                 D2X( LENGTH(value_stem.i), 4 ) ||,               /* 0337 */
                 '''x'                                            /* 0338 */
   call WRITE_OUTPUT_FILE output_line                             /* 0339 */
                                                                  /* 0340 */
   if list_control = 0 then                                       /* 0341 */
      do                                                          /* 0342 */
         call FORMAT_EA_DETAIL  value_stem.i                      /* 0343 */
      end                                                         /* 0344 */
   else                                                           /* 0345 */
      if list_control > 0 then                                    /* 0346 */
         do                                                       /* 0347 */
            call FORMAT_EA_DETAIL  LEFT( value_stem.i, list_control )
         end                                                      /* 0349 */
                                                                  /* 0350 */
   /*---------------------------------*\                          /* 0351 */
   |  Cross index EA name in EA table  |                          /* 0352 */
   \*---------------------------------*/                          /* 0353 */
   if ea_table.name = '' then                                     /* 0354 */
      do                                                          /* 0355 */
         e = ea_table.0 + 1                                       /* 0356 */
         ea_table.0 = e                                           /* 0357 */
         ea_table.e = name,                                       /* 0358 */
                      SUBSTR( value_stem.i, 2, 1 ) ||,            /* 0359 */
                      SUBSTR( value_stem.i, 1, 1 ),               /* 0360 */
                      file_name                                   /* 0361 */
         ea_table.name = 1                                        /* 0362 */
         if LENGTH(name) > ea_max_length then                     /* 0363 */
            ea_max_length = LENGTH(name)                          /* 0364 */
      end                                                         /* 0365 */
   else                                                           /* 0366 */
      do                                                          /* 0367 */
         ea_table.name = ea_table.name + 1                        /* 0368 */
      end                                                         /* 0369 */
                                                                  /* 0370 */
end                                                               /* 0371 */
                                                                  /* 0372 */
return                                                            /* 0373 */
                                                                  /* 0374 */
/*------------------------------------------------------------------------*\
|                                                                          |
|                     Format hex & character EA detail                     |
|                                                                          |
\*------------------------------------------------------------------------*/
FORMAT_EA_DETAIL:                                                 /* 0380 */
   Procedure expose,                                              /* 0381 */
      output_file,                                                /* 0382 */
      output_file_line_count,                                     /* 0383 */
      GBL.program_name,                                           /* 0384 */
      contig_hex_tt,                                              /* 0385 */
      spread_hex_tt,                                              /* 0386 */
      SYS001 SYS002,                                              /* 0387 */
      tt_128                                                      /* 0388 */
                                                                  /* 0389 */
ea_data               = ARG(1)                                    /* 0390 */
hex_displacement      = 0                                         /* 0391 */
prev_character_string = ''                                        /* 0392 */
sameness_switch       = 0                                         /* 0393 */
                                                                  /* 0394 */
do until ea_data = ''                                             /* 0395 */
   parse value ea_data with leading_token 17 ea_data              /* 0396 */
                                                                  /* 0397 */
   temp_character_string = LEFT( leading_token, 16 )              /* 0398 */
   if temp_character_string <> prev_character_string then         /* 0399 */
      do                                                          /* 0400 */
         temp_hex_string = TRANSLATE( spread_hex_tt,,             /* 0401 */
                                      C2X(temp_character_string),,
                                      contig_hex_tt )             /* 0403 */
         word_count = ( LENGTH(leading_token) - 1 ) % 4           /* 0404 */
         byte_count = LENGTH(leading_token) - ( 4 * word_count )  /* 0405 */
         temp_hex_length = ( 9 * word_count ) + ( 2 * byte_count )
         output_line = COPIES( ' ', 10 ) ||,                      /* 0407 */
                       '+' || D2X( hex_displacement, 4 ) ||,      /* 0408 */
                       COPIES( ' ', 3 ) ||,                       /* 0409 */
                       '| ' ||,                                   /* 0410 */
                       LEFT( temp_hex_string, temp_hex_length ) ||,
                       COPIES( ' ', 35 - temp_hex_length ) ||,    /* 0412 */
                       ' |' ||,                                   /* 0413 */
                       COPIES( ' ', 3 ) ||,                       /* 0414 */
                       TRANSLATE( temp_character_string, tt_128 ) /* 0415 */
         call WRITE_OUTPUT_FILE output_line                       /* 0416 */
         sameness_switch = 0                                      /* 0417 */
      end                                                         /* 0418 */
   else                                                           /* 0419 */
      if sameness_switch = 0 then                                 /* 0420 */
         do                                                       /* 0421 */
            output_line = COPIES( ' ', 10 ) ||,                   /* 0422 */
                          '+' || D2X( hex_displacement, 4 ) ||,   /* 0423 */
                          COPIES( ' ', 3 ) ||,                    /* 0424 */
                          '| ' ||,                                /* 0425 */
                          LEFT( 'same', 35 ) ||,                  /* 0426 */
                          ' |'                                    /* 0427 */
            call WRITE_OUTPUT_FILE output_line                    /* 0428 */
            sameness_switch = 1                                   /* 0429 */
         end                                                      /* 0430 */
                                                                  /* 0431 */
   hex_displacement = hex_displacement + 16                       /* 0432 */
   prev_character_string = temp_character_string                  /* 0433 */
end                                                               /* 0434 */
return                                                            /* 0435 */
                                                                  /* 0436 */
/*------------------------------------------------------------------------*\
|                                                                          |
|                       Initialize translate tables                        |
|                                                                          |
\*------------------------------------------------------------------------*/
INITIALIZE:                                                       /* 0442 */
   Procedure expose,                                              /* 0443 */
      contig_hex_tt,                                              /* 0444 */
      drive_table,                                                /* 0445 */
      ea_table.,                                                  /* 0446 */
      heading.,                                                   /* 0447 */
      hex_tt,                                                     /* 0448 */
      GBL.,                                                       /* 0449 */
      output_width,                                               /* 0450 */
      output_file,                                                /* 0451 */
      spread_hex_tt,                                              /* 0452 */
      title,                                                      /* 0453 */
      tt_128,                                                     /* 0454 */
      tt_256                                                      /* 0455 */
                                                                  /* 0456 */
drive_table  = SysDriveMap( 'A', 'LOCAL' )                        /* 0457 */
ea_table.    = ''; ea_table.0   = 0                               /* 0458 */
output_width = 76                   /* output page max line width         */
title = ''                                                        /* 0460 */
                                                                  /* 0461 */
hex_tt = COPIES( '00'x, 256 )                                     /* 0462 */
hex_tt = OVERLAY( XRANGE('30'x, '39'x), hex_tt, X2D(30) + 1 ) /* 0 - 9    */
hex_tt = OVERLAY( XRANGE('41'x, '46'x), hex_tt, X2D(41) + 1 ) /* A - F    */
hex_tt = OVERLAY( XRANGE('41'x, '46'x), hex_tt, X2D(61) + 1 ) /* a - f    */
                                                                  /* 0466 */
/* used for hex display of data */                                /* 0467 */
contig_hex_tt = XRANGE('01'x, '21'x)                              /* 0468 */
spread_hex_tt = XRANGE('01'x, '08'x) || '21'x ||,                 /* 0469 */
                XRANGE('09'x, '10'x) || '21'x ||,                 /* 0470 */
                XRANGE('11'x, '18'x) || '21'x ||,                 /* 0471 */
                XRANGE('19'x, '20'x)                              /* 0472 */
                                                                  /* 0473 */
tt_128 = COPIES( '.', 32 ) || XRANGE('20'X, '7F'X) || COPIES( '.', 128 )
tt_256 = '2E01 0203 0405 062E 2E2E 2E0B 0C2E 0E0F'X ||,           /* 0475 */
         '1011 1213 1415 1617 1819 1A2E 1C1D 1E1F'X ||,           /* 0476 */
         XRANGE('20'X, 'FE'X) || '.'                              /* 0477 */
return                                                            /* 0478 */
                                                                  /* 0479 */
/*------------------------------------------------------------------------*\
|                                                                          |
|                Build Work File 02 From Directory Entries                 |
|                                                                          |
\*------------------------------------------------------------------------*/
PROCESS_DRIVE:                                                    /* 0485 */
   Procedure expose,                                              /* 0486 */
      GBL. SYS001 SYS002 title                                    /* 0487 */
                                                                  /* 0488 */
drive = ARG(1)                                                    /* 0489 */
notready_switch = ''                                              /* 0490 */
call ON NOTREADY name DRIVE_NOTREADY                              /* 0491 */
call STREAM drive || '*', 'D'       /* check for not ready */     /* 0492 */
call OFF NOTREADY                                                 /* 0493 */
if notready_switch <> '' then                                     /* 0494 */
   do                                                             /* 0495 */
      say COPIES( GBL.spaces, 2 ) ||,                             /* 0496 */
          'Drive ' ||,                                            /* 0497 */
          drive ||,                                               /* 0498 */
          ' is not ready and is being ignored.'                   /* 0499 */
      return                                                      /* 0500 */
   end                                                            /* 0501 */
                                                                  /* 0502 */
/* ignore drives which are not ready */                           /* 0503 */
if DOSDISK( 'T', drive ) = -1 then                                /* 0504 */
   do                                                             /* 0505 */
      say COPIES( GBL.spaces, 2 ) ||,                             /* 0506 */
          'Drive ' ||,                                            /* 0507 */
          drive ||,                                               /* 0508 */
          ' is not ready and will be ignored.'                    /* 0509 */
      return                                                      /* 0510 */
   end                                                            /* 0511 */
                                                                  /* 0512 */
/* ignore CD-ROM drives */                                        /* 0513 */
if DOSFILESYS(drive) = 'CDFS' then                                /* 0514 */
   do                                                             /* 0515 */
      say COPIES( GBL.spaces, 2 ) ||,                             /* 0516 */
          'Drive ' ||,                                            /* 0517 */
          drive ||,                                               /* 0518 */
          ' is a CD-ROM and will be ignored.'                     /* 0519 */
      return                                                      /* 0520 */
   end                                                            /* 0521 */
                                                                  /* 0522 */
/* Clear any user specified DIRCMD value */                       /* 0523 */
GBL.dircmd_value = VALUE( 'DIRCMD', '', GBL.environment )         /* 0524 */
                                                                  /* 0525 */
title = title STRIP(drive)                                        /* 0526 */
say COPIES( GBL.spaces, 2 ) ||,                                   /* 0527 */
    'Drive ' ||,                                                  /* 0528 */
    drive    ||,                                                  /* 0529 */
    ' is being read to extract EAs.'                              /* 0530 */
'@dir' drive || '\*.* /s /n /a: 1>' SYS001                        /* 0531 */
if GBL.dircmd_value <> '' then                                    /* 0532 */
   do                                                             /* 0533 */
      /* Restore original value */                                /* 0534 */
      call VALUE 'DIRCMD', GBL.dircmd_value, GBL.environment      /* 0535 */
   end                                                            /* 0536 */
                                                                  /* 0537 */
path_name = ''                                                    /* 0538 */
directory_of_constant = 'Directory of '                           /* 0539 */
do while LINES(SYS001) > 0                                        /* 0540 */
   directory_line = LINEIN(SYS001)                                /* 0541 */
                                                                  /* 0542 */
   parse value directory_line with . (directory_of_constant) directory_of_value
   if directory_of_value <> '' then                               /* 0544 */
      do                                                          /* 0545 */
         path_name = directory_of_value                           /* 0546 */
         if RIGHT( path_name, 1 ) <> '\' then                     /* 0547 */
            path_name = path_name || '\'                          /* 0548 */
         iterate                                                  /* 0549 */
      end                                                         /* 0550 */
                                                                  /* 0551 */
   if ( SUBSTR( directory_line, 3, 1 ) <> GBL.sDate_character )  |,
      ( SUBSTR( directory_line, 6, 1 ) <> GBL.sDate_character ) then iterate
   parse var directory_line,                                      /* 0554 */
              file_date,                                          /* 0555 */
              file_time,                                          /* 0556 */
              file_size,                                          /* 0557 */
              file_ea_size,                                       /* 0558 */
              file_name                                           /* 0559 */
   if file_ea_size = 0 then iterate                               /* 0560 */
   if ( file_name = '.' )  |,                                     /* 0561 */
      ( file_name = '..' ) then iterate                           /* 0562 */
   full_file_name = path_name ||,                                 /* 0563 */
                    STRIP(file_name)                              /* 0564 */
                                                                  /* 0565 */
   /* ignore all \OS2\ARCHIVES directories */                     /* 0566 */
   if POS( '\OS2\ARCHIVES', full_file_name ) > 0 then iterate     /* 0567 */
                                                                  /* 0568 */
   output_line = LEFT( file_size, 9 ) ||,                         /* 0569 */
                 full_file_name                                   /* 0570 */
   call LINEOUT SYS002, output_line                               /* 0571 */
end                                                               /* 0572 */
call STREAM SYS001, 'C', 'CLOSE'                                  /* 0573 */
call SysFileDelete SYS001                                         /* 0574 */
return                                                            /* 0575 */
                                                                  /* 0576 */
DRIVE_NOTREADY:                                                   /* 0577 */
   Procedure expose notready_switch                               /* 0578 */
notready_switch = 1                                               /* 0579 */
return                                                            /* 0580 */
                                                                  /* 0581 */
/*------------------------------------------------------------------------*\
|                                                                          |
|                   Register external function routines                    |
|                                                                          |
\*------------------------------------------------------------------------*/
REGISTER_REQUIRED_FUNCTIONS:                                      /* 0587 */
   Procedure expose REXX_Version                                  /* 0588 */
                                                                  /* 0589 */
/*----------------------------------------*\                      /* 0590 */
|  Load REXXUtil External Function Module  |                      /* 0591 */
\*----------------------------------------*/                      /* 0592 */
function_name      = 'SysLoadFuncs'                               /* 0593 */
entry_name         = 'SysLoadFuncs'                               /* 0594 */
module             = 'RexxUtil'                                   /* 0595 */
anticipated_return = ''                                           /* 0596 */
call REGISTER_ROUTINE function_name module entry_name anticipated_return
                                                                  /* 0598 */
/*-----------------------------------*\                           /* 0599 */
|  Load the REXXLIB Function Package  |                           /* 0600 */
\*-----------------------------------*/                           /* 0601 */
if REXX_Version = 'REXX/Personal' then                            /* 0602 */
   do                                                             /* 0603 */
      module = 'qrexxlib'                                         /* 0604 */
   end                                                            /* 0605 */
else                                                              /* 0606 */
   do                                                             /* 0607 */
      module = 'rexxlib'                                          /* 0608 */
   end                                                            /* 0609 */
entry_name         = 'rexxlibregister'                            /* 0610 */
function_name      = 'RexxLibRegister'                            /* 0611 */
anticipated_return = '1'                                          /* 0612 */
call REGISTER_ROUTINE function_name module entry_name anticipated_return
return                                                            /* 0614 */
                                                                  /* 0615 */
                                                                  /* 0616 */
REGISTER_ROUTINE:                                                 /* 0617 */
parse ARG  function_name,                                         /* 0618 */
           module,                                                /* 0619 */
           entry_name,                                            /* 0620 */
           anticipated_return                                     /* 0621 */
                                                                  /* 0622 */
if RxFuncQuery(function_name) = 0 then return      /* function registered */
                                                                  /* 0624 */
if LENGTH(module) > 8 then                                        /* 0625 */
   do                                                             /* 0626 */
      dll_drive = FILESPEC( 'D', module )                         /* 0627 */
      dll_path  = STRIP( FILESPEC( 'P', module ), 'T', '\' )      /* 0628 */
      module    = FILESPEC( 'N', module )                         /* 0629 */
      '@' || dll_drive                                            /* 0630 */
      '@cd' dll_drive || dll_path                                 /* 0631 */
   end                                                            /* 0632 */
else                                                              /* 0633 */
   do                                                             /* 0634 */
      dll_drive = ''                                              /* 0635 */
   end                                                            /* 0636 */
                                                                  /* 0637 */
parse var module module_fname '.' module_fext                     /* 0638 */
if RxFuncAdd( function_name, module_fname, entry_name ) = 0 then  /* 0639 */
   do                                                             /* 0640 */
      register_call = 'call' function_name                        /* 0641 */
      interpret register_call                                     /* 0642 */
      if WORD( RESULT, 1 ) <> WORD( anticipated_return, 1 ) then  /* 0643 */
         do                                                       /* 0644 */
            Say function_name 'returned' RESULT '-',              /* 0645 */
                                         anticipated_return 'was expected'
            exit 255                                              /* 0647 */
         end                                                      /* 0648 */
   end                                                            /* 0649 */
else                                                              /* 0650 */
   do                                                             /* 0651 */
      Say 'RxFuncAdd returned' RESULT 'registering' module        /* 0652 */
      exit 254                                                    /* 0653 */
   end                                                            /* 0654 */
if dll_drive <> '' then                                           /* 0655 */
   do                                                             /* 0656 */
      '@' || LEFT( GBL.program_path_and_name, 2 )                 /* 0657 */
   end                                                            /* 0658 */
return                                                            /* 0659 */
                                                                  /* 0660 */
/*------------------------------------------------------------------------*\
|                                                                          |
|                              Trap Routines                               |
|                                                                          |
\*------------------------------------------------------------------------*/
ERROR:   call TRAP_PROCESSING SIGL, 'ERROR',   RC                 /* 0666 */
FAILURE: call TRAP_PROCESSING SIGL, 'FAILURE', RC                 /* 0667 */
HALT:    call TRAP_PROCESSING SIGL, 'HALT',    ''                 /* 0668 */
NOVALUE: call TRAP_PROCESSING SIGL, 'NOVALUE', ''                 /* 0669 */
SYNTAX:  call TRAP_PROCESSING SIGL, 'SYNTAX',  RC                 /* 0670 */
                                                                  /* 0671 */
/* Rev. 94/06/14 */                                               /* 0672 */
TRAP_PROCESSING:                                                  /* 0673 */
   parse Source . . TRAP.path_and_program                         /* 0674 */
   if POS( ':', TRAP.path_and_program ) > 0 then                  /* 0675 */
      /* get source line if it is available */                    /* 0676 */
      do                                                          /* 0677 */
         trap_source_line = STRIP( SOURCELINE(ARG(1)) )           /* 0678 */
      end                                                         /* 0679 */
   else                                                           /* 0680 */
      /* program is running in macrospace */                      /* 0681 */
      do                                                          /* 0682 */
         TRAP.path_and_program = VALUE( 'TEMP',, 'OS2ENVIRONMENT' ) ||,
                                 TRAP.path_and_program            /* 0684 */
         trap_source_line = 'Source line is not available.'       /* 0685 */
      end                                                         /* 0686 */
                                                                  /* 0687 */
   parse value FILESPEC( 'N', TRAP.path_and_program ) with,       /* 0688 */
      TRAP.fn '.' TRAP.fe                                         /* 0689 */
   trap_file_name = FILESPEC( 'D', TRAP.path_and_program ) ||,    /* 0690 */
                    FILESPEC( 'P', TRAP.path_and_program ) ||,    /* 0691 */
                    TRAP.fn || '.' || 'DMP'                       /* 0692 */
                                                                  /* 0693 */
   /*------------------------------------------*\                 /* 0694 */
   |  check for reason not to create .DMP file  |                 /* 0695 */
   \*------------------------------------------*/                 /* 0696 */
   if ARG(2) = 'HALT',                                            /* 0697 */
         |,                                                       /* 0698 */
      RxFuncQuery( 'VARDUMP' ) <> 0,                              /* 0699 */
         |,                                                       /* 0700 */
      POS( ':', trap_file_name ) = 0 then                         /* 0701 */
      do                                                          /* 0702 */
         trap_file_name = ''                                      /* 0703 */
      end                                                         /* 0704 */
                                                                  /* 0705 */
   /*------------------------*\                                   /* 0706 */
   |  Build trap message box  |                                   /* 0707 */
   \*------------------------*/                                   /* 0708 */
   dbl.h    = 'CD'x                 /*  double line - horizontal   */
   dbl.v    = 'BA'x                 /*  double line - vertical     */
   dbl.bl   = 'C8'x                 /*  double line - bottom left  */
   dbl.br   = 'BC'x                 /*  double line - bottom right */
   dbl.tl   = 'C9'x                 /*  double line - top left     */
   dbl.tr   = 'BB'x                 /*  double line - top right    */
   say ' '                                                        /* 0715 */
   trap_error_description =,                                      /* 0716 */
      'Error line = ' || ARG(1) ||,                               /* 0717 */
      '; ' ||,                                                    /* 0718 */
      ARG(2) ||,                                                  /* 0719 */
      ' error.'                                                   /* 0720 */
   if ARG(3) <> '' then                                           /* 0721 */
      trap_error_description = trap_error_description ||,         /* 0722 */
                               '  Return code = ' || ARG(3)       /* 0723 */
   say dbl.tl || COPIES( dbl.h, LENGTH(trap_error_description) + 2 ) || dbl.tr
   say dbl.v  || COPIES( ' ',   LENGTH(trap_error_description) + 2 ) || dbl.v
   say dbl.v               trap_error_description                       dbl.v
   if trap_file_name <> '' then                                   /* 0727 */
      do                                                          /* 0728 */
   say dbl.v  || COPIES( ' ',   LENGTH(trap_error_description) + 2 ) || dbl.v
   say dbl.v     CENTER( 'See: ' || trap_file_name,,              /* 0730 */
                                      LENGTH(trap_error_description) )  dbl.v
      end                                                         /* 0732 */
   say dbl.v  || COPIES( ' ',   LENGTH(trap_error_description) + 2 ) || dbl.v
   say dbl.bl || COPIES( dbl.h, LENGTH(trap_error_description) + 2 ) || dbl.br
   say ' '                                                        /* 0735 */
   say 'Source line at time of trap:'                             /* 0736 */
   say '   ' || trap_source_line                                  /* 0737 */
   say ' '                                                        /* 0738 */
                                                                  /* 0739 */
   /*---------------------------------*\                          /* 0740 */
   |  Create .DMP file if appropriate  |                          /* 0741 */
   \*---------------------------------*/                          /* 0742 */
   if trap_file_name <> '' then                                   /* 0743 */
      do                                                          /* 0744 */
         call SysFileDelete trap_file_name                        /* 0745 */
         /* remove meaningless labels from dump for clarity */    /* 0746 */
         drop dbl. TRAP. RC RESULT SIGL !tr!                      /* 0747 */
         call VARDUMP trap_file_name  /* write variables to program.DMP file */
      end                                                         /* 0749 */
   exit -254                                                      /* 0750 */
                                                                  /* 0751 */
/*------------------------------------------------------------------------*\
|                                                                          |
|                   Write output line & tally line count                   |
|                                                                          |
\*------------------------------------------------------------------------*/
WRITE_OUTPUT_FILE:                                                /* 0757 */
   Procedure expose,                                              /* 0758 */
      GBL.program_name,                                           /* 0759 */
      output_file,                                                /* 0760 */
      output_file_line_count,                                     /* 0761 */
      SYS001 SYS002                                               /* 0762 */
                                                                  /* 0763 */
output_file_line_count = output_file_line_count + 1               /* 0764 */
call LINEOUT output_file, ARG(1)                                  /* 0765 */
if RESULT <> 0 then                                               /* 0766 */
   do                                                             /* 0767 */
      call LINEOUT 'CON:', '0D0A'x ||,                            /* 0768 */
                           'Error writing line number ' ||,       /* 0769 */
                           output_file_line_count ||,             /* 0770 */
                           ' to ' ||,                             /* 0771 */
                           output_file || '.'                     /* 0772 */
      call LINEOUT 'CON:', 'Possibly insufficient disk space.'    /* 0773 */
      call LINEOUT 'CON:', 'Work files - ' ||,                    /* 0774 */
                           SYS001 || ' & ' || SYS002 ||,          /* 0775 */
                           ' not erased.'                         /* 0776 */
      call EOJ 255                                                /* 0777 */
   end                                                            /* 0778 */
return                                                            /* 0779 */
/*---------  REXX Cross Reference  - Created: 03/27/95 0:51am ----------*\
     J:\REXXPROG\LISTEA\LISTEA.CMD - Directory time stamp 3/12/95 4:44p

---- VARIABLES ----
!tr!                0218<  0218   0218   0747
Calling_Environment
                    0055
DRIVE_NOTREADY      0491
GBL.                0257   0449   0487
GBL.boot_drive      0058<
GBL.dircmd_value    0524<  0532   0535
GBL.environment     0057<  0058   0524   0535
GBL.program_name    0059<  0065   0384   0759
GBL.program_path    0060<  0083   0097   0098
GBL.program_path_and_name
                    0657
GBL.program_version
                    0062<
GBL.sDate_character
                    0077<  0552   0553
GBL.spaces          0106<  0113   0126   0145   0496   0506   0516   0527
OS_Name             0054
RC                  0666   0667   0670   0747
RESULT              0643   0645   0652   0747   0766
REXX_Version        0053   0588   0602
SIGL                0666   0667   0668   0669   0670   0747
SYS001              0097<  0213   0262   0387   0487   0531   0540   0541
                    0573   0574   0762   0775
SYS002              0098<  0115   0119   0131   0133   0138   0214   0262
                    0387   0487   0571   0762   0775
TRAP.               0747
TRAP.fe             0689
TRAP.fn             0689   0692
TRAP.path_and_program
                    0674   0675   0683<  0684   0688   0690   0691
Version             0053
X                   0474   0474   0475   0476   0477   0477
anticipated_return  0596<  0597   0612<  0613   0621   0643   0646
bksp                0162<  0167   0173
byte_count          0405<  0406
contig_hex_tt       0260   0385   0403   0444   0468<
crlf                0267<  0320   0328
dbl.                0747
dbl.bl              0711<  0734
dbl.br              0712<  0734
dbl.h               0709<  0724   0734
dbl.tl              0713<  0724
dbl.tr              0714<  0724
dbl.v               0710<  0725   0725   0726   0726   0729   0729   0730
                    0731   0733   0733
directory_line      0541<  0543   0552   0553   0554
directory_of_constant
                    0539<  0543
directory_of_value  0543   0544   0546
dll_drive           0627<  0630   0631   0635<  0655
dll_path            0628<  0631
drive               0489<  0492   0498   0504   0508   0514   0518   0526
                    0529   0531
drive_table         0116   0117   0445   0457<
duration            0240<  0245
e                   0130<  0132<  0132   0140   0165   0356<  0357
ea_count            0269<  0270   0273
ea_data             0390<  0395   0396   0396
ea_example          0201   0207
ea_hex_value        0201   0203
ea_max_length       0105<  0255   0363   0364<
ea_name             0201   0202
ea_table.           0256   0446   0458<
ea_table.0          0199   0200   0356   0357<  0458<
ea_table.e          0358<
ea_table.ea_name    0205
ea_table.i          0201
ea_table.name       0354   0362<  0368<  0368
elapsed_time        0232<  0233
entry_name          0594<  0597   0610<  0613   0620   0639
eoj_rc              0228<  0230<  0246
file_date           0555
file_ea_size        0558   0560
file_name           0265   0266<  0266   0269   0274   0286   0361   0559
                    0561   0562   0564
file_size           0265   0287   0557   0569
file_table.         0128<
file_table.0        0140<  0141   0165
file_table.e        0134<  0166
file_table_max_length
                    0129<  0135<  0135   0142
file_time           0556
flag_stem.i         0333
free_space          0087<  0088
full_file_name      0563<  0567   0570
function_name       0593<  0597   0611<  0613   0618   0623   0639   0641
                    0645
heading.            0447
heading.1           0151<  0155   0157<  0157   0160
heading.2           0178<  0181
hex_displacement    0391<  0408   0423   0432<  0432
hex_tt              0448   0462<  0463<  0463   0464<  0464   0465<  0465
hh                  0239<  0240
i                   0200   0280   0317
input_line          0133<  0134   0136
leading_token       0396   0398   0404   0405
list_control        0292<  0295<  0297<  0299<  0306<  0310<  0316   0341
                    0346   0348
micro_seconds       0233   0234
minutes             0237<  0238   0239
mm                  0238<  0239   0240
module              0595<  0597   0604<  0608<  0613   0619   0625   0627
                    0628   0629<  0629   0638   0652
module_fext         0638
module_fname        0638   0639
name                0281<  0294   0296   0298   0304   0308   0358   0363
                    0364   0491
name_stem.0         0280
name_stem.i         0281   0335
notready_switch     0490<  0494   0578   0579<
output_disk         0084<  0087   0092
output_file         0083<  0084   0085   0147   0160   0181   0188   0197
                    0210   0258   0276   0382   0451   0760   0765   0772
output_file_line_count
                    0086<  0259   0319   0327   0383   0761   0764<  0764
                    0770
output_line         0184<  0188   0190<  0197   0202<  0208   0286<  0289<
                    0289   0320<  0320   0321   0328<  0328   0329   0332<
                    0339   0407<  0416   0422<  0428   0569<  0571
output_width        0104<  0155   0180   0450   0459<
path_name           0538<  0546<  0547   0548<  0548   0563
prev_character_string
                    0392<  0399   0433<
program_name        0243<  0244
program_path_and_name
                    0056   0059   0060   0061   0242   0243
progress_list       0163<  0168   0170
progress_subscript  0164<  0168   0169<  0169   0170   0171<
register_call       0641<  0642
sameness_switch     0393<  0417<  0420   0429<
seconds             0233   0235<  0235   0236   0237
space_count         0155<  0156   0156   0158
spread_hex_tt       0261   0386   0401   0452   0469<
ss                  0236<  0237   0240
temp_character_string
                    0398<  0399   0402   0415   0433
temp_hex_length     0406<  0411   0412
temp_hex_string     0401<  0411
title               0149<  0150   0155   0159   0453   0460<  0487   0526<
                    0526
trap_error_description
                    0716<  0722<  0722   0724   0725   0726   0729   0731
                    0733   0734
trap_file_name      0690<  0701   0703<  0727   0730   0743   0745   0748
trap_source_line    0678<  0685<  0737
tt_128              0263   0388   0415   0454   0474<
tt_256              0455   0475<
value_stem.i        0306   0310   0337   0343   0348   0359   0360
w                   0116   0117
with                0201   0233   0396   0543   0688
word_count          0404<  0405   0406
x                   0078   0160   0162   0179   0182   0267   0272   0306
                    0310   0462   0463   0463   0464   0464   0465   0465
                    0468   0468   0469   0469   0469   0470   0470   0470
                    0471   0471   0471   0472   0472   0709   0710   0711
                    0712   0713   0714   0768

---- LABELS ----
DRIVE_NOTREADY      0577:
EOJ                 0216   0224:  0777
ERROR               0068   0666:
FAILURE             0069   0667:
FORMAT_EA_DETAIL    0343   0348   0380:
FORMAT_EA_ITEM      0166   0253:
HALT                0070   0668:
INITIALIZE          0103   0442:
NOVALUE             0071   0669:
OFF                 0493
ON                  0491
PROCESS_DRIVE       0117   0485:
PROCESS_SYS002      0124:
REGISTER_REQUIRED_FUNCTIONS
                    0066   0587:
REGISTER_ROUTINE    0597   0613   0617:
SYNTAX              0072   0670:
TRAP_PROCESSING     0666   0667   0668   0669   0670   0673:
WRITE_OUTPUT_FILE   0208   0321   0329   0339   0416   0428   0757:

---- FUNCTIONS ----
ARG                 0227   0230   0390   0489   0678   0697   0717   0719
                    0721   0723   0765
ARRAYSORT           0141   0199
C2X                 0203   0333   0402
CENTER              0180   0730
CHAROUT             0145   0167
COPIES              0106   0113   0126   0145   0148   0153   0158   0190
                    0191   0192   0193   0194   0195   0196   0204   0206
                    0332   0407   0409   0412   0414   0422   0424   0462
                    0474   0474   0496   0506   0516   0527   0724   0725
                    0729   0733   0734
D2X                 0337   0408   0423
DATE                0152
DOSDISK             0087   0504
DOSEALIST           0269
DOSFILESYS          0514
FILESPEC            0059   0060   0061   0084   0243   0276   0627   0628
                    0629   0688   0690   0691
FORMAT              0205   0236   0238   0239
LEFT                0058   0184   0185   0186   0202   0294   0333   0335
                    0348   0398   0411   0426   0569   0657
LENGTH              0136   0155   0155   0170   0337   0363   0364   0404
                    0405   0625   0724   0725   0729   0731   0733   0734
LINEIN              0133   0541
LINEOUT             0090   0093   0160   0173   0181   0188   0197   0571
                    0765   0768   0773   0774
LINES               0131   0540
MAX                 0135
OVERLAY             0463   0464   0465
POS                 0306   0310   0567   0675   0701
RIGHT               0547
RxFuncAdd           0639
RxFuncQuery         0623   0699
SOURCELINE          0678
STREAM              0119   0138   0210   0492   0573
STRIP               0078   0266   0281   0526   0564   0628   0678
SUBSTR              0168   0234   0359   0360   0552   0553
SysCurState         0144   0211
SysDriveMap         0457
SysFileDelete       0085   0115   0213   0214   0574   0745
SysIni              0078
TIME                0063   0065   0154   0232   0244
TRACE               0218
TRANSLATE           0084   0245   0401   0415
VALUE               0058   0218   0524   0535   0683
VARDUMP             0748
WORD                0117   0643   0643
WORDS               0116
X2D                 0463   0464   0465
XRANGE              0463   0464   0465   0468   0469   0470   0471   0472
                    0474   0477

\*-------------------  End of REXX Cross Reference  -------------------*/
