/*------------------------------------------------------------------------*\
|                                                                          |
|           LISTCFG.CMD  - Version 1.0 - Version Date 1995-09-22           |
|                 Copyright (C) 1995 by C F S Nevada, Inc.                 |
|                                                                          |
|                  by Dick Goran  - Voice    702-732-9616                  |
|                                 - FAX      702-732-3847                  |
|                                 - CIS      71154,2002                    |
|                                 - Internet dgoran@cfsrexx.com            |
|                                 - WWW      <http://www.cfsrexx.com>      |
|                                                                          |
\*------------------------------------------------------------------------*/
/*

   This program will create a CONFIG.TXT file which will contain date &
   time stamps for all files referenced in CONFIG.SYS as well as breaking
   all multiple directory lines (e.g PATH, LIBPATH, etc.) into short
   lines. The output .TXT file will be created in th esame directory where
   the CONFIG.SYS file is located.

   Default is to use CONFIG.SYS on the boot drive; however, an alternate
   CONFIG.SYS can be specified by supplying its full file system name
   on the command line.

*/                                                                /* 0025 */
                                                                  /* 0026 */
GBL. = ''             /* initialize stem */                       /* 0027 */
parse Arg             GBL.command_line                            /* 0028 */
parse Version         GBL.REXX_version,                           /* 0029 */
                      GBL.REXX_version_level,                     /* 0030 */
                      GBL.REXX_version_day,                       /* 0031 */
                      GBL.REXX_version_month,                     /* 0032 */
                      GBL.REXX_version_year .                     /* 0033 */
parse Source          GBL.operating_system,                       /* 0034 */
                      GBL.calling_environment,                    /* 0035 */
                      GBL.program_path_and_name                   /* 0036 */
GBL.environment     = 'OS2ENVIRONMENT'                            /* 0037 */
GBL.boot_drive      = LEFT( VALUE( 'RUNWORKPLACE',, GBL.environment ), 2 )
GBL.program_version = 1.0           /* version / mod of this program */
GBL.program_name    = STRIP( FILESPEC( 'N', GBL.program_path_and_name ) )
GBL.program_path    = STRIP( FILESPEC( 'D', GBL.program_path_and_name ) ||,
                             FILESPEC( 'P', GBL.program_path_and_name ) )
                                                                  /* 0043 */
parse var GBL.program_name,                                       /* 0044 */
   GBL.program_fn '.',                                            /* 0045 */
   GBL.program_fe                                                 /* 0046 */
                                                                  /* 0047 */
call TIME 'E'                       /* set elapsed timer - sssss.uuuuu */
say 'Begin' TRANSLATE( GBL.program_name ) 'at' TIME('N')          /* 0049 */
                                                                  /* 0050 */
call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'         /* 0051 */
call SysLoadFuncs                                                 /* 0052 */
                                                                  /* 0053 */
/*------------------------*\                                      /* 0054 */
|  Enable trap processing  |                                      /* 0055 */
|    if REXXLIB present    |                                      /* 0056 */
\*------------------------*/                                      /* 0057 */
   SIGNAL ON ERROR                                                /* 0058 */
   SIGNAL ON FAILURE                                              /* 0059 */
   SIGNAL ON HALT                                                 /* 0060 */
   SIGNAL ON NOVALUE                                              /* 0061 */
   SIGNAL ON SYNTAX                                               /* 0062 */
                                                                  /* 0063 */
/*------------------------------------*\                          /* 0064 */
|  Assure validity of CONFIG.SYS file  |                          /* 0065 */
\*------------------------------------*/                          /* 0066 */
if GBL.command_line = '' then                                     /* 0067 */
   do                                                             /* 0068 */
      input_file =,                                               /* 0069 */
         STREAM( GBL.boot_drive || '\CONFIG.SYS', 'C', 'QUERY EXISTS' )
   end                                                            /* 0071 */
else                                                              /* 0072 */
   do                                                             /* 0073 */
      input_file =,                                               /* 0074 */
         STREAM( GBL.command_line, 'C', 'QUERY EXISTS' )          /* 0075 */
   end                                                            /* 0076 */
if input_file = '' then                                           /* 0077 */
   do                                                             /* 0078 */
      say '   Unable to locate CONFIG.SYS on' GBL.boot_drive      /* 0079 */
      call EOJ                                                    /* 0080 */
   end                                                            /* 0081 */
                                                                  /* 0082 */
/*--------------------*\                                          /* 0083 */
|  Create output file  |                                          /* 0084 */
\*--------------------*/                                          /* 0085 */
output_file =,                                                    /* 0086 */
   FILESPEC( 'D', input_file ) ||,                                /* 0087 */
   FILESPEC( 'P', input_file ) ||,                                /* 0088 */
   'CONFIG.TXT'                                                   /* 0089 */
call SysFileDelete output_file                                    /* 0090 */
                                                                  /* 0091 */
dbl_h     = ''                     /* double line - horizontal            */
dbl_v     = ''                     /* double line - vertical              */
dbl_bl    = ''                     /* double line - bottom left           */
dbl_br    = ''                     /* double line - bottom right          */
dbl_tl    = ''                     /* double line - top left              */
dbl_tr    = ''                     /* double line - top right             */
title     =,                                                      /* 0098 */
   ' This file was created from '              ||,                /* 0099 */
   input_file                                  ||,                /* 0100 */
   '   ('                                      ||,                /* 0101 */
   STREAM( input_file, 'C', 'QUERY DATETIME' ) ||,                /* 0102 */
   ') '                                                           /* 0103 */
                                                                  /* 0104 */
h=0                                                               /* 0105 */
h=h+1; heading.h =,                                               /* 0106 */
          dbl_tl || COPIES( dbl_h, LENGTH(title) ) || dbl_tr      /* 0107 */
h=h+1; heading.h =,                                               /* 0108 */
          dbl_v  ||         title                  || dbl_v       /* 0109 */
h=h+1; heading.h =,                                               /* 0110 */
          dbl_bl || COPIES( dbl_h, LENGTH(title) ) || dbl_br      /* 0111 */
h=h+1; heading.h = ''                                             /* 0112 */
       heading.0 = h                                              /* 0113 */
do h = 1 to heading.0                                             /* 0114 */
   call LINEOUT output_file, heading.h                            /* 0115 */
end                                                               /* 0116 */
                                                                  /* 0117 */
/*--------------------------------*\                              /* 0118 */
|  Format CONFIG.SYS line-by-line  |                              /* 0119 */
\*--------------------------------*/                              /* 0120 */
known_file_name_lines =,                                          /* 0121 */
   'COUNTRY=',                                                    /* 0122 */
   'DEVICE=',                                                     /* 0123 */
   'IFS=',                                                        /* 0124 */
   'LIBPATH=',                                                    /* 0125 */
   'PROTSHELL=',                                                  /* 0126 */
   'RUN=',                                                        /* 0127 */
   'SHELL=',                                                      /* 0128 */
   ''                                                             /* 0129 */
                                                                  /* 0130 */
do while LINES( input_file ) > 0                                  /* 0131 */
   input_line = LINEIN( input_file )                              /* 0132 */
   uppercase_input_line = SPACE( TRANSLATE( input_line ) )        /* 0133 */
                                                                  /* 0134 */
   /*------------------------------------*\                       /* 0135 */
   |  Setup correct length, blank fields  |                       /* 0136 */
   \*------------------------------------*/                       /* 0137 */
   output_name = ''                                               /* 0138 */
   output_date = COPIES( ' ', 10 )                                /* 0139 */
   output_time = COPIES( ' ',  8 )                                /* 0140 */
   output_max_width = 76 - ( LENGTH(output_date) + LENGTH(output_time) )
                                                                  /* 0142 */
   /*---------------------------------*\                          /* 0143 */
   |  Check for lines with file names  |                          /* 0144 */
   \*---------------------------------*/                          /* 0145 */
   file_name_ext = ''                                             /* 0146 */
   do w = 1 to WORDS( known_file_name_lines )                     /* 0147 */
      keyword = WORD( known_file_name_lines, w )                  /* 0148 */
      if LEFT( uppercase_input_line, LENGTH(keyword) ) = keyword then
         do                                                       /* 0150 */
            parse value input_line with,                          /* 0151 */
               '=',                                               /* 0152 */
               possible_full_path_name,                           /* 0153 */
               .                                                  /* 0154 */
            file_name_ext =,                                      /* 0155 */
               FILESPEC( 'N', possible_full_path_name )           /* 0156 */
            leave w                                               /* 0157 */
         end                                                      /* 0158 */
   end                                                            /* 0159 */
   if file_name_ext = '' then                                     /* 0160 */
      do                                                          /* 0161 */
         /* let FILESPEC() try to find the file name */           /* 0162 */
         file_name_ext = FILESPEC( 'N', input_line )              /* 0163 */
      end                                                         /* 0164 */
                                                                  /* 0165 */
   if file_name_ext = '',                                        /* 0166 */
         &,                                                       /* 0167 */
      LEFT( uppercase_input_line, 3 ) = 'REM' then               /* 0168 */
      do                                                          /* 0169 */
         /*---------------------------------*\                    /* 0170 */
         |  Remove any follow-on parameters  |                    /* 0171 */
         \*---------------------------------*/                    /* 0172 */
         parse value file_name_ext with,                          /* 0173 */
            file_name_ext,                                        /* 0174 */
            .                                                     /* 0175 */
                                                                  /* 0176 */
         /*--------------------------------------------*\         /* 0177 */
         |  Point backward from fn.fe to get full path  |         /* 0178 */
         \*--------------------------------------------*/         /* 0179 */
         file_name_ptr = POS( file_name_ext, input_line )         /* 0180 */
         if LEFT( uppercase_input_line, 8 ) = 'BASEDEV=' then     /* 0181 */
            do                                                    /* 0182 */
               parse value input_line with,                       /* 0183 */
                  '=',                                            /* 0184 */
                  file_name_ext,                                  /* 0185 */
                  .                                               /* 0186 */
               file_name_ext =,                                   /* 0187 */
                  GBL.boot_drive || '\OS2\BOOT\' ||,              /* 0188 */
                  file_name_ext                                   /* 0189 */
            end                                                   /* 0190 */
         else                                                     /* 0191 */
            do                                                    /* 0192 */
               drive_ptr = LASTPOS( ':', input_line, file_name_ptr ) - 1
               if drive_ptr > 0 then                              /* 0194 */
                  do                                              /* 0195 */
                     file_name_ext =,                             /* 0196 */
                        SUBSTR( input_line,,                      /* 0197 */
                                drive_ptr,,                       /* 0198 */
                                file_name_ptr - drive_ptr ) ||,   /* 0199 */
                        file_name_ext                             /* 0200 */
                  end                                             /* 0201 */
               else                                               /* 0202 */
                  do                                              /* 0203 */
                     file_name_ext =,                             /* 0204 */
                        GBL.boot_drive || '\' ||,                 /* 0205 */
                        file_name_ext                             /* 0206 */
                  end                                             /* 0207 */
            end                                                   /* 0208 */
                                                                  /* 0209 */
         /*-------------------------------------------*\          /* 0210 */
         |  Get & format time stamp if file was found  |          /* 0211 */
         \*-------------------------------------------*/          /* 0212 */
         if POS( '.', file_name_ext ) > 0 then                    /* 0213 */
            do                                                    /* 0214 */
               call FORMAT_DATE_AND_TIME file_name_ext            /* 0215 */
            end                                                   /* 0216 */
      end                                                         /* 0217 */
                                                                  /* 0218 */
      /*--------------------------------------------------*\      /* 0219 */
      |  Find equal sign position as continuation pointer  |      /* 0220 */
      \*--------------------------------------------------*/      /* 0221 */
      equal_ptr = POS( '=', input_line )                          /* 0222 */
                                                                  /* 0223 */
      /*------------------------------------------------*\        /* 0224 */
      |  Write ouput line for short, REM, or no = lines  |        /* 0225 */
      \*------------------------------------------------*/        /* 0226 */
      if LENGTH( input_line ) <= output_max_width,                /* 0227 */
            |,                                                    /* 0228 */
         equal_ptr = 0,                                           /* 0229 */
            |,                                                    /* 0230 */
         LEFT( uppercase_input_line, 3 ) = 'REM' then             /* 0231 */
         do                                                       /* 0232 */
            call LINEOUT output_file,,                            /* 0233 */
               output_date ||,                                    /* 0234 */
               output_time ||,                                    /* 0235 */
               input_line                                         /* 0236 */
            iterate                                               /* 0237 */
         end                                                      /* 0238 */
                                                                  /* 0239 */
      /*-------------------*\                                     /* 0240 */
      |  Format long lines  |                                     /* 0241 */
      \*-------------------*/                                     /* 0242 */
      parse value input_line with,                                /* 0243 */
         before_equal,                                            /* 0244 */
         '=',                                                     /* 0245 */
         after_equal                                              /* 0246 */
      output_line =,                                              /* 0247 */
         output_date ||,                                          /* 0248 */
         output_time ||,                                          /* 0249 */
         before_equal || '='                                      /* 0250 */
      continuation = COPIES( ' ', LENGTH( output_line ) )         /* 0251 */
      before_equal = ''                                           /* 0252 */
                                                                  /* 0253 */
      do forever                                                  /* 0254 */
         parse value after_equal with,                            /* 0255 */
            token,                                                /* 0256 */
            ';',                                                  /* 0257 */
            after_equal                                           /* 0258 */
         if POS( ':\', token ) > 0,                               /* 0259 */
               &,                                                 /* 0260 */
            STREAM( token, 'C', 'QUERY DATETIME') = '' then      /* 0261 */
            do                                                    /* 0262 */
               call FORMAT_DATE_AND_TIME token                    /* 0263 */
               output_line =,                                     /* 0264 */
                  OVERLAY( output_date || output_time, output_line, 1 )
            end                                                   /* 0266 */
         if POS( ':\', token ) > 0,                               /* 0267 */
               &,                                                 /* 0268 */
            LEFT( output_line, LENGTH( output_date) ) =,          /* 0269 */
                  COPIES( ' ', LENGTH( output_date ) ) then       /* 0270 */
            do                                                    /* 0271 */
               output_line =,                                     /* 0272 */
                  OVERLAY( '?', output_line, 1 )                  /* 0273 */
            end                                                   /* 0274 */
         if LENGTH( output_line ) >= LENGTH( continuation ) then  /* 0275 */
            do                                                    /* 0276 */
               output_line =,                                     /* 0277 */
                  output_line ||,                                 /* 0278 */
                  token || ';'                                    /* 0279 */
            end                                                   /* 0280 */
         else                                                     /* 0281 */
            do                                                    /* 0282 */
               output_line =,                                     /* 0283 */
                  LEFT( output_line, LENGTH( continuation ) ) ||, /* 0284 */
                  token || ';'                                    /* 0285 */
            end                                                   /* 0286 */
         call LINEOUT output_file, output_line                    /* 0287 */
         output_line = ''                                         /* 0288 */
         if after_equal = '' then                                 /* 0289 */
            do                                                    /* 0290 */
               leave                                              /* 0291 */
            end                                                   /* 0292 */
      end                                                         /* 0293 */
                                                                  /* 0294 */
end                                                               /* 0295 */
                                                                  /* 0296 */
call STREAM input_file,  'C', 'CLOSE'                             /* 0297 */
call STREAM output_file, 'C', 'CLOSE'                             /* 0298 */
                                                                  /* 0299 */
call EOJ 0                                                        /* 0300 */
                                                                  /* 0301 */
/*------------------------------------------------------------------------*\
|                                                                          |
|          Format date and time for file name passed as parameter          |
|                                                                          |
\*------------------------------------------------------------------------*/
FORMAT_DATE_AND_TIME:                                             /* 0307 */
                                                                  /* 0308 */
parse value STREAM( ARG(1), 'C', 'QUERY DATETIME' ) with,         /* 0309 */
   month   '-',                                                   /* 0310 */
   day     '-',                                                   /* 0311 */
   year    '  ',                                                  /* 0312 */
   hours   ':',                                                   /* 0313 */
   minutes ':',                                                   /* 0314 */
   seconds                                                        /* 0315 */
                                                                  /* 0316 */
date_stamp =,                                                     /* 0317 */
   RIGHT( year,  2, '0' ) || '/' ||,                              /* 0318 */
   RIGHT( month, 2, '0' ) || '/' ||,                              /* 0319 */
   RIGHT( day,   2, '0' )                                         /* 0320 */
                                                                  /* 0321 */
am_pm = 'a'                                                       /* 0322 */
if hours > 11 then                                                /* 0323 */
   do                                                             /* 0324 */
      am_pm = 'p'                                                 /* 0325 */
      if hours > 12 then                                          /* 0326 */
         do                                                       /* 0327 */
            hours = hours - 12                                    /* 0328 */
         end                                                      /* 0329 */
   end                                                            /* 0330 */
                                                                  /* 0331 */
time_stamp =,                                                     /* 0332 */
   RIGHT( hours,   '2', '0' ) || ':' ||,                          /* 0333 */
   RIGHT( minutes, '2', '0' ) ||,                                 /* 0334 */
   am_pm                                                          /* 0335 */
                                                                  /* 0336 */
output_date =,                                                    /* 0337 */
   LEFT( date_stamp, LENGTH( output_date ) )                      /* 0338 */
output_time =,                                                    /* 0339 */
   LEFT( time_stamp, LENGTH( output_time ) )                      /* 0340 */
                                                                  /* 0341 */
return                                                            /* 0342 */
                                                                  /* 0343 */
!tr! = VALUE('TRACE',,GBL.environment); if !tr! <> '' then do; TRACE(!tr!); nop; end
/*------------------------------------------------------------------------*\
|                                                                          |
|                                End of Job                                |
|                                                                          |
\*------------------------------------------------------------------------*/
EOJ:                                                              /* 0350 */
   Procedure expose,                                              /* 0351 */
      GBL.                                                        /* 0352 */
                                                                  /* 0353 */
if ARG() = 0 then                                                 /* 0354 */
   eoj_rc = 0                                                     /* 0355 */
else                                                              /* 0356 */
   eoj_rc = ARG(1)                                                /* 0357 */
                                                                  /* 0358 */
elapsed_time = TIME('E')            /* get elapsed time - sssss.uuuuu */
parse value elapsed_time with seconds '.' micro_seconds           /* 0360 */
if LEFT( micro_seconds, 1, 1 ) >= 5 then                          /* 0361 */
   seconds = seconds + 1                                          /* 0362 */
ss = FORMAT( seconds // 60, 2 )                                   /* 0363 */
minutes = ( seconds - ss ) / 60                                   /* 0364 */
mm = FORMAT( minutes // 60, 2 )                                   /* 0365 */
hh = FORMAT( ( minutes - mm ) / 60, 2 )                           /* 0366 */
duration = hh':'mm':'ss                                           /* 0367 */
                                                                  /* 0368 */
program_name = TRANSLATE( FILESPEC( 'N', GBL.program_path_and_name ) )
say 'EOJ  ' program_name 'at' TIME('N') ||,                       /* 0370 */
    ', duration' TRANSLATE( duration, '0', ' ' )                  /* 0371 */
exit eoj_rc                                                       /* 0372 */
                                                                  /* 0373 */
/*------------------------------------------------------------------------*\
|                                                                          |
|                              Trap Routines                               |
|                                                                          |
\*------------------------------------------------------------------------*/
ERROR:   call TRAP_PROCESSING SIGL, 'ERROR',   RC                 /* 0379 */
FAILURE: call TRAP_PROCESSING SIGL, 'FAILURE', RC                 /* 0380 */
HALT:    call TRAP_PROCESSING SIGL, 'HALT',    ''                 /* 0381 */
NOVALUE: call TRAP_PROCESSING SIGL, 'NOVALUE', ''                 /* 0382 */
SYNTAX:  call TRAP_PROCESSING SIGL, 'SYNTAX',  RC                 /* 0383 */
                                                                  /* 0384 */
/* Rev. 95/10/14 */                                               /* 0385 */
TRAP_PROCESSING:                                                  /* 0386 */
   parse Source . . TRAP.path_and_program                         /* 0387 */
   trap.line_nbr = ARG(1)                                         /* 0388 */
   if POS( ':', TRAP.path_and_program ) > 0 then                  /* 0389 */
      /* get source line if it is available */                    /* 0390 */
      do t = 1                                                    /* 0391 */
         trap_source_line.t =  SOURCELINE( trap.line_nbr )        /* 0392 */
         trap_source_line.0 = t                                   /* 0393 */
         trap.line_nbr      = trap.line_nbr + 1                   /* 0394 */
         if RIGHT( trap_source_line.t, 1 ) = ',' then            /* 0395 */
            do                                                    /* 0396 */
               leave                                              /* 0397 */
            end                                                   /* 0398 */
      end                                                         /* 0399 */
   else                                                           /* 0400 */
      /* program is running in macrospace */                      /* 0401 */
      do                                                          /* 0402 */
         TRAP.path_and_program = STRIP( DIRECTORY(), 'T', '\' ) || '\' ||,
                                 TRAP.path_and_program            /* 0404 */
         trap_source_line.1 = 'Source line is not available.'     /* 0405 */
         trap_source_line.0 = 1                                   /* 0406 */
      end                                                         /* 0407 */
                                                                  /* 0408 */
   parse value FILESPEC( 'N', TRAP.path_and_program ) with,       /* 0409 */
      TRAP.fn '.' TRAP.fe                                         /* 0410 */
   trap_file_name = FILESPEC( 'D', TRAP.path_and_program ) ||,    /* 0411 */
                    FILESPEC( 'P', TRAP.path_and_program ) ||,    /* 0412 */
                    TRAP.fn || '.' || 'DMP'                       /* 0413 */
                                                                  /* 0414 */
   /*------------------------------------------*\                 /* 0415 */
   |  check for reason not to create .DMP file  |                 /* 0416 */
   \*------------------------------------------*/                 /* 0417 */
   if ARG(2) = 'HALT' then                                        /* 0418 */
      do                                                          /* 0419 */
         trap_file_name = ''                                      /* 0420 */
      end                                                         /* 0421 */
   if RxFuncQuery( 'VARDUMP' ) <> 0 then                          /* 0422 */
      do                                                          /* 0423 */
         trap_file_name = ''                                      /* 0424 */
      end                                                         /* 0425 */
   if POS( ':', trap_file_name ) = 0 then                         /* 0426 */
      do                                                          /* 0427 */
         trap_file_name = ''                                      /* 0428 */
      end                                                         /* 0429 */
                                                                  /* 0430 */
   /*------------------------*\                                   /* 0431 */
   |  Build trap message box  |                                   /* 0432 */
   \*------------------------*/                                   /* 0433 */
   dbl.h    = 'CD'x                 /*  double line - horizontal   */
   dbl.v    = 'BA'x                 /*  double line - vertical     */
   dbl.bl   = 'C8'x                 /*  double line - bottom left  */
   dbl.br   = 'BC'x                 /*  double line - bottom right */
   dbl.tl   = 'C9'x                 /*  double line - top left     */
   dbl.tr   = 'BB'x                 /*  double line - top right    */
   trap.red = '1B'x || '[1;37;41m'  /* bright white on red          */
   trap.dul = '1B'x || '[0m'        /* reset to normal              */
                                                                  /* 0442 */
   say ' '                                                        /* 0443 */
   trap_error_description =,                                      /* 0444 */
      'Error line = ' || ARG(1) ||,                               /* 0445 */
      '; ' ||,                                                    /* 0446 */
      ARG(2) ||,                                                  /* 0447 */
      ' error.'                                                   /* 0448 */
   if ARG(3) <> '' then                                           /* 0449 */
      trap_error_description = trap_error_description ||,         /* 0450 */
                               '  Return code = ' || ARG(3)       /* 0451 */
   trap.width = MAX( 74, LENGTH( trap_error_description ) )       /* 0452 */
   say trap.red || dbl.tl || COPIES( dbl.h,trap.width + 2 ) || dbl.tr || trap.dul
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.v CENTER( TRAP.fn'.'TRAP.fe,trap.width )    dbl.v  || trap.dul
   say trap.red || dbl.v CENTER( trap_error_description, trap.width ) dbl.v || trap.dul
   if trap_file_name <> '' then                                   /* 0457 */
      do                                                          /* 0458 */
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.v     CENTER( 'See: ' || trap_file_name,,  /* 0460 */
                                     trap.width )  dbl.v  || trap.dul
      end                                                         /* 0462 */
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.bl || COPIES( dbl.h,trap.width + 2 ) || dbl.br || trap.dul
   say trap.red || COPIES( ' ', trap.width + 4 ) || trap.dul      /* 0465 */
   say trap.red || LEFT( 'Source line(s) at time of trap:', trap.width + 4 ) || trap.dul
   do t = 1 to trap_source_line.0                                 /* 0467 */
      say trap.red || LEFT( '   ' || trap_source_line.t, trap.width + 4 ) || trap.dul
   end                                                            /* 0469 */
   say trap.red || COPIES( ' ', trap.width + 4 ) || trap.dul      /* 0470 */
                                                                  /* 0471 */
   /*---------------------------------*\                          /* 0472 */
   |  Create .DMP file if appropriate  |                          /* 0473 */
   \*---------------------------------*/                          /* 0474 */
   if trap_file_name <> '' then                                   /* 0475 */
      do                                                          /* 0476 */
         call SysFileDelete trap_file_name                        /* 0477 */
         /* remove meaningless labels from dump for clarity */    /* 0478 */
         drop dbl. TRAP. RC RESULT SIGL !tr!                      /* 0479 */
         call VARDUMP trap_file_name  /* write variables to program.DMP file */
      end                                                         /* 0481 */
   exit 253                                                       /* 0482 */
/*---------  REXX Cross Reference  - Created: 01/12/96 6:45pm ----------*\
       J:\REXXPROG\LISTCFG.CMD - Directory time stamp 12/28/95 12:26p

---- VARIABLES ----
!tr!                0344<  0344   0344   0479
GBL.                0027<  0352
GBL.REXX_version    0029
GBL.REXX_version_day
                    0031
GBL.REXX_version_level
                    0030
GBL.REXX_version_month
                    0032
GBL.REXX_version_year
                    0033
GBL.boot_drive      0038<  0070   0079   0188   0205
GBL.calling_environment
                    0035
GBL.command_line    0028   0067   0075
GBL.environment     0037<  0038   0344
GBL.operating_system
                    0034
GBL.program_fe      0046
GBL.program_fn      0045
GBL.program_name    0040<  0044   0049
GBL.program_path    0041<
GBL.program_path_and_name
                    0036   0040   0041   0042   0369
GBL.program_version
                    0039<
RC                  0379   0380   0383   0479
RESULT              0479
SIGL                0379   0380   0381   0382   0383   0479
TRAP.               0479
TRAP.fe             0410   0455
TRAP.fn             0410   0413   0455
TRAP.path_and_program
                    0387   0389   0403<  0404   0409   0411   0412
Version             0029
after_equal         0246   0255   0258   0289
am_pm               0322<  0325<  0335
before_equal        0244   0250   0252<
continuation        0251<  0275   0284
date_stamp          0317<  0338
day                 0311   0320
dbl.                0479
dbl.bl              0436<  0464
dbl.br              0437<  0464
dbl.h               0434<  0453   0464
dbl.tl              0438<  0453
dbl.tr              0439<  0453
dbl.v               0435<  0454   0454   0455   0455   0456   0456   0459
                    0459   0460   0461   0463   0463
dbl_bl              0094<  0111
dbl_br              0095<  0111
dbl_h               0092<  0107   0111
dbl_tl              0096<  0107
dbl_tr              0097<  0107
dbl_v               0093<  0109   0109
drive_ptr           0193<  0194   0198   0199
duration            0367<  0371
elapsed_time        0359<  0360
eoj_rc              0355<  0357<  0372
equal_ptr           0222<  0229
file_name_ext       0146<  0155<  0160   0163<  0166   0173   0174   0180
                    0185   0187<  0189   0196<  0200   0204<  0206   0213
                    0215
file_name_ptr       0180<  0193   0199
h                   0105<  0106<  0106   0108<  0108   0110<  0110   0112<
                    0112   0113   0114
heading.0           0113<  0114
heading.h           0106<  0108<  0110<  0112<  0115
hh                  0366<  0367
hours               0313   0323   0326   0328<  0328   0333
input_file          0069<  0074<  0077   0087   0088   0100   0102   0131
                    0132   0297
input_line          0132<  0133   0151   0163   0180   0183   0193   0197
                    0222   0227   0236   0243
keyword             0148<  0149   0149
known_file_name_lines
                    0121<  0147   0148
micro_seconds       0360   0361
minutes             0314   0334   0364<  0365   0366
mm                  0365<  0366   0367
month               0310   0319
output_date         0139<  0141   0234   0248   0265   0269   0270   0337<
                    0338
output_file         0086<  0090   0115   0233   0287   0298
output_line         0247<  0251   0264<  0265   0269   0272<  0273   0275
                    0277<  0278   0283<  0284   0287   0288<
output_max_width    0141<  0227
output_name         0138<
output_time         0140<  0141   0235   0249   0265   0339<  0340
possible_full_path_name
                    0153   0156
program_name        0369<  0370
seconds             0315   0360   0362<  0362   0363   0364
ss                  0363<  0364   0367
t                   0391   0393   0467
time_stamp          0332<  0340
title               0098<  0107   0109   0111
token               0256   0259   0261   0263   0267   0279   0285
trap.dul            0441<  0453   0454   0455   0456   0459   0461   0463
                    0464   0465   0466   0468   0470
trap.line_nbr       0388<  0392   0394<  0394
trap.red            0440<  0453   0454   0455   0456   0459   0460   0463
                    0464   0465   0466   0468   0470
trap.width          0452<  0453   0454   0455   0456   0459   0461   0463
                    0464   0465   0466   0468   0470
trap_error_description
                    0444<  0450<  0450   0452   0456
trap_file_name      0411<  0420<  0424<  0426   0428<  0457   0460   0475
                    0477   0480
trap_source_line.0  0393<  0406<  0467
trap_source_line.1  0405<
trap_source_line.t  0392<  0395   0468
uppercase_input_line
                    0133<  0149   0168   0181   0231
w                   0147   0148   0157
with                0151   0173   0183   0243   0255   0309   0360   0409
x                   0434   0435   0436   0437   0438   0439   0440   0441
year                0312   0318

---- LABELS ----
EOJ                 0080   0300   0350:
ERROR               0058   0379:
FAILURE             0059   0380:
FORMAT_DATE_AND_TIME
                    0215   0263   0307:
HALT                0060   0381:
NOVALUE             0061   0382:
RxFuncAdd           0051
SYNTAX              0062   0383:
SysLoadFuncs        0052
TRAP_PROCESSING     0379   0380   0381   0382   0383   0386:

---- FUNCTIONS ----
ARG                 0309   0354   0357   0388   0418   0445   0447   0449
                    0451
CENTER              0455   0456   0460
COPIES              0107   0111   0139   0140   0251   0270   0453   0454
                    0459   0463   0464   0465   0470
DIRECTORY           0403
FILESPEC            0040   0041   0042   0087   0088   0156   0163   0369
                    0409   0411   0412
FORMAT              0363   0365   0366
LASTPOS             0193
LEFT                0038   0149   0168   0181   0231   0269   0284   0338
                    0340   0361   0466   0468
LENGTH              0107   0111   0141   0141   0149   0227   0251   0269
                    0270   0275   0275   0284   0338   0340   0452
LINEIN              0132
LINEOUT             0115   0233   0287
LINES               0131
MAX                 0452
OVERLAY             0265   0273
POS                 0180   0213   0222   0259   0267   0389   0426
RIGHT               0318   0319   0320   0333   0334   0395
RxFuncQuery         0422
SOURCELINE          0392
SPACE               0133
STREAM              0070   0075   0102   0261   0297   0298   0309
STRIP               0040   0041   0403
SUBSTR              0197
SysFileDelete       0090   0477
TIME                0048   0049   0359   0370
TRACE               0344
TRANSLATE           0049   0133   0369   0371
VALUE               0038   0344
VARDUMP             0480
WORD                0148
WORDS               0147

\*-------------------  End of REXX Cross Reference  -------------------*/
