/*------------------------------------------------------------------------*\
|                                                                          |
|           FIXFONT3.CMD - Version 1.0 - Version Date 1996-08-11           |
|                                                                          |
\*------------------------------------------------------------------------*/
/*

   Remove any non-existing TrueType fonts from all WIN.INI & ATM.INI files

*/
GBL. = ''             /* initialize stem */
parse Arg             GBL.CommandLine 
parse Version         GBL.RexxVersion,
                      GBL.RexxVersionLevel,
                      GBL.RexxVersionDay,
                      GBL.RexxVersionMonth,
                      GBL.RexxVersionYear    .
parse Source          GBL.OperatingSystem,
                      GBL.CallingEnvironment,
                      GBL.ProgramPathAndName   /* case is unreliable */   

parse value DATE('S') with,
   year +4,
   mm   +2,
   dd

GBL.List            = 'GBL. crlf'
GBL.Environment     = 'OS2ENVIRONMENT'
GBL.BootDrive       = LEFT( VALUE( 'RUNWORKPLACE',, GBL.Environment ), 2 )
GBL.CurrentDate     = mm || '/' || dd || '/' || year
GBL.Hostname        = VALUE( 'MACHINENAME',, GBL.Environment )
GBL.Ramdrive        = VALUE( 'RAMDRIVE',, GBL.Environment )
GBL.ProgramVersion  = 1.0           /* version / mod of this program */
GBL.ProgramName     = STRIP( FILESPEC( 'N', GBL.ProgramPathAndName ) )
GBL.ProgramPath     = STRIP( FILESPEC( 'D', GBL.ProgramPathAndName ) ||,
                             FILESPEC( 'P', GBL.ProgramPathAndName ) )

parse var GBL.ProgramName,
   GBL.ProgramFn  '.',
   GBL.ProgramFe 
GBL.ProgramFe  = TRANSLATE( GBL.ProgramFe  )
call TIME 'R'                    /* reset elapsed timer - sssss.uuuuu */
say 'Begin' GBL.ProgramFn || '.' || GBL.ProgramFe  'at' TIME('N')

/*------------------------*\
|  Enable trap processing  |
|    if REXXLIB present    |
\*------------------------*/
   SIGNAL ON ERROR
   SIGNAL ON FAILURE
   SIGNAL ON HALT
   SIGNAL ON NOVALUE
   SIGNAL ON SYNTAX

crlf = '0D0A'x
GBL.font_home_path = 'M:\FONTS\'

GBL.LogFile  =,
   GBL.ProgramPath  ||,
   GBL.ProgramFn    || '.LOG'
if STREAM( GBL.LogFile, 'C', 'QUERY EXISTS' ) = '' then
   do
      log_line = crlf || COPIES( '=', 76 )
      call LINEOUT GBL.LogFile, log_line
   end
log_line = GBL.ProgramFn || '.' || GBL.ProgramFe || ' Started on' DATE() 'at' TIME() ' CPU:' GBL.Hostname '-' GBL.OperatingSystem
call LINEOUT GBL.LogFile, log_line

/*-----------------------------------------------*\
|  Table of path for all WIN.INI & ATM.INI files  |
\*-----------------------------------------------*/
p=0
/*
p=p+1; path_table.p = 'C:\WIN-311\'
p=p+1; path_table.p = 'D:\OS2\MDOS\WINOS2\'
p=p+1; path_table.p = 'F:\OS2\MDOS\WINOS2\'
p=p+1; path_table.p = 'G:\OS2\MDOS\WINOS2\'
p=p+1; path_table.p = 'H:\OS2\MDOS\WINOS2\'
*/
p=p+1; path_table.p = 'I:\OS2\MDOS\WINOS2\'
       path_table.0 = p

do p = 1 to path_table.0
   call PROCESS_ATM_INI path_table.p || 'ATM.INI'
   call PROCESS_WIN_INI path_table.p || 'WIN.INI'
end

call STREAM GBL.LogFile, 'C', 'CLOSE'

call EOJ 0

/*------------------------------------------------------------------------*\
|                                                                          |
|      Create archive with numeric file extension for specified file       |
|                                                                          |
\*------------------------------------------------------------------------*/
CREATE_ARCHIVE:
   Procedure expose,
      (GBL.List)

parse ARG original_path_and_file_name

original_path =,
   FILESPEC( 'D', original_path_and_file_name ) ||,
   FILESPEC( 'P', original_path_and_file_name )
parse value FILESPEC( 'N', original_path_and_file_name ) with,
   original_fn '.' original_fe

next_sequential_value = 0
call SysFileTree original_path || original_fn || '.*', 'stem', 'O'
do s = 1 to stem.0
   parse value FILESPEC( 'N', stem.s ) with,
      stem_fn '.' stem_fe
   if DATATYPE( stem_fe ) = 'NUM' then iterate s
   if stem_fe >= next_sequential_value then
      do
         next_sequential_value = stem_fe + 1
      end
end

new_path_and_file_name =,
   original_path || original_fn || '.' || RIGHT( next_sequential_value, 3, '0' )
call DOSCOPY original_path_and_file_name, new_path_and_file_name, 'R'
if RESULT = 0 then
   do
      log_line =,
         'Unable to copy' original_path_and_file_name 'to' new_path_and_file_name
      call LINEOUT GBL.LogFile, log_line
      say log_line
      call EOJ
   end

return

/*------------------------------------------------------------------------*\
|                                                                          |
|                    Process ATM.INI in specified path                     |
|                                                                          |
\*------------------------------------------------------------------------*/
PROCESS_ATM_INI:
   Procedure expose,
      (GBL.List)

parse ARG atm_ini_path_and_file_name

atm_ini_change_count = 0

/*-------------*\
|  Get ATM.INI  |
\*-------------*/
atm_size = STREAM( atm_ini_path_and_file_name, 'C', 'QUERY SIZE' )
if atm_size = '' then
   do
      log_line =,
         'Unable to locate' atm_ini_path_and_file_name
      call LINEOUT GBL.LogFile, log_line
      return
   end

atm_area = CHARIN( atm_ini_path_and_file_name, 1, atm_size )
call STREAM atm_ini_path_and_file_name, 'C', 'CLOSE'
uppercase_atm_area = TRANSLATE( atm_area )

/*--------------------*\
|  Check QLCDir value  |
\*--------------------*/
qlc_dir_arg = 'QLCDIR='
qlc_dir_beg = POS( crlf || qlc_dir_arg, uppercase_atm_area )
if qlc_dir_beg = 0 then
   do
      log_line =,
         'Unable to locate' qlc_dir_arg 'in' atm_ini_path_and_file_name
      call LINEOUT GBL.LogFile, log_line
      say log_line
      return
   end
qlc_dir_beg = qlc_dir_beg + LENGTH(qlc_dir_arg) + 2
qlc_dir_end = POS( crlf, uppercase_atm_area, qlc_dir_beg )
uppercase_qlc_dir_value =,
   SUBSTR( uppercase_atm_area, qlc_dir_beg, qlc_dir_end - qlc_dir_beg )
new_qlc_dir_value =,
   GBL.font_home_path || 'PSFONTS'
if uppercase_qlc_dir_value = new_qlc_dir_value then
   do
      atm_area =,
         DELSTR( atm_area, qlc_dir_beg, LENGTH(uppercase_qlc_dir_value) )
      atm_area =,
         INSERT( new_qlc_dir_value, atm_area, qlc_dir_beg - 1 )
      uppercase_atm_area = TRANSLATE( atm_area )
      atm_ini_change_count = atm_ini_change_count + 1
   end

/*---------------------*\
|  Check PFM_DIR value  |
\*---------------------*/
pfm_dir_arg = 'PFM_DIR='
pfm_dir_beg = POS( crlf || pfm_dir_arg, uppercase_atm_area )
if pfm_dir_beg = 0 then
   do
      log_line =,
         'Unable to locate' pfm_dir_arg 'in' atm_ini_path_and_file_name
      call LINEOUT GBL.LogFile, log_line
      say log_line
      return
   end
pfm_dir_beg = pfm_dir_beg + LENGTH(pfm_dir_arg) + 2
pfm_dir_end = POS( crlf, uppercase_atm_area, pfm_dir_beg )
uppercase_pfm_dir_value =,
   SUBSTR( uppercase_atm_area, pfm_dir_beg, pfm_dir_end - pfm_dir_beg )
new_pfm_dir_value =,
   GBL.font_home_path || 'PSFONTS\PFM'
if uppercase_pfm_dir_value = new_pfm_dir_value then
   do
      atm_area =,
         DELSTR( atm_area, pfm_dir_beg, LENGTH(uppercase_pfm_dir_value) )
      atm_area =,
         INSERT( new_pfm_dir_value, atm_area, pfm_dir_beg - 1 )
      uppercase_atm_area = TRANSLATE( atm_area )

      /*-----------------------*\
      |  Replace all PFM paths  |
      \*-----------------------*/
      pfm_ptr = LENGTH(atm_area)
      do forever
         pfm_ptr = LASTPOS( uppercase_pfm_dir_value, uppercase_atm_area, pfm_ptr )
         if pfm_ptr = 0 then leave
         atm_area =,
            DELSTR( atm_area, pfm_ptr, LENGTH(uppercase_pfm_dir_value) )
         atm_area =,
            INSERT( new_pfm_dir_value, atm_area, pfm_ptr -1 )
      end

      uppercase_atm_area = TRANSLATE( atm_area )
      atm_ini_change_count = atm_ini_change_count + 1
   end

/*---------------------*\
|  Check PFB_DIR value  |
\*---------------------*/
pfb_dir_arg = 'PFB_DIR='
pfb_dir_beg = POS( crlf || pfb_dir_arg, uppercase_atm_area )
if pfb_dir_beg = 0 then
   do
      log_line =,
         'Unable to locate' pfb_dir_arg 'in' atm_ini_path_and_file_name
      call LINEOUT GBL.LogFile, log_line
      say log_line
      return
   end
pfb_dir_beg = pfb_dir_beg + LENGTH(pfb_dir_arg) + 2
pfb_dir_end = POS( crlf, uppercase_atm_area, pfb_dir_beg )
uppercase_pfb_dir_value =,
   SUBSTR( uppercase_atm_area, pfb_dir_beg, pfb_dir_end - pfb_dir_beg )
new_pfb_dir_value =,
   GBL.font_home_path || 'PSFONTS'
if uppercase_pfb_dir_value = new_pfb_dir_value then
   do
      atm_area =,
         DELSTR( atm_area, pfb_dir_beg, LENGTH(uppercase_pfb_dir_value) )
      atm_area =,
         INSERT( new_pfb_dir_value, atm_area, pfb_dir_beg - 1 )
      uppercase_atm_area = TRANSLATE( atm_area )

      /*-----------------------*\
      |  Replace all PFB paths  |
      \*-----------------------*/
      pfb_ptr = LENGTH(atm_area)
      do forever
         pfb_ptr = LASTPOS( uppercase_pfb_dir_value, uppercase_atm_area, pfb_ptr )
         if pfb_ptr = 0 then leave
         atm_area =,
            DELSTR( atm_area, pfb_ptr, LENGTH(uppercase_pfb_dir_value) )
         atm_area =,
            INSERT( new_pfb_dir_value, atm_area, pfb_ptr -1 )
      end

      uppercase_atm_area = TRANSLATE( atm_area )
      atm_ini_change_count = atm_ini_change_count + 1
   end

if atm_ini_change_count = 0 then
   do
      return
   end

call CREATE_ARCHIVE atm_ini_path_and_file_name

call SysFileDelete atm_ini_path_and_file_name
call CHAROUT atm_ini_path_and_file_name, atm_area
call STREAM  atm_ini_path_and_file_name, 'C', 'CLOSE'

log_line =,
   atm_ini_path_and_file_name 'updated'
call LINEOUT GBL.LogFile, log_line

/*---------------------------------------------*\
|  Delete the ATMFONTS.QLC entry, if it exists  |
\*---------------------------------------------*/
call SysFileDelete new_qlc_dir_value || '\ATMFONTS.QLC'
call SysFileDelete uppercase_qlc_dir_value || '\ATMFONTS.QLC'

return

/*------------------------------------------------------------------------*\
|                                                                          |
|                    Process WIN.INI in specified path                     |
|                                                                          |
\*------------------------------------------------------------------------*/
PROCESS_WIN_INI:
   Procedure expose,
      (GBL.List)

parse ARG win_ini_path_and_file_name

win_ini_change_count = 0
win_ini_path =,
   FILESPEC( 'D', win_ini_path_and_file_name ) ||,
   FILESPEC( 'P', win_ini_path_and_file_name )

/*-------------*\
|  Get WIN.INI  |
\*-------------*/
win_size = STREAM( win_ini_path_and_file_name, 'C', 'QUERY SIZE' )
if win_size = '' then
   do
      log_line =,
         'Unable to locate' win_ini_path_and_file_name
      call LINEOUT GBL.LogFile, log_line
      return
   end

win_area = CHARIN( win_ini_path_and_file_name, 1, win_size )
call STREAM win_ini_path_and_file_name, 'C', 'CLOSE'
uppercase_win_area = TRANSLATE( win_area )

font_stanza_arg = '[FONTS]'
font_stanza_beg = POS( crlf || font_stanza_arg, uppercase_win_area )
if font_stanza_beg = 0 then
   do
      log_line =,
         'Unable to locate' font_stanza_arg 'in' win_ini_path_and_file_name
      call LINEOUT GBL.LogFile, log_line
      return
   end
font_stanza_beg = font_stanza_beg + LENGTH(font_stanza_arg) + 2
font_stanza_end =,
   POS( crlf || '[', uppercase_win_area || crlf || '[', font_stanza_beg )
drop uppercase_win_area

/*-----------------------------------------*\
|  Replace FOT font entries & delete .TTF   |
|  & .FOT files if they exist in home path  |
\*-----------------------------------------*/
line_beg_ptr = font_stanza_end
do do_loop_1 = 1
   line_beg_ptr = LASTPOS( crlf, win_area, line_beg_ptr - 2 ) + 2
   if line_beg_ptr < font_stanza_beg then leave do_loop_1
   line_end_ptr = POS( crlf, win_area, line_beg_ptr )

   fot_line =,
      SUBSTR( win_area, line_beg_ptr, line_end_ptr - line_beg_ptr )

   parse value fot_line with,
      fot_description '=' fot_path_and_file_name

   fot_path =,
      FILESPEC( 'D', fot_path_and_file_name ) ||,
      FILESPEC( 'P', fot_path_and_file_name )
   fot_name =,
      FILESPEC( 'N', fot_path_and_file_name )
   parse upper value fot_name with,
      fot_fn '.' fot_fe

   if fot_fe = 'FOT' then iterate do_loop_1

   /*-----------------------------------*\
   |  Be sure that font is in home path  |
   \*-----------------------------------*/
   fot_path = GBL.font_home_path || 'TRUETYPE\'
   fot_path_and_file_name =,
      fot_path || fot_name

   /*-----------------------------------------*\
   |  Delete existing TTF string from WIN.INI  |
   \*-----------------------------------------*/
   win_area =,
      DELSTR( win_area, line_beg_ptr, line_end_ptr - line_beg_ptr + 2 )
   win_ini_change_count = win_ini_change_count + 1

   /*------------------------------*\
   |  Be sure that FOT file exists  |
   \*------------------------------*/
   if STREAM( fot_path_and_file_name, 'C', 'QUERY EXISTS' ) = '' then
      do
         log_line =,
            fot_line,
            'removed from',
            win_ini_path_and_file_name
         call LINEOUT GBL.LogFile, log_line
         iterate do_loop_1
      end

   new_fot_line =,
      fot_description || '=' || fot_path_and_file_name
   win_area =,
      INSERT( new_fot_line || crlf, win_area, line_beg_ptr - 1 )

end

if win_ini_change_count > 0 then
   do
      call CREATE_ARCHIVE win_ini_path_and_file_name
      call SysFileDelete  win_ini_path_and_file_name
      call CHAROUT win_ini_path_and_file_name, win_area
      call STREAM  win_ini_path_and_file_name, 'C', 'CLOSE'
      log_line =,
         win_ini_path_and_file_name 'updated'
      call LINEOUT GBL.LogFile, log_line
   end

return


!tr!=VALUE('TRACE',, GBL.Environment); if !tr!<>'' then do;say 'Trace' !tr! 'started'; TRACE(!tr!);nop;end
/*------------------------------------------------------------------------*\
|                                                                          |
|                                End of Job                                |
|                                                                          |
\*------------------------------------------------------------------------*/
EOJ:
   Procedure expose,
      GBL.

if ARG() = 0 then
   eoj_rc = 0
else
   eoj_rc = ARG(1)

elapsed_time = TIME('E')            /* get elapsed time - sssss.uuuuu */
parse value elapsed_time with seconds '.' micro_seconds
if LEFT( micro_seconds, 1, 1 ) >= 5 then
   seconds = seconds + 1
ss = FORMAT( seconds // 60, 2 )
minutes = ( seconds - ss ) / 60
mm = FORMAT( minutes // 60, 2 )
hh = FORMAT( ( minutes - mm ) / 60, 2 )
duration = hh':'mm':'ss

say 'EOJ   ' || GBL.ProgramFn || '.' || GBL.ProgramFe 'at' TIME('N') ||,
    ', duration' TRANSLATE( duration, '0', ' ' )
exit eoj_rc

/*------------------------------------------------------------------------*\
|                                                                          |
|                              Trap Routines                               |
|                                                                          |
\*------------------------------------------------------------------------*/
ERROR:       call TRAP_PROCESSING_01   SIGL, 'ERROR',   RC
FAILURE:     call TRAP_PROCESSING_01   SIGL, 'FAILURE', RC
HALT:        call TRAP_PROCESSING_01   SIGL, 'HALT',    ''
LOGIC_ERROR: call TRAP_PROCESSING_01   SIGL, 'LOGIC',   ARG( 1 )
NOVALUE:     call TRAP_PROCESSING_01   SIGL, 'NOVALUE', ''
SYNTAX:      call TRAP_PROCESSING_01   SIGL, 'SYNTAX',  RC

TRAP_PROCESSING_01:
   SIGNAL ON ERROR   name TRAP_PROCESSING_02 /* prevent recursion */
   SIGNAL ON FAILURE name TRAP_PROCESSING_02 /* prevent recursion */
   SIGNAL ON HALT    name TRAP_PROCESSING_02 /* prevent recursion */
   SIGNAL ON NOVALUE name TRAP_PROCESSING_02 /* prevent recursion */
   SIGNAL ON SYNTAX  name TRAP_PROCESSING_02 /* prevent recursion */
   ?Trap.   = ''     /* Revised 98/12/18 */
   TRAP_DMP = ''     /* .DMP path & file name */
   TRAP_DMP_TIMESTAMP = DATE( ) || COPIES(' ', 2 ) || LEFT( TIME('L'),11 )

/*---------------------*\
|  Program path & name  |
\*---------------------*/
parse Source  ?Trap.?OperatingSystem . ?Trap.?ProgramPathAndFileName
parse Version ?Trap.?RexxVersion

?Trap.?LineNumber = ARG( 1 )
if POS( ':', ?Trap.?ProgramPathAndFileName ) > 0 then
   /* get source line if it is available */
   do ?T = 1
      TRAP_SOURCE_LINE.?T =  SOURCELINE( ?Trap.?LineNumber )
      TRAP_SOURCE_LINE.0  = ?T
      if TRAP_SOURCE_LINE.?T == '' then
         do
            TRAP_SOURCE_LINE.?T = 'Source is not available'
            leave
         end
      ?Trap.?LineNumber   = ?Trap.?LineNumber + 1
      if RIGHT( TRAP_SOURCE_LINE.?T, 1 ) == ',' then
         do
            leave
         end
   end
else
   /* program is running in macrospace */
   do
      ?Trap.?ProgramPathAndFileName =,
         STRIP( DIRECTORY( ), 'T', '\' ) || '\' ||,
         ?Trap.?ProgramPathAndFileName
      TRAP_SOURCE_LINE.1 = 'Source line is not available.'
      TRAP_SOURCE_LINE.0 = 1
   end

parse value FILESPEC( 'N', ?Trap.?ProgramPathAndFileName ) with,
   ?Trap.?Fn '.' ?Trap.?Fe
TRAP_DMP =,
   FILESPEC( 'D', ?Trap.?ProgramPathAndFileName ) ||,
   FILESPEC( 'P', ?Trap.?ProgramPathAndFileName ) ||,
   ?Trap.?Fn || '.' || 'DMP'

/*-------------------------------------------*\
|  Determine whether ANSII or VX-REXX output  |
\*-------------------------------------------*/
?Trap.?VXREXX = ( RxFuncQuery( 'VRWindow' ) = 0 )
if ?Trap.?VXREXX then
   do
      /* see if Primary Window handle exists */
      ?Trap.?VXREXX = ( LEFT( VRWindow( ), 1 ) = '?' )
   end

/*------------------------------------------*\
|  Check for reason NOT to create .DMP file  |
\*------------------------------------------*/
select
   when ARG( 2 ) = 'HALT' then
      do
         TRAP_DMP = ''
      end
   when POS( ':', TRAP_DMP ) = 0 then
      do
         TRAP_DMP = ''
      end
   when ABBREV( ?Trap.?RexxVersion, 'OBJREXX' ) then
      do
         if RxFuncQuery( 'SysDumpVariables' ) <> 0 then
            do
               TRAP_DMP = ''
            end
      end
   when ?Trap.?OperatingSystem = 'OS/2' then
      do
         if RxFuncQuery( 'VARDUMP' ) <> 0 then
            do
               TRAP_DMP = ''
            end
      end
   otherwise
      do
         nop
      end
end

/*------------------------*\
|  Build trap message box  |
\*------------------------*/
?DBL.H     = 'CD'x                 /*  double line - horizontal   */
?DBL.V     = 'BA'x                 /*  double line - vertical     */
?DBL.BL    = 'C8'x                 /*  double line - bottom left  */
?DBL.BR    = 'BC'x                 /*  double line - bottom right */
?DBL.TL    = 'C9'x                 /*  double line - top left     */
?DBL.TR    = 'BB'x                 /*  double line - top right    */
if ?Trap.?OperatingSystem == 'WindowsNT' then
   do
      ?Trap.?RED = '1B'x || '[1;37;41m'  /* bright white on red    */
      ?Trap.?DUL = '1B'x || '[0m'        /* reset to normal        */
   end
?Trap.?Margin = COPIES( ' ', 2 )

TRAP_ERROR_DESCRIPTION =,
   'Error line = ' || ARG( 1 ) || '; ' || ARG( 2 ) || ' trap caught'
if ARG( 3 ) <> '' then
   TRAP_ERROR_DESCRIPTION = TRAP_ERROR_DESCRIPTION ||,
      '  Return code = ' || ARG( 3 )

?T=0
?T=?T+1; ?Trap.?line.?T = ?Trap.?Fn'.'?Trap.?Fe
?T=?T+1; ?Trap.?line.?T = TRAP_ERROR_DESCRIPTION
if TRAP_DMP <> '' then
   do
?T=?T+1; ?Trap.?line.?T = ''
?T=?T+1; ?Trap.?line.?T = 'See: ' || TRAP_DMP
   end
?T=?T+1; ?Trap.?line.?T = ''
?T=?T+1; ?Trap.?line.?T = 'Source line(s) at time of trap:'
do ?S = 1 to TRAP_SOURCE_LINE.0
   ?T=?T+1; ?Trap.?line.?T = ?Trap.?Margin || TRAP_SOURCE_LINE.?S
end
         ?Trap.?line.0 = ?T
if ?Trap.?VXREXX then
   do
      ?Trap.?PrimaryWindowHandle = VRWindow( )
      call VRSet  ?Trap.?PrimaryWindowHandle,,
                  'BackColor',      'White',,
                  'ForeColor',      'Red',,
                  ''

      call VRMessageStem ?Trap.?PrimaryWindowHandle,,
                         '?Trap.?line.',,
                         CENTER( ?Trap.?Fn 'Fatal error', 74 ),,
                         'E'
   end
else
   do
      ?Trap.?Width = MAX( 74, LENGTH( TRAP_ERROR_DESCRIPTION ) )
      say ?Trap.?RED || ?DBL.TL || COPIES( ?DBL.H,?Trap.?Width + 2 ) || ?DBL.TR || ?Trap.?DUL
      say ?Trap.?RED || ?DBL.V  || COPIES( ' ',   ?Trap.?Width + 2 ) || ?DBL.V  || ?Trap.?DUL
      do ?T = 1 to ?Trap.?line.0
      say ?Trap.?RED || ?DBL.V    LEFT( ?Trap.?line.?T, ?Trap.?Width )   ?DBL.V  || ?Trap.?DUL
      end
      say ?Trap.?RED || ?DBL.V  || COPIES( ' ',   ?Trap.?Width + 2 ) || ?DBL.V  || ?Trap.?DUL
      say ?Trap.?RED || ?DBL.BL || COPIES( ?DBL.H,?Trap.?Width + 2 ) || ?DBL.BR || ?Trap.?DUL
   end

/*---------------------------------*\
|  Create .DMP file if appropriate  |
\*---------------------------------*/
if TRAP_DMP <> '' then
   do
      /* remove meaningless labels from dump for clarity */
      drop ( GBL.DumpExclusionList )
      drop ?dbl. ?Trap. ?S ?T ?tr?
      call SysFileDelete TRAP_DMP
      select
         when RxFuncQuery( 'VARDUMP' ) == 0 then
            do
               call VARDUMP TRAP_DMP  /* write variables to program.DMP file */
            end
         when RxFuncQuery( 'SysDumpVariables' ) == 0 then
            do
               call SysDumpVariables TRAP_DMP  /* write variables to program.DMP file */
            end
         otherwise; nop
      end
   end

TRAP_PROCESSING_02:
   exit 255
